
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.course.service;

import com.baijia.tianxiao.sal.course.dto.request.TeacherClassHourRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherClassHourDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

/**
 * @title OrgTeacherClassHourService
 * @desc 老师课时统计
 * @author shanyu
 * @date 2016年3月30日
 * @version 1.0
 */

public interface OrgTeacherClassHourService {

    /**
     * 获取老师课时列表
     * 
     * @param orgId
     * @param startTime
     * @param endTime
     * @param pageDto
     * @return
     */
    public List<TeacherClassHourDto> queryTeacherClassHourList(Long orgId, TeacherClassHourRequestDto params,
        PageDto pageDto);

    /**
     * 获取老师课时统计详情
     * 
     * @param orgId
     * @param teacherId
     * @param startTime
     * @param endTime
     * @param pageDto
     * @return
     */
    public TeacherClassHourDto queryTeacherClassHourDetail(Long orgId, TeacherClassHourRequestDto params,
        PageDto pageDto);

    /**
     * 获取老师课时信息导出数据
     * 
     * @param orgId
     * @param params
     * @return
     */
    public List<TeacherClassHourDto> exportTeacherClassHoursData(Long orgId, TeacherClassHourRequestDto params);

    /**
     * 导出数据
     * 
     * @param dtoList
     */
    public void export(HttpServletResponse response, Long orgId, Date date, List<TeacherClassHourDto> dtoList);

}
