
package com.baijia.tianxiao.sal.course.dto.response;

import com.baijia.tianxiao.util.NumberUtil;
import lombok.Data;

import java.util.Date;

@Data
public class CourseListReponseDto {

    private Long orgCourseId; // 课程ID

    private Long orgCourseNumber; // 课程number
    
    private String courseUrl; // 课程url

    private String courseName; // 课程名称

    private String color; // 颜色

    private Integer maxStudent; // 最大学生数

    private Integer studentCount; // 学生数量

    private Integer teacherCount; // 老师数量

    private Integer roomCount; // 教室数量

    private String roomNames;// 教室名称

    private Date startTime; // 开始时间

    private Date endTime; // 结束时间

    private Integer freq; // 计划课节

    private Integer lessonCount;// 排课课节

    private Integer lessonFinish; // 上完的课节

    private Integer arrageStatus; // 课程安排进展

    private Integer smsStudent; // 代发短信学生数量

    private Integer smsTeacher; // 代发短信老师数量

    private Integer viewStudent; // 代查看短信学生数量

    private Integer viewTeacher; // 代查看短信老师数量

    private String coverUrl; // 封面url

    private String address;// 上课地址

    private String introduction;// 介绍

    private Integer courseType;
    
    private Double price;

    private Integer isCourse; // 是否是课
    
    private Integer isClass; // 是否是班
    
    private Integer isFinish; //是否结课

    // 学生状态 退班 转班
    private Integer status;
    private Integer lessonToday; // 今天的课节数
    private Double attendanceRate;// 到课率
    private String teacherNames;
    private String studentNames;
    private Date createTime;
    private Integer cascadeId;

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public void setAttendanceRate(Double attendanceRate) {
        this.attendanceRate = Double.valueOf(NumberUtil.DOUBLE_FMT.format(attendanceRate));
    }

}
