package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.common.service.MsgSendService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.SigninMsgAsynModel;
import com.baijia.tianxiao.sal.course.dto.request.LessonSignRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.LessonSignReportDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentLessonSignDto;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

import javax.annotation.Resource;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

@Service
@Slf4j
public class OrgLessonSignServiceImpl implements OrgLessonSignService {

    private static String smsContent = "%s你好，你已经在%s的%s完成签到，状态为“%s”。如有疑问，请拨打4000122166转%s";

    private static String content = "你好:\n %s你已经在%s的%s完成签到，状态为“%s”。";

    private static String remark = "如果对打卡情况有疑问，请致电4000122166转%s";

    private static String course = "%s第%s次课";

    private static String defaultName = "-";

    @Resource
    private OrgLessonSignDao orgLessonSignDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private OrgTeacherDao orgTeacherDao;

    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;

    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;

    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;

    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;

    @Resource
    private TeacherDao teacherDao;

    @Resource
    private OrgAccountDao orgAccountDao;
    
    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;

    @Autowired(required = false)
    private MsgSendService msgSendService;

    @Autowired
    private StringRedisTemplate redisTemplate;
    
    /*@Resource
    private BizAsyncService bizAsynService;*/

    public StringRedisTemplate getRedisTemplate() {

        return redisTemplate;
    }

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {

        this.redisTemplate = redisTemplate;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void orgStudentLessonBatchSign(Long orgId, Long courseId, Long lessonId, List<Long> studentIds,
                                          Integer status) {
         if (CollectionUtils.isEmpty(studentIds) || lessonId == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节ID和学生ID不能为空");
        }
         
        OrgClassLesson lesson = orgClassLessonDao.getByIdForUpdate(lessonId);
        Preconditions.checkArgument(lesson != null && orgId.equals(lesson.getOrgId()), "课节ID不正确");
        Preconditions.checkArgument(status != null && status >= 0, "签到状态不正确");
        Map<Long, Long> map = orgStudentDao.getStudentIdUserIdMap(studentIds);
        
        OrgCourse course = orgCourseDao.getById(lesson.getCourseId());
        Preconditions.checkArgument(course != null , " 课节ID不正确");

        
        log.info("update studentIds:{} in lesson:{} to signStatus:{}", map.values(), lessonId, status);
        this.orgLessonSignDao.orgLessonSignBatchEdit(lessonId, map.values(), status);
        List<OrgLessonSign> signStudents =
                orgLessonSignDao.getLessonStudentIds(orgId, lessonId, map.values(), status);
        Set<Long> userIds = Sets.newHashSet(map.values());

        if (CollectionUtils.isNotEmpty(signStudents)) {
            for (OrgLessonSign signStudent : signStudents) {
                userIds.remove(signStudent.getUserId());
            }
        }
        
        if (CollectionUtils.isNotEmpty(userIds)) {
            
            Preconditions.checkArgument(lesson != null && orgId.equals(lesson.getOrgId()), "课节ID不正确");
            List<OrgLessonSign> newSignStudents = Lists.newArrayList();
            for (Long studentId : userIds) {
                OrgLessonSign lessonSign = new OrgLessonSign();
                lessonSign.setCourseId(lesson.getCourseId());
                lessonSign.setCreateTime(new Date());
                lessonSign.setLessonId(lessonId);
                lessonSign.setOrgId(orgId);
                lessonSign.setStatus(status);
                lessonSign.setUserId(studentId);
                lessonSign.setUpdateTime(new Date());
                lessonSign.setUserRole(UserRole.STUDENT.getRole());
                newSignStudents.add(lessonSign);
            }
            log.info("save sign students:{}", newSignStudents);
            orgLessonSignDao.saveAll(newSignStudents,false, "courseId", "createTime", "lessonId", "orgId", "status", "userId",
                    "updateTime", "userRole");
            
            if(!checkOrgPermissionSignMsg(orgId.intValue())){
                return;
            }
            
            // 发送签到提醒消息
            if (lesson.getStartTime().after(DateUtil.getCurrentDate())
                    && lesson.getStartTime().before(DateUtil.getDiffDateTime(DateUtil.getCurrentDate(), 1))) {
                /*List<OrgStudent> students = this.orgStudentDao.getStudentByIds(orgId, studentIds);
                //OrgCourse course = this.orgCourseDao.getById(lesson.getCourseId());
                OrgTeacherLesson orgTeacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
                Teacher teacher = null;
                if (orgTeacherLesson != null) {
                    teacher = this.teacherDao.getByUserId(orgTeacherLesson.getTeacherId());
                }
                // 机构信息
                OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId.intValue());
                for (OrgStudent student : students) {
                    timerSendSignMsg(orgInfo, student, teacher, lesson, course, status);
                }*/
            	
            	List<OrgLessonSign> signInList =  Lists.newArrayList();
            	signInList.addAll(signStudents);
            	signInList.addAll(newSignStudents);
            	addToSigninMsgAsynModel(signInList);
            }
        }
        
    }
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void orgStudentLessonBatchFastSign(Long orgId, Long courseId, List<Long> lessonIds, Map<Long,Integer> studentIdSignInStatus ) {
        Set<Long> studentIds = studentIdSignInStatus.keySet();
        if (CollectionUtils.isEmpty(studentIds) || CollectionUtils.isEmpty(lessonIds)) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节ID和学生ID不能为空");
        }
        log.info("create studentsSignIns:{} in lesson:{}", studentIdSignInStatus, lessonIds);
        
        Map<Long, Long> map = orgStudentDao.getStudentIdUserIdMap(studentIds);

        List<OrgLessonSign> newSignStudents = Lists.newArrayList();
        if (MapUtils.isNotEmpty(map)) {
            for(Long lessonId:lessonIds){
                OrgClassLesson lesson = orgClassLessonDao.getById(lessonId);
                Preconditions.checkArgument(lesson != null && orgId.equals(lesson.getOrgId()), "课节ID不正确");
                
                for (Map.Entry<Long,Long> studentEntry: map.entrySet()) {
                    OrgLessonSign lessonSign = new OrgLessonSign();
                    lessonSign.setCourseId(lesson.getCourseId());
                    lessonSign.setCreateTime(new Date());
                    lessonSign.setLessonId(lessonId);
                    lessonSign.setOrgId(orgId);
                    lessonSign.setStatus(studentIdSignInStatus.get(studentEntry.getKey()));
                    lessonSign.setUserId(studentEntry.getValue());
                    lessonSign.setUpdateTime(new Date());
                    lessonSign.setUserRole(UserRole.STUDENT.getRole());
                    newSignStudents.add(lessonSign);
                }
            }
            
            log.info("save sign students:{}", newSignStudents);
            orgLessonSignDao.saveAll(newSignStudents, "courseId", "createTime", "lessonId", "orgId", "status", "userId",
                    "updateTime", "userRole");
            
        }
    }

    /**
     * 签到提醒
     *
     * @param orgInfo
     * @param student
     * @param teacherName
     * @param lesson
     * @param course
     * @param status
     * @return
     */
    private SendMsgRequest getSendMsg(OrgInfo orgInfo, OrgStudent student, String teacherName, OrgClassLesson lesson,
                                      OrgCourse course, Integer status) {
        SendMsgRequest request = new SendMsgRequest();
        request.setOrgId(orgInfo.getOrgId().longValue());
        request.setMobile(student.getMobile());
        request.setCountSms(false);
        request.setReceiverId(student.getId());
        request.setWeixinOpenId(student.getWeixin());
        request.setReceiverRole(UserRoleEnum.STUDENT);
        request.setSenderId(orgInfo.getOrgId().longValue());
        request.setSenderRole(UserRoleEnum.ORG);
        request.setWechatTemplateId(WechateTemplateMsgType.COURSE_SIGNIN_TO_STU.getValue());
        Map<String, Object> params = Maps.newHashMap();
        String studentName = getStringValue(student.getName());
        String orgName = orgInfo.getShortName();
        String courseName = course.getName();
        String signStatusStr = SignStatus.getSignStatusByCode(status).getMessage();
        String extention = getStringValue(orgInfo.getExtension());
        teacherName = getStringValue(teacherName);
        String smsContent = String.format(OrgLessonSignServiceImpl.smsContent, studentName, orgName, courseName,
                signStatusStr, extention);
        request.setSmsContent(smsContent);
        Date now = new Date();
        params.put("first",
                String.format(OrgLessonSignServiceImpl.content, studentName, orgName, courseName, signStatusStr));
        params.put("remark", String.format(OrgLessonSignServiceImpl.remark, extention));
        params.put("keyword1", studentName);
        params.put("keyword2", DateUtil.getStrByDateFormate(now, "yyyy-MM-dd HH:mm"));
        params.put("keyword3", String.format(OrgLessonSignServiceImpl.course, courseName, lesson.getNumber()));
        params.put("keyword4", getStringValue(teacherName));
        request.setWechatParams(params);
        log.debug("remind student comment the course! data={}", request);
        return request;
    }

    /**
     * 没有名称返回“－”
     *
     * @param message
     * @return
     */
    private String getStringValue(String message) {
        if (StringUtils.isBlank(message)) {
            return defaultName;
        }
        return message;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void orgStudentLessonSign(@NonNull Long orgId, Long courseId, @NonNull Long lessonId,
                                     @NonNull Long studentId, Integer status) {

        Preconditions.checkArgument(status != null && status >= 0, "签到状态不正确");
        Preconditions.checkArgument(lessonId != null && lessonId >= 0, "课节ID不正确");
        Preconditions.checkArgument(orgId != null && orgId >= 0, "机构ID不正确");
        Preconditions.checkArgument(studentId != null && studentId >= 0, "学生ID不正确");

        OrgClassLesson lesson = orgClassLessonDao.getByIdForUpdate(lessonId);
        Preconditions.checkArgument(lesson != null && orgId.equals(lesson.getOrgId()), "课节ID不正确");
        
        OrgCourse course = orgCourseDao.getById(lesson.getCourseId());
        Preconditions.checkArgument(course != null , " 课节ID不正确");
        OrgStudent student = orgStudentDao.getById(studentId);
        Long userId = student == null ? null : student.getUserId();
        Preconditions.checkArgument(userId != null && userId >= 0, "无法找到对应的学生ID:" + studentId);

        

        OrgLessonSign obj =
                orgLessonSignDao.getStudentLessonSign(orgId, courseId, lessonId, userId, UserRole.STUDENT.getRole());
        if (obj != null && status != null && !status.equals(obj.getStatus())) {
            // 签到提醒
            // this.sendLessonSignMsg(orgId, courseId, lessonId, studentId, status);
            obj.setStatus(status);
            orgLessonSignDao.update(obj, "status");
        } else if (obj == null && status != null) {
            obj = new OrgLessonSign();
            obj.setCourseId(lesson.getCourseId());
            obj.setCreateTime(new Date());
            obj.setLessonId(lessonId);
            obj.setOrgId(orgId);
            obj.setStatus(status);
            obj.setUpdateTime(new Date());
            obj.setUserId(userId);
            obj.setUserRole(UserRole.STUDENT.getRole());
            orgLessonSignDao.saveOrUpdate(obj);
        }
        if(!checkOrgPermissionSignMsg(orgId.intValue())){
            return;
        }
        if (lesson.getStartTime().after(DateUtil.getCurrentDate())
                && lesson.getStartTime().before(DateUtil.getDiffDateTime(DateUtil.getCurrentDate(), 1))) {
            //OrgCourse course = this.orgCourseDao.getById(lesson.getCourseId());
            /*OrgTeacherLesson orgTeacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
            Teacher teacher = null;
            if (orgTeacherLesson != null) {
                teacher = this.teacherDao.getByUserId(orgTeacherLesson.getTeacherId());
            }
            // 机构信息
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId.intValue());

            timerSendSignMsg(orgInfo, student, teacher, lesson, course, status);*/
        	List<OrgLessonSign> signInList =  Lists.newArrayList();
        	signInList.add(obj);
        	addToSigninMsgAsynModel(signInList);

        }
    
    }

    @Override
    @Transactional(readOnly = true)
    public OrgStudentLessonSignDto getStudentLessonSign(@NonNull Long orgId, Long courseId, @NonNull Long lessonId,
                                                        @NonNull Long studentId) {

        Long userId = orgStudentDao.getUserId(studentId);

        OrgLessonSign obj =
                orgLessonSignDao.getStudentLessonSign(orgId, courseId, lessonId, userId, UserRole.STUDENT.getRole());
        if (obj != null) {
            OrgStudentLessonSignDto dto = new OrgStudentLessonSignDto();
            dto.setCourseId(obj.getCourseId());
            dto.setCreateTime(obj.getCreateTime());
            dto.setId(obj.getId());
            dto.setLessonId(obj.getLessonId());
            dto.setSignStatusEnum(SignStatus.getSignStatusByCode(obj.getStatus()));
            dto.setUpdateTime(obj.getUpdateTime());

            return dto;
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true)
    public Map<String, Map<String, Integer>> getLessonStudentSign(Long orgId, Collection<Long> lessonIds,
                                                                  Map<Long, Long> userIdMap) {
        List<OrgLessonSign> signs = this.orgLessonSignDao.getStudentLessonSign(orgId, null, lessonIds);

        Map<String, Map<String, Integer>> signUserIdMap = Maps.newHashMap();

        for (OrgLessonSign sign : signs) {
            if (!signUserIdMap.containsKey(String.valueOf(sign.getUserId()))) {
                Map<String, Integer> map = Maps.newHashMap();
                signUserIdMap.put(String.valueOf(sign.getUserId()), map);
            }
            signUserIdMap.get(String.valueOf(sign.getUserId())).put(String.valueOf(sign.getLessonId()),
                    sign.getStatus());
        }

        Map<String, Map<String, Integer>> signStudentIdMap = Maps.newHashMap();
        for (String userId : signUserIdMap.keySet()) {
            signStudentIdMap.put(String.valueOf(userIdMap.get(Long.parseLong(userId))), signUserIdMap.get(userId));
        }

        return signStudentIdMap;

    }

    @Override
    @Transactional(readOnly = true)
    public Map<String, Map<String, Integer>> getLessonStudentSignReport(Long orgId, Collection<Long> lessonIds,
                                                                        Map<Long, Long> userIdMap, Long courseId) {
        // lessonIds:课程所有课节Id，userIdMap.keySet()所有userId
        Preconditions.checkArgument(courseId != null && courseId > 0, "illegal courseId = " + courseId);
        long current = System.currentTimeMillis();
        Map<Long, List<Long>> userIdsLessonMap =
                this.orgStudentLessonDao.getLessonIdsOfStudents(orgId, userIdMap.keySet(), lessonIds);
        // 从org_lesson_sign查出学生课节信息对应的签到信息
        List<OrgLessonSign> signList = orgLessonSignDao.getUserLessonSignList(orgId, userIdMap.keySet(), courseId,
                UserRole.STUDENT.getRole(), null);
        Map<Long, List<OrgLessonSign>> userIdLessonSignMap = getUserIdLessonSignMap(signList);

        Map<String, Map<String, Integer>> signStudentIdMap = Maps.newHashMap();
        for (Long userId : userIdsLessonMap.keySet()) {

            Map<String, Integer> userMap = Maps.newHashMap();

            List<Long> lessons = userIdsLessonMap.get(userId);

            List<OrgLessonSign> signs = userIdLessonSignMap.get(userId);
            Map<Long, Integer> lessonSignMap = toLessonSignMap(signs);

            for (Long lessonId : lessons) {
                Integer sign = lessonSignMap.get(lessonId);

                userMap.put(String.valueOf(lessonId), sign == null ? 0 : sign);
            }

            signStudentIdMap.put(String.valueOf(userIdMap.get(userId)), userMap);
        }
        log.debug("cost:{}ms", System.currentTimeMillis() - current);
        return signStudentIdMap;

    }

    @Override
    @Transactional(readOnly = true)
    public Map<Long, Integer> getLessonStudentSignCount(Long orgId, Collection<Long> lessonIds,
                                                        Map<Long, Long> userIdMap) {
        Map<Long, Integer> userIdCountMap =
                this.orgLessonSignDao.getOrgLessonSignCount(lessonIds, UserRole.STUDENT.getRole());
        log.debug("getLessonStudentSignCount result={}", userIdCountMap);
        log.debug("getLessonStudentSignCount userIdMap={}", userIdMap);
        Map<Long, Integer> studentIdCountMap = Maps.newHashMap();
        for (Long userId : userIdCountMap.keySet()) {
            studentIdCountMap.put(userIdMap.get(userId), userIdCountMap.get(userId));
        }
        log.debug("getLessonStudentSignCount result={}", studentIdCountMap);
        return studentIdCountMap;
    }

    @Override
    public LessonSignReportDto getLessonSignReport(@NonNull LessonSignRequestDto params) {
        log.info("params = {}", params);
        Preconditions.checkArgument(params.getOrgId() != null && params.getOrgId() > 0, "orgId invalid!");
        List<Long> courseIds = Lists.newArrayList();
        LessonSignReportDto lessonSignReportDto = new LessonSignReportDto();
        // 如果传入有效的courseID
        if (params.getCourseId() != null && params.getCourseId() > 0) {
            courseIds.add(params.getCourseId());
        }
        Map<Long, Integer> courseLessonCountMap = null;
        Long userId = null;

        if (params.getStudentId() != null && params.getStudentId() > 0) {
            userId = this.orgStudentDao.getUserId(params.getStudentId());
            Preconditions.checkArgument(userId != null && userId > 0, "student not exits!");
            // 没有传courseId,则查出本学生所有courseId
            if (courseIds.isEmpty()) {
                List<Long> cIds = this.orgStudentCourseDao.getStudentCourseIds(params.getOrgId(), userId, null);
                log.debug("cIds = {}", cIds);
                courseIds.addAll(cIds);
            }
            OrgStudent orgStudent = orgStudentDao.getStudent(params.getOrgId(), userId, 0, "userId", "id", "name",
                    "nickName", "mobile", "show_mobile");
            if(orgStudent==null){
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "学生已删除");
            }
            lessonSignReportDto.getStudentInfo().setName(buildStudentName(orgStudent));
            lessonSignReportDto.getStudentInfo().setStudentId(orgStudent.getUserId());
            // 本学生的各个课程的课节数目
            courseLessonCountMap =
                    this.orgStudentLessonDao.getStudentLessonCountOfCourses(params.getOrgId(), userId, courseIds);
        } else {
            // 如果没有传入学生ID,取各个课程的安排的课节数目
            courseLessonCountMap = this.orgClassLessonDao.getLessonCount(params.getOrgId(), courseIds, 0);
        }
        log.debug("courseLessonCountMap = {}", courseLessonCountMap);

        // 课程列表
        List<OrgCourse> courseList = this.orgCourseDao.getByIds(courseIds, "id", "name");
        log.debug("courseIds = {}, courseList = {}", courseIds, courseList);
        if (CollectionUtils.isEmpty(courseList)) {
            return lessonSignReportDto;
        }

        // 获取课程的学生ids
        Map<Long, List<Long>> courseStuUserIdsMap = null;
        if (userId == null) {
            courseStuUserIdsMap = orgStudentCourseDao.getStudentIdMapBycourseIdsNoStatus(courseIds, params.getOrgId());
            log.debug("courseStuUserIdsMap = {}", courseStuUserIdsMap);
        }

        for (OrgCourse orgCourse : courseList) {
            LessonSignReportDto.OrgCourseInfo courseInfo = new LessonSignReportDto.OrgCourseInfo();
            courseInfo.setCourseName(orgCourse.getName());
            Integer lessonCount = courseLessonCountMap.get(orgCourse.getId());
            courseInfo.setLessonCount(lessonCount == null ? 0 : lessonCount);
            // 课程的学生
            List<Long> userIds = null;
            if (userId == null) {
                userIds = courseStuUserIdsMap.get(orgCourse.getId());
            } else {
                userIds = Lists.newArrayList();
                userIds.add(userId);
            }
            courseInfo.setStudentCount(userIds.size());

            List<OrgStudent> orgStudents = orgStudentDao.getStudentByUserIds(params.getOrgId(), userIds, "userId", "id",
                    "name", "nickName", "mobile", "show_mobile");
            log.debug("userIds = {}, orgStudents = {}", userIds, orgStudents);
            // 各个学生的在课程中课节的列表
            // 从org_class_lesson查出本课程对应的课节ids
            Map<Long, OrgClassLesson> lessonMap =
                    orgClassLessonDao.getClassLessonMap(params.getOrgId(), orgCourse.getId(), 0);
            // 从org_student_lesson查出本课程所有学生在本课程的课节useid -> lessonIds, 用课程课节id过滤
            Map<Long, List<Long>> userIdsLessonMap =
                    this.orgStudentLessonDao.getLessonIdsOfStudents(params.getOrgId(), userIds, lessonMap.keySet());
            log.debug("lessonMap = {},userIdsLessonMap={}", lessonMap, userIdsLessonMap);

            // 从org_lesson_sign查出学生课节信息对应的签到信息
            List<OrgLessonSign> signList = orgLessonSignDao.getUserLessonSignList(params.getOrgId(), userIds,
                    orgCourse.getId(), UserRole.STUDENT.getRole(), null);
            Map<Long, List<OrgLessonSign>> userIdLessonSignMap = getUserIdLessonSignMap(signList);
            log.debug("signList = {},userIdLessonSignMap={}", signList, userIdLessonSignMap);
            for (OrgStudent orgStudent : orgStudents) {
                LessonSignReportDto.CourseStudentDto studentDto = new LessonSignReportDto.CourseStudentDto();
                studentDto.setStudentName(buildStudentName(orgStudent));
                List<OrgLessonSign> lessonSignList = userIdLessonSignMap.get(orgStudent.getUserId());
                Map<Long, Integer> lessSignMap = toLessonSignMap(lessonSignList);
                log.debug("lessSignMap = {}", lessSignMap);
                // 课节签到情况
                // 学生在本课程的课节Ids
                List<Long> stuLessonIds = userIdsLessonMap.get(orgStudent.getUserId());
                if (CollectionUtils.isNotEmpty(stuLessonIds)) {
                    for (Long lessonId : stuLessonIds) {
                        LessonSignReportDto.StudentLessonSignInfoDto signDto =
                                new LessonSignReportDto.StudentLessonSignInfoDto();
                        signDto.setLessonId(lessonId);
                        Integer status = lessSignMap.get(lessonId);
                        signDto.setSignStatus(status != null ? status : SignStatus.UNSIGN.getCode());
                        OrgClassLesson lesson = lessonMap.get(lessonId);
                        if (lesson != null) {
                            signDto.setLessonNumber(lesson.getNumber());
                        } else {
                            log.error("lessonId = {} not exits!", lessonId);
                            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "lessonId not found!");
                        }
                        studentDto.addLessonSignInfo(signDto);
                    }
                }

                // 只在课程，没有课节的学生不反回
                if (CollectionUtils.isNotEmpty(studentDto.getLessonList())) {
                    log.debug("no lesson in course studentDto = {}", studentDto);
                    courseInfo.getStudentList().add(studentDto);
                }
            }
            if (userId != null) {
                log.debug("{}{}", courseInfo.getLessonCount(), courseInfo.getStudentList());
                if (courseInfo.getStudentList().size() > 0
                        && courseInfo.getLessonCount() != courseInfo.getStudentList().get(0).getLessonList().size()) {
                    log.warn("should be equal.{} != {}", courseInfo.getLessonCount(),
                            courseInfo.getStudentList().size());
                }
            }
            lessonSignReportDto.getCourseList().add(courseInfo);
        }

        return lessonSignReportDto;
    }

    private Map<Long, List<OrgLessonSign>> getUserIdLessonSignMap(List<OrgLessonSign> signList) {
        return CollectorUtil.group(signList, new Function<OrgLessonSign, Long>() {
            @Override
            public Long apply(OrgLessonSign arg0) {
                return arg0.getUserId();
            }
        }, new Function<OrgLessonSign, OrgLessonSign>() {
            @Override
            public OrgLessonSign apply(OrgLessonSign arg0) {
                return arg0;
            }
        });
    }

    private Map<Long, Integer> toLessonSignMap(List<OrgLessonSign> signList) {
        Map<Long, Integer> lessonSignMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(signList)) {
            return Collections.emptyMap();
        }
        for (OrgLessonSign sign : signList) {
            lessonSignMap.put(sign.getLessonId(), sign.getStatus());
        }
        return lessonSignMap;
    }

    private String buildStudentName(OrgStudent stu) {
        if (StringUtils.isNotBlank(stu.getName())) {
            return stu.getName();
        } else if (StringUtils.isNotBlank(stu.getNickName())) {
            return stu.getNickName();
        } else {
            return MaskUtil.maskMobile(stu.getMobile());
        }
    }

    @Override
    public Map<Long, Double> getAttendanceRateOfCourses(Long orgId, Collection<Long> courseIds) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        Map<Long, Double> resultMap = Maps.newHashMap();
        Map<Long, Integer> shouldSignCntMap = this.orgClassLessonDao.getCourseAttendCountMap(orgId, courseIds);
        Map<Long, Integer> actualSignCntMap = this.orgLessonSignDao.getCourseSignCountMap(orgId, courseIds);
        log.debug("shouldSignCntMap={},actualSignCntMap={}", shouldSignCntMap, actualSignCntMap);
        for (Long courseId : courseIds) {
            Integer shouldSignCnt = shouldSignCntMap.get(courseId);
            Integer actualSignCnt = actualSignCntMap.get(courseId);
            if (actualSignCnt != null && shouldSignCnt != null && shouldSignCnt > 0) {
                Double attendanceRate = (double) actualSignCnt / shouldSignCnt;
                resultMap.put(courseId, attendanceRate);
            } else {
                resultMap.put(courseId, 0.00);
            }

        }
        log.debug("resultMap={}", resultMap);
        return resultMap;

    }

    @Override
    public Map<Long, Double> getAttendanceRateOfStudents(Long orgId, Collection<Long> studentds) {

        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        if (CollectionUtils.isEmpty(studentds)) {
            return Collections.emptyMap();
        }
        Map<Long, Long> stuUserMap = this.orgStudentDao.getStudentIdUserIdMap(studentds);
        Collection<Long> userIds = stuUserMap.values();
        log.debug("stuUserMap={}", stuUserMap);
        log.debug("userIds={}", userIds);
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        Map<Long, Double> resultMap = Maps.newHashMap();
        Map<Long, Integer> shouldSignCntMap = this.orgClassLessonDao.getStudentAttendCountMap(orgId, userIds);
        Map<Long, Integer> actualSignCntMap = this.orgLessonSignDao.getStudentSignCountMap(orgId, userIds);
        log.debug("shouldSignCntMap={},actualSignCntMap={}", shouldSignCntMap, actualSignCntMap);
        for (Long studentId : studentds) {
            Long userId = stuUserMap.get(studentId);
            if (userId == null || userId <= 0) {
                continue;
            }
            Integer shouldSignCnt = shouldSignCntMap.get(userId);
            Integer actualSignCnt = actualSignCntMap.get(userId);
            if (actualSignCnt != null && shouldSignCnt != null && shouldSignCnt > 0) {
                Double attendanceRate = (double) actualSignCnt / shouldSignCnt;
                resultMap.put(studentId, attendanceRate);
            } else {
                resultMap.put(studentId, 0.00);
            }

        }
        log.debug("resultMap={}", resultMap);
        return resultMap;

    }


    @Override
    public List<Long> getStudentBySignStatus(Long orgId, Long lessonId) {

        List<OrgLessonSign> dtos = orgLessonSignDao.getStudentLessonByStatus(orgId, lessonId, SignStatus.UNSIGN.getCode());

        Collection<Long> studentIds = CollectorUtil.collect(dtos, new Function<OrgLessonSign, Long>() {
            @Override
            public Long apply(OrgLessonSign input) {
                return input.getUserId();
            }
        });

        return new ArrayList(studentIds);
    }


    private boolean checkOrgPermissionSignMsg(Integer orgId){
        TXSaleClueRule tXSaleClueRule = tXSaleClueRuleService.getByOrgId(orgId);
        log.info("checkOrgPermissionSignMsg orgId={orgId},txsaleClueRule={}",orgId,tXSaleClueRule);
        if(tXSaleClueRule!=null&&tXSaleClueRule.getSigninMsg() == 0){
            return true;
        }else{
            return false;
        }
        
    }
    
    
    
    /**
     * 根据发送的信息存储的缓存中
     * <p/>
     * 如果被覆盖 则不发送
     *
     * @param orgInfo
     * @param student
     * @param teacher
     * @param lesson
     * @param course
     * @param status
     */
    private Map<String,String> timerSendSignCacheKey(Collection< Long> studentIds, final OrgClassLesson lesson) {
        Map<String,String> sendMap = Maps.newHashMap();
        if(!checkOrgPermissionSignMsg(lesson.getOrgId().intValue())){
            return sendMap;
        }
        for(Long studentId:studentIds){
            final String key = lesson.getOrgId() + "" + studentIds + "" + lesson.getId();
            final String value = UUID.randomUUID().toString();
            
            redisTemplate.execute(new RedisCallback<Object>() {
                @Override
                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.setEx(key.getBytes(), 60 * 2l, value.getBytes());
                    
                    return null;
                }
            });
            sendMap.put(key, value);
        }
        
        return sendMap;

       
    }
    
    /**
     * 根据发送的信息存储的缓存中
     * <p/>
     * 如果被覆盖 则不发送
     *
     * @param orgInfo
     * @param student
     * @param teacher
     * @param lesson
     * @param course
     * @param status
     */
    private void timerSendSignMsg(final OrgInfo orgInfo, final OrgStudent student, final Teacher teacher, final OrgClassLesson lesson, final OrgCourse course, final Integer status) {
        
        
        final String key = orgInfo.getId() + "" + student.getId() + "" + lesson.getId();
        final String value = UUID.randomUUID().toString();
        redisTemplate.execute(new RedisCallback<Object>() {
            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.setEx(key.getBytes(), 60 * 2l, value.getBytes());
                return null;
            }
        });

        Timer timer = new Timer();
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                redisTemplate.execute(new RedisCallback<Object>() {
                    @Override
                    public Object doInRedis(RedisConnection connection) throws DataAccessException {
                        String olduuid = redisTemplate.getStringSerializer().deserialize(connection.get(key.getBytes()));
                        log.debug("time send sign msg =={},{}", olduuid, value);
                        if (value.equals(olduuid)) {
                            signSendMsg(orgInfo, student, teacher, lesson, course, status);
                        }
                        return null;
                    }
                });
            }
        }, 60 * 1000);
    }


    public void signSendMsg(OrgInfo orgInfo, OrgStudent student, Teacher teacher, OrgClassLesson lesson, OrgCourse course, Integer status) {
        try {
            this.msgSendService.sendMsg(getSendMsg(orgInfo, student,
                    teacher == null ? null : teacher.getRealName(), lesson, course, status));
        } catch (Exception e) {
            log.warn(e.getMessage());
        }
    }
    
    private Map<String,OrgLessonSign> conver2Map(List<OrgLessonSign> lessonSignIn){
    	return CollectorUtil.collectMap(lessonSignIn, new Function<OrgLessonSign, String>() {
            @Override
            public String apply(OrgLessonSign arg0) {
            	String key =  arg0.getUserId() + "|" + arg0.getLessonId();
                return key;
            }
        });
    }
    
    private void addToSigninMsgAsynModel(List<OrgLessonSign> lessonSignIn){
    	
    	Map<String,OrgLessonSign> newSignin = conver2Map(lessonSignIn);
    	for(Map.Entry<String, OrgLessonSign> entry:newSignin.entrySet()){
    		final String cacheKey = "siginMsg_"+entry.getKey();
    		final String value = UUID.randomUUID().toString();
    		entry.getValue().setRandomUUID(value);
            redisTemplate.execute(new RedisCallback<Object>() {
                @Override
                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.setEx(cacheKey.getBytes(), 60 * 2l, value.getBytes());
                    return null;
                }
            });
    	}
    	SigninMsgAsynModel.addNewLessonSignIn(newSignin);
    }
}
