
package com.baijia.tianxiao.sal.course.dto.response;

import java.util.Date;

import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;

import lombok.Data;

@Data
public class OrgStudentLessonSignDto {

    private Long id;

    private Long courseId;

    private Long lessonId;

    private Integer signStatus;// 0,未签到；1，签到；2，请假；3，旷课

    private String signStatusStr;

    private Date createTime;

    private String signTime;

    private Date updateTime;

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
        this.signTime = TianXiaoConstant.DAY_TIME_FORMAT.format(updateTime);
    }

    public void setSignStatusEnum(SignStatus signStatusEnum) {
        if (signStatusEnum == null) {
            signStatusEnum = SignStatus.UNSIGN;
        }
        signStatus = signStatusEnum.getCode();
        signStatusStr = signStatusEnum.getMessage();
    }

}
