/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.dto.response;

import com.baijia.tianxiao.sal.course.dto.response.OrgTeacherLessonInfoDto;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class TeacherCourseDto {
    private Long courseId;
    private String courseName;
    private int lessonCount;
    private int minutes;
    private List<OrgTeacherLessonInfoDto> lessons;
    private int signCount;
    private int studentCount;
    private int leaveCount;
    private int absentCount;

    public void setLessons(List<OrgTeacherLessonInfoDto> lessons) {
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgTeacherLessonInfoDto>(){

                @Override
                public int compare(OrgTeacherLessonInfoDto o1, OrgTeacherLessonInfoDto o2) {
                    return o1.getStartTime().compareTo(o2.getStartTime());
                }
            });
        }
        this.lessons = lessons;
        int tempStudentCount = 0;
        int tempSignCount = 0;
        int tempLeaveCount = 0;
        int tempAbsentCount = 0;
        for (OrgTeacherLessonInfoDto lesson : lessons) {
            tempStudentCount += lesson.getStudentCount();
            tempSignCount += lesson.getSignCount();
            tempLeaveCount += lesson.getLeaveCount();
            tempAbsentCount += lesson.getAbsentCount();
        }
        this.studentCount = tempStudentCount;
        this.signCount = tempSignCount;
        this.leaveCount = tempLeaveCount;
        this.absentCount = tempAbsentCount;
    }

    public Long getCourseId() {
        return this.courseId;
    }

    public String getCourseName() {
        return this.courseName;
    }

    public int getLessonCount() {
        return this.lessonCount;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public List<OrgTeacherLessonInfoDto> getLessons() {
        return this.lessons;
    }

    public int getSignCount() {
        return this.signCount;
    }

    public int getStudentCount() {
        return this.studentCount;
    }

    public int getLeaveCount() {
        return this.leaveCount;
    }

    public int getAbsentCount() {
        return this.absentCount;
    }

    public void setCourseId(Long courseId) {
        this.courseId = courseId;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }

    public void setLessonCount(int lessonCount) {
        this.lessonCount = lessonCount;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public void setSignCount(int signCount) {
        this.signCount = signCount;
    }

    public void setStudentCount(int studentCount) {
        this.studentCount = studentCount;
    }

    public void setLeaveCount(int leaveCount) {
        this.leaveCount = leaveCount;
    }

    public void setAbsentCount(int absentCount) {
        this.absentCount = absentCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TeacherCourseDto)) {
            return false;
        }
        TeacherCourseDto other = (TeacherCourseDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$courseId = this.getCourseId();
        Long other$courseId = other.getCourseId();
        if (this$courseId == null ? other$courseId != null : !((Object)this$courseId).equals(other$courseId)) {
            return false;
        }
        String this$courseName = this.getCourseName();
        String other$courseName = other.getCourseName();
        if (this$courseName == null ? other$courseName != null : !this$courseName.equals(other$courseName)) {
            return false;
        }
        if (this.getLessonCount() != other.getLessonCount()) {
            return false;
        }
        if (this.getMinutes() != other.getMinutes()) {
            return false;
        }
        List<OrgTeacherLessonInfoDto> this$lessons = this.getLessons();
        List<OrgTeacherLessonInfoDto> other$lessons = other.getLessons();
        if (this$lessons == null ? other$lessons != null : !((Object)this$lessons).equals(other$lessons)) {
            return false;
        }
        if (this.getSignCount() != other.getSignCount()) {
            return false;
        }
        if (this.getStudentCount() != other.getStudentCount()) {
            return false;
        }
        if (this.getLeaveCount() != other.getLeaveCount()) {
            return false;
        }
        return this.getAbsentCount() == other.getAbsentCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TeacherCourseDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $courseId = this.getCourseId();
        result = result * 59 + ($courseId == null ? 43 : ((Object)$courseId).hashCode());
        String $courseName = this.getCourseName();
        result = result * 59 + ($courseName == null ? 43 : $courseName.hashCode());
        result = result * 59 + this.getLessonCount();
        result = result * 59 + this.getMinutes();
        List<OrgTeacherLessonInfoDto> $lessons = this.getLessons();
        result = result * 59 + ($lessons == null ? 43 : ((Object)$lessons).hashCode());
        result = result * 59 + this.getSignCount();
        result = result * 59 + this.getStudentCount();
        result = result * 59 + this.getLeaveCount();
        result = result * 59 + this.getAbsentCount();
        return result;
    }

    public String toString() {
        return "TeacherCourseDto(courseId=" + this.getCourseId() + ", courseName=" + this.getCourseName() + ", lessonCount=" + this.getLessonCount() + ", minutes=" + this.getMinutes() + ", lessons=" + this.getLessons() + ", signCount=" + this.getSignCount() + ", studentCount=" + this.getStudentCount() + ", leaveCount=" + this.getLeaveCount() + ", absentCount=" + this.getAbsentCount() + ")";
    }
}

