/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.dto.response;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class OrgTeacherLessonInfoDto {
    private static String LESSON_NUMBER_FORMAT = "\u7b2c%d\u8282";
    private Long lessonId;
    private Long courseId;
    private String name;
    private String roomName;
    private int freeLessonCount;
    private int studentCount;
    private int signCount;
    private int leaveCount;
    private int absentCount;
    private int unsignCount;
    private Date startTime;
    private Date endTime;
    private Integer index;
    private int minutes;

    public String getLessonNumberInfo() {
        return String.format(LESSON_NUMBER_FORMAT, this.index);
    }

    public String getLessonTime() {
        Preconditions.checkArgument((this.startTime != null ? 1 : 0) != 0, (Object)"lesson start time can not be null");
        Preconditions.checkArgument((this.endTime != null ? 1 : 0) != 0, (Object)"lesson end time can not be null");
        String startTimeStr = TianXiaoConstant.TIME_MINUTE_FORMAT.format(this.startTime);
        String endTimeStr = TianXiaoConstant.TIME_MINUTE_FORMAT.format(this.endTime);
        return startTimeStr + "-" + endTimeStr;
    }

    public String getSignRate() {
        if (this.studentCount == 0) {
            return "0%";
        }
        String rate = new BigDecimal(this.studentCount - this.unsignCount).multiply(new BigDecimal(100)).divide(new BigDecimal(this.studentCount), 2, RoundingMode.HALF_UP).toString();
        return rate + "%";
    }

    public Long getLessonId() {
        return this.lessonId;
    }

    public Long getCourseId() {
        return this.courseId;
    }

    public String getName() {
        return this.name;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public int getFreeLessonCount() {
        return this.freeLessonCount;
    }

    public int getStudentCount() {
        return this.studentCount;
    }

    public int getSignCount() {
        return this.signCount;
    }

    public int getLeaveCount() {
        return this.leaveCount;
    }

    public int getAbsentCount() {
        return this.absentCount;
    }

    public int getUnsignCount() {
        return this.unsignCount;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Integer getIndex() {
        return this.index;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setLessonId(Long lessonId) {
        this.lessonId = lessonId;
    }

    public void setCourseId(Long courseId) {
        this.courseId = courseId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public void setFreeLessonCount(int freeLessonCount) {
        this.freeLessonCount = freeLessonCount;
    }

    public void setStudentCount(int studentCount) {
        this.studentCount = studentCount;
    }

    public void setSignCount(int signCount) {
        this.signCount = signCount;
    }

    public void setLeaveCount(int leaveCount) {
        this.leaveCount = leaveCount;
    }

    public void setAbsentCount(int absentCount) {
        this.absentCount = absentCount;
    }

    public void setUnsignCount(int unsignCount) {
        this.unsignCount = unsignCount;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrgTeacherLessonInfoDto)) {
            return false;
        }
        OrgTeacherLessonInfoDto other = (OrgTeacherLessonInfoDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$lessonId = this.getLessonId();
        Long other$lessonId = other.getLessonId();
        if (this$lessonId == null ? other$lessonId != null : !((Object)this$lessonId).equals(other$lessonId)) {
            return false;
        }
        Long this$courseId = this.getCourseId();
        Long other$courseId = other.getCourseId();
        if (this$courseId == null ? other$courseId != null : !((Object)this$courseId).equals(other$courseId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$roomName = this.getRoomName();
        String other$roomName = other.getRoomName();
        if (this$roomName == null ? other$roomName != null : !this$roomName.equals(other$roomName)) {
            return false;
        }
        if (this.getFreeLessonCount() != other.getFreeLessonCount()) {
            return false;
        }
        if (this.getStudentCount() != other.getStudentCount()) {
            return false;
        }
        if (this.getSignCount() != other.getSignCount()) {
            return false;
        }
        if (this.getLeaveCount() != other.getLeaveCount()) {
            return false;
        }
        if (this.getAbsentCount() != other.getAbsentCount()) {
            return false;
        }
        if (this.getUnsignCount() != other.getUnsignCount()) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        return this.getMinutes() == other.getMinutes();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrgTeacherLessonInfoDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $lessonId = this.getLessonId();
        result = result * 59 + ($lessonId == null ? 43 : ((Object)$lessonId).hashCode());
        Long $courseId = this.getCourseId();
        result = result * 59 + ($courseId == null ? 43 : ((Object)$courseId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $roomName = this.getRoomName();
        result = result * 59 + ($roomName == null ? 43 : $roomName.hashCode());
        result = result * 59 + this.getFreeLessonCount();
        result = result * 59 + this.getStudentCount();
        result = result * 59 + this.getSignCount();
        result = result * 59 + this.getLeaveCount();
        result = result * 59 + this.getAbsentCount();
        result = result * 59 + this.getUnsignCount();
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        result = result * 59 + this.getMinutes();
        return result;
    }

    public String toString() {
        return "OrgTeacherLessonInfoDto(lessonId=" + this.getLessonId() + ", courseId=" + this.getCourseId() + ", name=" + this.getName() + ", roomName=" + this.getRoomName() + ", freeLessonCount=" + this.getFreeLessonCount() + ", studentCount=" + this.getStudentCount() + ", signCount=" + this.getSignCount() + ", leaveCount=" + this.getLeaveCount() + ", absentCount=" + this.getAbsentCount() + ", unsignCount=" + this.getUnsignCount() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", index=" + this.getIndex() + ", minutes=" + this.getMinutes() + ")";
    }
}

