
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.course.service.impl;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.common.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.CourseNotifyWechatMsg;
import com.baijia.tianxiao.sal.common.utils.NotifyMessageUtils;
import com.baijia.tianxiao.sal.common.utils.WechatTemplateMsgHelper;
import com.baijia.tianxiao.sal.course.dto.MsgSendResult;
import com.baijia.tianxiao.sal.course.service.OrgLessonSyncService;
import com.baijia.tianxiao.sal.course.util.ErpUtils;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import sun.misc.BASE64Encoder;

/**
 * @author shanyu
 * @version 1.0
 * @title OrgLessonSyncServiceImpl
 * @desc TODO
 * @date 2016年1月18日
 */
@Service
@Slf4j
public class OrgLessonSyncServiceImpl implements OrgLessonSyncService {

    private static String lessonStartStudent = "%s，你在%s的%s%s将在%s开始上课。请做好上课准备哦。如有疑问，请拨打4000122166转%s。";

    private static String lessonStartStudent22480 =
            "%s，你在%s的%s%s将在%s开始上课。请做好上课准备哦。班课不接受请假，一对一请假请拨打(4000122166转%s)上课当天不接受请假。";

    private static String defaultName = "-";

    private static String remark = "别迟到哦～～";

    @Autowired(required = false)
    private CommonMsgService commonMsgService;

    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;

    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;

    @Resource
    private OrgInfoDao orgInfoDao;

    @Resource
    private OrgClassRoomDao OrgClassRoomDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private TeacherDao teacherDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;

    @Resource
    private OrgLessonSignService orgLessonSignService;

    /*
     * private static ThreadLocal<Map<Long,MsgSendResult>> lessonSyncResult = new
     * ThreadLocal<Map<Long,MsgSendResult>>();
     * 
     * private String lessonSyncReadyCountKey = "lessonSyncReadyCountKey";
     * 
     * private String lessonSyncFailCountKey = "lessonSyncFailCountKey";
     */

    private boolean checkOrgPermissionLessonMsg(Integer orgId) {
        TXSaleClueRule tXSaleClueRule = tXSaleClueRuleService.getByOrgId(orgId);
        if (tXSaleClueRule != null && tXSaleClueRule.getAttendClassMsg() == 0) {
            return true;
        } else {
            return false;
        }

    }

    @PostConstruct
    public void init() {

    }

    @Override
    public void syncSMSBeforeLessonBegin() {
        // 初始化本地线程
        MsgSendResult.lessonSyncResult.set(new HashMap<Integer, MsgSendResult>());
        Date now = new Date();

        Date startTime = DateUtil.getEndOfDay(now);
        for (int i = 0; i < 24; i++) {
            Date tempStartTime = DateUtil.getDiffDateTime(startTime, i, Calendar.HOUR_OF_DAY);
            Date tempEndTime = DateUtil.getDiffDateTime(startTime, i + 1, Calendar.HOUR_OF_DAY);
            studentLessonSms(tempStartTime, tempEndTime);
            log.debug("send message startTime={},endTime={}", tempStartTime, tempEndTime);
        }

        Map<Integer, MsgSendResult> result = MsgSendResult.lessonSyncResult.get();
        log.info("lessonSyncResult={}", result);
        try {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Integer, MsgSendResult> orgSendResult : result.entrySet()) {
                MsgSendResult tempOrgResult = orgSendResult.getValue();
                String resultStr = JSONObject.fromObject(tempOrgResult).toString();
                sb.append(resultStr + ",\n");
            }

            sendMail(sb.toString());
        } catch (Exception e) {
            log.error("syncSMSBeforeLessonBegin result mail error", e);
        }
        // 清空本地线程
        MsgSendResult.lessonSyncResult.set(null);

    }

    /**
     * 通知学生上课
     *
     * @param startTime
     * @param endTime
     */
    private void studentLessonSms(Date startTime, Date endTime) {
        // 当前时间后的 25～30 分钟之内开始的课节
        Map<Long, List<Long>> lessonUnBeginMap =
                this.orgStudentLessonDao.getStudentLessonByStartTime(startTime, endTime);
        log.debug("lessonUnBeginMap={}", lessonUnBeginMap);
        List<OrgClassLesson> lessons = this.orgClassLessonDao.getByIds(lessonUnBeginMap.keySet());

        Map<String, OrgLessonSign> orgLessonSignMap = orgLessonSignService.getLessonSignStatus(lessonUnBeginMap.keySet());

        Map<Long, Long> teacherIdMap =
                this.orgTeacherLessonDao.queryLessonTeacherIdMap(null, lessonUnBeginMap.keySet());
        Map<Long, String> teacherNameMap = teacherDao.getTeacherRealNameMap(teacherIdMap.values());

        Set<Long> courseIds = Sets.newHashSet();// 课程id
        Set<Integer> orgIds = Sets.newHashSet();// 机构id
        Set<Long> orgIdLs = Sets.newHashSet();// 机构id
        Set<Long> roomIds = Sets.newHashSet();// 教室id
        Set<Long> userIds = Sets.newHashSet();// 学员userId
        for (OrgClassLesson lesson : lessons) {

            courseIds.add(lesson.getCourseId());
            orgIds.add(lesson.getOrgId().intValue());
            orgIdLs.add(lesson.getOrgId());
            roomIds.add(lesson.getRoomId());
            List<Long> value = lessonUnBeginMap.get(lesson.getId());
            if (CollectionUtils.isNotEmpty(value)) {
                userIds.addAll(value);
            }
        }
        log.debug("courseIds={},orgIds={},roomIds={}", courseIds, orgIds, roomIds);
        Map<Long, OrgInfo> orgInfos = getOrgInfoMap(orgIds);
        // Map<Integer,TXSaleClueRule> orgSaleClueRules = getOrgSaleClueRule(orgIds);
        Map<Long, OrgCourse> courseInfos = getCourseInfos(courseIds);
        Map<String, OrgStudent> studentInfos = getStudentInfos(orgIdLs, userIds);
        Map<Long, String> roomNameMap = this.OrgClassRoomDao.getRoomName(null, roomIds);// 教室名称

        for (OrgClassLesson lesson : lessons) {

            OrgInfo orgInfo = orgInfos.get(lesson.getOrgId());// 机构信息
            List<Long> lessonUserIds = lessonUnBeginMap.get(lesson.getId());
            int tempStudentCount = 0;
            if (lessonUserIds != null) {
                tempStudentCount = lessonUserIds.size();
            }

            MsgSendResult.addLessonCount(orgInfo, 1, tempStudentCount);
            // bugfix 权限校验的批量接口逻辑不正确，暂时改为单查询，效率略低，先确保逻辑正确
            if (!checkOrgPermissionLessonMsg(lesson.getOrgId().intValue())) {
                MsgSendResult.addFailRule(orgInfo, 1, tempStudentCount);
                log.info("机构权限不足，过滤上课提醒，机构id:{},机构名字:{}", lesson.getOrgId(),
                        orgInfo == null ? null : orgInfo.getName());
                continue;
            }

            OrgCourse course = courseInfos.get(lesson.getCourseId());// 课程信息

            if (course == null || course.getIsDel() != 0) {
                MsgSendResult.addFailDelCourse(orgInfo, 1, tempStudentCount);
                log.info("课程状态是已删除，过滤上课提醒，机构id:{},机构名字:{},课程id:{}", lesson.getOrgId(),
                        orgInfo == null ? null : orgInfo.getName(), course == null ? null : course.getName());
                continue;
            }

            Long teacherId = teacherIdMap.get(lesson.getId());
            String teacherName = null;
            if (teacherId != null) {
                teacherName = teacherNameMap.get(teacherId);
            }
            String roomName = null;
            if (lesson.getRoomId() != null) {
                roomName = roomNameMap.get(lesson.getRoomId());
            }
            if (orgInfo != null && course != null && CollectionUtils.isNotEmpty(lessonUserIds)) {
                int delStudentFailCount = 0;
                int sendFailCount = 0;
                for (Long lessonUserId : lessonUserIds) {
                    OrgStudent student = studentInfos
                            .get(String.valueOf(orgInfo.getOrgId()) + String.valueOf('|') + String.valueOf(lessonUserId));

                    if (student != null && student.getDelStatus() == 0) {
                        try {
                            //已经签到的不发短信
                            OrgLessonSign orgLessonSign = orgLessonSignMap.get(lesson.getId().longValue() + "_" + lessonUserId.longValue());
                            if (orgLessonSign == null || orgLessonSign.getStatus().intValue() == SignStatus.UNSIGN.getCode()) {
                                boolean bool = commonMsgService.sendMsg(
                                        getStudentLessonStartRequest(teacherName, roomName, lesson, course, orgInfo, student));
                                if (!bool) {
                                    sendFailCount++;
                                }
                            }
                        } catch (Exception e) {
                            log.error("error is:{} ", e);
                        }
                    } else {
                        delStudentFailCount++;
                        log.info("学员状态不合法，过滤上课提醒，机构id:{},机构名字:{},课程id:{},学员id:{}", lesson.getOrgId(),
                                orgInfo == null ? null : orgInfo.getName(), course == null ? null : course.getName(),
                                lessonUserId);
                    }

                }
                MsgSendResult.addFailDelStudent(orgInfo, delStudentFailCount);
                MsgSendResult.addFailSend(orgInfo, sendFailCount);
            }
        } /**
         * TODO 发送短信
         */

    }

    /**
     * 构造学生上课提醒信息
     *
     * @param teacherName
     * @param roomName
     * @param lesson
     * @param course
     * @param orgInfo
     * @param student
     * @return
     */
    private SendMsgRequest getStudentLessonStartRequest(String teacherName, String roomName, OrgClassLesson lesson,
                                                        OrgCourse course, OrgInfo orgInfo, OrgStudent student) {

        // 构建短信内容
        String smsContent = null;
        // 线上环境对机构orgId=22480 上课提醒做特殊话术修改，卢佳定制,测试环境orgId=3792,小心处理
        if (orgInfo != null && orgInfo.getOrgId() != null && orgInfo.getOrgId().intValue() == 22480) {
            smsContent = String.format(lessonStartStudent22480, getStringValue(student.getName()),
                    getStringValue(orgInfo.getShortName()), getStringValue(course.getName()),
                    NotifyMessageUtils.generateLessonName(lesson.getName(), false),
                    DateUtil.getStrByDateFormate(lesson.getStartTime(), "yyyy-MM-dd HH:mm"),
                    getStringValue(orgInfo.getExtension()));
        } else {
            smsContent = SmsContentHelper.createClassNotify(lesson.getStartTime().getTime(),
                    getStringValue(course.getName()), orgInfo.getShortName());
        }

        String scheduleUrl = ErpUtils.createClassSchedule(orgInfo.getOrgId().longValue(), student.getId());
        // 构建微信内容
        CourseNotifyWechatMsg msg =
                CourseNotifyWechatMsg.newInstance(student.getName(), course.getName(), orgInfo.getExtension(),
                        lesson.getStartTime().getTime(), lesson.getEndTime().getTime(), teacherName, roomName, scheduleUrl);
        SendMsgRequest createSendMsgRequestToStu =
                WechatTemplateMsgHelper.createSendMsgRequestToStu(orgInfo.getOrgId().longValue(), student.getMobile(),
                        student.getId(), student.getWeixin(), smsContent, WechateTemplateMsgType.COURSE_START_TO_STU, msg);

        createSendMsgRequestToStu.setSmsCodeType(TxSmsCodeType.CLASS_NOTIFY);
        return createSendMsgRequestToStu;
    }

    /**
     * 构造学生上课提醒信息
     *
     * @param teacherName
     * @param roomName
     * @param lesson
     * @param course
     * @param orgInfo
     * @param student
     * @return
     */
    private SendMsgRequest getStudentLessonStart(String teacherName, String roomName, OrgClassLesson lesson,
                                                 OrgCourse course, OrgInfo orgInfo, OrgStudent student) {
        SendMsgRequest request = new SendMsgRequest();
        request.setOrgId(orgInfo.getOrgId().longValue());
        request.setMobile(student.getMobile());
        request.setCountSms(false);
        request.setReceiverId(student.getId());
        request.setWeixinOpenId(student.getWeixin());
        request.setReceiverRole(UserRoleEnum.STUDENT);
        request.setSenderId(orgInfo.getOrgId().longValue());
        request.setSenderRole(UserRoleEnum.ORG);
        request.setWechatTemplateId(WechateTemplateMsgType.COURSE_START_TO_STU.getValue());
        String smsContent =
                String.format(lessonStartStudent, getStringValue(student.getName()), getStringValue(orgInfo.getShortName()),
                        getStringValue(course.getName()), NotifyMessageUtils.generateLessonName(lesson.getName(), false),
                        DateUtil.getStrByDateFormate(lesson.getStartTime(), "yyyy-MM-dd HH:mm"),
                        getStringValue(orgInfo.getExtension()));
        // 线上环境对机构orgId=22480 上课提醒做特殊话术修改，卢佳定制,测试环境orgId=3792,小心处理
        if (orgInfo != null && orgInfo.getOrgId() != null && orgInfo.getOrgId().intValue() == 22480) {
            smsContent = String.format(lessonStartStudent22480, getStringValue(student.getName()),
                    getStringValue(orgInfo.getShortName()), getStringValue(course.getName()),
                    NotifyMessageUtils.generateLessonName(lesson.getName(), false),
                    DateUtil.getStrByDateFormate(lesson.getStartTime(), "yyyy-MM-dd HH:mm"),
                    getStringValue(orgInfo.getExtension()));
        }
        Map<String, Object> params = Maps.newHashMap();
        request.setSmsContent(SmsContentHelper.createClassNotify(lesson.getStartTime().getTime(),
                getStringValue(course.getName()), orgInfo.getShortName()));
        params.put("first", smsContent);
        params.put("remark", remark);
        params.put("keyword1", DateUtil.getStrByDateFormate(lesson.getStartTime(), "yyyy-MM-dd HH:mm"));
        params.put("keyword2", getStringValue(teacherName));
        params.put("keyword3",
                getStringValue(course.getName()) + NotifyMessageUtils.generateLessonName(lesson.getName(), true));
        params.put("keyword4", getStringValue(roomName));
        request.setWechatParams(params);
        log.debug("send msg={}", request);
        return request;
    }

    /**
     * 没有名称返回“－”
     *
     * @param message
     * @return
     */
    private String getStringValue(String message) {
        if (StringUtils.isBlank(message)) {
            return defaultName;
        }
        return message;
    }

    /**
     * 通知学生上课
     *
     * @param startTime
     * @param endTime
     */
    private void teacherLessonSms(Date startTime, Date endTime) {
        // 当前时间后的 25～30 分钟之内开始的课节
        Map<Long, List<Long>> lessonUnBeginMap =
                this.orgTeacherLessonDao.getTeacherLessonByStartTime(startTime, endTime);
        List<OrgClassLesson> lessons = this.orgClassLessonDao.getByIds(lessonUnBeginMap.keySet());
        Set<Long> courseIds = Sets.newHashSet();// 课程id
        Set<Integer> orgIds = Sets.newHashSet();// 机构id
        Set<Long> orgIdLs = Sets.newHashSet();// 机构id
        Set<Long> roomIds = Sets.newHashSet();// 教室id
        Set<Long> userIds = Sets.newHashSet();// 学员userId
        for (OrgClassLesson lesson : lessons) {
            courseIds.add(lesson.getCourseId());
            orgIds.add(lesson.getOrgId().intValue());
            orgIdLs.add(lesson.getOrgId());
            roomIds.add(lesson.getRoomId());
            List<Long> value = lessonUnBeginMap.get(lesson.getId());
            if (CollectionUtils.isNotEmpty(value)) {
                userIds.addAll(value);
            }
        }
        Map<Long, OrgInfo> orgInfos = getOrgInfoMap(orgIds);
        Map<Long, OrgCourse> courseInfos = getCourseInfos(courseIds);
        Map<Long, Teacher> teacherInfos = getTeacherInfos(userIds);
        /**
         * TODO 发送短信
         */

    }

    /**
     * 获取老师信息
     *
     * @param userIds
     * @return
     */
    private Map<Long, Teacher> getTeacherInfos(Collection<Long> userIds) {
        List<Teacher> teachers = this.teacherDao.getByUserIds(userIds);
        return CollectorUtil.collectMap(teachers, new Function<Teacher, Long>() {
            @Override
            public Long apply(Teacher arg0) {
                return arg0.getUserId();
            }
        });
    }

    private Map<String, OrgStudent> getStudentInfos(Collection<Long> orgIds, Collection<Long> userIds) {
        List<OrgStudent> students = this.orgStudentDao.getStudentsByUserIdsAndOrgIds(orgIds, userIds);
        return CollectorUtil.collectMap(students, new Function<OrgStudent, String>() {
            @Override
            public String apply(OrgStudent arg0) {
                return String.valueOf(arg0.getOrgId()) + String.valueOf('|') + String.valueOf(arg0.getUserId());
            }
        });
    }

    /**
     * 获取教室信息
     *
     * @param roomIds
     * @return
     */
    private Map<Long, OrgClassRoom> getRoomsInfos(Collection<Long> roomIds) {
        List<OrgClassRoom> rooms = this.OrgClassRoomDao.getByIds(roomIds);
        return CollectorUtil.collectMap(rooms, new Function<OrgClassRoom, Long>() {
            @Override
            public Long apply(OrgClassRoom arg0) {
                return arg0.getId();
            }
        });
    }

    /**
     * 获取课程信息
     *
     * @param courseIds
     * @return
     */
    private Map<Long, OrgCourse> getCourseInfos(Collection<Long> courseIds) {
        List<OrgCourse> courses = this.orgCourseDao.getByIds(courseIds);
        return CollectorUtil.collectMap(courses, new Function<OrgCourse, Long>() {
            @Override
            public Long apply(OrgCourse arg0) {
                return arg0.getId();
            }
        });
    }

    /**
     * 获取机构信息
     *
     * @param orgIds
     * @return
     */
    private Map<Long, OrgInfo> getOrgInfoMap(Collection<Integer> orgIds) {
        List<OrgInfo> orgInfos = this.orgInfoDao.getOrgInfos(orgIds);
        return CollectorUtil.collectMap(orgInfos, new Function<OrgInfo, Long>() {
            @Override
            public Long apply(OrgInfo arg0) {
                return arg0.getOrgId().longValue();
            }
        });
    }

    private Map<Integer, TXSaleClueRule> getOrgSaleClueRule(Collection<Integer> orgIds) {
        return tXSaleClueRuleService.queryByIds(orgIds);
    }

    private void sendMail(String content) {
        Properties prop = new Properties();
        prop.setProperty("mail.host", "mail.baijiahulian.com");
        prop.setProperty("mail.smtp.auth", "true");

        Authenticator auth = new Authenticator() {
            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("txm", "$lVo6%s*grcV5bqQ");
            }
        };
        Session session = Session.getInstance(prop, auth);

        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom(new InternetAddress("MTPM@baijiahulian.com"));
            msg.addRecipients(Message.RecipientType.TO, "leiruiqi@baijiahulian.com");
            sun.misc.BASE64Encoder base64 = new BASE64Encoder();
            String subject = new String(base64.encode(("监控测试").getBytes("UTF-8")));
            msg.setSubject(MimeUtility.encodeText("监控测试", "UTF-8", "B"));
            MimeMultipart parts = new MimeMultipart();
            MimeBodyPart part = new MimeBodyPart();
            part.setContent(content, "text/html;charset=utf-8");
            parts.addBodyPart(part);
            msg.setContent(parts);
            Transport.send(msg);
        } catch (Exception e) {
            log.error("OrgLessonSyncService send mail error", e);
        }
    }
}