package com.baijia.tianxiao.sal.course.dto;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.sal.course.dto.response.OrgCourseGroupDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.organization.org.dto.addressbook.TXAddressBookDto;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.List;

@Data
public class OrgCourseInfoDto {
    private Long courseId; // 课程ID id<=0 || id ==null 则添加
    private String courseName; // 课程名称
    private Double coursePrice; // 价格
    private String coursePriceStr;// 价格
    private Long courseNumber;// 课程号
    private Integer studentNum;// 学生数
    private Integer maxStudent; // 最大学生数
    private Integer freq; // 计划课节
    private Integer hasPlan;// 已完成课节
    private String startDay;// 开课时间
    private String startWeek;// 开课星期
    /**
     * 是否显示排课按钮. 逻辑:
     * if(当前操作人 has 排课权限){
     *     if(当前操作人 is 员工 && 当前操作人 is not 当前课程班主任){
     *         lost;
     *     }else{
     *         own;
     *     }
     * }else{
     *     lost;
     * }
     */
    private Integer showArrangeCourse;
    private Integer consumeRule; // 课消规则的数值
    private String consumeRuleStr; // 课消规则对应的话术显示
    private Integer courseType; // 课程类型，1是班课，2是1v1课程
    private Integer chargeType; //收费类型
    private Integer chargeUnit; //计费单位

    private Date startTime; // 上课开始时间
    private Date endTime; // 上课结束时间

    // private Integer lessonCount;// 排课课节
    // private Integer lessonFinish; // 上完的课节

    private Integer coverStorageId; // 封面storageId
    private String coverUrl; // 封面url
    private String courseUrl;
    private String introduction;// 课程简介
    private Integer status; // 状态 0=招生中,1=已下架
    private String address;// 课程上课地址
    private Double lng; // 经度
    private Double lat;// 纬度
    private String cityName;// 城市名
    private Integer isDel;
    private String group;
    private String lessonSummary;
    private List<OrgCourseGroupDto> groups;
    private List<TeacherResponseDto> teachers = null;
    private Integer isCourse; // 课程类型
    private Integer isClass;
    private Long parentId;
    private String teacherIds = null;// 课程老师
    
    private Integer refundDays; //退款天数
    
    private Integer effectDays;//有效天数

    private Integer fullStatus;//是否满班

    private Integer fullEnrollRule;//满班招生规则0 不可招生  1可招生
    private String addressDetail;//地址id

    public String getCoverUrl() {
        if (StringUtils.isBlank(coverUrl)) {
            return TianXiaoConstant.DEFAULT_CLASS_COVER;
        } else {
            return coverUrl;
        }
    }
}
