/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.util;

import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErpUtils {
    private static final Logger log = LoggerFactory.getLogger(ErpUtils.class);

    public static String createClassSchedule(Long orgId, Long studentId) {
        try {
            Properties fillProperties = PropertiesReader.fillProperties((String)"erp.properties");
            log.info("fillProperties is:{} ", (Object)fillProperties);
            String scheduleUrl = fillProperties.getProperty("student_class_schedule");
            if (GenericsUtils.isNullOrEmpty((Object)scheduleUrl)) {
                return "";
            }
            StudentSmsTokenDto token = new StudentSmsTokenDto(orgId, null, studentId, null);
            token.setStudentId(studentId);
            String scheduleUrlStr = scheduleUrl.replace("#{TOKEN}", token.toTokenStr());
            return ShortUrlUtil.getShortUrl((String)scheduleUrlStr);
        }
        catch (Exception e) {
            log.info("can not create token with orgId:{} and studentId:{} ", (Object)orgId, (Object)studentId);
            return "";
        }
    }
}

