/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.syncThread;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;
import com.baijia.tianxiao.util.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PreDestroy;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Deprecated
public class SyncOrgSignupCourseServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(SyncOrgSignupCourseServiceImpl.class);
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgSignupCourseService orgSignupCourseService;
    @Autowired
    private OrgCourseDao orgCourseDao;
    private Integer BATCH_SYNC_NUMBER = 1000;
    private List<Long> orgIds = null;
    private volatile Boolean flag;
    private SyncSignupThread thread;

    public void start(Integer startId, Integer endId, List<Long> orgIds) {
        this.orgIds = orgIds;
        if (null == this.thread) {
            this.flag = true;
            this.thread = new SyncSignupThread(startId, endId);
            new Thread(this.thread).start();
        } else {
            if (this.flag.booleanValue()) {
                return;
            }
            this.flag = true;
            this.thread = new SyncSignupThread(startId, endId);
            new Thread(this.thread).start();
        }
    }

    @PreDestroy
    public void preDestory() {
        this.stop();
    }

    public void stop() {
        this.flag = false;
    }

    @Transactional
    private int syncBetween(Integer startId, Integer endId) {
        List studentCourseList = this.orgStudentCourseDao.getBetweenId(startId, endId, this.orgIds, Integer.valueOf(StudentCourseStatus.NORMAL.getCode()), Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[0]);
        log.info("syncBetween [{},{}) get List<OrgStudentCourse> size:{}", new Object[]{startId, endId, studentCourseList.size()});
        HashSet orgIds = Sets.newHashSet();
        HashSet courseIds = Sets.newHashSet();
        HashSet userIds = Sets.newHashSet();
        for (OrgStudentCourse orgStudentCourse : studentCourseList) {
            orgIds.add(orgStudentCourse.getOrgId());
            courseIds.add(orgStudentCourse.getCourseId());
            userIds.add(orgStudentCourse.getUserId());
        }
        Map classMap = this.orgCourseDao.getOrgCourseMap((Collection)courseIds, new String[]{"id", "number", "price", "isDel", "isCourse", "isClass", "parentId", "courseType"});
        HashSet parentIds = Sets.newHashSet();
        for (OrgCourse course : classMap.values()) {
            if (course.getCourseType() != CourseTypeEnum.COURSE_TYPE_1v1.getCode()) continue;
            if (course.getIsCourse() == CourseTypeEnum.IS_COURSE_FALSE.getCode() && course.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode()) {
                parentIds.add(course.getParentId());
                continue;
            }
            log.error("\u6570\u636e\u9519\u8bef, \u4e0d\u8be5\u51fa\u73b01v1\u8bfe\u7a0b, \u5e94\u8be5\u90fd\u662f1V1\u73ed\u7ea7 :{}", (Object)course);
        }
        Map courseMap = CollectorUtil.collectMap((Collection)this.orgCourseDao.getCoursesByParentIdsIgnoreDel(null, (Collection)parentIds, new String[]{"id", "number", "price", "isDel", "isCourse", "isClass", "parentId", "courseType"}), (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse input) {
                return input.getId();
            }
        });
        HashMap classCourseMap = Maps.newHashMap();
        for (OrgCourse course : courseMap.values()) {
            classCourseMap.put(course.getId(), course.getParentId());
        }
        HashMap allCourseMap = Maps.newHashMap();
        allCourseMap.putAll(classMap);
        allCourseMap.putAll(courseMap);
        allCourseMap.putAll(this.orgCourseDao.getOrgCourseMap((Collection)parentIds, new String[]{"id", "number", "price", "isDel", "isCourse", "isClass", "parentId", "courseType"}));
        HashMap courseStuStrMap = Maps.newHashMap();
        for (OrgStudentCourse orgStudentCourse : studentCourseList) {
            Long parentId = (Long)classCourseMap.get(orgStudentCourse.getCourseId());
            if (null != parentId) {
                courseStuStrMap.put(orgStudentCourse.getOrgId() + "," + parentId + "," + orgStudentCourse.getUserId(), orgStudentCourse);
                continue;
            }
            courseStuStrMap.put(orgStudentCourse.getOrgId() + "," + orgStudentCourse.getCourseId() + "," + orgStudentCourse.getUserId(), orgStudentCourse);
        }
        List signupCourseList = this.orgSignupCourseDao.getByCourseIdsAndStudentIds((Collection)orgIds, allCourseMap.keySet(), (Collection)userIds, new String[0]);
        log.info("syncBetween [{},{}) get List<OrgSignupCourse> size:{}", new Object[]{startId, endId, signupCourseList.size()});
        List signupKeys = Lists.transform((List)signupCourseList, (Function)new Function<OrgSignupCourse, String>(){

            public String apply(OrgSignupCourse input) {
                return input.getOrgId() + "," + input.getOrgCourseId() + "," + input.getUserId();
            }
        });
        Set allKeys = courseStuStrMap.keySet();
        allKeys.removeAll(signupKeys);
        log.info("syncBetween [{},{}) find no signup size:{}", new Object[]{startId, endId, allKeys.size()});
        ArrayList newSignupCourses = Lists.newArrayList();
        for (String courseKey : allKeys) {
            OrgStudentCourse orgStudentCourse = (OrgStudentCourse)courseStuStrMap.get(courseKey);
            OrgCourse course = (OrgCourse)allCourseMap.get(Long.parseLong(courseKey.split(",")[1]));
            if (null == course) {
                log.info("****************** dirty data! orgId,courseId,userId is:{} course is :{}", (Object)courseKey, (Object)course);
                continue;
            }
            OrgSignupCourse signupCourse = new OrgSignupCourse();
            signupCourse.setSignupPurchaseId(this.orgSignupCourseService.randomSignupPurchaseId4Excel(orgStudentCourse.getCreateTime()));
            signupCourse.setOrgId(orgStudentCourse.getOrgId());
            signupCourse.setUserId(orgStudentCourse.getUserId());
            signupCourse.setOrgCourseId(course.getId());
            signupCourse.setClassId(orgStudentCourse.getCourseId());
            signupCourse.setOrgCourseNumber(course.getNumber());
            signupCourse.setOriginPrice(Integer.valueOf(new Double(course.getPrice() * 100.0).intValue()));
            signupCourse.setPreferential(signupCourse.getOriginPrice());
            signupCourse.setCount(Integer.valueOf(1));
            signupCourse.setLessonCount(Integer.valueOf(0));
            signupCourse.setCreateTime(orgStudentCourse.getCreateTime());
            signupCourse.setUpdateTime(new Date());
            signupCourse.setStatus(Integer.valueOf(SignupCourseStatus.INIT.getCode()));
            signupCourse.setSyncLessonCount(Integer.valueOf(Flag.TRUE.getInt()));
            newSignupCourses.add(signupCourse);
        }
        log.info("---------------------------------------------------------------");
        if (CollectionUtils.isNotEmpty((Collection)newSignupCourses)) {
            try {
                long now = System.currentTimeMillis();
                this.orgSignupCourseDao.saveAll((List)newSignupCourses, false, new String[]{"orgId", "userId", "orgCourseId", "orgCourseNumber", "originPrice", "preferential", "count", "lessonCount", "createTime", "updateTime", "classId", "signupPurchaseId", "syncLessonCount", "status"});
                log.info("insert done! insert size:{}, cost:{}ms", (Object)newSignupCourses.size(), (Object)(System.currentTimeMillis() - now));
            }
            catch (Exception e) {
                log.error("error! :{}", (Object)e.getMessage());
                log.error("error! :{}", (Throwable)e);
                throw e;
            }
        }
        return newSignupCourses.size();
    }

    public void setBATCH_SYNC_NUMBER(Integer BATCH_SYNC_NUMBER) {
        this.BATCH_SYNC_NUMBER = BATCH_SYNC_NUMBER;
    }

    private class SyncSignupThread
    implements Runnable {
        private Integer startId;
        private Integer endId;
        private Integer temp;
        private Integer batchTimes;
        private Integer totalInsertSize;

        public SyncSignupThread(Integer startId, Integer endId) {
            this.startId = startId;
            this.endId = endId;
            this.temp = startId;
            this.totalInsertSize = 0;
            this.batchTimes = (endId - startId) / SyncOrgSignupCourseServiceImpl.this.BATCH_SYNC_NUMBER;
        }

        @Override
        public void run() {
            try {
                log.info("sync orgSignupCourse is going to start from {}, to {}, by {} batches transection with checking {} courseStudent records per batch.", new Object[]{this.startId, this.endId, this.batchTimes + 1, SyncOrgSignupCourseServiceImpl.this.BATCH_SYNC_NUMBER});
                int i = 0;
                while (SyncOrgSignupCourseServiceImpl.this.flag.booleanValue()) {
                    int dataSize;
                    if (i < this.batchTimes) {
                        dataSize = SyncOrgSignupCourseServiceImpl.this.syncBetween(this.temp, this.temp + SyncOrgSignupCourseServiceImpl.this.BATCH_SYNC_NUMBER);
                        this.temp = this.temp + SyncOrgSignupCourseServiceImpl.this.BATCH_SYNC_NUMBER;
                        ++i;
                    } else {
                        dataSize = SyncOrgSignupCourseServiceImpl.this.syncBetween(this.temp, this.endId);
                        this.temp = this.endId;
                        break;
                    }
                    this.totalInsertSize = this.totalInsertSize + dataSize;
                }
                log.info("sync orgSignupCourse is finished from {}, to {}, by {} batches transection with checking {} courseStudent records per batch. totalInsertSize:{}", new Object[]{this.startId, this.temp, this.batchTimes + 1, SyncOrgSignupCourseServiceImpl.this.BATCH_SYNC_NUMBER, this.totalInsertSize});
            }
            catch (Exception e) {
                log.error("sync orgSignupCourse is error from {}, to {}", new Object[]{this.startId, this.temp, e.getMessage()});
                log.error("task error occured :{}", (Throwable)e);
            }
            finally {
                SyncOrgSignupCourseServiceImpl.this.flag = false;
            }
        }
    }
}

