
package com.baijia.tianxiao.sal.course.service;

import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sal.course.dto.SignStatusRemarkDto;
import com.baijia.tianxiao.sal.course.dto.request.SignWithRemarkRequest;
import com.baijia.tianxiao.sal.course.dto.response.LessonSignReportDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentLessonSignDto;
import com.baijia.tianxiao.sal.course.dto.response.SigninFailedDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 签到
 *
 * @author shizuwei
 * @version 1.0
 * @title OrgLessonSignService
 * @desc TODO
 * @date 2016年1月3日
 * @see com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao
 */
public interface OrgLessonSignService {

    /**
     * 学生批量签到
     *
     * @param orgId
     * @param lessonId
     * @param studentIds
     * @return
     */
    SigninFailedDto orgStudentLessonBatchSign(Long orgId, Long lessonId, List<Long> studentIds, Integer status, int confirm);

    void fillStudentInfo(Long orgId, SigninFailedDto result);

    /**
     * 多课节并集学员签到
     *
     * @param orgId
     * @param courseId
     * @param lessonIds
     * @param userId
     * @param status
     */
    void orgUnionStudentsMultiLessonBatchSign(Long orgId, Long courseId, List<Long> lessonIds, List<Long> userId, Integer status, int confirm);

    public void orgStudentLessonBatchFastSign(Long orgId, Long courseId, List<Long> lessonIds, Map<Long, Integer> studentIdSignInStatus);

    /**
     * 单个学生签到
     *
     * @param orgId
     * @param courseId
     * @param lessonId
     * @param studentId
     * @param status
     */
    void orgStudentLessonSign(Long orgId, Long courseId, Long lessonId, Long studentId, Integer status, Integer teacherId,Integer confirm);

    /**
     * 单个学生的签到情况
     *
     * @param orgId
     * @param courseId
     * @param lessonId
     * @param studentId
     * @return
     */
    OrgStudentLessonSignDto getStudentLessonSign(Long orgId, Long courseId, Long lessonId, Long studentId);

    /**
     * 获取课节学员签到数量
     *
     * @param orgId
     * @param lessonIds
     * @param userIdMap userId:studentId map
     * @return
     */
    Map<Long, Integer> getLessonStudentSignCount(Long orgId, Collection<Long> lessonIds, Map<Long, Long> userIdMap);

    /**
     * 获取课节学员签到情况
     *
     * @param orgId
     * @param lessonIds
     * @param userIdMap userId:studentId map
     * @return
     */
    @Deprecated
    public Map<String, Map<String, Integer>> getLessonStudentSign(Long orgId, Collection<Long> lessonIds,
                                                                  Map<Long, Long> userIdMap);

    /**
     * 获取签到报表
     *
     * @return
     */
    LessonSignReportDto getLessonSignReport(Long orgId, Long studentId);

    /**
     * 获取课程出勤率
     */

    public Map<Long, Double> getAttendanceRateOfCourses(Long orgId, Collection<Long> courseIds);

    /**
     * 获取学生出勤率
     */
    public Map<Long, Double> getAttendanceRateOfStudents(Long orgId, Collection<Long> studentIds);


    Map<String, Map<String, SignStatusRemarkDto>> getLessonStudentSignReport(Long orgId, Collection<Long> lessonIds,
                                                                             Map<Long, Long> userIdMap, Long courseId);


    List<Long> getStudentBySignStatus(Long orgId, Long lessonId);

    void signSendMsg(OrgInfo orgInfo, OrgStudent student, Teacher teacher, OrgClassLesson lesson, OrgCourse course,
                     OrgLessonSign orgLessonSign);

    SigninFailedDto signWithRemark(Long orgId, SignWithRemarkRequest request, Integer source, Boolean sendSms);

    Map<String, OrgLessonSign> getLessonSignStatus(Collection<Long> lesssonIds);
}
