
package com.baijia.tianxiao.sal.course.dto.response;

import com.baijia.tianxiao.util.NumberUtil;
import lombok.Data;

import java.util.Date;

@Data
public class CourseListReponseDto {

    private Long orgCourseId; // 课程ID

    private Long orgCourseNumber; // 课程number
    
    private String courseUrl; // 课程url

    private String courseName; // 课程名称

    private String color; // 颜色

    private Integer maxStudent; // 最大学生数

    private Integer studentCount; // 学生数量

    private Integer teacherCount; // 老师数量

    private Integer roomCount; // 教室数量

    private String roomNames;// 教室名称

    private Date startTime; // 开始时间

    private Date endTime; // 结束时间

    private Integer freq; // 计划课节

    private Integer lessonCount;// 排课课节

    private Integer lessonFinish; // 上完的课节

    private Integer arrageStatus; // 课程安排进展

    private Integer smsStudent; // 代发短信学生数量

    private Integer smsTeacher; // 代发短信老师数量

    private Integer viewStudent; // 代查看短信学生数量

    private Integer viewTeacher; // 代查看短信老师数量

    private String coverUrl; // 封面url

    private String address;// 上课地址

    private String introduction;// 介绍

    private Integer courseType;
    
    private Double price;

    private Integer isCourse; // 是否是课
    
    private Integer isClass; // 是否是班
    
    private Integer isFinish; //是否结课

    private Integer chargeType; //收费类型

    private Integer chargeUnit; //计费单位

    private Date kexiaoTime; //课消补充信息时间

    private Integer kexiaoCascadeId; //课消补充信息操作人

    private String kexiaoCascadeName; //课消补充信息操作人-姓名

    private Integer finishedMinutes; //已上分钟

    private Integer arrangedMinutes; //已排分钟

    private Integer paidMinutes; //已购分钟

    private Integer remainClassHour;//是否有剩余课时，1代表有，0代表无

    private Integer remainClassTime; //是否有剩余课次，1代表有，0代表无

    private Long studentId;

    private String studentName;

    private String studentMobile;

    private Long signUpCourseId;

    private String signUpCourseName;
    // 学生状态 退班 转班
    private Integer status;
    private Integer lessonToday; // 今天的课节数
    private Double attendanceRate;// 到课率
    private String teacherNames;
    private String studentNames;
    private Date createTime;
    private Integer cascadeId;

    private Integer fullStatus;//满班状态
    private Integer finishStatus;//结课

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public void setAttendanceRate(Double attendanceRate) {
        this.attendanceRate = Double.valueOf(NumberUtil.DOUBLE_FMT.format(attendanceRate));
    }

}
