package com.baijia.tianxiao.sal.course.dto.request;

import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

import java.text.ParseException;
import java.util.Date;

/**
 * Created by zhangrui on 16/8/25.
 */
@Data
public class LessonConflictCheckDto {
    private Long lessonId;
    private Long teacherId;
    private Long roomId;
    private String startTime;
    private Date startTimeDate;
    private String endTime;
    private Date endTimeDate;

    private int pageNum = 1;
    private int pageSize = 10;


    public void validate() {
        if (StringUtils.isEmpty(startTime)) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "需要传入课节开始时间");
        }

        try {
            startTimeDate = DateUtils.parseDate(startTime,"yyyy-MM-dd HH:mm");
        } catch (ParseException e) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "开始时间格式有误");
        }

        if (StringUtils.isEmpty(endTime)) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "需要传入课节结束时间");
        }

        try {
            endTimeDate = DateUtils.parseDate(endTime,"yyyy-MM-dd HH:mm");
        } catch (ParseException e) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "结束时间格式有误");
        }

        if((teacherId == null || teacherId <= 0) && (roomId == null || roomId <= 0)){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "教室Id和老师Id最少需要传入一个");
        }

        if(pageNum <= 0){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "页数不能小于0");
        }

        if(pageSize <= 0){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "每页获取条数不能小于0");
        }
    }
}
