/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.course.dto;

import java.io.Serializable;

import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author shanyu
 * @version 1.0
 * @title OrgCourseQueryResponseDto
 * @desc TODO
 * @date 2015年9月9日
 */
@Data
public class OrgCourseQueryResponseDto implements Serializable {

    private static final long serialVersionUID = -5341010409668119506L;

    private String coverUrl;

    private Long orgCourseId;

    private Long orgCourseNumber;

    private String courseName;

    private String courseNamePinYin;

    /**
     * 如果多个老师,逗号分隔
     */
    private String teacherName = "待定";

    private Double originPrice;

    private String color;
    
    private Integer lessonCount;
    private Integer lessonFinish;
    private String roomName;

    // 课程状态 CourseStatus : 0官网显示(招生中),1官网隐藏(已下架)
    private Integer courseStatus;
    // 课程类型 CourseTypeEnum : 11直播,12点播
    private Integer courseType;
    
    //可退款天数
    private Integer refundDays;
    
    //有效天数
    private Integer effectDays;

    public String getCoverUrl() {
        return StringUtils.isBlank(this.coverUrl) ? TianXiaoConstant.DEFAULT_CLASS_COVER : this.coverUrl;
    }

    public static OrgCourseQueryResponseDto getInstanceByOrgCourse(OrgCourse orgCourse){
        OrgCourseQueryResponseDto dto = new OrgCourseQueryResponseDto();
        dto.setCourseName(orgCourse.getName());
        dto.setOrgCourseId(orgCourse.getId());
        dto.setOrgCourseNumber(orgCourse.getNumber());
        return dto;
    }

}
