
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.course.util;

import java.util.Properties;

import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time May 19, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public class ErpUtils {

    /**
     * 创建学生课表链接
     * 
     * @param orgId
     * @param studentId
     * @return
     */
    public static String createClassSchedule(Long orgId, Long studentId) {
        try {
            Properties fillProperties = PropertiesReader.fillProperties("erp.properties");
            log.info("fillProperties is:{} ", fillProperties);
            String scheduleUrl = fillProperties.getProperty("student_class_schedule");
            if (GenericsUtils.isNullOrEmpty(scheduleUrl)) {
                return "";
            }
            StudentSmsTokenDto token = new StudentSmsTokenDto(orgId, null, studentId, null);
            token.setStudentId(studentId);
            String scheduleUrlStr = scheduleUrl.replace("#{TOKEN}", token.toTokenStr());
            return ShortUrlUtil.getShortUrl(scheduleUrlStr);
        } catch (Exception e) {
            log.info("can not create token with orgId:{} and studentId:{} ", orgId, studentId);
            return "";
        }
    }

}
