package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.constant.TransferClassStatus;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.utils.KexiaoUtil;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoChangeLogService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ListUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * Created by liuxp on 16/12/5.
 */
@Service
@Slf4j
public class OrgSignupCourseLessonServiceImpl implements OrgSignupCourseLessonService {

    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private KexiaoChangeLogService changeLogService;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgStudentCourseDao studentCourseDao;
    @Autowired
    private OrgCourseConsumeRuleDao ruleDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private OrgSignupRefundDao refundDao;
    @Autowired
    private TxTransferClassRecordDao transferClassRecordDao;

    @Override
    public void saveSignupCourseLessons(Long orgId, Long classId, Collection<OrgStudentLesson> studentLessons) {
        saveSignupCourseLessons(orgId, classId, studentLessons, null);
    }

    @Override
    @Transactional
    public void saveSignupCourseLessons(Long orgId, Long classId, Collection<OrgStudentLesson> studentLessons, OrgSignupCourse orgSignupCourse) {
        if (studentLessons == null || studentLessons.size() < 1) {
            log.info("[SignupCourseLesson] studentLessons is null.orgId={},classId={}", orgId, classId);
            return;
        }
        Long courseId = 0L;
        OrgCourse orgCourse = courseDao.getById(classId, "isClass", "isCourse", "parentId", "chargeUnit");
        if (orgCourse.getChargeUnit() <= 0) {//如果没设置，默认设置为按次
            orgCourse.setChargeUnit(ChargeUnit.BY_TIMES.getCode());
        }
        //班级非课程的课程ID为其parentId
        if (CourseTypeEnum.IS_CLASS_TRUE.getCode() == orgCourse.getIsClass()
                && CourseTypeEnum.IS_COURSE_FALSE.getCode() == orgCourse.getIsCourse()) {
            courseId = orgCourse.getParentId();
        } else {
            courseId = classId;
        }

        // 1.查询学生报名课表记录
        List<Long> userIds = ListUtil.toKeyList(studentLessons, "userId", OrgStudentLesson.class);
        List<OrgSignupCourse> signupCourses = signupCourseDao.searchByUserIdsAndClassId(userIds, classId, orgId, SignupCourseStatus.inClassStatus);//2:报名，3：补充，4：导入
        if (orgSignupCourse != null) {//pc导入的时候，会直接将OrgSignupCourse传递过来
            boolean isExisted = false;
            for (OrgSignupCourse signupCourse : signupCourses) {
                if (signupCourse.getId().equals(orgSignupCourse.getId())) {
                    isExisted = true;
                    break;
                }
            }
            if (!isExisted) {
                //因为该方法中修改了OrgSignupCourse中的值,为了不引起副作用,所以copy一份
                OrgSignupCourse copy = new OrgSignupCourse();
                BeanUtils.copyProperties(orgSignupCourse,copy);
                signupCourses.add(copy);
            }
        }

        classHourToMinute(signupCourses);
        //1.1 处理退款信息
        handleRefund(signupCourses);

        log.info("[SignupCourseLesson] signupCourses={}",signupCourses);

        Map<Long, List<OrgSignupCourse>> stuSignupMap = getUserSignupCourseMap(signupCourses);

        // 2、过滤有未设置（即charge_unit=-1）课次/课时信息的学生
        Map<Long, List<OrgSignupCourse>> unCompleteSignupMap = filterUnHandleStudent(stuSignupMap);

        // 处理转班
        handleTransferClassInfo(signupCourses);
        log.info("[SignupCourseLesson] Validate userIds={}", stuSignupMap.keySet());
        // 3.查询排课报名记录明细信息
        deleteSignupCourseLessons(orgId, studentLessons);
        Map<Long, OrgSignupCourseLesson> signupLessonStatMap = new HashMap<>();
        if (!stuSignupMap.isEmpty()) {
            signupLessonStatMap = signupCourseLessonDao.selectSignUpLessons(stuSignupMap.keySet(), classId, orgId);
        }
        // 4.过滤所有已排课完成的课程
        Map<Long, List<OrgSignupCourse>> unfinishedSignupCourseMap = getUnFinishedOrgSignupCourse(signupLessonStatMap, stuSignupMap);
        // 5.获取以取消的课节
        Set<String> cancelLessons = getCancelLessonType(orgId, courseId, classId, stuSignupMap.keySet());
        // 6.更新排课信息
        for (OrgStudentLesson studentLesson : studentLessons) {
            if (studentLesson.getDelStatus() != null && studentLesson.getDelStatus() == 1) {
                log.warn("[SignupCourseLesson] StudentLesson is deleted.studentLesson={}", studentLesson);
                continue;
            }
            log.info("[SignupCourseLesson] orgId={},studentLesson={},courseId={}", orgId, studentLesson, courseId);
            studentLesson.setKexiaoDuration(studentLesson.getLessonDuration());
            OrgSignupCourseLesson signupLesson = createOrgSignupCourseLesson(orgId, studentLesson, studentLesson.getLessonDuration(), courseId);
            if (stuSignupMap.keySet().contains(studentLesson.getUserId())) { // 有可排课的报名单
                //已取消课节处理
                if (cancelLessons.contains(getKey(studentLesson))) {
                    if(LessonType.isFree(studentLesson.getLessonType())){
                        signupLesson.setLessonType(LessonType.FREE_CANCEL.getCode());
                        signupLesson.setLessonType(LessonType.FREE_CANCEL.getCode());
                    }else {
                        signupLesson.setLessonType(LessonType.CANCEL.getCode());
                        studentLesson.setLessonType(LessonType.CANCEL.getCode());
                    }
                } else {
                    List<OrgSignupCourse> signUpList = unfinishedSignupCourseMap.get(studentLesson.getUserId());
                    log.info("[SignupCourseLesson] signUpList={}", signUpList);
                    if (signUpList != null && !signUpList.isEmpty()) {
                        // 正价课
                        OrgSignupCourse signupCourse = signUpList.get(0);
                        studentLesson.setLessonType(LessonType.NORMAL.getCode());
                        if (ChargeUnit.BY_TIMES.getCode() == signupCourse.getChargeUnit()) {
                            // 按次课节
                            handleTimesLesson(signUpList, signupLesson, signupLessonStatMap);
                        } else if (ChargeUnit.isByTime(signupCourse.getChargeUnit())) {
                            // 按时间课节
                            handleTimeLesson(signUpList, signupLesson, signupLessonStatMap, studentLesson, courseId, orgCourse);
                        } else {
                            log.error("[SignupCourseLesson] Type error.{}", signUpList);
                        }
                    } else {
                        // 赠送课
                        studentLesson.setLessonType(LessonType.FREE.getCode());
                        studentLesson.setKexiaoDuration(0);
                        signupLesson.setLessonType(LessonType.FREE.getCode());
                    }
                }
                signupLesson.setChargeUnit(orgCourse.getChargeUnit());
                log.info("[SignupCourseLesson] courseLesson={}", signupLesson);
                signupCourseLessonDao.save(signupLesson);
            } else {
                if (unCompleteSignupMap.get(studentLesson.getUserId()) != null) {//有未补充的报名单
                    studentLesson.setLessonType(LessonType.OTHER.getCode());
                    studentLesson.setKexiaoDuration(0);
                } else { //无排课的报名单
                    studentLesson.setLessonType(LessonType.FREE.getCode());
                    studentLesson.setKexiaoDuration(0);
                    signupLesson.setChargeUnit(orgCourse.getChargeUnit());
                    signupLesson.setLessonType(LessonType.FREE.getCode());
                    signupCourseLessonDao.save(signupLesson);
                }
            }
        }
    }

    private void handleRefund(List<OrgSignupCourse> signupCourses) {
        if (signupCourses == null || signupCourses.isEmpty()) {
            return;
        }
        Set<Long> signupIds = new HashSet<>();
        for (OrgSignupCourse signupCourse : signupCourses) {
            signupIds.add(signupCourse.getSignupPurchaseId());
        }
        List<OrgSignupRefund> refunds = refundDao.getByPurcahseIds(signupIds);
        Map<String, Long> refundMap = new HashMap<>();
        for (OrgSignupRefund refund : refunds) {
            String key = refund.getSignupPurchaseId() + "_" + refund.getCourseId();
            Long fee = refundMap.get(key);
            if (fee == null) {
                refundMap.put(key, refund.getRefundPrice());
            } else {
                refundMap.put(key, refund.getRefundPrice() + fee);
            }
        }
        log.info("[SignupCourseLesson] refundMap={}", refundMap);
        for (OrgSignupCourse signupCourse : signupCourses) {
            String key = signupCourse.getSignupPurchaseId() + "_" + signupCourse.getOrgCourseId();
            Long fee = refundMap.get(key);
            if (fee != null) {
                signupCourse.setPayPrice(signupCourse.getPayPrice() - fee);
            }
        }
    }

    private void handleTransferClassInfo(List<OrgSignupCourse> signupCourses) {
        log.info("[SignupCourseLesson] TxTransferClassRecord,signupCourses={}",signupCourses);
        if (signupCourses == null || signupCourses.isEmpty()) {
            return;
        }
        List<Long> purchaseIds = ListUtil.toKeyList(signupCourses, "signupPurchaseId", OrgSignupCourse.class);
        List<Integer> status = Arrays.asList(TransferClassStatus.SUCCESS.getCode(), TransferClassStatus.INIT.getCode());
        Map<String, TxTransferClassRecord> purchaseTransferMap = transferClassRecordDao.groupByPurchaseIds(purchaseIds, status);
        for (OrgSignupCourse signupCourse : signupCourses) {
            String key = signupCourse.getSignupPurchaseId() + "_" + signupCourse.getClassId();
            TxTransferClassRecord record = purchaseTransferMap.get(key);
            log.info("[SignupCourseLesson] TxTransferClassRecord={}",record);
            if (record != null) {
                signupCourse.setPayPrice(signupCourse.getPayPrice() - record.getLessonMoney());
                signupCourse.setLessonCount(signupCourse.getLessonCount() - record.getRealLessonCount());
            }
        }
    }

    //处理按课次计算的课节
    private void handleTimesLesson(List<OrgSignupCourse> signUpList,
                                   OrgSignupCourseLesson signupLesson,
                                   Map<Long, OrgSignupCourseLesson> signupLessonStatMap) {
        OrgSignupCourse signupCourse = signUpList.get(0);
        signupLesson.setLessonType(LessonType.NORMAL.getCode());
        OrgSignupCourseLesson stat = signupLessonStatMap.get(signupCourse.getId());
        if (stat == null) {
            stat = OrgSignupCourseLesson.create(signupCourse);
            signupLessonStatMap.put(signupCourse.getId(), stat);
        }
        signupLesson.setAmount(getCountAmount(signupCourse, stat));
        signupLesson.setSignupCourseId(signupCourse.getId());
        stat.setAmount(stat.getAmount() + signupLesson.getAmount());
        stat.setLessonDuration(stat.getLessonDuration() + signupLesson.getLessonDuration());
        stat.setLessonCount(stat.getLessonCount() + 1);
        if (stat.getLessonCount() >= signupCourse.getLessonCount()) {//单子已排完
            signUpList.remove(signupCourse);
        }
    }

    //处理按课时计算的课节
    private void handleTimeLesson(List<OrgSignupCourse> signUpList,
                                  OrgSignupCourseLesson signupLesson,
                                  Map<Long, OrgSignupCourseLesson> signupLessonStatMap,
                                  OrgStudentLesson studentLesson,
                                  long courseId,
                                  OrgCourse orgCourse) {
        int lessonTime = studentLesson.getLessonDuration();
        int leftTime = lessonTime;
        int kexiaoDuration = 0;
        for (Iterator<OrgSignupCourse> iter = signUpList.iterator(); iter.hasNext(); ) {
            OrgSignupCourse tmpSginupCourse = iter.next();
            int totalTime = tmpSginupCourse.getLessonCount();
            long usedAmount = 0;
            OrgSignupCourseLesson stat = signupLessonStatMap.get(tmpSginupCourse.getId());
            if (stat == null) {
                stat = OrgSignupCourseLesson.create(tmpSginupCourse);
                signupLessonStatMap.put(tmpSginupCourse.getId(), stat);
            }
            totalTime = totalTime - stat.getLessonDuration();
            log.info("[SignupCourseLesson] leftTime={},totalTime={}", leftTime, totalTime);
            usedAmount = stat.getAmount();
            if (leftTime <= totalTime) {
                kexiaoDuration += leftTime;
                signupLesson.setLessonType(LessonType.NORMAL.getCode());
                signupLesson.setSignupCourseId(tmpSginupCourse.getId());
                signupLesson.setLessonDuration(leftTime);
                if (leftTime == totalTime) {
                    //最后一节课
                    signupLesson.setAmount(tmpSginupCourse.getTotalPayPrice()- usedAmount);
                    iter.remove();//课时已排完
                } else {
                    //该报名信息扔未排完
                    signupLesson.setAmount(getHourAmount(tmpSginupCourse, leftTime));
                }
                leftTime = leftTime - totalTime;
                stat.setAmount(stat.getAmount() + signupLesson.getAmount());
                stat.setLessonDuration(stat.getLessonDuration() + signupLesson.getLessonDuration());
                stat.setLessonCount(stat.getLessonCount() + 1);
                break;
            } else {
                // 如果报名记录的剩余课时小于排课时间，需要拆分排课记录
                OrgSignupCourseLesson splitLesson = createOrgSignupCourseLesson(studentLesson.getOrgId(), studentLesson,
                        studentLesson.getLessonDuration(), courseId);
                splitLesson.setLessonType(LessonType.NORMAL.getCode());
                splitLesson.setLessonDuration(totalTime);
                splitLesson.setSignupCourseId(tmpSginupCourse.getId());
                splitLesson.setAmount(tmpSginupCourse.getTotalPayPrice()- usedAmount);
                splitLesson.setChargeUnit(orgCourse.getChargeUnit());
                signupCourseLessonDao.save(splitLesson);
                stat.setAmount(stat.getAmount() + splitLesson.getAmount());
                stat.setLessonDuration(stat.getLessonDuration() + splitLesson.getLessonDuration());
                stat.setLessonCount(stat.getLessonCount() + 1);
                iter.remove();//课时已排完
                leftTime = leftTime - totalTime;
                kexiaoDuration += totalTime;
            }
        }
        if (leftTime > 0) {
            // 如果所有报名记录的剩余课时之和都小于排课时间，剩余部分的时间需要记录为赠送课时
            signupLesson.setLessonType(LessonType.FREE.getCode());
            signupLesson.setLessonDuration(leftTime);
        }
        studentLesson.setKexiaoDuration(kexiaoDuration);
    }

    //获取已取消的课节
    private Set<String> getCancelLessonType(long orgId, long courseId, long classId, Collection<Long> userIds) {
        Set<String> ret = new HashSet<>();
        OrgCourseConsumeRule rule = ruleDao.getRuleByCourseId(orgId, courseId);
        if (rule != null && rule.getRuleValue() > 0) {
            List<OrgLessonSign> signList = orgLessonSignDao.getUserLessonSignList(orgId, userIds, classId,
                    UserRole.STUDENT.getRole(), null, "status", "lessonId", "userId");
            if (signList != null && signList.size() > 0) {
                for (OrgLessonSign sign : signList) {
                    LessonStatus status = kexiaoApiService.getKexiaoStatus(sign, rule.getRuleValue());
                    if (status != LessonStatus.FINISHED) {
                        ret.add(getKey(sign));
                    }
                }
            }
        }
        return ret;
    }

    private void deleteSignupCourseLessons(Long orgId, Collection<OrgStudentLesson> studentLessons) {
        List<OrgSignupCourseLesson> lessons = getByStudentLessons(orgId, studentLessons);
        if (lessons != null) {
            Set<Long> ids = new HashSet<>();
            for (OrgSignupCourseLesson lesson : lessons) {
                ids.add(lesson.getId());
            }
            if (!ids.isEmpty()) {
                signupCourseLessonDao.delByIds(ids);
            }
        }
    }

    private List<OrgSignupCourseLesson> getByStudentLessons(Long orgId, Collection<OrgStudentLesson> studentLessons) {
        List<OrgSignupCourseLesson> ret = new ArrayList<>();
        Set<Long> lessonIds = new HashSet<>();
        Set<Long> userIds = new HashSet<>();
        Set<String> keys = new HashSet<>();
        for (OrgStudentLesson lesson : studentLessons) {
            lessonIds.add(lesson.getLessonId());
            userIds.add(lesson.getUserId());
            keys.add(getKey(lesson));
        }
        List<OrgSignupCourseLesson> lessons = signupCourseLessonDao.getLessonList(orgId, lessonIds, userIds);
        if (lessons != null) {
            for (OrgSignupCourseLesson lesson : lessons) {
                if (keys.contains(getKey(lesson))) {
                    ret.add(lesson);
                }
            }
        }
        return ret;
    }

    private void classHourToMinute(Collection<OrgSignupCourse> signupCourses){
        if(signupCourses!=null){
            for (OrgSignupCourse course:signupCourses){
                long totalTime = KexiaoUtil.getClassNumber(course);
                course.setLessonCount((int)totalTime);
            }
        }
    }

    private String getKey(OrgStudentLesson lesson) {
        return lesson.getLessonId() + "_" + lesson.getUserId();
    }

    private String getKey(OrgSignupCourseLesson lesson) {
        return lesson.getLessonId() + "_" + lesson.getUserId();
    }

    private String getKey(OrgLessonSign sign) {
        return sign.getLessonId() + "_" + sign.getUserId();
    }

    @Override
    @Transactional
    public void updateLessonDuration(Long orgId, OrgClassLesson classLesson) {
        List<OrgStudentLesson> studentLessons = studentLessonDao.queryStudentsByLessonId(orgId, classLesson.getId());
        if (studentLessons == null || studentLessons.isEmpty()) {
            return;
        }
        List<Long> userIds = Lists.newArrayList();
        for (OrgStudentLesson lesson : studentLessons) {
            userIds.add(lesson.getUserId());
        }
        List<OrgStudentCourse> studentCourses = studentCourseDao.listByStatus(orgId, classLesson.getCourseId(), userIds, Arrays.asList(1, 2), "id", "userId");
        Set<Long> invalidIds = Sets.newHashSet();
        if (studentCourses != null) {
            for (OrgStudentCourse studentCourse : studentCourses) {
                invalidIds.add(studentCourse.getUserId());
            }
            log.info("Quit class can not modify status.InvalidIds={}", invalidIds);
        }


        List<OrgStudentLesson> normalLessons = Lists.newArrayList();
        List<Long> freeUserIds = Lists.newArrayList();
        List<Long> stuLessonIds = new ArrayList<>();

        for (OrgStudentLesson lesson : studentLessons) {
            if (invalidIds.contains(lesson.getUserId())) {
                continue;
            }
            stuLessonIds.add(lesson.getId());
            if (lesson.getLessonType() == LessonType.NORMAL.getCode() || lesson.getLessonType() == LessonType.CANCEL.getCode()) {
                normalLessons.add(lesson);
            } else if (lesson.getLessonType() == LessonType.FREE.getCode()) {
                freeUserIds.add(lesson.getUserId());
            } else {
                log.info("[Kexiao] info uncompleted.classLesson={}", classLesson);
            }
        }
        Date date = new Date();
        if (!normalLessons.isEmpty()) {
            saveSignupCourseLessons(orgId, classLesson.getCourseId(), normalLessons);
            for (OrgStudentLesson studentLesson : normalLessons) {
                studentLesson.setUpdateTime(date);
                studentLessonDao.update(studentLesson);
            }
        }
        if (!freeUserIds.isEmpty()) {
            signupCourseLessonDao.batchUpdateLessonDuration(orgId, classLesson.getId(), freeUserIds,
                    diffTime(classLesson.getStartTime(), classLesson.getEndTime()));
        }
        //changeLogService.addModifyStuLessonsLog(orgId,stuLessonIds);
    }

    /**
     * 获取不能重新排课的课节
     *
     * @param orgId
     * @param classId
     * @param studentLessons
     * @return
     */
    public List<OrgStudentLesson> getUnSignableList(Long orgId, Long classId, Collection<OrgStudentLesson> studentLessons) {
        log.info("[SignupCourseLesson] studentLessons={},classId={}", studentLessons, classId);
        List<OrgStudentLesson> unSignableList = new ArrayList<>();
        if (studentLessons == null || studentLessons.size() < 1) {
            return Collections.emptyList();
        }
        List<OrgStudentLesson> cancelLessons = new ArrayList<>();
        for (OrgStudentLesson lesson : studentLessons) {
            if (lesson.getLessonType() == LessonType.CANCEL.getCode()) {
                cancelLessons.add(lesson);
            }
        }
        if (!cancelLessons.isEmpty()) {
            Map<String, OrgSignupCourseLesson> courseLessonMap = getSignupCourseLessonMap(orgId, cancelLessons);

            List<Long> userIds = ListUtil.toKeyList(cancelLessons, "userId", OrgStudentLesson.class);
            List<OrgSignupCourse> signupCourses = signupCourseDao.searchByUserIdsAndClassId(userIds, classId, orgId, SignupCourseStatus.inClassStatus);
            classHourToMinute(signupCourses);

            Map<Long, List<OrgSignupCourse>> stuSignupMap = getUserSignupCourseMap(signupCourses);

            Map<Long, OrgSignupCourseLesson> signupLessonMap = new HashMap<>();
            if (!stuSignupMap.isEmpty()) {
                signupLessonMap = signupCourseLessonDao.selectSignUpLessons(stuSignupMap.keySet(), classId, orgId);
            }

            Map<Long, List<OrgSignupCourse>> unfinishedSignupCourseMap = getUnFinishedOrgSignupCourse(signupLessonMap, stuSignupMap);
            log.info("[SignupCourseLesson] unfinishedSignupCourseMap={}", unfinishedSignupCourseMap);

            for (OrgStudentLesson studentLesson : cancelLessons) {
                if (stuSignupMap.keySet().contains(studentLesson.getUserId())) {
                    List<OrgSignupCourse> courseList = unfinishedSignupCourseMap.get(studentLesson.getUserId());

                    OrgSignupCourseLesson courseLesson = courseLessonMap.get(getKey(studentLesson));
                    log.info("[SignupCourseLesson] key={},courseLessonMap={}", getKey(studentLesson), courseLessonMap);
                    if (courseLesson == null) {//之前无排课记录
                        //unSignableList.add(studentLesson);
                        continue;
                    } else {
                        if (courseList != null && !courseList.isEmpty()) {
                            handleTransferClassInfo(courseList);
                            OrgSignupCourse course = courseList.get(0);
                            if (ChargeUnit.isByTime(course.getChargeUnit())) {
                                int leftTime = 0;
                                for (OrgSignupCourse signupCourse : courseList) {
                                    int orderLeftTime = signupCourse.getLessonCount();
                                    OrgSignupCourseLesson stat = signupLessonMap.get(signupCourse.getId());
                                    if (stat != null) {
                                        orderLeftTime = orderLeftTime - stat.getLessonDuration();
                                    }
                                    leftTime += orderLeftTime;
                                }
                                if (leftTime <= 0) {//课时不足
                                    log.info("[SignupCourseLesson] leftTime={},lessonDuration={}", leftTime, courseLesson.getLessonDuration());
                                    unSignableList.add(studentLesson);
                                }
                            }
                        } else {// 无可排课的报名单
                            unSignableList.add(studentLesson);
                        }
                    }
                } else {
                    // 无可排课的报名单
                    unSignableList.add(studentLesson);
                }
            }
        }
        return unSignableList;
    }

    private Map<String, OrgSignupCourseLesson> getSignupCourseLessonMap(Long orgId, List<OrgStudentLesson> cancelLessons) {
        List<OrgSignupCourseLesson> signupCourseLessons = getByStudentLessons(orgId, cancelLessons);
        Map<String, OrgSignupCourseLesson> retMap = Maps.newHashMap();
        log.info("[SignupCourseLesson] signupCourseLessons={},cancelLessons={}", signupCourseLessons, cancelLessons);
        for (OrgSignupCourseLesson signupCourseLesson : signupCourseLessons) {
            OrgSignupCourseLesson lesson = retMap.get(getKey(signupCourseLesson));
            if (lesson == null) {
                if (!LessonType.isFree(signupCourseLesson.getLessonType())) {
                    retMap.put(getKey(signupCourseLesson), signupCourseLesson);
                }
            } else {
                if (!LessonType.isFree(signupCourseLesson.getLessonType())) {
                    lesson.setLessonDuration(signupCourseLesson.getLessonDuration() + lesson.getLessonDuration());
                }
            }
        }
        return retMap;
    }

    private Map<Long, List<OrgSignupCourse>> getUserSignupCourseMap(List<OrgSignupCourse> signupCourses) {
        Map<Long, List<OrgSignupCourse>> stuSignupMap = new HashMap<>();
        for (OrgSignupCourse signupCourse : signupCourses) {
            List<OrgSignupCourse> list = stuSignupMap.get(signupCourse.getUserId());
            if (list == null) {
                list = new ArrayList<>();
                stuSignupMap.put(signupCourse.getUserId(), list);
            }
            list.add(signupCourse);
        }
        return stuSignupMap;
    }

    /**
     * 按次计算每门课的钱
     *
     * @return
     */
    private long getCountAmount(OrgSignupCourse course, OrgSignupCourseLesson stat) {
        long total = course.getTotalPayPrice();
        long unit = total / course.getLessonCount();
        if (course.getLessonCount() - stat.getLessonCount() > 1) {
            return unit;
        } else {
            return total - stat.getAmount();
        }
    }

    private long getHourAmount(OrgSignupCourse course, int lessonTime) {
        log.info("OrgSignupCourse={}",course);
        //long totalTime = KexiaoUtil.getClassNumber(course);
        return lessonTime * (course.getTotalPayPrice()) / course.getLessonCount();
    }

    private OrgSignupCourseLesson createOrgSignupCourseLesson(Long orgId, OrgStudentLesson studentLesson,
                                                              int lessonDuration, Long courseId) {
        OrgSignupCourseLesson courseLesson = new OrgSignupCourseLesson();
        courseLesson.setOrgId(orgId);
        courseLesson.setCreateTime(new Date());
        courseLesson.setSignupCourseId(-1L);
        courseLesson.setLessonDuration(lessonDuration);
        courseLesson.setClassId(studentLesson.getCourseId());
        courseLesson.setCourseId(courseId);
        courseLesson.setLessonId(studentLesson.getLessonId());
        courseLesson.setUserId(studentLesson.getUserId());
        return courseLesson;
    }

    private int diffTime(Date startTime, Date endTime) {
        Calendar start = Calendar.getInstance();
        start.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return end.get(Calendar.MINUTE) - start.get(Calendar.MINUTE);
    }

    private Map<Long, List<OrgSignupCourse>> filterUnHandleStudent(Map<Long, List<OrgSignupCourse>> stuSignupMap) {
        Map<Long, List<OrgSignupCourse>> unCompleteSignupMap = new HashMap<>();
        Set<Map.Entry<Long, List<OrgSignupCourse>>> set = stuSignupMap.entrySet();
        for (Iterator<Map.Entry<Long, List<OrgSignupCourse>>> iter = set.iterator(); iter.hasNext(); ) {
            Map.Entry<Long, List<OrgSignupCourse>> entry = iter.next();
            for (OrgSignupCourse course : entry.getValue()) {
                if (course.getLessonCount() <= 0) {
                    unCompleteSignupMap.put(entry.getKey(), entry.getValue());
                    iter.remove();
                    break;
                }
            }
        }
        return unCompleteSignupMap;
    }

    private Map<Long, List<OrgSignupCourse>> getUnFinishedOrgSignupCourse(
            Map<Long, OrgSignupCourseLesson> signupLessonsMap, Map<Long, List<OrgSignupCourse>> stuSignupMap) {

        Map<Long, List<OrgSignupCourse>> unFinishedSignup = new HashMap<>();
        Set<Long> stuKeySet = stuSignupMap.keySet();
        for (Long stuKey : stuKeySet) {
            List<OrgSignupCourse> signupCourseList = stuSignupMap.get(stuKey);
            for (OrgSignupCourse course : signupCourseList) {
                OrgSignupCourseLesson stat = signupLessonsMap.get(course.getId());
                List<OrgSignupCourse> list = unFinishedSignup.get(stuKey);
                if (list == null) {
                    list = new ArrayList<>();
                }
                if (stat == null ) {
                    if(course.getLessonCount()>0) {
                        list.add(course);
                    }
                } else if (ChargeUnit.BY_TIMES.getCode() == course.getChargeUnit()) {
                    if (course.getLessonCount() > stat.getLessonCount()) {
                        list.add(course);
                    }
                } else if (ChargeUnit.isByTime(course.getChargeUnit())) {
                    if (course.getLessonCount() > stat.getLessonDuration()) {
                        list.add(course);
                    }
                }
                if (!list.isEmpty()) {
                    unFinishedSignup.put(stuKey, list);
                }
            }
        }
        return unFinishedSignup;
    }

    @Override
    @Transactional
    public void deleteClassLessons(Long orgId, Collection<Long> lessonIds) {
        signupCourseLessonDao.batchDelLesson(orgId, lessonIds);
        changeLogService.addDelLessonsLog(orgId, lessonIds);
    }

    @Override
    @Transactional
    public void cancelSign(Long orgId, Long lessonId, Collection<Long> userIds) {
        log.info("[SignupCourseLesson] cancel sign.orgId={},lessonId={},userIds={}", orgId, lessonId, userIds);
        signupCourseLessonDao.batchCancelLesson(orgId, lessonId, userIds,LessonType.CANCEL.getCode(),LessonType.NORMAL.getCode());
        signupCourseLessonDao.batchCancelLesson(orgId, lessonId, userIds,LessonType.FREE_CANCEL.getCode(),LessonType.FREE.getCode());

        studentLessonDao.batchUpdateLessonType(userIds, lessonId, LessonType.CANCEL.getCode(),LessonType.NORMAL.getCode());
        studentLessonDao.batchUpdateLessonType(userIds, lessonId, LessonType.FREE_CANCEL.getCode(),LessonType.FREE.getCode());
    }

    @Override
    @Transactional
    public void deleteStudentLessons(Long orgId, Collection<Long> userIds, Collection<Long> lessonIds) {
        signupCourseLessonDao.batchDelStuLesson(orgId, userIds, lessonIds);
        List<OrgStudentLesson> studentLessons = studentLessonDao.getAllStuLessonsBy(orgId, userIds, lessonIds, "id");
        if (studentLessons != null && studentLessons.size() > 0) {
            List<Long> ids = ListUtil.toKeyList(studentLessons, "id", OrgStudentLesson.class);
            changeLogService.addDelStuLessonsLog(orgId, ids);
        }
    }

    @Override
    public void syncHistoryData(Long orgId) {
        List<Long> courseIds = studentCourseDao.selectOneToOneClassId(orgId);
        Set<Long> courseIdSet = new HashSet<>(courseIds);
        for (Long id : courseIdSet) {
            log.info("[SignupCourseLesson] update 1v1 data.orgId={},courseId={}", orgId, id);
            List<OrgStudentLesson> lessons = studentLessonDao.getByCourseIdsUserIds(orgId, Arrays.asList(id), null);
            if (lessons != null && lessons.size() > 0) {
                saveSignupCourseLessons(orgId, id, lessons);
                for (OrgStudentLesson lesson : lessons) {
                    lesson.setUpdateTime(new Date());
                    studentLessonDao.update(lesson);
                }
            }
        }
    }

    @Override
    @Transactional
    public void validateData(Long orgId) {
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(10000);
        List<OrgSignupCourseLesson> signupCourseLessons = signupCourseLessonDao.listByOrg(orgId,pageDto,"id","lessonId","userId","lessonType");
        while (signupCourseLessons!=null && signupCourseLessons.size()>0){
            log.info("[SignupCourseLesson] signupCourseLessons size={}",signupCourseLessons.size());
            validateSignupCourseLessons(signupCourseLessons);
            pageDto.setPageNum(pageDto.getPageNum()+1);
            signupCourseLessons = signupCourseLessonDao.listByOrg(orgId,pageDto,"id","lessonId","userId","lessonType");
        }
    }

    private void validateSignupCourseLessons(List<OrgSignupCourseLesson> signupCourseLessons){
        Set<Long> lessonIds = new HashSet<>();
        Set<Long> userIds = new HashSet<>();
        Map<String,OrgSignupCourseLesson> map = new HashMap<>();
        for (OrgSignupCourseLesson lesson:signupCourseLessons){
            lessonIds.add(lesson.getLessonId());
            userIds.add(lesson.getUserId());
        }
        List<OrgStudentLesson> studentLessons = studentLessonDao.getByLessonIdsStudentIds(lessonIds,userIds);
        Map<String,OrgStudentLesson> stuLessonMap = new HashMap<>();
        for (OrgStudentLesson studentLesson:studentLessons){
            stuLessonMap.put(studentLesson.getLessonId()+"_"+studentLesson.getUserId(),studentLesson);
        }
        Set<String> invalidKeys = new HashSet<>();
        Set<String> delKeys = new HashSet<>();
        Set<String> errorKeys = new HashSet<>();
        for (OrgSignupCourseLesson lesson:signupCourseLessons){
            String key = lesson.getLessonId()+"_"+lesson.getUserId();
            if(stuLessonMap.get(key)==null){
                delKeys.add(key);
                //signupCourseLessonDao.delById(lesson.getId());
            }else if(stuLessonMap.get(key).getLessonType()==-1){
                errorKeys.add(key);
            }if(stuLessonMap.get(key).getLessonType()!=lesson.getLessonType()){
                invalidKeys.add(key);
            }
        }
        log.info("[SignupCourseLesson] delKeys={},invalidKeys={},errorKeys={}",delKeys,invalidKeys,errorKeys);
    }

    @Override
    @Transactional
    public void validateLessonType(Long orgId) {
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(10000);
        Map<String,Object> param = new HashMap<>();
        param.put("orgId",orgId);
        param.put("lessonType",3);
        List<OrgStudentLesson> studentLessons = studentLessonDao.queryByCondition(param,pageDto,"id","lessonId","userId","lessonType");
        while (studentLessons!=null && studentLessons.size()>0){
            log.info("[SignupCourseLesson] studentLessons size={}",studentLessons.size());
            validateStudentLessonSign(studentLessons);
            pageDto.setPageNum(pageDto.getPageNum()+1);
            studentLessons = studentLessonDao.queryByCondition(param,pageDto,"id","lessonId","userId","lessonType");
        }
    }

    private void validateStudentLessonSign(List<OrgStudentLesson> studentLessons){

    }

    public void validateCancelData(Long orgId,Date startTime,Date endTime){
        Set<Integer> status = new HashSet<>();
        status.add(2);//请假
        status.add(3);//缺课
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(10000);
        Map<Long,OrgCourseConsumeRule> ruleMap = new HashMap<>();
        List<OrgLessonSign> signList = orgLessonSignDao.listByStatus(orgId,status,startTime,endTime,pageDto);
        Set<Long> stuLessonIds = new HashSet<>();
        int number = 1;
        while (signList!=null && signList.size()>0){
            log.info("[SignupCourseLesson] SignList size={},pageDto={}",signList.size(),pageDto);
            if (signList != null && signList.size() > 0) {
                for (OrgLessonSign sign : signList) {
                    OrgCourseConsumeRule rule = ruleMap.get(sign.getCourseId());
                    if(rule==null) {
                        rule = ruleDao.getRuleByCourseId(orgId, sign.getCourseId());
                        ruleMap.put(sign.getCourseId(),rule);
                    }
                    if(rule!=null){
                        LessonStatus lessonStatus = kexiaoApiService.getKexiaoStatus(sign, rule.getRuleValue());
                        if (lessonStatus != LessonStatus.FINISHED) {
                            List<OrgStudentLesson> lessons =  studentLessonDao.getByLessonIdsAndUserIds(Arrays.asList(sign.getLessonId()),Arrays.asList(sign.getUserId()),0);
                            if(lessons!=null && lessons.size()>0){
                                saveSignupCourseLessons(orgId,sign.getCourseId(),lessons);
                                for (OrgStudentLesson lesson:lessons){
                                    if(LessonType.isCancel(lesson.getLessonType())){
                                        stuLessonIds.add(lesson.getId());
                                        lesson.setUpdateTime(new Date());
                                        studentLessonDao.update(lesson);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            number++;
            pageDto.setPageNum(number);
            signList = orgLessonSignDao.listByStatus(orgId,status,startTime,endTime,pageDto);
        }
        log.info("[SignupCourseLesson] validate student lesson Id={},startTime={},endTime={}",stuLessonIds,startTime,endTime);
    }
}