package com.baijia.tianxiao.sal.course.exceptions;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.ErpErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

/**
 * Created by lxp on 2017/2/23.
 */
public class SignErrorCode implements UniverseErrorCode {

    private String message = "签到失败";

    @Override
    public ErrorSide getErrorSide() {
        return ErrorSide.SERVER;
    }

    @Override
    public Platform getPlatform() {
        return Platform.PC;
    }

    public Subsystem getSystem(){
        return Subsystem.SIGN;
    }

    @Override
    public int getSubsystemErrorCode() {
        return ErpErrorCode.MODIFY_SIGNUP_STATUS_ERROR.getSubsystemErrorCode();
    }


    @Override
    public String getMessage() {
        return message;
    }

    public void setMessage(String message){
        this.message = message;
    }

    @Override
    public UniverseErrorCode fromCode(int code) {
        return this;
    }
}
