package com.baijia.tianxiao.sal.course.dto.response;

import java.util.List;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import org.apache.commons.collections.CollectionUtils;

import com.baijia.tianxiao.constant.SignStatus;
import com.google.common.collect.Lists;

/**
 * 签到报表
 * 
 * @title LessonSignReportDto
 * @desc TODO
 * @author shizuwei
 * @date 2016年1月22日
 * @version 1.0
 */
@Slf4j
@Data
public class LessonSignReportDto {

    private List<OrgCourseInfo> courseList = Lists.newArrayList();

    private StudentInfo studentInfo = new StudentInfo();

    @Data
    public static class OrgCourseInfo {
        private String courseName;
        private Integer lessonCount = 0;
        private Integer studentCount = 0;
        private List<CourseStudentDto> studentList = Lists.newLinkedList();
    }

    @Data
    public static class StudentInfo {
        String name;
        Long studentId;
    }

    @Data
    public static class CourseStudentDto {

        private String studentName;
        private Integer signCount = 0;
        private List<StudentLessonSignInfoDto> lessonList = Lists.newArrayList();

        public void addLessonSignInfo(StudentLessonSignInfoDto lessonSignInfo) {

            if (lessonSignInfo == null) {
                return;
            }

            log.debug("lessonSignInfo ={}", lessonSignInfo);
            if (lessonSignInfo.getSignStatus() == SignStatus.SIGNED.getCode()) {
                this.signCount++;
            }
            if (CollectionUtils.isNotEmpty(lessonList)) {
                for (int i = 0; i < this.lessonList.size(); i++) {
                    if (lessonSignInfo.getLessonNumber() <= lessonList.get(i).getLessonNumber()) {
                        lessonList.add(i, lessonSignInfo);
                        return;
                    }
                }
            }

            this.lessonList.add(lessonSignInfo);
        }
    }

    @Data
    public static class StudentLessonSignInfoDto {
        private Long lessonId;
        private Integer lessonNumber;
        private Integer signStatus;
        // 0,未签到；1，签到；2，请假；3，旷课
        private String signStatusStr;
        private String signRemark;

        public void setSignStatus(Integer signStatus) {
            SignStatus status = SignStatus.getSignStatusByCode(signStatus);
            this.signStatus = signStatus;
            this.signStatusStr = status.getMessage();
        }

    }
}
