
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;

import com.google.common.collect.Maps;

import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Date;
import java.util.Map;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title OrgCourseConsumeRuleImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年8月23日
 * @version 1.0
 */
@Slf4j
@Service("orgCourseConsumeRuleService")
public class OrgCourseConsumeRuleServiceImpl implements OrgCourseConsumeRuleService{

    @Resource
    private OrgCourseConsumeRuleDao orgCourseConsumeRuleDao;
    
    @Resource
    private TXCommonRuleService tXCommonRuleService;
    
    @Override
    public Map<Long, Integer> queryCourseRuleMapByCourseIds(Long orgId, Collection<Long> courseIds) {
        
        Map<Long,Integer> courseConsumeRuleMap = orgCourseConsumeRuleDao.queryCourseRuleMapByCourseIds(orgId, courseIds);
        
        for(Long courseId:courseIds){
            //没有则是历史数据，历史数据默认规则是0
            courseConsumeRuleMap.put(courseId, 0);
        }
        
        return courseConsumeRuleMap;
            
    }

    @Override
    public Integer getRuleValueByCourseId(Long orgId, Long courseId) {
        
        return orgCourseConsumeRuleDao.getRuleValueByCourseId(orgId, courseId);
            
    }

    @Override
    public void create(Long orgId, Long courseId, Integer ruleValue) {
        
        OrgCourseConsumeRule rule = new OrgCourseConsumeRule();
        rule.setOrgId(orgId);
        rule.setCourseId(courseId);
        rule.setRuleValue(ruleValue);
        Date now = new Date();
        rule.setCreateTime(now);
        rule.setUpdateTime(now);
        
        orgCourseConsumeRuleDao.save(rule);
        log.info("OrgCourseConsumeRuleService createRule orgId:{},courseId:{},ruleValue:{}",orgId,courseId,ruleValue);
    }

    @Override
    public boolean updateRuleValue(Long orgId, Long courseId, Integer ruleValue) {
        
        OrgCourseConsumeRule rule = new OrgCourseConsumeRule();
        rule.setOrgId(orgId);
        rule.setCourseId(courseId);
        rule.setRuleValue(ruleValue);
        Map<String, Object> updateCondtion = Maps.newHashMap();
        updateCondtion.put("orgId", orgId);
        updateCondtion.put("courseId", courseId);
        updateCondtion.put("ruleValue", ruleValue);
        updateCondtion.put("updateTime",new Date());
        int count = orgCourseConsumeRuleDao.update(updateCondtion, "ruleValue","updateTime");
        log.info("OrgCourseConsumeRuleService updateRuleValue orgId:{},courseId:{},ruleValue:{}",orgId,courseId,ruleValue);
        if(count>0){
            return true;
        }
        return false;
    }

    @Override
    public void saveOfupdate(Long orgId, Long courseId, Integer ruleValue) {
        
        OrgCourseConsumeRule rule = orgCourseConsumeRuleDao.getRuleByCourseId(orgId, courseId);
        if(rule !=null){
            this.updateRuleValue(orgId, courseId, ruleValue);
        }else{
            this.create(orgId, courseId, ruleValue);
        }
    }

    @Override
    public OrgCourseConsumeRule getRuleByCourseId(Long orgId, Long courseId) {
        
        //获取课消规则
        OrgCourseConsumeRule rule = orgCourseConsumeRuleDao.getRuleByCourseId(orgId, courseId);
        if(rule == null){
            rule = new OrgCourseConsumeRule();
        }
        //获取课消规则对应的描述
        String ruleDesc = CourseConsumeRuleEnum.getRuleDescByValue(rule.getRuleValue());
        rule.setRuleDesc(ruleDesc);
        
        return rule;
            
    }

    @Override
    public OrgCourseConsumeRule getOrgDefaultRule(Long orgId) {
        OrgCourseConsumeRule defaultRule = new OrgCourseConsumeRule();
        TXCommonRule commonRule = tXCommonRuleService.getByOrgId(orgId.intValue());
        if(commonRule!=null && commonRule.getConsumeRule()!=null){
            Integer defaultConsumeRuleValue = commonRule.getConsumeRule();
            defaultRule.setRuleValue(defaultConsumeRuleValue);
            String defaultRuleDesc = CourseConsumeRuleEnum.getRuleDescByValue(defaultConsumeRuleValue);
            defaultRule.setRuleDesc(defaultRuleDesc);
        }
        return defaultRule;
            
    }
    
   

}

    