package com.baijia.tianxiao.sal.course.service;

import com.baijia.tianxiao.dal.org.po.OrgLessonConflict;
import com.baijia.tianxiao.sal.course.dto.request.LessonConflictCheckDto;
import com.baijia.tianxiao.sal.course.enums.LessonConflictEnum;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Date;
import java.util.List;

/**
 * Created by zhangrui on 16/8/24.
 */
public interface OrgLessonConflictService {

    /**
     * 获取老师冲突详情
     * @param orgId
     * @param teacherId
     * @param startTime
     * @param endTime
     * @param lessonId lessonId非必传,如果传入,查询的数据会过滤此lessonId的数据,使用场景 1,要查询lessonId为1的冲突课程有哪些,则需要传入lessonId=1    2,排课前先看看某一老师在某一个时间段安排了哪些课节,则不用传入lessonId
     * @param pageDto
     * @return
     */
    public List<OrgLessonConflict> checkTeacherConflict(Long orgId,Long teacherId, Date startTime, Date endTime,Long lessonId,PageDto pageDto);

    /**
     * 获取教室冲突详情
     * @param orgId
     * @param roomId
     * @param startTime
     * @param endTime
     * @param lessonId lessonId非必传,如果传入,查询的数据会过滤此lessonId的数据,使用场景 1,要查询lessonId为1的冲突课程有哪些,则需要传入lessonId=1    2,排课前先看看某一教室在某一个时间段安排了哪些课节,则不用传入lessonId
     * @param pageDto
     * @return
     */
    public List<OrgLessonConflict> checkRoomConflict(Long orgId,Long roomId, Date startTime, Date endTime,Long lessonId,PageDto pageDto);

    public void saveOrgLessonConflicts(List<OrgLessonConflict> lists);

    /**
     * 获取老师冲突个数
     * @param orgId
     * @param teacherId
     * @param startTime
     * @param endTime
     * @param lessonId lessonId非必传,如果传入,查询的数据会过滤此lessonId的数据,使用场景 1,要查询lessonId为1的冲突课程有多少,则需要传入lessonId=1    2,排课前先看看某一老师在某一个时间段安排了多少课节,则不用传入lessonId
     * @return
     */
    public int queryTeacherConflictNum(Long orgId,Long teacherId, Date startTime, Date endTime,Long lessonId);

    /**
     * 获取教室冲突个数
     * @param orgId
     * @param roomId
     * @param startTime
     * @param endTime
     * @param lessonId lessonId非必传,如果传入,查询的数据会过滤此lessonId的数据,使用场景 1,要查询lessonId为1的冲突课程有多少,则需要传入lessonId=1    2,排课前先看看某一教室在某一个时间段安排了多少课节,则不用传入lessonId
     * @return
     */
    public int queryRoomConflictNum(Long orgId,Long roomId, Date startTime, Date endTime,Long lessonId);

    void updateOrgLessonConflictForTeacherChange(OrgLessonConflict conflict);

    void updateOrgLessonConflictForTeacherChange(List<OrgLessonConflict> conflictList);


    public void updateOrgLessonConflictForRoomOrTimeChange(OrgLessonConflict conflictList);

    /**
     * 检测是否有冲突
     * @param orgId
     * @param lessonConflictCheckDto
     * @return
     */
    public LessonConflictEnum lessonConflictFlagCheck(Long orgId, LessonConflictCheckDto lessonConflictCheckDto);

    /**
     * 物理刪除
     * @param lessonIds
     */
    void delByLessonIds(Long orgId,List<Long> lessonIds);

    /**
     * 强制删除orgid+lessonid的数据后再insert入表中
     * @param conflict
     */
    void updateOrgLessonConflictsForce(OrgLessonConflict conflict);
}
