package com.baijia.tianxiao.sal.course.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.sal.course.dto.OrgClassLessonDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseDetailResponseDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseInfoDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseQueryResponseDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgTimeSpanDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import lombok.NonNull;

public interface OrgCourseService {
    /**
     * 获取机构课程列表
     *
     * @param orgId 机构id
     * @return
     */
    public List<OrgCourseQueryResponseDto> getOrgCourses(Long orgId, String key, PageDto pageDto);

    /**
     * 获取最近的机构课程列表
     *
     * @param orgId 机构id
     * @return
     */
    public List<OrgCourseQueryResponseDto> getLatestOrgCourses(Long orgId, PageDto pageDto);

    Map<Long, List<String>> getCourseIdTeacherNamesMap(Collection<Long> courseIds);

    /**
     * 获取课程的35种颜色
     *
     * @return
     */
    List<String> getCourseColors();

    /**
     * 修改某一课程的颜色值 color格式："#A0E099"
     *
     * @param orgId
     * @param courseId
     * @param color
     */
    void changeCourseColor(Long orgId, Long courseId, String color);

    /**
     * 分配班主任
     *
     * @param orgId
     * @param cascadeId
     * @param courserIds
     */
    void assign(Long orgId, List<Long> courserIds, Long cascadeId);

    /**
     * 分页查询机构3810课程列表
     *
     * @param orgId
     * @param pageDto
     * @return
     */
    public List<OrgCourseDetailResponseDto> getOrgCourseList(Long orgId, int status, PageDto pageDto);

    /**
     * 查询课程详情
     *
     * @param orgId
     * @param courseId
     * @return
     */
    public OrgCourseDetailResponseDto getOrgCourseDetail(Long orgId, Long courseId);

    /**
     * 查询课程详情
     *
     * @param orgId
     * @param courseId
     * @return
     */
    public CourseListReponseDto getOrgBasicCourseInfo(Long orgId, Long courseId);

    /**
     * 添加,修改课程时间段 1.OrgTimeSpanDto.id无效(null 或者 0)则添加，否则根据id修改对应时间段2.时间段起止必须是5min为单位，否则会抛出异常
     *
     * @param orgId
     * @param timeSpanList
     */
    public void addOrEditOrgTimeSpan(Long orgId, List<OrgTimeSpanDto> timeSpanList);

    /**
     * 列表课程时间段
     *
     * @param orgId
     * @return
     */
    public List<OrgTimeSpanDto> listOrgTimeSpan(Long orgId);

    /**
     * 根据时间段的id批量删除课程时间段
     *
     * @param ids
     */
    void deleteOrgTimeSpan(Collection<Long> ids);

    /**
     * 返回学生的课节的相关信息 包括：课节号，课节起止时间，课程名，老师姓名，老师名，老师头像，老师ID
     *
     * @param orgId
     * @param lessonId
     * @param studentId
     * @return
     */
    Map<String, Object> buildLessonInfo(Long orgId, Long lessonId, Long studentId);

    /**
     * 添加或者修改一个课程 courseId <= 0 或者 courseId == null:表示添加。其它有效的courseId表示编辑。
     *
     * @param course
     */
    Long saveOrUpdateCourse(Long orgId, OrgCourseInfoDto course, boolean doDelete, boolean updateRepeate);

    OrgCourseInfoDto getOrgCourseInfo(Long orgId, Long courseId);
    
    void deleteOrgCourses(Long orgId, Collection<Long> courseIds);

    void batchUpdateStatus(Long orgId, Collection<Long> courseIds, Integer status);

    void repairNumber();

    /**
     * 获取有报名的班级
     *
     * @param orgId
     * @param key
     * @param pageDto
     * @return
     */
    public List<OrgCourseQueryResponseDto> getEnrolledOrgCourses(@NonNull Long orgId, String key, PageDto pageDto);


    public OrgCourseDetailResponseDto getOrgCourseDetailByNumber(Long orgNumber, Long courseNumber);

    /**
     * @param orgId
     * @param key
     * @return
     */
        
    List<OrgCourse> getAllOrgCourses(Long orgId, String key);
    
    List<OrgCourse> getAllOrgCoursesByNames(Long orgId, List<String> courseNames);

    public List<OrgClassLessonDto> getOrgClassLessonDtoList(Long valueOf, Long id);
    
    public List<Long> getCourseNumberByOrg(@NonNull Long orgNumber);

    /**
     * 筛选满足条件的课程列表
     * @param orgId：机构id
     * @param teacherIds：老师id集合
     * @param classRoomIds：教室id集合
     * @param type：筛选类型 0:全部 1:有冲突
     * @return
     */
	public List<CourseDto> selectCourse(Long orgId, List<Long> teacherIds, List<Long> classRoomIds, Integer type);
}
