
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.course.dto.response;

import org.apache.commons.collections4.CollectionUtils;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import lombok.Data;

/**
 * @title TeacherClassHourDto
 * @desc TODO
 * @author shanyu
 * @date 2016年3月30日
 * @version 1.0
 */
@Data
public class TeacherClassHourDto {

    private Long teacherId;

    private String teacherName;

    private String avatar;

    private int lessonCount;

    private int minutes;

    private List<TeacherCourseDto> courses;
    
    private int studentCount;
    
    private int signCount;
    
    private int leaveCount;
    
    private int absentCount;

    public void setCourses(List<TeacherCourseDto> courses) {
        if (CollectionUtils.isNotEmpty(courses)) {
            Collections.sort(courses, new Comparator<TeacherCourseDto>() {

                @Override
                public int compare(TeacherCourseDto o1, TeacherCourseDto o2) {
                    return Integer.compare(o2.getMinutes(), o1.getMinutes());
                }
            });
        }
        this.courses = courses;
        
        int tempCount = 0;
        for(TeacherCourseDto courseDto:courses){
            tempCount+=courseDto.getSignCount();
        }
        this.signCount = tempCount;
        
        int tempStudentCount = 0;
        int tempSignCount = 0;
        int tempLeaveCount = 0;
        int tempAbsentCount = 0;
        for(TeacherCourseDto courseDto:courses){
            tempStudentCount+=courseDto.getStudentCount();
            tempSignCount+=courseDto.getSignCount();
            tempLeaveCount+=courseDto.getLeaveCount();
            tempAbsentCount+=courseDto.getAbsentCount();
        }
        this.studentCount = tempStudentCount;
        this.signCount = tempSignCount;
        this.leaveCount = tempLeaveCount;
        this.absentCount = tempAbsentCount;
    }

}
