/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.constant.OrgLessonSignSourceEnum;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.common.dto.WechatMsgTypeSuper;
import com.baijia.tianxiao.sal.common.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.SignWechatTemplateMsg;
import com.baijia.tianxiao.sal.common.utils.NotifyMessageUtils;
import com.baijia.tianxiao.sal.common.utils.WechatTemplateMsgHelper;
import com.baijia.tianxiao.sal.course.dto.SignStatusRemarkDto;
import com.baijia.tianxiao.sal.course.dto.SigninMsgAsynModel;
import com.baijia.tianxiao.sal.course.dto.request.SignWithRemarkRequest;
import com.baijia.tianxiao.sal.course.dto.response.LessonSignReportDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentLessonSignDto;
import com.baijia.tianxiao.sal.course.dto.response.SigninFailedDto;
import com.baijia.tianxiao.sal.course.exceptions.SignErrorCode;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sal.course.util.ErpUtils;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoChangeLogService;
import com.baijia.tianxiao.sal.kexiao.utils.KexiaoUtil;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgLessonSignServiceImpl
implements OrgLessonSignService {
    private static final Logger log = LoggerFactory.getLogger(OrgLessonSignServiceImpl.class);
    @Deprecated
    private static String smsContent = "%s\u4f60\u597d\uff0c\u4f60\u5df2\u7ecf\u5728%s\u7684%s%s\u5b8c\u6210\u7b7e\u5230\uff0c\u72b6\u6001\u4e3a\u201c%s\u201d\u3002\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u62e8\u62534000122166\u8f6c%s";
    @Deprecated
    private static String smsContentWithRemark = "%s\u4f60\u597d\uff0c\u4f60\u5df2\u7ecf\u5728%s\u7684%s%s\u5b8c\u6210\u7b7e\u5230\uff0c\u72b6\u6001\u4e3a\u201c%s\u201d\uff0c\u5907\u6ce8\u4e3a\u201c%s\u201d\u3002\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u62e8\u62534000122166\u8f6c%s";
    private static String content = "\u4f60\u597d:\n %s\u4f60\u5df2\u7ecf\u5728%s\u7684%s\u5b8c\u6210\u7b7e\u5230\uff0c\u72b6\u6001\u4e3a\u201c%s\u201d\u3002";
    private static String contentWithRemark = "\u4f60\u597d:\n %s\u4f60\u5df2\u7ecf\u5728%s\u7684%s\u5b8c\u6210\u7b7e\u5230\uff0c\u72b6\u6001\u4e3a\u201c%s\u201d\uff0c\u5907\u6ce8\u4e3a\u201c%s\u201d\u3002";
    private static String remark = "\n\u8bf7\u70b9\u51fb\u6d88\u606f\u67e5\u770b\u8bfe\u8868\uff0c\u5982\u679c\u5bf9\u7b7e\u5230\u60c5\u51b5\u6709\u7591\u95ee\uff0c\u60a8\u53ef\u81f4\u75354000122166\u8f6c%s";
    private static String course = "%s\u7b2c%s\u6b21\u8bfe";
    private static final String SIGN_TIP = "%s\u5269\u4f59%s\u4e0d\u8db3,\u4fee\u6539\u7b7e\u5230\u72b6\u6001\u540e,\u7cfb\u7edf\u4f1a\u5c06\u8be5\u8bfe\u8282\u6807\u8bb0\u4e3a\u5b66\u5458\u7684\u8d60\u9001\u8bfe,\u786e\u8ba4\u4fee\u6539\u7b7e\u5230\u72b6\u6001\u5417?";
    private static String defaultName = "-";
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;
    @Autowired(required=false)
    private CommonMsgService commonMsgService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private KexiaoChangeLogService changeLogService;
    @Autowired
    private OrgSignupCourseLessonService courseLessonService;
    @Autowired
    private OrgCourseConsumeRuleDao courseConsumeRuleDao;
    public static final String firstFormat = "%s\u540c\u5b66\u5728%s\u8bfe\u7a0b%s\n\u4e0a\u8bfe\u65f6\u95f4\u4e3a%s";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SigninFailedDto orgStudentLessonBatchSign(Long orgId, Long lessonId, List<Long> studentIds, Integer status, int confirm) {
        if (CollectionUtils.isEmpty(studentIds) || lessonId == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u548c\u5b66\u751fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long cascadeId = TianxiaoMContext.getTXCascadeIdLongZeroFill();
        OrgClassLesson lesson = this.orgClassLessonDao.getByIdForUpdate(lessonId);
        Preconditions.checkArgument((lesson != null && orgId.equals(lesson.getOrgId()) ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((status != null && status >= 0 ? 1 : 0) != 0, (Object)"\u7b7e\u5230\u72b6\u6001\u4e0d\u6b63\u786e");
        Map studentIdUserIdMap = this.orgStudentDao.getStudentIdUserIdMap(studentIds);
        Collection userIdList = studentIdUserIdMap.values();
        Long courseId = ((OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[]{"courseId"})).getCourseId();
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)lesson.getCourseId(), new String[0]);
        Preconditions.checkArgument((course != null ? 1 : 0) != 0, (Object)" \u8bfe\u8282ID\u4e0d\u6b63\u786e");
        log.info("orgId:{}, courseId:{}, userIdList:{}", new Object[]{orgId, courseId, userIdList});
        Map uIdStatusWithdrawMap = this.orgStudentCourseDao.userMapByStatus(orgId, courseId, userIdList, Arrays.asList(StudentCourseStatus.WITHDRAW.getCode(), StudentCourseStatus.TRANSFER.getCode()));
        Collection inValidUserIds = CollectionUtils.intersection(userIdList, uIdStatusWithdrawMap.keySet());
        SigninFailedDto result = new SigninFailedDto();
        for (Long userId : inValidUserIds) {
            result.addFailedStudent(new SigninFailedDto.FailedStudent(userId, (Integer)uIdStatusWithdrawMap.get(userId)));
        }
        log.info("Quit class can not modify allInvalidUserIds={}", (Object)uIdStatusWithdrawMap);
        List allSignStudents = this.orgLessonSignDao.getLessonStudentIds(orgId, lessonId, userIdList, null, new String[0]);
        HashSet userIds = Sets.newHashSet(userIdList);
        HashSet signedUserIds = Sets.newHashSet();
        ArrayList<OrgLessonSign> validSigns = new ArrayList<OrgLessonSign>();
        log.debug("userIds:{}, signStudents:{}", (Object)userIds, (Object)allSignStudents);
        if (CollectionUtils.isNotEmpty((Collection)allSignStudents)) {
            for (Object signStudent : allSignStudents) {
                SigninFailedDto.FailedStudent failedStudent = result.getFailedStudent(signStudent.getUserId());
                if (null != failedStudent) {
                    failedStudent.setSignStatus(signStudent.getStatus());
                    failedStudent.setSignRemark(signStudent.getSignRemark());
                    failedStudent.setSendToStu(signStudent.getSendToStu());
                } else {
                    signStudent.setStatus(status);
                    validSigns.add((OrgLessonSign)signStudent);
                    signedUserIds.add(signStudent.getUserId());
                }
                userIds.remove(signStudent.getUserId());
            }
        }
        this.fillStudentInfo(orgId, result);
        log.info("update studentIds:{} in lesson:{} to signStatus:{}", new Object[]{signedUserIds, lessonId, status});
        this.orgLessonSignDao.orgLessonSignBatchEdit(lessonId, (Collection)signedUserIds, status, cascadeId, Integer.valueOf(OrgLessonSignSourceEnum.NORMAL.getValue()));
        if (CollectionUtils.isNotEmpty((Collection)userIds) || CollectionUtils.isNotEmpty((Collection)signedUserIds)) {
            Preconditions.checkArgument((lesson != null && orgId.equals(lesson.getOrgId()) ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
            ArrayList newSignStudents = Lists.newArrayList();
            for (Long userId : userIds) {
                OrgLessonSign lessonSign = new OrgLessonSign();
                lessonSign.setCourseId(lesson.getCourseId());
                lessonSign.setCreateTime(new Date());
                lessonSign.setLessonId(lessonId);
                lessonSign.setOrgId(orgId);
                lessonSign.setStatus(status);
                lessonSign.setUserId(userId);
                lessonSign.setUpdateTime(new Date());
                lessonSign.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
                lessonSign.setCascadeId(cascadeId);
                lessonSign.setTeacherId(Integer.valueOf(0));
                lessonSign.setSource(Integer.valueOf(OrgLessonSignSourceEnum.NORMAL.getValue()));
                newSignStudents.add(lessonSign);
            }
            log.info("save sign students:{}", (Object)newSignStudents);
            this.orgLessonSignDao.saveAll((List)newSignStudents, false, new String[]{"courseId", "createTime", "lessonId", "orgId", "status", "userId", "updateTime", "userRole", "cascadeId", "source", "teacherId"});
            long realCourseId = courseId;
            if (CourseTypeEnum.isOneToOne((Integer)course.getCourseType())) {
                realCourseId = course.getParentId();
            }
            OrgCourseConsumeRule rule = this.courseConsumeRuleDao.getRuleByCourseId(orgId, Long.valueOf(realCourseId));
            LessonStatus lessonStatus = null;
            if (rule != null) {
                lessonStatus = KexiaoUtil.getKexiaoStatus((int)status, (int)rule.getRuleValue());
            }
            if (status.intValue() != SignStatus.SIGNED.getCode() && rule != null && rule.getRuleValue() > 0 && status != 0 && lessonStatus != LessonStatus.FINISHED) {
                HashSet<Long> allUserIds = new HashSet<Long>(userIds);
                allUserIds.addAll(signedUserIds);
                this.courseLessonService.cancelSign(orgId, lessonId, allUserIds);
            }
            this.changeLogService.addBatchSignLog(orgId, userIdList, (Collection)Sets.newHashSet((Object[])new Long[]{lessonId}), status.intValue());
            if (lessonStatus == LessonStatus.FINISHED) {
                this.resetLesson(orgId, courseId, Arrays.asList(lessonId), signedUserIds, course.getChargeUnit(), confirm);
            }
            if (!this.checkOrgPermissionSignMsg(orgId.intValue())) {
                return result;
            }
            if (lesson.getStartTime().after(DateUtil.getCurrentDate()) && lesson.getStartTime().before(DateUtil.getDiffDateTime((Date)DateUtil.getCurrentDate(), (int)1))) {
                ArrayList signInList = Lists.newArrayList();
                signInList.addAll(validSigns);
                signInList.addAll(newSignStudents);
                this.addToSigninMsgAsynModel(signInList);
            }
        }
        return result;
    }

    @Override
    public void fillStudentInfo(Long orgId, SigninFailedDto result) {
        Map userIdOrgStudentMap = this.orgStudentDao.getStudentMap(result.getFailedStudentMap().keySet(), orgId, new String[]{"id", "userId", "name"});
        for (SigninFailedDto.FailedStudent failedStudent : result.getFailedStudentList()) {
            OrgStudent orgStudent = (OrgStudent)userIdOrgStudentMap.get(failedStudent.getUserId());
            failedStudent.setStudentId(orgStudent.getId());
            failedStudent.setName(orgStudent.getName());
        }
    }

    private void resetLesson(Long orgId, Long courseId, Collection<Long> lessonIds, Collection<Long> userIds, int chargeUnit, int confirm) {
        List lessons = this.orgStudentLessonDao.getByLessonIdsStudentIds(lessonIds, userIds, new String[0]);
        List<OrgStudentLesson> unSignableList = this.courseLessonService.getUnSignableList(orgId, courseId, lessons);
        HashSet<Long> unSignableUserIds = new HashSet<Long>();
        for (OrgStudentLesson orgStudentLesson : unSignableList) {
            unSignableUserIds.add(orgStudentLesson.getUserId());
        }
        if (unSignableUserIds.size() > 0 && confirm != 1) {
            SignErrorCode code = new SignErrorCode();
            code.setMessage(this.createErrorMessage(orgId, unSignableUserIds, chargeUnit));
            throw new BussinessException((UniverseErrorCode)code);
        }
        ArrayList<OrgStudentLesson> reLessons = new ArrayList<OrgStudentLesson>();
        for (OrgStudentLesson stuLesson : lessons) {
            if (stuLesson.getLessonType() != LessonType.CANCEL.getCode()) continue;
            reLessons.add(stuLesson);
        }
        Date date = new Date();
        if (!reLessons.isEmpty()) {
            this.courseLessonService.saveSignupCourseLessons(orgId, courseId, reLessons);
            for (OrgStudentLesson updateStudentLesson : reLessons) {
                updateStudentLesson.setUpdateTime(date);
                this.orgStudentLessonDao.update((Object)updateStudentLesson, new String[0]);
            }
        }
    }

    private String createErrorMessage(Long orgId, Collection<Long> unSignableUserIds, int chargeUnit) {
        PageDto page = new PageDto();
        page.setPageSize(Integer.valueOf(6));
        List studentList = this.orgStudentDao.getStudents(orgId, unSignableUserIds, null, page, new String[]{"name"});
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < studentList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            if (i >= 5) {
                stringBuilder.append("...\u7b49");
                break;
            }
            stringBuilder.append(((OrgStudent)studentList.get(i)).getName());
        }
        String chargeUnitDesc = "\u8bfe\u6b21";
        if (ChargeUnit.isByTime((int)chargeUnit)) {
            chargeUnitDesc = "\u8bfe\u65f6";
        }
        return String.format(SIGN_TIP, stringBuilder.toString(), chargeUnitDesc);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orgUnionStudentsMultiLessonBatchSign(Long orgId, Long courseId, List<Long> lessonIds, List<Long> userIds, Integer status, int confirm) {
        Long cascadeId = TianxiaoMContext.getTXCascadeIdLongZeroFill();
        this.orgLessonSignDao.orgLessonSignBatchEdit(lessonIds, userIds, status, cascadeId, Integer.valueOf(OrgLessonSignSourceEnum.BATCH.getValue()));
        Map<Long, Set<Long>> inDbSigninLessonIdUserIdsMap = this.makeInDbSigninLessonIdUserIdsMap(orgId, courseId, lessonIds, userIds);
        HashSet<Long> signedUserIds = new HashSet<Long>();
        for (Long lessonId : inDbSigninLessonIdUserIdsMap.keySet()) {
            signedUserIds.addAll((Collection)inDbSigninLessonIdUserIdsMap.get(lessonId));
        }
        log.info("orgUnionStudentsMultiLessonBatchSign inDB signin lessonIdUserIds map:{}", inDbSigninLessonIdUserIdsMap);
        Map<Long, Set<Long>> inDbStudentLessonIdUserIdsMap = this.makeInDbStudentLessonIdUserIdsMap(lessonIds, userIds);
        log.info("orgUnionStudentsMultiLessonBatchSign inDB students lessonIdUserIds map:{}", inDbStudentLessonIdUserIdsMap);
        Map<Long, Set<Long>> newSigninLessonIdUserIdsMap = this.makeDifferenceSetLessonIdUserIdsMap(inDbSigninLessonIdUserIdsMap, inDbStudentLessonIdUserIdsMap);
        log.info("orgUnionStudentsMultiLessonBatchSign deference students lessonIdStudentId map:{}", newSigninLessonIdUserIdsMap);
        ArrayList newSignStudents = Lists.newArrayList();
        for (Long lessonId : newSigninLessonIdUserIdsMap.keySet()) {
            for (Long studentId : newSigninLessonIdUserIdsMap.get(lessonId)) {
                OrgLessonSign lessonSign = new OrgLessonSign();
                lessonSign.setCourseId(courseId);
                lessonSign.setCreateTime(new Date());
                lessonSign.setLessonId(lessonId);
                lessonSign.setOrgId(orgId);
                lessonSign.setStatus(status);
                lessonSign.setUserId(studentId);
                lessonSign.setUpdateTime(new Date());
                lessonSign.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
                lessonSign.setCascadeId(cascadeId);
                lessonSign.setTeacherId(Integer.valueOf(0));
                lessonSign.setSource(Integer.valueOf(OrgLessonSignSourceEnum.BATCH.getValue()));
                newSignStudents.add(lessonSign);
            }
        }
        log.info("save sign students length:{}", (Object)newSignStudents.size());
        if (CollectionUtils.isNotEmpty((Collection)newSignStudents)) {
            this.orgLessonSignDao.saveAll((List)newSignStudents, false, new String[]{"courseId", "createTime", "lessonId", "orgId", "status", "userId", "updateTime", "userRole", "cascadeId", "source", "teacherId"});
        }
        long realCourseId = courseId;
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        if (CourseTypeEnum.isOneToOne((Integer)course.getCourseType())) {
            realCourseId = course.getParentId();
        }
        OrgCourseConsumeRule rule = this.courseConsumeRuleDao.getRuleByCourseId(orgId, Long.valueOf(realCourseId));
        LessonStatus lessonStatus = null;
        if (rule != null && (lessonStatus = KexiaoUtil.getKexiaoStatus((int)status, (int)rule.getRuleValue())) == LessonStatus.FINISHED) {
            this.resetLesson(orgId, courseId, lessonIds, signedUserIds, course.getChargeUnit(), confirm);
        }
        if (status.intValue() != SignStatus.SIGNED.getCode() && rule != null && rule.getRuleValue() > 0 && status != 0 && lessonStatus != LessonStatus.FINISHED) {
            for (Long lessonId : lessonIds) {
                HashSet<Long> allUserIds = new HashSet<Long>(userIds);
                allUserIds.addAll(signedUserIds);
                this.courseLessonService.cancelSign(orgId, lessonId, allUserIds);
            }
        }
        this.changeLogService.addBatchSignLog(orgId, userIds, lessonIds, status.intValue());
    }

    private Map<Long, Set<Long>> makeDifferenceSetLessonIdUserIdsMap(Map<Long, Set<Long>> inDbSigninLessonIdUserIdsMap, Map<Long, Set<Long>> inDbStudentLessonIdUserIdsMap) {
        HashMap result = Maps.newHashMap();
        for (Long lessonId : inDbStudentLessonIdUserIdsMap.keySet()) {
            Set<Long> someUserIds = inDbSigninLessonIdUserIdsMap.get(lessonId);
            Set<Long> allUserIds = inDbStudentLessonIdUserIdsMap.get(lessonId);
            result.put(lessonId, Sets.newHashSet((Iterable)CollectionUtils.subtract(allUserIds, (Collection)(null == someUserIds ? Sets.newHashSet() : someUserIds))));
        }
        return result;
    }

    private Map<Long, Set<Long>> makeInDbStudentLessonIdUserIdsMap(List<Long> lessonIds, List<Long> userIds) {
        HashMap result = Maps.newHashMap();
        List studentLessons = this.orgStudentLessonDao.getByLessonIdsStudentIds(lessonIds, userIds, new String[]{"lessonId", "userId"});
        for (OrgStudentLesson studentLesson : studentLessons) {
            if (result.containsKey(studentLesson.getLessonId())) {
                ((Set)result.get(studentLesson.getLessonId())).add(studentLesson.getUserId());
                continue;
            }
            result.put(studentLesson.getLessonId(), Sets.newHashSet((Object[])new Long[]{studentLesson.getUserId()}));
        }
        return result;
    }

    private Map<Long, Set<Long>> makeInDbSigninLessonIdUserIdsMap(Long orgId, Long courseId, List<Long> lessonIds, List<Long> userIds) {
        HashMap result = Maps.newHashMap();
        List signList = this.orgLessonSignDao.getByOrgIdCourseIdLessonIdsStudentIds(orgId, courseId, lessonIds, userIds, new String[]{"lessonId", "userId"});
        for (OrgLessonSign sign : signList) {
            if (result.containsKey(sign.getLessonId())) {
                ((Set)result.get(sign.getLessonId())).add(sign.getUserId());
                continue;
            }
            result.put(sign.getLessonId(), Sets.newHashSet((Object[])new Long[]{sign.getUserId()}));
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orgStudentLessonBatchFastSign(Long orgId, Long courseId, List<Long> lessonIds, Map<Long, Integer> studentIdSignInStatus) {
        Set<Long> studentIds = studentIdSignInStatus.keySet();
        if (CollectionUtils.isEmpty(studentIds) || CollectionUtils.isEmpty(lessonIds)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u548c\u5b66\u751fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("create studentsSignIns:{} in lesson:{}", studentIdSignInStatus, lessonIds);
        Long cascadeId = TianxiaoMContext.getTXCascadeIdLongZeroFill();
        Map map = this.orgStudentDao.getStudentIdUserIdMap(studentIds);
        HashMap<Long, Integer> userIdSignInStatus = new HashMap<Long, Integer>();
        ArrayList newSignStudents = Lists.newArrayList();
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        long realCourseId = courseId;
        if (CourseTypeEnum.isOneToOne((Integer)course.getCourseType())) {
            realCourseId = course.getParentId();
        }
        OrgCourseConsumeRule rule = this.courseConsumeRuleDao.getRuleByCourseId(orgId, Long.valueOf(realCourseId));
        LessonStatus lessonStatus = null;
        if (MapUtils.isNotEmpty((Map)map)) {
            for (Long lessonId : lessonIds) {
                OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
                Preconditions.checkArgument((lesson != null && orgId.equals(lesson.getOrgId()) ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
                Map invalidUsers = this.orgStudentCourseDao.userMapByStatus(orgId, courseId, map.values(), Arrays.asList(1, 2));
                HashSet<Long> allUserIds = new HashSet<Long>();
                for (Map.Entry studentEntry : map.entrySet()) {
                    if (invalidUsers.containsKey(studentEntry.getValue())) continue;
                    OrgLessonSign lessonSign = new OrgLessonSign();
                    lessonSign.setCourseId(lesson.getCourseId());
                    lessonSign.setCreateTime(new Date());
                    lessonSign.setLessonId(lessonId);
                    lessonSign.setOrgId(orgId);
                    lessonSign.setStatus(studentIdSignInStatus.get(studentEntry.getKey()));
                    lessonSign.setUserId((Long)studentEntry.getValue());
                    lessonSign.setUpdateTime(new Date());
                    lessonSign.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
                    lessonSign.setCascadeId(cascadeId);
                    lessonSign.setTeacherId(Integer.valueOf(0));
                    lessonSign.setSource(Integer.valueOf(OrgLessonSignSourceEnum.FAST.getValue()));
                    newSignStudents.add(lessonSign);
                    userIdSignInStatus.put(lessonSign.getUserId(), lessonSign.getStatus());
                    if (rule != null) {
                        lessonStatus = KexiaoUtil.getKexiaoStatus((int)lessonSign.getStatus(), (int)rule.getRuleValue());
                    }
                    if (lessonSign.getStatus().intValue() == SignStatus.SIGNED.getCode() || rule == null || rule.getRuleValue() <= 0 || lessonSign.getStatus() == 0 || lessonStatus == LessonStatus.FINISHED) continue;
                    allUserIds.add(lessonSign.getUserId());
                }
                if (allUserIds.size() <= 0) continue;
                this.courseLessonService.cancelSign(orgId, lessonId, allUserIds);
            }
            log.info("save sign students:{}", (Object)newSignStudents);
            this.orgLessonSignDao.saveAll((List)newSignStudents, false, new String[]{"courseId", "createTime", "lessonId", "orgId", "status", "userId", "updateTime", "userRole", "cascadeId", "source", "teacherId"});
            this.changeLogService.addFastSignLog(orgId, lessonIds, userIdSignInStatus);
        }
    }

    private SendMsgRequest getSendMsgRequest(OrgInfo orgInfo, OrgStudent student, String teacherName, OrgClassLesson lesson, OrgCourse course, OrgLessonSign orgLessonSign) {
        String studentName = this.getStringValue(student.getName());
        String orgName = orgInfo.getShortName();
        String courseName = course.getName();
        String extention = this.getStringValue(orgInfo.getExtension());
        teacherName = this.getStringValue(teacherName);
        int type = 1;
        if (orgLessonSign.getStatus().intValue() == SignStatus.SIGNED.getCode()) {
            type = 1;
        } else if (orgLessonSign.getStatus().intValue() == SignStatus.LEAVE.getCode()) {
            type = 2;
        } else if (orgLessonSign.getStatus().intValue() == SignStatus.ABSENT.getCode()) {
            type = 3;
        }
        String smsContent = SmsContentHelper.createSignRecordSmsMsg((int)type, (String)studentName, (long)lesson.getStartTime().getTime(), (String)courseName, (String)orgName);
        String url = ErpUtils.createClassSchedule(orgInfo.getOrgId().longValue(), student.getId());
        SignWechatTemplateMsg msg = SignWechatTemplateMsg.newInstance((String)studentName, (String)orgName, (Integer)orgLessonSign.getStatus(), (String)courseName, (long)lesson.getStartTime().getTime(), (long)lesson.getEndTime().getTime(), (long)orgLessonSign.getUpdateTime().getTime(), (String)teacherName, (String)extention, (String)url);
        SendMsgRequest createSendMsgRequestToStu = WechatTemplateMsgHelper.createSendMsgRequestToStu((Long)orgInfo.getOrgId().longValue(), (String)student.getMobile(), (Long)student.getId(), (String)student.getWeixin(), (String)smsContent, (WechateTemplateMsgType)WechateTemplateMsgType.COURSE_SIGNIN_TO_STU, (WechatMsgTypeSuper)msg);
        return createSendMsgRequestToStu;
    }

    public String createClassSchedule(Long orgId, Long studentId) {
        try {
            Properties fillProperties = PropertiesReader.fillProperties((String)"erp.properties");
            log.info("fillProperties is:{} ", (Object)fillProperties);
            String scheduleUrl = fillProperties.getProperty("student_class_schedule");
            if (GenericsUtils.isNullOrEmpty((Object)scheduleUrl)) {
                return "";
            }
            StudentSmsTokenDto token = new StudentSmsTokenDto(orgId, null, studentId, null);
            token.setStudentId(studentId);
            return scheduleUrl.replace("#{TOKEN}", token.toTokenStr());
        }
        catch (Exception e) {
            log.error("error :{} ", (Throwable)e);
            log.info("can not create token with orgId:{} and studentId:{} ", (Object)orgId, (Object)studentId);
            return "";
        }
    }

    private String makeFirst(String studentName, String orgName, String courseName, String signStatusStr, String signRemark, Integer sendToStu) {
        if (sendToStu != null && sendToStu.intValue() == Flag.TRUE.getInt() && StringUtils.isNotBlank((String)signRemark)) {
            return String.format(contentWithRemark, studentName, orgName, courseName, signStatusStr, signRemark);
        }
        return String.format(content, studentName, orgName, courseName, signStatusStr);
    }

    public String markFirst(String stuName, String orgName, int signStatus, String courseTime, String remak, Integer sendToStu) {
        String signStatusStr = SignStatus.createSignStr((int)signStatus);
        String retStr = String.format(firstFormat, stuName, orgName, signStatusStr, courseTime);
        if (GenericsUtils.notNullAndEmpty((Object)remak) && sendToStu != null && sendToStu.intValue() == Flag.TRUE.getInt()) {
            retStr = retStr + "\u5907\u6ce8\u4e3a:" + remark;
        }
        retStr = retStr + "\n";
        return retStr;
    }

    private String makeSmsContent(String studentName, String orgName, String courseName, String lessonName, String signStatusStr, String extention, String signRemark, Integer sendToStu) {
        if (sendToStu != null && sendToStu.intValue() == Flag.TRUE.getInt() && StringUtils.isNotBlank((String)signRemark)) {
            return String.format(smsContentWithRemark, studentName, orgName, courseName, NotifyMessageUtils.generateLessonName((String)lessonName, (boolean)false), signStatusStr, extention, signRemark);
        }
        return String.format(smsContent, studentName, orgName, courseName, NotifyMessageUtils.generateLessonName((String)lessonName, (boolean)false), signStatusStr, extention);
    }

    private String getStringValue(String message) {
        if (StringUtils.isBlank((String)message)) {
            return defaultName;
        }
        return message;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orgStudentLessonSign(@NonNull Long orgId, Long courseId, @NonNull Long lessonId, @NonNull Long studentId, Integer status, Integer teacherId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        Preconditions.checkArgument((status != null && status >= 0 ? 1 : 0) != 0, (Object)"\u7b7e\u5230\u72b6\u6001\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((lessonId != null && lessonId >= 0L ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((orgId != null && orgId >= 0L ? 1 : 0) != 0, (Object)"\u673a\u6784ID\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((studentId != null && studentId >= 0L ? 1 : 0) != 0, (Object)"\u5b66\u751fID\u4e0d\u6b63\u786e");
        OrgClassLesson lesson = this.orgClassLessonDao.getByIdForUpdate(lessonId);
        Preconditions.checkArgument((lesson != null && orgId.equals(lesson.getOrgId()) ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)lesson.getCourseId(), new String[0]);
        Preconditions.checkArgument((course != null ? 1 : 0) != 0, (Object)" \u8bfe\u8282ID\u4e0d\u6b63\u786e");
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        Long userId = student == null ? null : student.getUserId();
        Preconditions.checkArgument((userId != null && userId >= 0L ? 1 : 0) != 0, (Object)("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5b66\u751fID:" + studentId));
        Map uIdStatusWithdrawMap = this.orgStudentCourseDao.userMapByStatus(orgId, courseId, Arrays.asList(userId), Arrays.asList(StudentCourseStatus.WITHDRAW.getCode(), StudentCourseStatus.TRANSFER.getCode()));
        log.info("Quit class can not modify status.InvalidUserIds={}", (Object)uIdStatusWithdrawMap);
        if (uIdStatusWithdrawMap.containsKey(userId)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u9000\u73ed\u5b66\u5458\u7b7e\u5230\u72b6\u6001\u4e0d\u53ef\u66f4\u6539");
        }
        Long cascadeId = TianxiaoMContext.getTXCascadeIdLongZeroFill();
        OrgLessonSign obj = this.orgLessonSignDao.getStudentLessonSign(orgId, courseId, lessonId, userId, Integer.valueOf(UserRole.STUDENT.getRole()));
        if (obj != null && status != null && !status.equals(obj.getStatus())) {
            obj.setStatus(status);
            if (null != teacherId) {
                obj.setCascadeId(Long.valueOf(0L));
                obj.setTeacherId(teacherId);
                obj.setSource(Integer.valueOf(OrgLessonSignSourceEnum.WECHAT.getValue()));
            } else {
                obj.setTeacherId(Integer.valueOf(0));
                obj.setCascadeId(cascadeId);
                obj.setSource(Integer.valueOf(OrgLessonSignSourceEnum.NORMAL.getValue()));
            }
            this.orgLessonSignDao.update((Object)obj, new String[]{"status", "cascadeId", "source", "teacherId"});
        } else if (obj == null && status != null) {
            obj = new OrgLessonSign();
            obj.setCourseId(lesson.getCourseId());
            obj.setCreateTime(new Date());
            obj.setLessonId(lessonId);
            obj.setOrgId(orgId);
            obj.setStatus(status);
            obj.setUpdateTime(new Date());
            obj.setUserId(userId);
            obj.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
            if (null != teacherId) {
                obj.setCascadeId(Long.valueOf(0L));
                obj.setTeacherId(teacherId);
                obj.setSource(Integer.valueOf(OrgLessonSignSourceEnum.WECHAT.getValue()));
            } else {
                obj.setTeacherId(Integer.valueOf(0));
                obj.setCascadeId(cascadeId);
                obj.setSource(Integer.valueOf(OrgLessonSignSourceEnum.NORMAL.getValue()));
            }
            this.orgLessonSignDao.saveOrUpdate((Object)obj, new String[]{"courseId", "createTime", "lessonId", "orgId", "status", "userId", "updateTime", "userRole", "cascadeId", "source", "teacherId"});
        }
        this.changeLogService.addBatchSignLog(orgId, Arrays.asList(lessonId), Arrays.asList(userId), status.intValue());
        if (!this.checkOrgPermissionSignMsg(orgId.intValue())) {
            return;
        }
        if (lesson.getStartTime().after(DateUtil.getCurrentDate()) && lesson.getStartTime().before(DateUtil.getDiffDateTime((Date)DateUtil.getCurrentDate(), (int)1))) {
            ArrayList signInList = Lists.newArrayList();
            signInList.add(obj);
            this.addToSigninMsgAsynModel(signInList);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public OrgStudentLessonSignDto getStudentLessonSign(@NonNull Long orgId, Long courseId, @NonNull Long lessonId, @NonNull Long studentId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        Long userId = this.orgStudentDao.getUserId(studentId);
        OrgLessonSign obj = this.orgLessonSignDao.getStudentLessonSign(orgId, courseId, lessonId, userId, Integer.valueOf(UserRole.STUDENT.getRole()));
        if (obj != null) {
            OrgStudentLessonSignDto dto = new OrgStudentLessonSignDto();
            dto.setCourseId(obj.getCourseId());
            dto.setCreateTime(obj.getCreateTime());
            dto.setId(obj.getId());
            dto.setLessonId(obj.getLessonId());
            dto.setSignStatusEnum(SignStatus.getSignStatusByCode((Integer)obj.getStatus()));
            dto.setUpdateTime(obj.getUpdateTime());
            return dto;
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    @Deprecated
    public Map<String, Map<String, Integer>> getLessonStudentSign(Long orgId, Collection<Long> lessonIds, Map<Long, Long> userIdMap) {
        List signs = this.orgLessonSignDao.getStudentLessonSign(orgId, null, lessonIds, new String[0]);
        HashMap signUserIdMap = Maps.newHashMap();
        for (OrgLessonSign sign : signs) {
            if (!signUserIdMap.containsKey(String.valueOf(sign.getUserId()))) {
                HashMap map = Maps.newHashMap();
                signUserIdMap.put(String.valueOf(sign.getUserId()), map);
            }
            ((Map)signUserIdMap.get(String.valueOf(sign.getUserId()))).put(String.valueOf(sign.getLessonId()), sign.getStatus());
        }
        HashMap signStudentIdMap = Maps.newHashMap();
        for (String userId : signUserIdMap.keySet()) {
            signStudentIdMap.put(String.valueOf(userIdMap.get(Long.parseLong(userId))), signUserIdMap.get(userId));
        }
        return signStudentIdMap;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Map<String, SignStatusRemarkDto>> getLessonStudentSignReport(Long orgId, Collection<Long> lessonIds, Map<Long, Long> userIdMap, Long courseId) {
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)("illegal courseId = " + courseId));
        long current = System.currentTimeMillis();
        Map userIdsLessonMap = this.orgStudentLessonDao.getLessonIdsOfStudents(orgId, userIdMap.keySet(), lessonIds);
        List signList = this.orgLessonSignDao.getUserLessonSignList(orgId, userIdMap.keySet(), courseId, Integer.valueOf(UserRole.STUDENT.getRole()), null, new String[0]);
        Map<Long, List<OrgLessonSign>> userIdLessonSignMap = this.getUserIdLessonSignMap(signList);
        HashMap signStudentIdMap = Maps.newHashMap();
        for (Long userId : userIdsLessonMap.keySet()) {
            HashMap userMap = Maps.newHashMap();
            List lessons = (List)userIdsLessonMap.get(userId);
            List<OrgLessonSign> signs = userIdLessonSignMap.get(userId);
            Map<Long, SignStatusRemarkDto> lessonSignMap = this.toLessonSignMap(signs);
            for (Long lessonId : lessons) {
                SignStatusRemarkDto statusRemarkDto = lessonSignMap.get(lessonId);
                userMap.put(String.valueOf(lessonId), statusRemarkDto == null ? new SignStatusRemarkDto(0, "") : statusRemarkDto);
            }
            signStudentIdMap.put(String.valueOf(userIdMap.get(userId)), userMap);
        }
        log.debug("cost:{}ms", (Object)(System.currentTimeMillis() - current));
        return signStudentIdMap;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, Integer> getLessonStudentSignCount(Long orgId, Collection<Long> lessonIds, Map<Long, Long> userIdMap) {
        Map userIdCountMap = this.orgLessonSignDao.getOrgLessonSignCount(lessonIds, Integer.valueOf(UserRole.STUDENT.getRole()));
        log.debug("getLessonStudentSignCount result={}", (Object)userIdCountMap);
        log.debug("getLessonStudentSignCount userIdMap={}", userIdMap);
        HashMap studentIdCountMap = Maps.newHashMap();
        for (Long userId : userIdCountMap.keySet()) {
            studentIdCountMap.put(userIdMap.get(userId), userIdCountMap.get(userId));
        }
        log.debug("getLessonStudentSignCount result={}", (Object)studentIdCountMap);
        return studentIdCountMap;
    }

    @Override
    public LessonSignReportDto getLessonSignReport(@NonNull Long orgId, @NonNull Long studentId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        log.info("orgId = {}, studentId={}", (Object)orgId, (Object)studentId);
        LessonSignReportDto lessonSignReportDto = new LessonSignReportDto();
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"student not exits!");
        OrgStudent orgStudent = this.orgStudentDao.getStudent(orgId, userId, Integer.valueOf(0), new String[]{"userId", "id", "name", "nickName", "mobile", "show_mobile"});
        if (orgStudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u751f\u5df2\u5220\u9664");
        }
        lessonSignReportDto.getStudentInfo().setName(this.buildStudentName(orgStudent));
        lessonSignReportDto.getStudentInfo().setStudentId(orgStudent.getUserId());
        Integer orgNumber = ((OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[]{"number"})).getNumber();
        List orgCourseList = this.orgCourseDao.getCoursesByOrgNumber(Long.valueOf(orgNumber.longValue()), Integer.valueOf(DeleteStatus.DELETED.getValue()), new String[]{"id"});
        ArrayList deletedIds = Lists.newArrayList();
        for (OrgCourse orgCourse : orgCourseList) {
            deletedIds.add(orgCourse.getId());
        }
        List courseIds = this.orgStudentCourseDao.getStudentCourseIds(orgId, userId, null);
        courseIds.removeAll(deletedIds);
        log.debug("courseIds = {}", (Object)courseIds);
        Map courseLessonCountMap = this.orgStudentLessonDao.getStudentLessonCountOfCourses(orgId, userId, (Collection)courseIds);
        log.debug("courseLessonCountMap = {}", (Object)courseLessonCountMap);
        List courseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[]{"id", "name"});
        log.debug("courseIds = {}, courseList = {}", (Object)courseIds, (Object)courseList);
        if (CollectionUtils.isEmpty((Collection)courseList)) {
            return lessonSignReportDto;
        }
        List lessonList = this.orgClassLessonDao.queryByCourseIds(orgId, (Collection)courseIds, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        HashMap lessonMap = Maps.newHashMap();
        ArrayList allLessonIds = Lists.newArrayList();
        for (OrgClassLesson lesson : lessonList) {
            allLessonIds.add(lesson.getId());
            lessonMap.put(lesson.getId(), lesson);
        }
        HashMap studentLessonCondition = Maps.newHashMap();
        studentLessonCondition.put("orgId", orgId);
        studentLessonCondition.put("lessonId", allLessonIds);
        studentLessonCondition.put("userId", userId);
        studentLessonCondition.put("delStatus", 0);
        List studentLessons = this.orgStudentLessonDao.queryByCondition((Map)studentLessonCondition, null, new String[0]);
        HashSet effectAllLesson = Sets.newHashSet();
        HashSet effectAllStudentId = Sets.newHashSet();
        HashMap courseStudentLessonMap = Maps.newHashMap();
        for (OrgStudentLesson studentLesson : studentLessons) {
            List tempList;
            Long courseId = ((OrgClassLesson)lessonMap.get(studentLesson.getLessonId())).getCourseId();
            Long tempStudentId = studentLesson.getUserId();
            Map studentLessonMap = (Map)courseStudentLessonMap.get(courseId);
            if (studentLessonMap == null) {
                studentLessonMap = Maps.newHashMap();
                courseStudentLessonMap.put(courseId, studentLessonMap);
            }
            if ((tempList = (List)studentLessonMap.get(tempStudentId)) == null) {
                tempList = Lists.newArrayList();
                studentLessonMap.put(tempStudentId, tempList);
            }
            tempList.add(studentLesson);
            effectAllLesson.add(studentLesson.getLessonId());
            effectAllStudentId.add(tempStudentId);
        }
        List allsignList = Lists.newArrayList();
        if (effectAllLesson.size() > 0 && effectAllStudentId.size() > 0) {
            HashMap signLessonCondition = Maps.newHashMap();
            signLessonCondition.put("orgId", orgId);
            signLessonCondition.put("lessonId", effectAllLesson);
            signLessonCondition.put("studentId", effectAllStudentId);
            signLessonCondition.put("userRole", 2);
            allsignList = this.orgLessonSignDao.queryByCondition((Map)signLessonCondition, null, new String[0]);
        }
        HashMap allSignMap = Maps.newHashMap();
        for (OrgLessonSign sign : allsignList) {
            String key = sign.getUserId() + "|" + sign.getLessonId();
            allSignMap.put(key, new SignStatusRemarkDto(sign.getStatus(), sign.getSignRemark()));
        }
        for (OrgCourse orgCourse : courseList) {
            LessonSignReportDto.OrgCourseInfo courseInfo = new LessonSignReportDto.OrgCourseInfo();
            courseInfo.setCourseName(orgCourse.getName());
            Integer lessonCount = (Integer)courseLessonCountMap.get(orgCourse.getId());
            courseInfo.setLessonCount(lessonCount == null ? 0 : lessonCount);
            ArrayList userIds = Lists.newArrayList((Object[])new Long[]{userId});
            courseInfo.setStudentCount(userIds.size());
            Map userIdsLessonMap = (Map)courseStudentLessonMap.get(orgCourse.getId());
            LessonSignReportDto.CourseStudentDto studentDto = new LessonSignReportDto.CourseStudentDto();
            studentDto.setStudentName(this.buildStudentName(orgStudent));
            List studentLessonList = null;
            if (userIdsLessonMap != null) {
                studentLessonList = (List)userIdsLessonMap.get(orgStudent.getUserId());
            }
            if (CollectionUtils.isNotEmpty(studentLessonList)) {
                for (OrgStudentLesson studentLesson : studentLessonList) {
                    LessonSignReportDto.StudentLessonSignInfoDto signDto = new LessonSignReportDto.StudentLessonSignInfoDto();
                    signDto.setLessonId(studentLesson.getLessonId());
                    String key = studentLesson.getUserId() + "|" + studentLesson.getLessonId();
                    SignStatusRemarkDto statusRemarkDto = (SignStatusRemarkDto)allSignMap.get(key);
                    signDto.setSignStatus(statusRemarkDto != null ? statusRemarkDto.getSignStatus().intValue() : SignStatus.UNSIGN.getCode());
                    signDto.setSignRemark(statusRemarkDto != null ? statusRemarkDto.getSignRemark() : "");
                    OrgClassLesson lesson = (OrgClassLesson)lessonMap.get(studentLesson.getLessonId());
                    if (lesson == null) {
                        log.error("lessonId = {} not exits!", (Object)studentLesson.getLessonId());
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "lessonId not found!");
                    }
                    signDto.setLessonNumber(lesson.getNumber());
                    studentDto.addLessonSignInfo(signDto);
                }
            }
            if (CollectionUtils.isNotEmpty(studentDto.getLessonList())) {
                log.info("no lesson in course studentDto = {}", (Object)studentDto);
                courseInfo.getStudentList().add(studentDto);
            }
            if (userId != null) {
                log.debug("{}{}", (Object)courseInfo.getLessonCount(), courseInfo.getStudentList());
                if (courseInfo.getStudentList().size() > 0 && courseInfo.getLessonCount().intValue() != courseInfo.getStudentList().get(0).getLessonList().size()) {
                    log.warn("should be equal.{} != {}", (Object)courseInfo.getLessonCount(), (Object)courseInfo.getStudentList().size());
                }
            }
            lessonSignReportDto.getCourseList().add(courseInfo);
        }
        return lessonSignReportDto;
    }

    private Map<Long, List<OrgLessonSign>> getUserIdLessonSignMap(List<OrgLessonSign> signList) {
        return CollectorUtil.group(signList, (Function)new Function<OrgLessonSign, Long>(){

            public Long apply(OrgLessonSign arg0) {
                return arg0.getUserId();
            }
        }, (Function)new Function<OrgLessonSign, OrgLessonSign>(){

            public OrgLessonSign apply(OrgLessonSign arg0) {
                return arg0;
            }
        });
    }

    private Map<Long, SignStatusRemarkDto> toLessonSignMap(List<OrgLessonSign> signList) {
        HashMap lessonSignMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(signList)) {
            return Collections.emptyMap();
        }
        for (OrgLessonSign sign : signList) {
            lessonSignMap.put(sign.getLessonId(), new SignStatusRemarkDto(sign.getStatus(), sign.getSignRemark()));
        }
        return lessonSignMap;
    }

    private String buildStudentName(OrgStudent stu) {
        if (StringUtils.isNotBlank((String)stu.getName())) {
            return stu.getName();
        }
        if (StringUtils.isNotBlank((String)stu.getNickName())) {
            return stu.getNickName();
        }
        return MaskUtil.maskMobile((String)stu.getMobile());
    }

    @Override
    public Map<Long, Double> getAttendanceRateOfCourses(Long orgId, Collection<Long> courseIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMap();
        Map shouldSignCntMap = this.orgClassLessonDao.getCourseAttendCountMap(orgId, courseIds);
        Map actualSignCntMap = this.orgLessonSignDao.getCourseSignCountMap(orgId, courseIds);
        log.debug("shouldSignCntMap={},actualSignCntMap={}", (Object)shouldSignCntMap, (Object)actualSignCntMap);
        for (Long courseId : courseIds) {
            Integer shouldSignCnt = (Integer)shouldSignCntMap.get(courseId);
            Integer actualSignCnt = (Integer)actualSignCntMap.get(courseId);
            if (actualSignCnt != null && shouldSignCnt != null && shouldSignCnt > 0) {
                Double attendanceRate = (double)actualSignCnt.intValue() / (double)shouldSignCnt.intValue();
                resultMap.put(courseId, attendanceRate);
                continue;
            }
            resultMap.put(courseId, 0.0);
        }
        log.debug("resultMap={}", (Object)resultMap);
        return resultMap;
    }

    @Override
    public Map<Long, Double> getAttendanceRateOfStudents(Long orgId, Collection<Long> studentds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(studentds)) {
            return Collections.emptyMap();
        }
        Map stuUserMap = this.orgStudentDao.getStudentIdUserIdMap(studentds);
        Collection userIds = stuUserMap.values();
        log.debug("stuUserMap={}", (Object)stuUserMap);
        log.debug("userIds={}", userIds);
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMap();
        Map shouldSignCntMap = this.orgClassLessonDao.getStudentAttendCountMap(orgId, userIds);
        Map actualSignCntMap = this.orgLessonSignDao.getStudentSignCountMap(orgId, userIds);
        log.debug("shouldSignCntMap={},actualSignCntMap={}", (Object)shouldSignCntMap, (Object)actualSignCntMap);
        for (Long studentId : studentds) {
            Long userId = (Long)stuUserMap.get(studentId);
            if (userId == null || userId <= 0L) continue;
            Integer shouldSignCnt = (Integer)shouldSignCntMap.get(userId);
            Integer actualSignCnt = (Integer)actualSignCntMap.get(userId);
            if (actualSignCnt != null && shouldSignCnt != null && shouldSignCnt > 0) {
                Double attendanceRate = (double)actualSignCnt.intValue() / (double)shouldSignCnt.intValue();
                resultMap.put(studentId, attendanceRate);
                continue;
            }
            resultMap.put(studentId, 0.0);
        }
        log.debug("resultMap={}", (Object)resultMap);
        return resultMap;
    }

    @Override
    public List<Long> getStudentBySignStatus(Long orgId, Long lessonId) {
        List dtos = this.orgLessonSignDao.getStudentLessonByStatus(orgId, lessonId, SignStatus.UNSIGN.getCode(), new String[0]);
        Collection studentIds = CollectorUtil.collect((Collection)dtos, (Function)new Function<OrgLessonSign, Long>(){

            public Long apply(OrgLessonSign input) {
                return input.getUserId();
            }
        });
        return new ArrayList<Long>(studentIds);
    }

    private boolean checkOrgPermissionSignMsg(Integer orgId) {
        TXSaleClueRule tXSaleClueRule = this.tXSaleClueRuleService.getByOrgId(orgId);
        log.info("checkOrgPermissionSignMsg orgId={orgId},txsaleClueRule={}", (Object)orgId, (Object)tXSaleClueRule);
        return tXSaleClueRule != null && tXSaleClueRule.getSigninMsg() == 0;
    }

    @Override
    public void signSendMsg(OrgInfo orgInfo, OrgStudent student, Teacher teacher, OrgClassLesson lesson, OrgCourse course, OrgLessonSign orgLessonSign) {
        try {
            SendMsgRequest sendMsgRequest = this.getSendMsgRequest(orgInfo, student, teacher == null ? null : teacher.getRealName(), lesson, course, orgLessonSign);
            log.info("sendMsgRequest is:{}", (Object)sendMsgRequest);
            sendMsgRequest.setSmsCodeType(TxSmsCodeType.SIGN_NOTIFY_PRESENT);
            this.commonMsgService.sendMsg(sendMsgRequest);
        }
        catch (Exception e) {
            log.error("error : {} ", (Throwable)e);
            log.warn(e.getMessage());
        }
    }

    private Map<String, OrgLessonSign> conver2Map(List<OrgLessonSign> lessonSignIn) {
        return CollectorUtil.collectMap(lessonSignIn, (Function)new Function<OrgLessonSign, String>(){

            public String apply(OrgLessonSign arg0) {
                String key = arg0.getUserId() + "|" + arg0.getLessonId();
                return key;
            }
        });
    }

    private void addToSigninMsgAsynModel(List<OrgLessonSign> lessonSignIn) {
        Map<String, OrgLessonSign> newSignin = this.conver2Map(lessonSignIn);
        for (Map.Entry<String, OrgLessonSign> entry : newSignin.entrySet()) {
            final String cacheKey = RedisKeyEnums.ERP.SIGINMSG_PREFIX.getRedisKey() + entry.getKey();
            final String value = UUID.randomUUID().toString();
            entry.getValue().setRandomUUID(value);
            this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.setEx(cacheKey.getBytes(), 120L, value.getBytes());
                    return null;
                }
            });
        }
        SigninMsgAsynModel.addNewLessonSignIn(newSignin);
    }

    @Override
    public SigninFailedDto signWithRemark(@NonNull Long orgId, SignWithRemarkRequest request, @NonNull Integer source, @NonNull Boolean sendSms) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (sendSms == null) {
            throw new NullPointerException("sendSms");
        }
        Preconditions.checkArgument((null != request.getSignRemark() && request.getSignRemark().length() < 101 ? 1 : 0) != 0, (Object)"\u7b7e\u5230\u5907\u6ce8\u4e3a\u7a7a\u6216\u957f\u5ea6\u8d85\u8fc7100!");
        SigninFailedDto result = new SigninFailedDto();
        List<OrgLessonSign> updateSigns = this.updateAndSave(orgId, request, source, result);
        List lessonIds = Lists.transform(updateSigns, (Function)new Function<OrgLessonSign, Long>(){

            public Long apply(OrgLessonSign input) {
                return input.getLessonId();
            }
        });
        this.fillStudentInfo(orgId, result);
        if (sendSms.booleanValue() && this.checkOrgPermissionSignMsg(orgId.intValue())) {
            Map lessonMap = this.orgClassLessonDao.getClassLessonMap(orgId, (Collection)lessonIds, Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[0]);
            Iterator<OrgLessonSign> iter = updateSigns.iterator();
            while (iter.hasNext()) {
                OrgLessonSign sign = iter.next();
                OrgClassLesson lesson = (OrgClassLesson)lessonMap.get(sign.getLessonId());
                if (lesson.getStartTime().after(DateUtil.getCurrentDate()) && lesson.getStartTime().before(DateUtil.getDiffDateTime((Date)DateUtil.getCurrentDate(), (int)1))) continue;
                iter.remove();
            }
            this.addToSigninMsgAsynModel(updateSigns);
        }
        long realCourseId = request.getCourseId();
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)request.getCourseId(), new String[0]);
        if (CourseTypeEnum.isOneToOne((Integer)course.getCourseType())) {
            realCourseId = course.getParentId();
        }
        OrgCourseConsumeRule rule = this.courseConsumeRuleDao.getRuleByCourseId(orgId, Long.valueOf(realCourseId));
        LessonStatus lessonStatus = null;
        if (rule != null && (lessonStatus = KexiaoUtil.getKexiaoStatus((int)request.getStatus(), (int)rule.getRuleValue())) == LessonStatus.FINISHED) {
            this.resetLesson(orgId, request.getCourseId(), lessonIds, Arrays.asList(request.getUserId()), course.getChargeUnit(), request.getConfirm());
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    private List<OrgLessonSign> updateAndSave(Long orgId, SignWithRemarkRequest request, Integer source, SigninFailedDto result) {
        Integer status = request.getStatus();
        Long userId = ((OrgStudent)this.orgStudentDao.getById((Serializable)request.getStudentId(), new String[]{"userId"})).getUserId();
        request.setUserId(userId);
        Map uIdStatusWithdrawMap = this.orgStudentCourseDao.userMapByStatus(orgId, request.getCourseId(), Arrays.asList(userId), Arrays.asList(StudentCourseStatus.WITHDRAW.getCode(), StudentCourseStatus.TRANSFER.getCode()));
        Collection inValidUserIds = CollectionUtils.intersection(Arrays.asList(userId), uIdStatusWithdrawMap.keySet());
        for (Long temp : inValidUserIds) {
            result.addFailedStudent(new SigninFailedDto.FailedStudent(temp, (Integer)uIdStatusWithdrawMap.get(temp)));
        }
        log.info("Quit class can not modify allInvalidUserIds={}", (Object)uIdStatusWithdrawMap);
        List<Long> lessonIds = this.getLessonIds(request.getLessonIds());
        Long cascadeId = TianxiaoMContext.getTXCascadeIdLongZeroFill();
        this.checkArguments(orgId, request, userId);
        List inDBSigns = this.orgLessonSignDao.getStudentSign(orgId, userId, Integer.valueOf(UserRole.STUDENT.getRole()), lessonIds, new String[0]);
        List<Long> notInDBSignIds = this.getSaveLessons(lessonIds, inDBSigns);
        this.updateSign(inDBSigns, request, cascadeId, source, result);
        List<OrgLessonSign> saveSigns = this.saveSign(orgId, notInDBSignIds, status, userId, request.getSignRemark(), request.getSendToStu(), cascadeId, source, result);
        this.changeLogService.addBatchSignLog(orgId, lessonIds, Arrays.asList(userId), status.intValue());
        log.debug("updateSigns:{}, saveSigns:{}", (Object)inDBSigns, saveSigns);
        inDBSigns.addAll(saveSigns);
        inDBSigns = Lists.newLinkedList((Iterable)inDBSigns);
        return inDBSigns;
    }

    private List<Long> getLessonIds(String lessonIds) {
        String[] s;
        ArrayList result = Lists.newArrayList();
        for (String l : s = lessonIds.split(",")) {
            result.add(Long.parseLong(l));
        }
        return result;
    }

    private void checkArguments(Long orgId, SignWithRemarkRequest request, Long userId) {
        Integer status = request.getStatus();
        Long studentId = request.getStudentId();
        List<Long> lessonIds = this.getLessonIds(request.getLessonIds());
        Preconditions.checkArgument((status != null && status >= 0 ? 1 : 0) != 0, (Object)"\u7b7e\u5230\u72b6\u6001\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((lessonIds != null && lessonIds.size() >= 0 ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((orgId != null && orgId >= 0L ? 1 : 0) != 0, (Object)"\u673a\u6784ID\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((studentId != null && studentId >= 0L ? 1 : 0) != 0, (Object)"\u5b66\u751fID\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((userId != null && userId >= 0L ? 1 : 0) != 0, (Object)("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5b66\u751fID:" + studentId));
    }

    private List<Long> getSaveLessons(List<Long> lessonIds, List<OrgLessonSign> lessonSigns) {
        ArrayList saveList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(lessonIds)) {
            return saveList;
        }
        if (CollectionUtils.isEmpty(lessonSigns)) {
            return lessonIds;
        }
        HashMap map = Maps.newHashMap();
        for (OrgLessonSign o : lessonSigns) {
            map.put(o.getLessonId(), o);
        }
        for (Long l : lessonIds) {
            if (map.containsKey(l)) continue;
            saveList.add(l);
        }
        return saveList;
    }

    private void updateSign(List<OrgLessonSign> lessonSigns, SignWithRemarkRequest request, Long cascadeId, Integer source, SigninFailedDto result) {
        log.debug("failedStudents:{}, request:{}", result.getFailedStudentList(), (Object)request);
        if (CollectionUtils.isEmpty(lessonSigns)) {
            return;
        }
        Integer status = request.getStatus();
        if (request.getSource().intValue() == OrgLessonSignSourceEnum.NORMAL.getValue() && !result.getFailedStudentMap().containsKey(request.getUserId())) {
            for (OrgLessonSign o : lessonSigns) {
                if ((status == null || status.equals(o.getStatus())) && o.getSendToStu().intValue() == request.getSendToStu().intValue() && o.getSignRemark().equals(request.getSignRemark())) continue;
                o.setStatus(status);
                o.setSignRemark(request.getSignRemark());
                o.setSendToStu(request.getSendToStu());
                o.setCascadeId(cascadeId);
                o.setTeacherId(Integer.valueOf(0));
                o.setSource(source);
                this.orgLessonSignDao.update((Object)o, new String[]{"status", "signRemark", "sendToStu", "cascadeId", "source", "teacherId"});
            }
        } else {
            for (OrgLessonSign o : lessonSigns) {
                SigninFailedDto.FailedStudent failedStudent = result.getFailedStudentMap().get(o.getUserId());
                if (null != failedStudent && o.getStatus() != status) {
                    failedStudent.setSignStatus(o.getStatus());
                    failedStudent.setSignRemark(request.getSignRemark());
                    failedStudent.setSendToStu(request.getSendToStu());
                } else {
                    log.debug("failedList clear!");
                    result.getFailedStudentList().clear();
                    result.getFailedStudentMap().clear();
                }
                if (o.getSignRemark().equals(request.getSignRemark()) && o.getSendToStu().intValue() == request.getSendToStu().intValue()) continue;
                o.setSignRemark(request.getSignRemark());
                o.setSendToStu(request.getSendToStu());
                o.setCascadeId(cascadeId);
                o.setTeacherId(Integer.valueOf(0));
                o.setSource(source);
                this.orgLessonSignDao.update((Object)o, new String[]{"signRemark", "sendToStu", "cascadeId", "source", "teacherId"});
            }
        }
    }

    private List<OrgLessonSign> saveSign(Long orgId, List<Long> saveLessons, Integer status, Long userId, String signRemark, Integer sendToStu, Long cascadeId, Integer source, SigninFailedDto result) {
        log.debug("failedStudents:{}, userId:{}, status:{}", new Object[]{result.getFailedStudentList(), userId, status});
        if (CollectionUtils.isEmpty(saveLessons)) {
            return Collections.emptyList();
        }
        if (!result.getFailedStudentMap().containsKey(userId) || status.intValue() == SignStatus.UNSIGN.getCode()) {
            List classLessons = this.orgClassLessonDao.getByIds(saveLessons, new String[0]);
            ArrayList saveList = Lists.newArrayList();
            for (OrgClassLesson lesson : classLessons) {
                OrgLessonSign obj = new OrgLessonSign();
                obj.setCourseId(lesson.getCourseId());
                obj.setCreateTime(new Date());
                obj.setLessonId(lesson.getId());
                obj.setOrgId(orgId);
                obj.setStatus(status);
                obj.setUpdateTime(new Date());
                obj.setUserId(userId);
                obj.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
                obj.setSignRemark(signRemark != null ? signRemark : "");
                obj.setSendToStu(sendToStu);
                obj.setCascadeId(cascadeId);
                obj.setTeacherId(Integer.valueOf(0));
                obj.setSource(source);
                saveList.add(obj);
            }
            this.orgLessonSignDao.saveAll((List)saveList, false, new String[]{"courseId", "createTime", "lessonId", "orgId", "status", "userId", "updateTime", "userRole", "signRemark", "sendToStu", "cascadeId", "source", "teacherId"});
            return saveList;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String, OrgLessonSign> getLessonSignStatus(Collection<Long> lesssonIds) {
        if (CollectionUtils.isEmpty(lesssonIds)) {
            return Maps.newHashMap();
        }
        List lessonSignList = this.orgLessonSignDao.getByStudentLessonIds(lesssonIds, new String[0]);
        Map userLessonSign = CollectorUtil.collectMap((Collection)lessonSignList, (Function)new Function<OrgLessonSign, String>(){

            public String apply(OrgLessonSign orgLessonSign) {
                return orgLessonSign.getLessonId() + "_" + orgLessonSign.getUserId();
            }
        });
        return userLessonSign;
    }
}

