/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.commons.lang.utils.BaseUtils;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.InClassStatus;
import com.baijia.tianxiao.constant.OrgTeacherStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonConflictDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherBranchDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.org.po.OrgTeacherBranch;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.FilterSoftDelTeacherService;
import com.baijia.tianxiao.sal.course.dto.response.AppTeacherResponseDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherRespDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.HtmlUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CourseTeacherServiceImpl
implements CourseTeacherService {
    private static final Logger log = LoggerFactory.getLogger(CourseTeacherServiceImpl.class);
    public static final String ANONYMOUS_TEACHER_NAME = "\u533f\u540d\u8001\u5e08";
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgTeacherBranchDao orgTeacherBranchDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgTeacherDao orgTeacherDao;
    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;
    @Resource
    private UserDao userDao;
    @Resource
    private OrgLessonConflictDao orgLessonConflictDao;
    @Autowired
    private FilterSoftDelTeacherService filterSoftDelTeacherService;

    @Override
    @Transactional(readOnly=true)
    public List<TeacherResponseDto> listOrgTeacher(String key, Long orgId, Long branchId, Long courseId, PageDto page) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet teacherIds = Sets.newHashSet((Iterable)this.orgTeacherDao.getTeacherIds(orgId, Integer.valueOf(OrgTeacherStatus.SIGNED.getCode())));
        List courseTeacherIds = null;
        if (branchId != null) {
            List branchTeachers = this.orgTeacherBranchDao.getBranchTeacher(orgId, branchId, null, (Collection)teacherIds, new String[]{"userId"});
            if (CollectionUtils.isEmpty((Collection)branchTeachers)) {
                return Collections.emptyList();
            }
            teacherIds.clear();
            for (OrgTeacherBranch teacherBranch : branchTeachers) {
                teacherIds.add(teacherBranch.getUserId());
            }
        }
        if (courseId != null && courseId > 0L) {
            courseTeacherIds = this.orgCourseTeacherDao.getTeacherIdsByCourseId(courseId);
            if (CollectionUtils.isNotEmpty((Collection)teacherIds) && CollectionUtils.isNotEmpty((Collection)courseTeacherIds)) {
                teacherIds.removeAll(courseTeacherIds);
            }
        }
        if (CollectionUtils.isEmpty((Collection)teacherIds)) {
            return Lists.newArrayList();
        }
        List teacherList = this.teacherDao.getTeachers(orgId, (Collection)teacherIds, key, null, null, Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()), page);
        if (CollectionUtils.isNotEmpty((Collection)courseTeacherIds)) {
            Iterator iterator = teacherList.iterator();
            while (iterator.hasNext()) {
                Teacher teacher = (Teacher)iterator.next();
                if (!courseTeacherIds.contains(teacher.getUserId())) continue;
                iterator.remove();
            }
        }
        return this.buildDtoList(teacherList);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TeacherResponseDto> listCourseTeacher(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        List courseTeachers = this.orgCourseTeacherDao.getTeacher(orgId, courseId);
        HashSet userIds = Sets.newHashSet();
        for (OrgCourseTeacher courseTeacher : courseTeachers) {
            userIds.add(courseTeacher.getUserId());
        }
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            List teacherList = this.teacherDao.getTeachers(orgId, (Collection)userIds, null, null, null, Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()), null);
            this.filterSoftDelTeacherService.filterTeachers(orgId, teacherList);
            return this.buildDtoList(teacherList);
        }
        return Collections.emptyList();
    }

    @Override
    @Transactional(readOnly=true)
    public List<TeacherResponseDto> listCourseTeacher(Long orgId, Collection<Long> courseIds, String key, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(courseIds), (Object)"courseIds is empty");
        List courseTeachers = this.orgCourseTeacherDao.getOrgCourseTeacher(courseIds, pageDto);
        HashSet userIds = Sets.newHashSet();
        for (OrgCourseTeacher courseTeacher : courseTeachers) {
            userIds.add(courseTeacher.getUserId());
        }
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            List teacherList = this.teacherDao.getTeachers(orgId, (Collection)userIds, key, null, null, null);
            this.filterSoftDelTeacherService.filterTeachers(orgId, teacherList);
            return this.buildDtoList(teacherList);
        }
        return Collections.emptyList();
    }

    @Override
    public List<AppTeacherResponseDto> listOrgTeacherWithCourse(String key, Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet teacherIds = Sets.newHashSet((Iterable)this.orgTeacherDao.getTeacherIds(orgId, Integer.valueOf(OrgTeacherStatus.SIGNED.getCode())));
        if (CollectionUtils.isEmpty((Collection)teacherIds)) {
            return Lists.newArrayList();
        }
        List teacherList = this.teacherDao.getTeachers(orgId, (Collection)teacherIds, key, null, null, Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()), null);
        if (CollectionUtils.isEmpty((Collection)teacherList)) {
            return Lists.newArrayList();
        }
        List courseTeacherIds = null;
        if (courseId != null && courseId > 0L) {
            courseTeacherIds = this.orgCourseTeacherDao.getTeacherIdsByCourseId(courseId);
        }
        if (CollectionUtils.isNotEmpty((Collection)teacherList)) {
            ArrayList result = Lists.newArrayList();
            HashSet avatarIds = Sets.newHashSet();
            for (Teacher teacher : teacherList) {
                if (teacher.getAvatar() == null || teacher.getAvatar() <= 0L) continue;
                avatarIds.add(teacher.getAvatar());
            }
            List storageList = this.storageDao.getByIds((Collection)avatarIds, new String[0]);
            Map<Long, String> avatarMap = this.getAvatarMap(storageList);
            for (Teacher teacher : teacherList) {
                AppTeacherResponseDto dto = new AppTeacherResponseDto();
                if (teacher.getAvatar() != null) {
                    dto.setAvatar(avatarMap.get(teacher.getAvatar()));
                }
                dto.setTeacherId(teacher.getUserId());
                dto.setTeacherName(this.getTeacherName(teacher));
                dto.setInitial(HanZiPinYinUtils.getInitialStr((String)dto.getTeacherName()));
                if (CollectionUtils.isNotEmpty((Collection)courseTeacherIds) && courseTeacherIds.contains(teacher.getUserId())) {
                    dto.setChosen(InClassStatus.YES.isCode());
                }
                result.add(dto);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTeacherToCourse(Long orgId, Long courseId, Collection<Long> teacherIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        if (CollectionUtils.isEmpty(teacherIds)) {
            log.warn("add teacher ids is empty");
            return;
        }
        List courseTeachers = this.orgCourseTeacherDao.getTeacher(orgId, courseId);
        for (OrgCourseTeacher t : courseTeachers) {
            teacherIds.remove(t.getUserId());
        }
        List teacherList = this.teacherDao.getByTeacherIds(teacherIds, new String[]{"userId", "orgId"});
        this.filterSoftDelTeacherService.filterTeachers(orgId, teacherList);
        ArrayList saveCourseTeacher = Lists.newArrayList();
        OrgCourseTeacher po = null;
        for (Teacher teacher : teacherList) {
            if (!orgId.equals(teacher.getOrgId())) {
                log.warn("teacher id:{} is not current org teacher", (Object)teacher.getUserId());
                continue;
            }
            po = new OrgCourseTeacher();
            po.setOrgCourseId(courseId);
            po.setUserId(teacher.getUserId());
            po.setCreateTime(new Date());
            po.setUpdateTime(new Date());
            saveCourseTeacher.add(po);
        }
        log.info("save teachers :{} to courseId:{}", (Object)saveCourseTeacher, (Object)courseId);
        this.orgCourseTeacherDao.saveAll((List)saveCourseTeacher, new String[]{"orgCourseId", "userId", "createTime", "updateTime"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delTeacherFromCourse(Long orgId, Long courseId, Collection<Long> teacherIds) {
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        if (CollectionUtils.isEmpty(teacherIds)) {
            log.warn("clear all teacher from courseId:{}", (Object)courseId);
            return 0;
        }
        this.orgCourseTeacherDao.delTeachersFromCourse(courseId, teacherIds);
        this.orgCourseSmsDao.delCourseSmsRecord(orgId, courseId, Integer.valueOf(UserRole.TEACHER.getRole()), teacherIds);
        List lessonIds = this.orgClassLessonDao.getLeftLessonIds(orgId, courseId);
        if (CollectionUtils.isNotEmpty((Collection)lessonIds)) {
            HashMap<String, List> delCondition = new HashMap<String, List>();
            delCondition.put("lessonId", lessonIds);
            int result = this.orgTeacherLessonDao.delByCondition(delCondition);
            log.info("del from org teacher lesson by lessonId:{},result:{}", (Object)lessonIds, (Object)result);
            return result;
        }
        return 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delTeacherFromCourseForLessonCheck(Long orgId, Long courseId, Collection<Long> teacherIds) {
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        if (CollectionUtils.isEmpty(teacherIds)) {
            log.warn("clear all teacher from courseId:{}", (Object)courseId);
            return 0;
        }
        Map mapClassLesson = this.orgClassLessonDao.getClassLessonMap(orgId, courseId, Integer.valueOf(0), null);
        HashSet allLessonTeacherId = new HashSet();
        if (mapClassLesson.size() > 0) {
            Map mapTeacherLesson = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, mapClassLesson.keySet());
            allLessonTeacherId.addAll(mapTeacherLesson.values());
        }
        if (allLessonTeacherId.size() > 0) {
            Map orgTeacherMap = this.orgTeacherDao.getMapByIds(orgId, teacherIds, new String[0]);
            for (Long deleteTeacherId : teacherIds) {
                OrgTeacher orgTeacher = (OrgTeacher)orgTeacherMap.get(deleteTeacherId);
                if (orgTeacher == null || orgTeacher.getStatus() != 1 || !allLessonTeacherId.contains(deleteTeacherId)) continue;
                return 0;
            }
        }
        int result = this.orgCourseTeacherDao.delTeachersFromCourse(courseId, teacherIds);
        this.orgCourseSmsDao.delCourseSmsRecord(orgId, courseId, Integer.valueOf(UserRole.TEACHER.getRole()), teacherIds);
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<TeacherResponseDto> getLessonTeacher(@NonNull Long orgId, @NonNull Long lessonId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        List userIdList = this.orgTeacherLessonDao.getUserIds(lessonId, orgId);
        if (CollectionUtils.isEmpty((Collection)userIdList)) {
            return Collections.emptyList();
        }
        List teachers = this.teacherDao.getTeachers(orgId, (Collection)userIdList, null, null, null, null);
        OrgClassLesson byId = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (byId != null && byId.getEndTime().compareTo(new Date()) > 0) {
            this.filterSoftDelTeacherService.filterTeachers(orgId, teachers);
        }
        return this.buildDtoList(teachers);
    }

    private List<TeacherResponseDto> buildDtoList(List<Teacher> teacherList) {
        if (CollectionUtils.isNotEmpty(teacherList)) {
            ArrayList result = Lists.newArrayList();
            HashSet avatarIds = Sets.newHashSet();
            for (Teacher teacher : teacherList) {
                if (teacher.getAvatar() == null || teacher.getAvatar() <= 0L) continue;
                avatarIds.add(teacher.getAvatar());
            }
            List storageList = this.storageDao.getByIds((Collection)avatarIds, new String[0]);
            Map<Long, String> avatarMap = this.getAvatarMap(storageList);
            for (Teacher teacher : teacherList) {
                TeacherResponseDto dto = this.buildDto(teacher, false);
                dto.setAvatar(avatarMap.get(teacher.getAvatar()));
                dto.setSchoolAge(teacher.getSchoolAge());
                dto.setInitial(HanZiPinYinUtils.getInitialStr((String)dto.getTeacherName()));
                dto.setIntroduce(teacher.getOtherInfo() == null || teacher.getOtherInfo().equals("\u65e0") ? "" : HtmlUtils.delHTMLTag((String)teacher.getOtherInfo()));
                result.add(dto);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private TeacherResponseDto buildDto(Teacher teacher, boolean needAvatar) {
        TeacherResponseDto dto = new TeacherResponseDto();
        if (needAvatar && teacher.getAvatar() != null) {
            Storage storage = (Storage)this.storageDao.getById((Serializable)teacher.getAvatar(), new String[0]);
            dto.setAvatar(StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
        }
        dto.setTeacherId(teacher.getUserId());
        User user = (User)this.userDao.getById((Serializable)teacher.getUserId(), new String[0]);
        dto.setTeacherNumber(user.getNumber());
        dto.setTeacherName(this.getTeacherName(teacher));
        dto.setMobile(teacher.getMobile());
        dto.setIntroduce(teacher.getIntroduce());
        return dto;
    }

    private String getTeacherName(Teacher teacher) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{teacher.getRealName()})) {
            return teacher.getRealName();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{teacher.getNickName()})) {
            return teacher.getNickName();
        }
        return ANONYMOUS_TEACHER_NAME;
    }

    private Map<Long, String> getAvatarMap(List<Storage> storageList) {
        if (CollectionUtils.isNotEmpty(storageList)) {
            HashMap result = Maps.newHashMap();
            for (Storage storage : storageList) {
                result.put(storage.getId(), StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    @Transactional(readOnly=true)
    public List<TeacherResponseDto> getTeachers(Collection<Long> teacherIds, Long orgId) {
        List teacherList = this.teacherDao.getTeachers(orgId, teacherIds, null, null, null, null);
        this.filterSoftDelTeacherService.filterTeachers(orgId, teacherList);
        return this.buildDtoList(teacherList);
    }

    @Override
    @Transactional(readOnly=true)
    public TeacherResponseDto getTeacher(Long teacherId, Long orgId) {
        Teacher teacher = this.teacherDao.getByUserId(teacherId, new String[0]);
        this.filterSoftDelTeacherService.filterTeachers(orgId, Arrays.asList(teacher));
        return this.buildDto(teacher, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTeacherToLesson(Long orgId, Long courseId, Long lessonId, Collection<Long> teacherIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        if (CollectionUtils.isEmpty(teacherIds)) {
            log.warn("add teacher ids is empty");
            return;
        }
        if (CollectionUtils.isEmpty(teacherIds)) {
            log.warn("lesson teacher:{} is not all course teacher ids:{}", teacherIds);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6dfb\u52a0\u8001\u5e08\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList saveLessonTeachers = Lists.newArrayList();
        OrgTeacherLesson po = null;
        for (Long teacherId : teacherIds) {
            po = new OrgTeacherLesson();
            po.setCreateTime(new Date());
            po.setLessonId(lessonId);
            po.setOrgId(orgId);
            po.setTeacherId(teacherId);
            saveLessonTeachers.add(po);
        }
        log.info("save teachers :{} to lessonId:{}", (Object)saveLessonTeachers, (Object)lessonId);
        this.orgTeacherLessonDao.saveAll((List)saveLessonTeachers, false, new String[]{"createTime", "lessonId", "orgId", "teacherId"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delTeacherFromLesson(Long orgId, Long lessonId, Collection<Long> teacherIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[]{"startTime", "endTime"});
        if (lesson == null) {
            log.warn("can not found lesson by lessonId:{}", (Object)lessonId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonId);
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            condition.put("teacherId", teacherIds);
        }
        return this.orgTeacherLessonDao.delByCondition((Map)condition);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resetLessonTeacher(Long orgId, Long courseId, Long lessonId, Collection<Long> teacherIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        this.delTeacherFromLesson(orgId, lessonId, null);
        HashSet tempTeacherIds = Sets.newHashSet();
        tempTeacherIds.addAll(teacherIds);
        this.addTeacherToCourse(orgId, courseId, teacherIds);
        this.addTeacherToLesson(orgId, courseId, lessonId, tempTeacherIds);
    }

    @Override
    public List<TeacherRespDto> listPcOrgTeacher(Long orgId, String key, Long courseId, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u975e\u6cd5");
        List orgTeacherIds = this.orgTeacherDao.getTeacherIds(orgId, Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        HashSet teacherIds = Sets.newHashSet((Iterable)orgTeacherIds);
        List courseTeacherIds = Lists.newArrayList();
        if (courseId != null && courseId > 0L) {
            courseTeacherIds = this.orgCourseTeacherDao.getTeacherIdsByCourseId(courseId);
            if (CollectionUtils.isNotEmpty((Collection)teacherIds) && CollectionUtils.isNotEmpty((Collection)courseTeacherIds)) {
                teacherIds.removeAll(courseTeacherIds);
            }
        }
        if (CollectionUtils.isEmpty((Collection)teacherIds)) {
            return Lists.newArrayList();
        }
        List teacherList = this.teacherDao.getTeachers(orgId, (Collection)teacherIds, key, null, null, Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()), pageDto);
        if (CollectionUtils.isNotEmpty((Collection)courseTeacherIds)) {
            Iterator iterator = teacherList.iterator();
            while (iterator.hasNext()) {
                Teacher teacher = (Teacher)iterator.next();
                if (!courseTeacherIds.contains(teacher.getUserId())) continue;
                iterator.remove();
            }
        }
        List<TeacherRespDto> dtos = this.buildList(teacherList);
        Collections.sort(dtos, new Comparator(){

            public int compare(Object object1, Object object2) {
                String name2;
                TeacherRespDto info1 = (TeacherRespDto)object1;
                TeacherRespDto info2 = (TeacherRespDto)object2;
                String name1 = info1.getName();
                if (name1 == null) {
                    name1 = "";
                }
                if ((name2 = info2.getName()) == null) {
                    name2 = "";
                }
                return Collator.getInstance(Locale.CHINESE).compare(name1, name2);
            }
        });
        return dtos;
    }

    private List<TeacherRespDto> buildList(List<Teacher> teacherList) {
        if (CollectionUtils.isNotEmpty(teacherList)) {
            ArrayList result = Lists.newArrayList();
            HashSet avatarIds = Sets.newHashSet();
            for (Teacher teacher : teacherList) {
                if (teacher.getAvatar() == null || teacher.getAvatar() <= 0L) continue;
                avatarIds.add(teacher.getAvatar());
            }
            List storageList = this.storageDao.getByIds((Collection)avatarIds, new String[0]);
            Map<Long, String> avatarMap = this.getAvatarMap(storageList);
            for (Teacher teacher : teacherList) {
                TeacherRespDto dto = new TeacherRespDto();
                dto.setId(teacher.getUserId());
                dto.setName(teacher.getRealName() == null ? "" : teacher.getRealName());
                if (teacher.getAvatar() == null || teacher.getAvatar() == 0L || StringUtils.isEmpty((CharSequence)avatarMap.get(teacher.getAvatar()))) {
                    dto.setAvatarUrl("https://imgs.genshuixue.com/21644918_xqjeiipb.png");
                } else {
                    dto.setAvatarUrl(avatarMap.get(teacher.getAvatar()));
                }
                dto.setMobile(teacher.getMobile());
                result.add(dto);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public List<TeacherDto> selectTeacher(Long orgId, List<Long> classRoomIds, List<Long> courseIds, Integer type) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u975e\u6cd5");
        List confictLessonIds = Lists.newArrayList();
        if (type == 1) {
            List confictLessons = this.orgLessonConflictDao.queryConfilctByClassRoomIds(orgId, classRoomIds);
            confictLessonIds = BaseUtils.getPropertyCollections((List)confictLessons, (String)"lessonId");
        }
        List classLessonIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(classRoomIds)) {
            List classLessons = this.orgClassLessonDao.queryByClassRooms(orgId, classRoomIds, courseIds, confictLessonIds);
            classLessonIds = BaseUtils.getPropertyCollections((List)classLessons, (String)"id");
        }
        List teacherLessons = this.orgTeacherLessonDao.queryByLessonIds(orgId, (Collection)classLessonIds);
        List teacherIds = BaseUtils.getPropertyCollections((List)teacherLessons, (String)"teacherId");
        List teachers = this.teacherDao.getByIds((Collection)teacherIds, new String[0]);
        this.filterSoftDelTeacherService.filterTeachers(orgId, teachers);
        return TeacherDto.converToDto(teachers);
    }
}

