/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgSignupCourseServiceImpl
implements OrgSignupCourseService {
    private static final Logger log = LoggerFactory.getLogger(OrgSignupCourseServiceImpl.class);
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;

    @Override
    public Long randomSignupPurchaseId4Excel(Date date) {
        String fixLenthString = String.valueOf((1.0 + new Random().nextDouble()) * Math.pow(10.0, 9.0));
        fixLenthString = fixLenthString.substring(2, 10);
        String str = String.format("%s%s", new SimpleDateFormat("yyMMdd").format(date), fixLenthString);
        return Long.parseLong(str);
    }

    @Override
    public OrgSignupCourse saveOrgSignupCourseByExcel(Long orgId, Long signupPurchaseId, OrgCourse orgCourse, Long studentUserId, Integer lessonCount, Double payPrice, Integer chargeUnit) {
        Date now = new Date();
        if (signupPurchaseId == null) {
            signupPurchaseId = this.randomSignupPurchaseId4Excel(now);
        }
        OrgSignupCourse orgSignupCourse = new OrgSignupCourse();
        orgSignupCourse.setOrgId(orgId);
        orgSignupCourse.setOrgCourseId(orgCourse.getId());
        orgSignupCourse.setOrgCourseNumber(orgCourse.getNumber());
        orgSignupCourse.setOriginPrice(Integer.valueOf((int)Math.round(orgCourse.getPrice() * 100.0)));
        orgSignupCourse.setUserId(studentUserId);
        orgSignupCourse.setLessonCount(lessonCount);
        orgSignupCourse.setCourseDiscount(Integer.valueOf(100));
        orgSignupCourse.setPreferential(Integer.valueOf(0));
        orgSignupCourse.setCount(Integer.valueOf(1));
        orgSignupCourse.setPayPrice(Long.valueOf(Math.round(payPrice * 100.0)));
        orgSignupCourse.setStudentPayPrice(Long.valueOf(0L));
        orgSignupCourse.setCreateTime(now);
        orgSignupCourse.setUpdateTime(now);
        orgSignupCourse.setStatus(Integer.valueOf(SignupCourseStatus.IMPORT.getCode()));
        orgSignupCourse.setChargeUnit(chargeUnit);
        orgSignupCourse.setSyncLessonCount(Integer.valueOf(1));
        orgSignupCourse.setSignupPurchaseId(signupPurchaseId);
        log.debug("save orgSignupCourse info =={}", (Object)orgSignupCourse);
        this.orgSignupCourseDao.save((Object)orgSignupCourse, new String[0]);
        return orgSignupCourse;
    }

    @Override
    public OrgSignupCourse saveOrgSignupCourseByExcel(Long orgId, Long signupPurchaseId, OrgCourse orgCourse, Long studentUserId, Integer lessonCount, Double payPrice) {
        return this.saveOrgSignupCourseByExcel(orgId, signupPurchaseId, orgCourse, studentUserId, lessonCount, payPrice, orgCourse.getChargeUnit());
    }

    @Override
    public String getSignupCourseName(Long orgId, Long signupPurchaseId) {
        StringBuilder opInfo = new StringBuilder();
        List signupCourseList = this.orgSignupCourseDao.loadByPurchaseId(signupPurchaseId, new String[0]);
        Map signupCourseMap = CollectorUtil.collectMap((Collection)signupCourseList, (Function)new Function<OrgSignupCourse, Long>(){

            public Long apply(OrgSignupCourse orgSignupCourse) {
                return orgSignupCourse.getOrgCourseId();
            }
        });
        List courseList = this.orgCourseDao.getByIds(signupCourseMap.keySet(), new String[0]);
        Map courseMap = CollectorUtil.collectMap((Collection)courseList, (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse orgCourse) {
                return orgCourse.getId();
            }
        });
        for (int i = 0; i < signupCourseList.size(); ++i) {
            opInfo.append(((OrgCourse)courseMap.get(((OrgSignupCourse)signupCourseList.get(i)).getOrgCourseId())).getName());
            if (i == signupCourseList.size() - 1) continue;
            opInfo.append(",");
        }
        return opInfo.toString();
    }

    @Override
    public void saveSignupCourse(OrgSignupCourse course) {
        this.orgSignupCourseDao.update((Object)course, new String[0]);
    }
}

