/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.course.dao.OrgRecommendCourseDao;
import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.po.OrgRecommendCourse;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.enums.ModifyStatus;
import com.baijia.tianxiao.sal.course.dto.request.OrgRecommendCourseRequestDto;
import com.baijia.tianxiao.sal.course.service.OrgRecommendCourseService;
import com.baijia.tianxiao.util.BaseUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orgRecommendCourseService")
public class OrgRecommendCourseServiceImpl
implements OrgRecommendCourseService {
    private static final Logger logger = LoggerFactory.getLogger(OrgRecommendCourseServiceImpl.class);
    @Autowired
    private OrgRecommendCourseDao orgRecommendCourseDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private TeacherClassCourseDao teacherClassCourseDao;

    @Override
    public List<OrgRecommendCourse> getOrgRecommentCourseList(Integer orgId) {
        return this.orgRecommendCourseDao.getRecommendCourseList(orgId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRecommendCourse(Integer orgId, Long courseId, Integer courseType) {
        OrgRecommendCourse recommendCourse = this.orgRecommendCourseDao.getOrgRecommendCourse(orgId, courseId, courseType);
        if (recommendCourse != null) {
            recommendCourse.setIsDeleted(Integer.valueOf(DeleteStatus.DELETED.getValue()));
            recommendCourse.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            logger.debug("removeRecommendCourse.orgId:{}, courseId:{}, courseType:{}, recommendCourse:{}", new Object[]{orgId, courseId, courseType, recommendCourse});
            this.orgRecommendCourseDao.removeRecommendCourse(recommendCourse);
        }
    }

    @Override
    public void batchEdit(List<OrgRecommendCourseRequestDto> recommendCourses, Integer orgId) {
        try {
            int minDisPlayOrder = this.getMaxDisplayOrder(recommendCourses, orgId.longValue());
            ArrayList cache = Lists.newArrayList();
            logger.info("batchEdit.recommendCourses:{}", recommendCourses);
            for (OrgRecommendCourseRequestDto dto : recommendCourses) {
                Integer modifyStatus = dto.getModifyStatus();
                logger.info("batchEdit.dto:{},modifyStatus:{}", (Object)dto, (Object)modifyStatus);
                OrgRecommendCourse sourceRecommendCourse = this.validateParams(orgId, dto.getCourseId(), dto.getCourseType());
                switch (ModifyStatus.values()[modifyStatus]) {
                    case NORMAL: {
                        if (sourceRecommendCourse == null || minDisPlayOrder == sourceRecommendCourse.getDisplayOrder()) break;
                        sourceRecommendCourse.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                        sourceRecommendCourse.setDisplayOrder(Integer.valueOf(minDisPlayOrder--));
                        this.orgRecommendCourseDao.update((Object)sourceRecommendCourse, new String[]{"updateTime", "displayOrder"});
                        logger.info("NORMAL.sourceRecommendCourse:{}", (Object)sourceRecommendCourse);
                        break;
                    }
                    case UPDATE: {
                        if (sourceRecommendCourse == null) break;
                        logger.info("UPDATE.sourceRecommendCourse:{}", (Object)sourceRecommendCourse);
                        cache.add(sourceRecommendCourse);
                        break;
                    }
                    case ADDED: {
                        if (sourceRecommendCourse != null) {
                            sourceRecommendCourse.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                            sourceRecommendCourse.setDisplayOrder(Integer.valueOf(minDisPlayOrder--));
                            this.orgRecommendCourseDao.update((Object)sourceRecommendCourse, new String[]{"updateTime", "displayOrder"});
                            logger.info("ADDED.sourceRecommendCourse:{}", (Object)sourceRecommendCourse);
                            break;
                        }
                        this.save(dto, minDisPlayOrder--, orgId);
                        break;
                    }
                    case DELETE: {
                        if (sourceRecommendCourse == null) break;
                        sourceRecommendCourse.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                        sourceRecommendCourse.setDisplayOrder(Integer.valueOf(0));
                        sourceRecommendCourse.setIsDeleted(Integer.valueOf(DeleteStatus.DELETED.getValue()));
                        this.orgRecommendCourseDao.update((Object)sourceRecommendCourse, new String[]{"updateTime", "displayOrder", "isDeleted"});
                        logger.info("DELETE.sourceRecommendCourse:{}", (Object)sourceRecommendCourse);
                        break;
                    }
                }
                this.doAfter(cache, orgId, minDisPlayOrder);
                logger.info("batchEdit.orgId:{}, dto:{}, sourceRecommendCourse:{}", new Object[]{orgId, dto, sourceRecommendCourse});
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private int getMaxDisplayOrder(List<OrgRecommendCourseRequestDto> recommendCourses, Long orgId) {
        List excludeIds = BaseUtils.getListFilter(recommendCourses, (String)"courseId");
        int maxDisplayOrder = this.orgRecommendCourseDao.getMaxDisplayOrderByExcludeIds(orgId, (Collection)excludeIds);
        maxDisplayOrder = maxDisplayOrder == 0 ? recommendCourses.size() + 1 : (maxDisplayOrder += recommendCourses.size() + 1);
        return maxDisplayOrder;
    }

    private void doAfter(List<OrgRecommendCourse> cache, int orgId, int threadhold) {
        if (cache != null && !cache.isEmpty()) {
            int totalCount = this.orgRecommendCourseDao.getOrgRecommendCourseCount(Integer.valueOf(orgId));
            int size = cache.size();
            if (totalCount > BizConf.MAX_RECOMMEND_COURSE_COUNT) {
                int edgeVal = totalCount - BizConf.MAX_RECOMMEND_COURSE_COUNT;
                if (size >= edgeVal) {
                    List<OrgRecommendCourse> deleteCourse = cache.subList(size - edgeVal, size);
                    this.deleteRecommendCourse(deleteCourse);
                    if (edgeVal > 0) {
                        List<OrgRecommendCourse> updateCourse = cache.subList(0, size - edgeVal);
                        this.updateCourse(updateCourse, threadhold);
                    }
                }
            } else {
                this.updateCourse(cache, threadhold);
            }
        }
    }

    private void updateCourse(List<OrgRecommendCourse> updateCourse, int threadhold) {
        if (updateCourse != null && !updateCourse.isEmpty()) {
            for (OrgRecommendCourse course : updateCourse) {
                if (course.getDisplayOrder() == threadhold--) continue;
                course.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                course.setDisplayOrder(Integer.valueOf(threadhold--));
                this.orgRecommendCourseDao.update((Object)course, new String[]{"updateTime", "displayOrder"});
            }
        }
    }

    private void deleteRecommendCourse(List<OrgRecommendCourse> deleteCourse) {
        if (deleteCourse != null && !deleteCourse.isEmpty()) {
            for (OrgRecommendCourse item : deleteCourse) {
                item.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                item.setDisplayOrder(Integer.valueOf(0));
                item.setIsDeleted(Integer.valueOf(DeleteStatus.DELETED.getValue()));
                logger.info("UPDATE.sourceRecommendCourse:{}", (Object)item);
                this.orgRecommendCourseDao.update((Object)item, new String[]{"updateTime", "displayOrder", "isDeleted"});
            }
        }
    }

    private void save(OrgRecommendCourseRequestDto dto, int minDisPlayOrder, int orgId) {
        OrgRecommendCourse destRecommendCourse = new OrgRecommendCourse();
        destRecommendCourse.setCourseid(Integer.valueOf(dto.getCourseId().intValue()));
        destRecommendCourse.setCourseType(dto.getCourseType());
        destRecommendCourse.setCreateTime(new Timestamp(System.currentTimeMillis()));
        destRecommendCourse.setDisplayOrder(Integer.valueOf(minDisPlayOrder));
        destRecommendCourse.setIsDeleted(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        destRecommendCourse.setOrgId(Integer.valueOf(orgId));
        logger.info("save.destRecommendCourse:{}, dto:{}", (Object)destRecommendCourse, (Object)dto);
        this.orgRecommendCourseDao.save((Object)destRecommendCourse, new String[0]);
    }

    private boolean validateCourse(Integer orgNumber, Long courseId, Integer courseType) {
        if (courseType.intValue() == CourseType.CLASS.getCode()) {
            TeacherClassCourse classCourse = (TeacherClassCourse)this.teacherClassCourseDao.getById((Serializable)courseId, new String[0]);
            return classCourse != null && classCourse.getOrganizationNumber() == orgNumber;
        }
        if (courseType.intValue() == CourseType.ORG_COURSE.getCode()) {
            OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
            return orgCourse != null && orgCourse.getOrgNumber().longValue() == orgNumber.longValue();
        }
        return false;
    }

    private OrgRecommendCourse validateParams(Integer orgId, Long courseId, Integer courseType) {
        OrgRecommendCourse result = this.orgRecommendCourseDao.getOrgRecommendCourse(orgId, courseId, courseType);
        logger.info("validateParams.result:{}", (Object)result);
        return result;
    }
}

