/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoChangeLogService;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="orgCourseConsumeRuleService")
public class OrgCourseConsumeRuleServiceImpl
implements OrgCourseConsumeRuleService {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseConsumeRuleServiceImpl.class);
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgCourseConsumeRuleDao orgCourseConsumeRuleDao;
    @Resource
    private KexiaoChangeLogService changeLogService;

    @Override
    public Map<Long, Integer> queryCourseRuleMapByCourseIds(Long orgId, Collection<Long> courseIds) {
        HashMap allCourseConsumeRuleMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(courseIds)) {
            return allCourseConsumeRuleMap;
        }
        Map courseConsumeRuleMap = this.orgCourseConsumeRuleDao.queryCourseRuleMapByCourseIds(orgId, courseIds);
        if (MapUtils.isNotEmpty((Map)courseConsumeRuleMap)) {
            allCourseConsumeRuleMap.putAll(courseConsumeRuleMap);
        }
        for (Long courseId : courseIds) {
            if (allCourseConsumeRuleMap.containsKey(courseId)) continue;
            allCourseConsumeRuleMap.put(courseId, 0);
        }
        return courseConsumeRuleMap;
    }

    @Override
    public Integer getRuleValueByCourseId(Long orgId, Long courseId) {
        OrgCourseConsumeRule rule = this.getRuleByCourseId(orgId, courseId);
        if (rule != null && rule.getRuleValue() != null) {
            return rule.getRuleValue();
        }
        return CourseConsumeRuleEnum.TIME_0.getValue();
    }

    @Override
    public Integer getRuleValueByCourseId(Long orgId, OrgCourse orgCourse) {
        OrgCourseConsumeRule rule = this.getRuleByCourseId(orgId, orgCourse);
        return rule.getRuleValue();
    }

    @Override
    public OrgCourseConsumeRule create(Long orgId, Long courseId, Integer ruleValue) {
        OrgCourseConsumeRule rule = new OrgCourseConsumeRule();
        rule.setOrgId(orgId);
        rule.setCourseId(courseId);
        rule.setRuleValue(ruleValue);
        Date now = new Date();
        rule.setCreateTime(now);
        rule.setUpdateTime(now);
        this.orgCourseConsumeRuleDao.save((Object)rule, new String[0]);
        log.info("OrgCourseConsumeRuleService createRule orgId:{},courseId:{},ruleValue:{}", new Object[]{orgId, courseId, ruleValue});
        return rule;
    }

    @Override
    public boolean updateRuleValue(Long orgId, Long courseId, Integer ruleValue) {
        OrgCourseConsumeRule rule = new OrgCourseConsumeRule();
        rule.setOrgId(orgId);
        rule.setCourseId(courseId);
        rule.setRuleValue(ruleValue);
        HashMap updateCondtion = Maps.newHashMap();
        updateCondtion.put("orgId", orgId);
        updateCondtion.put("courseId", courseId);
        updateCondtion.put("ruleValue", ruleValue);
        updateCondtion.put("updateTime", new Date());
        int count = this.orgCourseConsumeRuleDao.update((Map)updateCondtion, new String[]{"ruleValue", "updateTime"});
        log.info("OrgCourseConsumeRuleService updateRuleValue orgId:{},courseId:{},ruleValue:{}", new Object[]{orgId, courseId, ruleValue});
        return count > 0;
    }

    @Override
    public void saveOfupdate(Long orgId, Long courseId, Integer ruleValue) {
        OrgCourseConsumeRule rule = this.orgCourseConsumeRuleDao.getRuleByCourseId(orgId, courseId);
        if (rule != null) {
            int oldRule = rule.getRuleValue();
            this.updateRuleValue(orgId, courseId, ruleValue);
            rule.setRuleValue(ruleValue);
            if (oldRule != ruleValue) {
                this.changeLogService.addRuleChangedLog(rule);
            }
        } else {
            rule = this.create(orgId, courseId, ruleValue);
            this.changeLogService.addRuleChangedLog(rule);
        }
    }

    @Override
    public OrgCourseConsumeRule getRuleByCourseId(Long orgId, Long courseId) {
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId, new String[0]);
        return this.getRuleByCourseId(orgId, orgCourse);
    }

    @Override
    public OrgCourseConsumeRule getRuleByCourseId(Long orgId, OrgCourse orgCourse) {
        OrgCourseConsumeRule rule;
        Long ruleCourseId = orgCourse.getId();
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode()) {
            ruleCourseId = orgCourse.getParentId();
        }
        if ((rule = this.orgCourseConsumeRuleDao.getRuleByCourseId(orgId, ruleCourseId)) == null) {
            rule = new OrgCourseConsumeRule();
        }
        String ruleDesc = CourseConsumeRuleEnum.getRuleDescByValue(rule.getRuleValue());
        rule.setRuleDesc(ruleDesc);
        return rule;
    }
}

