/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoChangeLogService;
import com.baijia.tianxiao.util.ListUtil;
import com.beust.jcommander.internal.Maps;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgSignupCourseLessonServiceImpl
implements OrgSignupCourseLessonService {
    private static final Logger log = LoggerFactory.getLogger(OrgSignupCourseLessonServiceImpl.class);
    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private KexiaoChangeLogService changeLogService;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgStudentCourseDao studentCourseDao;
    @Autowired
    private OrgCourseConsumeRuleDao ruleDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private OrgSignupRefundDao refundDao;
    private static final int HOUR = 60;
    private static final int HALF_HOUR = 30;

    @Override
    public void saveSignupCourseLessons(Long orgId, Long classId, Collection<OrgStudentLesson> studentLessons) {
        this.saveSignupCourseLessons(orgId, classId, studentLessons, null);
    }

    @Override
    @Transactional
    public void saveSignupCourseLessons(Long orgId, Long classId, Collection<OrgStudentLesson> studentLessons, OrgSignupCourse orgSignupCourse) {
        if (studentLessons == null || studentLessons.size() < 1) {
            log.info("[SignupCourseLesson] studentLessons is null.orgId={},classId={}", (Object)orgId, (Object)classId);
            return;
        }
        Long courseId = 0L;
        OrgCourse orgCourse = (OrgCourse)this.courseDao.getById((Serializable)classId, new String[]{"isClass", "isCourse", "parentId", "chargeUnit"});
        if (orgCourse.getChargeUnit() <= 0) {
            orgCourse.setChargeUnit(Integer.valueOf(ChargeUnit.BY_TIMES.getCode()));
        }
        courseId = CourseTypeEnum.IS_CLASS_TRUE.getCode() == orgCourse.getIsClass() && CourseTypeEnum.IS_COURSE_FALSE.getCode() == orgCourse.getIsCourse() ? orgCourse.getParentId() : classId;
        List userIds = ListUtil.toKeyList(studentLessons, (String)"userId", OrgStudentLesson.class);
        List signupCourses = this.signupCourseDao.searchByUserIdsAndCourseId((Collection)userIds, classId, orgId, (Collection)Lists.newArrayList((Object[])new Integer[]{2, 3, 4}));
        if (orgSignupCourse != null) {
            boolean isExisted = false;
            for (OrgSignupCourse signupCourse : signupCourses) {
                if (!signupCourse.getId().equals(orgSignupCourse.getId())) continue;
                isExisted = true;
                break;
            }
            if (!isExisted) {
                signupCourses.add(orgSignupCourse);
            }
        }
        this.handleRefund(signupCourses);
        Map<Long, List<OrgSignupCourse>> stuSignupMap = this.getUserSignupCourseMap(signupCourses);
        Map<Long, List<OrgSignupCourse>> unCompleteSignupMap = this.filterUnHandleStudent(stuSignupMap);
        log.info("[SignupCourseLesson] Validate userIds={}", stuSignupMap.keySet());
        this.deleteSignupCourseLessons(orgId, studentLessons);
        Map<Long, Object> signupLessonStatMap = new HashMap<Long, OrgSignupCourseLesson>();
        if (!stuSignupMap.isEmpty()) {
            signupLessonStatMap = this.signupCourseLessonDao.selectSignUpLessons(stuSignupMap.keySet(), classId, orgId);
        }
        Map<Long, List<OrgSignupCourse>> unfinishedSignupCourseMap = this.getUnFinishedOrgSignupCourse(signupLessonStatMap, stuSignupMap);
        Set<String> cancelLessons = this.getCancelLessonType(orgId, courseId, classId, stuSignupMap.keySet());
        for (OrgStudentLesson studentLesson : studentLessons) {
            if (studentLesson.getDelStatus() != null && studentLesson.getDelStatus() == 1) {
                log.warn("[SignupCourseLesson] StudentLesson is deleted.studentLesson={}", (Object)studentLesson);
                continue;
            }
            log.info("[SignupCourseLesson] orgId={},studentLesson={},courseId={}", new Object[]{orgId, studentLesson, courseId});
            studentLesson.setKexiaoDuration(studentLesson.getLessonDuration());
            OrgSignupCourseLesson signupLesson = this.createOrgSignupCourseLesson(orgId, studentLesson, studentLesson.getLessonDuration(), courseId);
            if (stuSignupMap.keySet().contains(studentLesson.getUserId())) {
                if (cancelLessons.contains(this.getKey(studentLesson))) {
                    signupLesson.setLessonType(LessonType.CANCEL.getCode());
                    studentLesson.setLessonType(LessonType.CANCEL.getCode());
                } else {
                    List<OrgSignupCourse> signUpList = unfinishedSignupCourseMap.get(studentLesson.getUserId());
                    log.info("[SignupCourseLesson] signUpList={}", signUpList);
                    if (signUpList != null && !signUpList.isEmpty()) {
                        OrgSignupCourse signupCourse = signUpList.get(0);
                        studentLesson.setLessonType(LessonType.NORMAL.getCode());
                        if (ChargeUnit.BY_TIMES.getCode() == signupCourse.getChargeUnit().intValue()) {
                            this.handleTimesLesson(signUpList, signupLesson, signupLessonStatMap);
                        } else if (ChargeUnit.isByTime((int)signupCourse.getChargeUnit())) {
                            this.handleTimeLesson(signUpList, signupLesson, signupLessonStatMap, studentLesson, courseId, orgCourse);
                        } else {
                            log.error("[SignupCourseLesson] Type error.{}", signUpList);
                        }
                    } else {
                        studentLesson.setLessonType(LessonType.FREE.getCode());
                        studentLesson.setKexiaoDuration(Integer.valueOf(0));
                        signupLesson.setLessonType(LessonType.FREE.getCode());
                    }
                }
                signupLesson.setChargeUnit(orgCourse.getChargeUnit());
                log.info("[SignupCourseLesson] courseLesson={}", (Object)signupLesson);
                this.signupCourseLessonDao.save((Object)signupLesson, new String[0]);
                continue;
            }
            if (unCompleteSignupMap.get(studentLesson.getUserId()) != null) {
                studentLesson.setLessonType(LessonType.OTHER.getCode());
                studentLesson.setKexiaoDuration(Integer.valueOf(0));
                continue;
            }
            studentLesson.setLessonType(LessonType.FREE.getCode());
            studentLesson.setKexiaoDuration(Integer.valueOf(0));
            signupLesson.setChargeUnit(orgCourse.getChargeUnit());
            signupLesson.setLessonType(LessonType.FREE.getCode());
            this.signupCourseLessonDao.save((Object)signupLesson, new String[0]);
        }
    }

    private void handleRefund(List<OrgSignupCourse> signupCourses) {
        Long fee;
        String key;
        if (signupCourses == null || signupCourses.isEmpty()) {
            return;
        }
        HashSet<Long> signupIds = new HashSet<Long>();
        for (OrgSignupCourse signupCourse : signupCourses) {
            signupIds.add(signupCourse.getSignupPurchaseId());
        }
        List refunds = this.refundDao.getByPurcahseIds(signupIds);
        HashMap<String, Long> refundMap = new HashMap<String, Long>();
        for (OrgSignupRefund refund : refunds) {
            key = refund.getSignupPurchaseId() + "_" + refund.getCourseId();
            fee = (Long)refundMap.get(key);
            if (fee == null) {
                refundMap.put(key, refund.getRefundPrice());
                continue;
            }
            refundMap.put(key, refund.getRefundPrice() + fee);
        }
        log.info("[SignupCourseLesson] refundMap={}", refundMap);
        for (OrgSignupCourse signupCourse : signupCourses) {
            key = signupCourse.getSignupPurchaseId() + "_" + signupCourse.getOrgCourseId();
            fee = (Long)refundMap.get(key);
            if (fee == null) continue;
            signupCourse.setPayPrice(Long.valueOf(signupCourse.getPayPrice() - fee));
        }
    }

    private void handleTimesLesson(List<OrgSignupCourse> signUpList, OrgSignupCourseLesson signupLesson, Map<Long, OrgSignupCourseLesson> signupLessonStatMap) {
        OrgSignupCourse signupCourse = signUpList.get(0);
        signupLesson.setLessonType(LessonType.NORMAL.getCode());
        OrgSignupCourseLesson stat = signupLessonStatMap.get(signupCourse.getId());
        if (stat == null) {
            stat = OrgSignupCourseLesson.create((OrgSignupCourse)signupCourse);
            signupLessonStatMap.put(signupCourse.getId(), stat);
        }
        signupLesson.setAmount(Long.valueOf(this.getCountAmount(signupCourse, stat)));
        signupLesson.setSignupCourseId(signupCourse.getId());
        stat.setAmount(Long.valueOf(stat.getAmount() + signupLesson.getAmount()));
        stat.setLessonDuration(Integer.valueOf(stat.getLessonDuration() + signupLesson.getLessonDuration()));
        stat.setLessonCount(stat.getLessonCount() + 1);
        if (stat.getLessonCount() >= signupCourse.getLessonCount()) {
            signUpList.remove(signupCourse);
        }
    }

    private void handleTimeLesson(List<OrgSignupCourse> signUpList, OrgSignupCourseLesson signupLesson, Map<Long, OrgSignupCourseLesson> signupLessonStatMap, OrgStudentLesson studentLesson, long courseId, OrgCourse orgCourse) {
        int lessonTime;
        int leftTime = lessonTime = studentLesson.getLessonDuration().intValue();
        int kexiaoDuration = 0;
        Iterator<OrgSignupCourse> iter = signUpList.iterator();
        while (iter.hasNext()) {
            OrgSignupCourse tmpSginupCourse = iter.next();
            int totalTime = this.getTotalTime(tmpSginupCourse);
            long usedAmount = 0L;
            OrgSignupCourseLesson stat = signupLessonStatMap.get(tmpSginupCourse.getId());
            if (stat == null) {
                stat = OrgSignupCourseLesson.create((OrgSignupCourse)tmpSginupCourse);
                signupLessonStatMap.put(tmpSginupCourse.getId(), stat);
            }
            log.info("[SignupCourseLesson] leftTime={},totalTime={}", (Object)leftTime, (Object)(totalTime -= stat.getLessonDuration().intValue()));
            usedAmount = stat.getAmount();
            if (leftTime <= totalTime) {
                kexiaoDuration += leftTime;
                signupLesson.setLessonType(LessonType.NORMAL.getCode());
                signupLesson.setSignupCourseId(tmpSginupCourse.getId());
                signupLesson.setLessonDuration(Integer.valueOf(leftTime));
                if (leftTime == totalTime) {
                    long stuPay = tmpSginupCourse.getStudentPayPrice() == null ? 0L : tmpSginupCourse.getStudentPayPrice();
                    long pay = tmpSginupCourse.getPayPrice() == null ? 0L : tmpSginupCourse.getPayPrice();
                    signupLesson.setAmount(Long.valueOf(stuPay + pay - usedAmount));
                    iter.remove();
                } else {
                    signupLesson.setAmount(Long.valueOf(this.getHourAmount(tmpSginupCourse, leftTime)));
                }
                leftTime -= totalTime;
                stat.setAmount(Long.valueOf(stat.getAmount() + signupLesson.getAmount()));
                stat.setLessonDuration(Integer.valueOf(stat.getLessonDuration() + signupLesson.getLessonDuration()));
                stat.setLessonCount(stat.getLessonCount() + 1);
                break;
            }
            OrgSignupCourseLesson splitLesson = this.createOrgSignupCourseLesson(studentLesson.getOrgId(), studentLesson, studentLesson.getLessonDuration(), courseId);
            splitLesson.setLessonType(LessonType.NORMAL.getCode());
            splitLesson.setLessonDuration(Integer.valueOf(totalTime));
            splitLesson.setSignupCourseId(tmpSginupCourse.getId());
            splitLesson.setAmount(Long.valueOf(tmpSginupCourse.getStudentPayPrice() + tmpSginupCourse.getPayPrice() - usedAmount));
            splitLesson.setChargeUnit(orgCourse.getChargeUnit());
            this.signupCourseLessonDao.save((Object)splitLesson, new String[0]);
            stat.setAmount(Long.valueOf(stat.getAmount() + splitLesson.getAmount()));
            stat.setLessonDuration(Integer.valueOf(stat.getLessonDuration() + splitLesson.getLessonDuration()));
            stat.setLessonCount(stat.getLessonCount() + 1);
            iter.remove();
            leftTime -= totalTime;
            kexiaoDuration += totalTime;
        }
        if (leftTime > 0) {
            signupLesson.setLessonType(LessonType.FREE.getCode());
            signupLesson.setLessonDuration(Integer.valueOf(leftTime));
        }
        studentLesson.setKexiaoDuration(Integer.valueOf(kexiaoDuration));
    }

    private Set<String> getCancelLessonType(long orgId, long courseId, long classId, Collection<Long> userIds) {
        List signList;
        HashSet<String> ret = new HashSet<String>();
        OrgCourseConsumeRule rule = this.ruleDao.getRuleByCourseId(Long.valueOf(orgId), Long.valueOf(courseId));
        if (rule != null && rule.getRuleValue() > 0 && (signList = this.orgLessonSignDao.getUserLessonSignList(Long.valueOf(orgId), userIds, Long.valueOf(classId), Integer.valueOf(UserRole.STUDENT.getRole()), null, new String[]{"status", "lessonId", "userId"})) != null && signList.size() > 0) {
            for (OrgLessonSign sign : signList) {
                LessonStatus status = this.kexiaoApiService.getKexiaoStatus(sign, rule.getRuleValue().intValue());
                if (status == LessonStatus.FINISHED) continue;
                ret.add(this.getKey(sign));
            }
        }
        return ret;
    }

    private void deleteSignupCourseLessons(Long orgId, Collection<OrgStudentLesson> studentLessons) {
        List<OrgSignupCourseLesson> lessons = this.getByStudentLessons(orgId, studentLessons);
        if (lessons != null) {
            HashSet<Long> ids = new HashSet<Long>();
            for (OrgSignupCourseLesson lesson : lessons) {
                ids.add(lesson.getId());
            }
            if (!ids.isEmpty()) {
                this.signupCourseLessonDao.delByIds(ids);
            }
        }
    }

    private List<OrgSignupCourseLesson> getByStudentLessons(Long orgId, Collection<OrgStudentLesson> studentLessons) {
        ArrayList<OrgSignupCourseLesson> ret = new ArrayList<OrgSignupCourseLesson>();
        HashSet<Long> lessonIds = new HashSet<Long>();
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<String> keys = new HashSet<String>();
        for (OrgStudentLesson lesson : studentLessons) {
            lessonIds.add(lesson.getLessonId());
            userIds.add(lesson.getUserId());
            keys.add(this.getKey(lesson));
        }
        List lessons = this.signupCourseLessonDao.getLessonList(orgId, lessonIds, userIds);
        if (lessons != null) {
            for (OrgSignupCourseLesson lesson : lessons) {
                if (!keys.contains(this.getKey(lesson))) continue;
                ret.add(lesson);
            }
        }
        return ret;
    }

    private String getKey(OrgStudentLesson lesson) {
        return lesson.getLessonId() + "_" + lesson.getUserId();
    }

    private String getKey(OrgSignupCourseLesson lesson) {
        return lesson.getLessonId() + "_" + lesson.getUserId();
    }

    private String getKey(OrgLessonSign sign) {
        return sign.getLessonId() + "_" + sign.getUserId();
    }

    @Override
    @Transactional
    public void updateLessonDuration(Long orgId, OrgClassLesson classLesson) {
        List studentLessons = this.studentLessonDao.queryStudentsByLessonId(orgId, classLesson.getId());
        if (studentLessons == null || studentLessons.isEmpty()) {
            return;
        }
        ArrayList userIds = Lists.newArrayList();
        for (OrgStudentLesson lesson : studentLessons) {
            userIds.add(lesson.getUserId());
        }
        List studentCourses = this.studentCourseDao.listByStatus(orgId, classLesson.getCourseId(), (Collection)userIds, Arrays.asList(1, 2), new String[]{"id", "userId"});
        HashSet invalidIds = Sets.newHashSet();
        if (studentCourses != null) {
            for (OrgStudentCourse studentCourse : studentCourses) {
                invalidIds.add(studentCourse.getUserId());
            }
            log.info("Quit class can not modify status.InvalidIds={}", (Object)invalidIds);
        }
        ArrayList normalLessons = Lists.newArrayList();
        ArrayList freeUserIds = Lists.newArrayList();
        ArrayList<Long> stuLessonIds = new ArrayList<Long>();
        for (OrgStudentLesson lesson : studentLessons) {
            if (invalidIds.contains(lesson.getUserId())) continue;
            stuLessonIds.add(lesson.getId());
            if (lesson.getLessonType() == LessonType.NORMAL.getCode() || lesson.getLessonType() == LessonType.CANCEL.getCode()) {
                normalLessons.add(lesson);
                continue;
            }
            if (lesson.getLessonType() == LessonType.FREE.getCode()) {
                freeUserIds.add(lesson.getUserId());
                continue;
            }
            log.info("[Kexiao] info uncompleted.classLesson={}", (Object)classLesson);
        }
        Date date = new Date();
        if (!normalLessons.isEmpty()) {
            this.saveSignupCourseLessons(orgId, classLesson.getCourseId(), normalLessons);
            for (OrgStudentLesson studentLesson : normalLessons) {
                studentLesson.setUpdateTime(date);
                this.studentLessonDao.update((Object)studentLesson, new String[0]);
            }
        }
        if (!freeUserIds.isEmpty()) {
            this.signupCourseLessonDao.batchUpdateLessonDuration(orgId, classLesson.getId(), (Collection)freeUserIds, (long)this.diffTime(classLesson.getStartTime(), classLesson.getEndTime()));
        }
    }

    @Override
    public List<OrgStudentLesson> getUnSignableList(Long orgId, Long classId, Collection<OrgStudentLesson> studentLessons) {
        log.info("[SignupCourseLesson] studentLessons={},classId={}", studentLessons, (Object)classId);
        ArrayList<OrgStudentLesson> unSignableList = new ArrayList<OrgStudentLesson>();
        if (studentLessons == null || studentLessons.size() < 1) {
            return Collections.emptyList();
        }
        ArrayList<OrgStudentLesson> cancelLessons = new ArrayList<OrgStudentLesson>();
        for (OrgStudentLesson lesson : studentLessons) {
            if (lesson.getLessonType() != LessonType.CANCEL.getCode()) continue;
            cancelLessons.add(lesson);
        }
        if (!cancelLessons.isEmpty()) {
            Map<String, OrgSignupCourseLesson> courseLessonMap = this.getSignupCourseLessonMap(orgId, cancelLessons);
            List userIds = ListUtil.toKeyList(cancelLessons, (String)"userId", OrgStudentLesson.class);
            List signupCourses = this.signupCourseDao.searchByUserIdsAndCourseId((Collection)userIds, classId, orgId, (Collection)Lists.newArrayList((Object[])new Integer[]{2, 3, 4}));
            Map<Long, List<OrgSignupCourse>> stuSignupMap = this.getUserSignupCourseMap(signupCourses);
            Map<Long, Object> signupLessonMap = new HashMap<Long, OrgSignupCourseLesson>();
            if (!stuSignupMap.isEmpty()) {
                signupLessonMap = this.signupCourseLessonDao.selectSignUpLessons(stuSignupMap.keySet(), classId, orgId);
            }
            Map<Long, List<OrgSignupCourse>> unfinishedSignupCourseMap = this.getUnFinishedOrgSignupCourse(signupLessonMap, stuSignupMap);
            log.info("[SignupCourseLesson] unfinishedSignupCourseMap={}", unfinishedSignupCourseMap);
            for (OrgStudentLesson studentLesson : cancelLessons) {
                if (stuSignupMap.keySet().contains(studentLesson.getUserId())) {
                    List<OrgSignupCourse> courseList = unfinishedSignupCourseMap.get(studentLesson.getUserId());
                    OrgSignupCourseLesson courseLesson = courseLessonMap.get(this.getKey(studentLesson));
                    log.info("[SignupCourseLesson] key={},courseLessonMap={}", (Object)this.getKey(studentLesson), courseLessonMap);
                    if (courseLesson == null) continue;
                    if (courseList != null && !courseList.isEmpty()) {
                        OrgSignupCourse course = courseList.get(0);
                        if (!ChargeUnit.isByTime((int)course.getChargeUnit())) continue;
                        int leftTime = 0;
                        for (OrgSignupCourse signupCourse : courseList) {
                            int totalTime = this.getTotalTime(signupCourse);
                            OrgSignupCourseLesson stat = (OrgSignupCourseLesson)signupLessonMap.get(signupCourse.getId());
                            if (stat == null) continue;
                            leftTime += (totalTime -= stat.getLessonDuration().intValue());
                        }
                        if (leftTime > 0) continue;
                        log.info("[SignupCourseLesson] leftTime={},lessonDuration={}", (Object)leftTime, (Object)courseLesson.getLessonDuration());
                        unSignableList.add(studentLesson);
                        continue;
                    }
                    unSignableList.add(studentLesson);
                    continue;
                }
                unSignableList.add(studentLesson);
            }
        }
        return unSignableList;
    }

    private Map<String, OrgSignupCourseLesson> getSignupCourseLessonMap(Long orgId, List<OrgStudentLesson> cancelLessons) {
        List<OrgSignupCourseLesson> signupCourseLessons = this.getByStudentLessons(orgId, cancelLessons);
        Map retMap = Maps.newHashMap();
        log.info("[SignupCourseLesson] signupCourseLessons={},cancelLessons={}", signupCourseLessons, cancelLessons);
        for (OrgSignupCourseLesson signupCourseLesson : signupCourseLessons) {
            OrgSignupCourseLesson lesson = (OrgSignupCourseLesson)retMap.get(this.getKey(signupCourseLesson));
            if (lesson == null) {
                if (LessonType.isFree((Integer)signupCourseLesson.getLessonType())) continue;
                retMap.put(this.getKey(signupCourseLesson), signupCourseLesson);
                continue;
            }
            if (LessonType.isFree((Integer)signupCourseLesson.getLessonType())) continue;
            lesson.setLessonDuration(Integer.valueOf(signupCourseLesson.getLessonDuration() + lesson.getLessonDuration()));
        }
        return retMap;
    }

    private Map<Long, List<OrgSignupCourse>> getUserSignupCourseMap(List<OrgSignupCourse> signupCourses) {
        HashMap<Long, List<OrgSignupCourse>> stuSignupMap = new HashMap<Long, List<OrgSignupCourse>>();
        for (OrgSignupCourse signupCourse : signupCourses) {
            ArrayList<OrgSignupCourse> list = (ArrayList<OrgSignupCourse>)stuSignupMap.get(signupCourse.getUserId());
            if (list == null) {
                list = new ArrayList<OrgSignupCourse>();
                stuSignupMap.put(signupCourse.getUserId(), list);
            }
            list.add(signupCourse);
        }
        return stuSignupMap;
    }

    private long getCountAmount(OrgSignupCourse course, OrgSignupCourseLesson stat) {
        long stuPay = course.getStudentPayPrice() == null ? 0L : course.getStudentPayPrice();
        long pay = course.getPayPrice() == null ? 0L : course.getPayPrice();
        long total = stuPay + pay;
        long unit = total / (long)course.getLessonCount().intValue();
        if (course.getLessonCount() - stat.getLessonCount() > 1) {
            return unit;
        }
        return total - stat.getAmount();
    }

    private long getHourAmount(OrgSignupCourse course, int lessonTime) {
        long totalTime = this.getTotalTime(course);
        long stuPay = course.getStudentPayPrice() == null ? 0L : course.getStudentPayPrice();
        long pay = course.getPayPrice() == null ? 0L : course.getPayPrice();
        return (long)lessonTime * (pay + stuPay) / totalTime;
    }

    private int getTotalTime(OrgSignupCourse signupCourse) {
        ChargeUnit chargeUnit = ChargeUnit.getByCode((int)signupCourse.getChargeUnit());
        switch (chargeUnit) {
            case BY_HOUR: {
                return signupCourse.getLessonCount() * 60;
            }
            case BY_HALF_HOUR: {
                return signupCourse.getLessonCount() * 30;
            }
            case BY_MINUTE: {
                return signupCourse.getLessonCount();
            }
        }
        log.error("[SignupCourseLesson] chargeUnit is error.chargeUnit={}", (Object)chargeUnit);
        return signupCourse.getLessonCount();
    }

    private OrgSignupCourseLesson createOrgSignupCourseLesson(Long orgId, OrgStudentLesson studentLesson, int lessonDuration, Long courseId) {
        OrgSignupCourseLesson courseLesson = new OrgSignupCourseLesson();
        courseLesson.setOrgId(orgId);
        courseLesson.setCreateTime(new Date());
        courseLesson.setSignupCourseId(Long.valueOf(-1L));
        courseLesson.setLessonDuration(Integer.valueOf(lessonDuration));
        courseLesson.setClassId(studentLesson.getCourseId());
        courseLesson.setCourseId(courseId);
        courseLesson.setLessonId(studentLesson.getLessonId());
        courseLesson.setUserId(studentLesson.getUserId());
        return courseLesson;
    }

    private int diffTime(Date startTime, Date endTime) {
        Calendar start = Calendar.getInstance();
        start.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return end.get(12) - start.get(12);
    }

    private Map<Long, List<OrgSignupCourse>> filterUnHandleStudent(Map<Long, List<OrgSignupCourse>> stuSignupMap) {
        HashMap<Long, List<OrgSignupCourse>> unCompleteSignupMap = new HashMap<Long, List<OrgSignupCourse>>();
        Set<Map.Entry<Long, List<OrgSignupCourse>>> set = stuSignupMap.entrySet();
        Iterator<Map.Entry<Long, List<OrgSignupCourse>>> iter = set.iterator();
        block0: while (iter.hasNext()) {
            Map.Entry<Long, List<OrgSignupCourse>> entry = iter.next();
            for (OrgSignupCourse course : entry.getValue()) {
                if (course.getLessonCount() > 0) continue;
                unCompleteSignupMap.put(entry.getKey(), entry.getValue());
                iter.remove();
                continue block0;
            }
        }
        return unCompleteSignupMap;
    }

    private Map<Long, List<OrgSignupCourse>> getUnFinishedOrgSignupCourse(Map<Long, OrgSignupCourseLesson> signupLessonsMap, Map<Long, List<OrgSignupCourse>> stuSignupMap) {
        HashMap<Long, List<OrgSignupCourse>> unFinishedSignup = new HashMap<Long, List<OrgSignupCourse>>();
        Set<Map.Entry<Long, List<OrgSignupCourse>>> set = stuSignupMap.entrySet();
        for (Map.Entry<Long, List<OrgSignupCourse>> entry : set) {
            for (OrgSignupCourse course : entry.getValue()) {
                OrgSignupCourseLesson stat = signupLessonsMap.get(course.getId());
                ArrayList<OrgSignupCourse> list = (ArrayList<OrgSignupCourse>)unFinishedSignup.get(entry.getKey());
                if (list == null) {
                    list = new ArrayList<OrgSignupCourse>();
                }
                if (stat == null) {
                    list.add(course);
                } else if (ChargeUnit.BY_TIMES.getCode() == course.getChargeUnit().intValue()) {
                    if (course.getLessonCount() > stat.getLessonCount()) {
                        if (log.isDebugEnabled()) {
                            log.debug("[SignupCourseLesson] contract count={},lesson count={},unit={}", new Object[]{course.getLessonCount(), stat.getLessonCount(), course.getChargeUnit()});
                        }
                        list.add(course);
                    }
                } else if (ChargeUnit.BY_HOUR.getCode() == course.getChargeUnit().intValue()) {
                    if (course.getLessonCount() * 60 > stat.getLessonDuration()) {
                        if (log.isDebugEnabled()) {
                            log.debug("[SignupCourseLesson] contract count={},lesson time={},unit={}", new Object[]{course.getLessonCount(), stat.getLessonDuration(), course.getChargeUnit()});
                        }
                        list.add(course);
                    }
                } else if (ChargeUnit.BY_HOUR.getCode() == course.getChargeUnit().intValue()) {
                    if (course.getLessonCount() * 30 > stat.getLessonDuration()) {
                        if (log.isDebugEnabled()) {
                            log.debug("[SignupCourseLesson] contract count={},lesson time={},unit={}", new Object[]{course.getLessonCount(), stat.getLessonDuration(), course.getChargeUnit()});
                        }
                        list.add(course);
                    }
                } else if (ChargeUnit.BY_MINUTE.getCode() == course.getChargeUnit().intValue()) {
                    if (course.getLessonCount() > stat.getLessonDuration()) {
                        if (log.isDebugEnabled()) {
                            log.debug("[SignupCourseLesson] contract count={},lesson time={},unit={}", new Object[]{course.getLessonCount(), stat.getLessonDuration(), course.getChargeUnit()});
                        }
                        list.add(course);
                    }
                } else {
                    log.error("[SignupCourseLesson] OrgSignupCourseLessonStat data error={}", (Object)stat);
                }
                if (list.isEmpty()) continue;
                unFinishedSignup.put(entry.getKey(), list);
            }
        }
        return unFinishedSignup;
    }

    @Override
    @Transactional
    public void deleteClassLessons(Long orgId, Collection<Long> lessonIds) {
        this.signupCourseLessonDao.batchDelLesson(orgId.longValue(), lessonIds);
        this.changeLogService.addDelLessonsLog(orgId, lessonIds);
    }

    @Override
    @Transactional
    public void cancelSign(Long orgId, Long lessonId, Collection<Long> userIds) {
        log.info("[SignupCourseLesson] cancel sign.orgId={},lessonId={},userIds={}", new Object[]{orgId, lessonId, userIds});
        this.signupCourseLessonDao.batchCancelLesson(orgId, lessonId, userIds);
        this.studentLessonDao.batchUpdateLessonType(userIds, lessonId, LessonType.CANCEL.getCode().intValue());
    }

    @Override
    @Transactional
    public void deleteStudentLessons(Long orgId, Collection<Long> userIds, Collection<Long> lessonIds) {
        this.signupCourseLessonDao.batchDelStuLesson(orgId.longValue(), userIds, lessonIds);
        List studentLessons = this.studentLessonDao.getAllStuLessonsBy(orgId, userIds, lessonIds, new String[]{"id"});
        if (studentLessons != null && studentLessons.size() > 0) {
            List ids = ListUtil.toKeyList((Collection)studentLessons, (String)"id", OrgStudentLesson.class);
            this.changeLogService.addDelStuLessonsLog(orgId, (Collection)ids);
        }
    }

    @Override
    public void syncHistoryData(Long orgId) {
        List courseIds = this.studentCourseDao.selectOneToOneClassId(orgId);
        HashSet courseIdSet = new HashSet(courseIds);
        for (Long id : courseIdSet) {
            log.info("[SignupCourseLesson] update 1v1 data.orgId={},courseId={}", (Object)orgId, (Object)id);
            List lessons = this.studentLessonDao.getByCourseIdsUserIds(orgId, Arrays.asList(id), null, new String[0]);
            if (lessons == null || lessons.size() <= 0) continue;
            this.saveSignupCourseLessons(orgId, id, lessons);
            for (OrgStudentLesson lesson : lessons) {
                lesson.setUpdateTime(new Date());
                this.studentLessonDao.update((Object)lesson, new String[0]);
            }
        }
    }
}

