/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.BooleanEnum;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseStudentOpDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dto.KexiaoStatisticss;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseStudentOp;
import com.baijia.tianxiao.dal.org.po.OrgLessonComment;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dto.PersonBaseDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.common.api.StudentCourseApi;
import com.baijia.tianxiao.sal.common.api.StudentKexiaoStatisticsApiService;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.common.dto.StudentCourseBase;
import com.baijia.tianxiao.sal.course.constant.KexiaoReason;
import com.baijia.tianxiao.sal.course.dto.response.ClassLessonInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseStudentDetailDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseStudentSumDto;
import com.baijia.tianxiao.sal.course.dto.response.MultiLessonsUnionStudentsResponse;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentsChooseListDto;
import com.baijia.tianxiao.sal.course.dto.response.StudentResponseDto;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.baijia.tianxiao.sal.course.service.OrgLessonConflictService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sal.course.util.StudentNameUtil;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.*;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.*;

/*
 * 班级学生
 * 
 * @title CourseStudentServiceImpl
 * 
 * @desc TODO
 * 
 * @author shizuwei
 * 
 * @date 2015年12月26日
 * 
 * @version 1.0
 */
@Slf4j
@Service
public class CourseStudentServiceImpl implements CourseStudentService {

    @Autowired
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgAccountDao orgAccountDao;

    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;

    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;

    @Resource
    private OrgCourseStudentOpDao orgCourseStudentOpDao;

    @Resource
    private OrgLessonSignDao orgLessonSignDao;

    @Resource
    private OrgLessonCommentDao orgLessonCommentDao;

    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;

    @Resource
    private OrgCourseConsumeRuleService orgCourseConsumeRuleService;

    @Autowired
    private OrgStudentKexiaoRecordDao OrgStudentKexiaoRecordDao;

    @Autowired
    private OrgStudentApiService studentApiService;

    @Resource
    private OrgLessonConflictService orgLessonConflictService;

    @Autowired
    private StudentKexiaoStatisticsApiService studentKexiaoStatisticsApiService;
    @Resource
    private OrgSignupCourseLessonService signupCourseLessonService;

    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    @Resource
    private StudentCourseApi studentCourseApi;

    @Autowired
    private KexiaoApiService kexiaoApiService;


    @Override
    public MultiLessonsUnionStudentsResponse multiLessonUnionStudents(Long orgId, Long courseId, List<Long> lessonIds) {
        MultiLessonsUnionStudentsResponse response = new MultiLessonsUnionStudentsResponse();
        OrgCourse course = orgCourseDao.getByCourseId(courseId);
        List<OrgClassLesson> lessons = orgClassLessonDao.getByIds(lessonIds, "name", "number");
        Collections.sort(lessons, Ordering.<Integer> natural().onResultOf(new Function<OrgClassLesson, Integer>() {
            @Override
            public Integer apply(OrgClassLesson input) {
                return input.getNumber();
            }
        }));
        // put course info
        response.setCourseId(course.getId());
        response.setCourseName(course.getName());
        response.setCourseType(course.getCourseType());
        response.setLessonIds(Lists.newArrayList(lessonIds));
        response.setLessonNames(Lists.transform(lessons, new Function<OrgClassLesson, String>() {
            @Override
            public String apply(OrgClassLesson input) {
                return input.getName();
            }
        }));
        response.setIndexes(Lists.transform(lessons, new Function<OrgClassLesson, Integer>() {
            @Override
            public Integer apply(OrgClassLesson input) {
                return input.getNumber();
            }
        }));
        response.setStudentsInAllLessons(Lists.<Long> newArrayList());
        response.setStudentsInPartLessons(Lists.<Long> newArrayList());

        List<OrgStudentLesson> lessonList =
            new LinkedList<>(orgStudentLessonDao.getOrgStudentLessonsByLessonIds(lessonIds));
        List<Long> allUserIds = Lists.transform(lessonList, new Function<OrgStudentLesson, Long>() {
            @Override
            public Long apply(OrgStudentLesson input) {
                return input.getUserId();
            }
        });
        // 退转班的学生 剔除
        Map<Long, Integer> uIdStatusWithdrawMap = orgStudentCourseDao.userMapByStatus(orgId, courseId, allUserIds,
            Arrays.asList(StudentCourseStatus.WITHDRAW.getCode(), StudentCourseStatus.TRANSFER.getCode()));
        Iterator<OrgStudentLesson> iter = lessonList.iterator();
        while (iter.hasNext()) {
            OrgStudentLesson temp = iter.next();
            if (uIdStatusWithdrawMap.containsKey(temp.getUserId())) {
                log.debug("Quit class! remove! OrgStudentLesson:{}", temp);
                iter.remove();
            }
        }

        log.info("the total orgStudentLesson size is:{}", lessonList.size());
        Set<Long> userIdSet = Sets.newHashSet(Lists.transform(lessonList, new Function<OrgStudentLesson, Long>() {
            @Override
            public Long apply(OrgStudentLesson input) {
                return input.getUserId();
            }
        }));
        log.info("the user id set is:{}", userIdSet);

        List<MultiLessonsUnionStudentsResponse.UnionStudent> studentList = makeUnionStudentList(orgStudentDao
            .getStudentByUserIdsAndDelStatus(orgId, userIdSet, null, "id", "userId", "mobile", "name", "pinyin"));
        log.info("the union student list size is:{}", studentList.size());

        Map<Long, List<Long>> userShowTimes = Maps.newHashMap();
        for (Long userId : userIdSet) {
            userShowTimes.put(userId, Lists.<Long> newArrayList());
        }
        for (OrgStudentLesson studentLesson : lessonList) {
            userShowTimes.get(studentLesson.getUserId()).add(studentLesson.getLessonId());
        }
        log.info("the student lesson map is:{}", userShowTimes);

        for (MultiLessonsUnionStudentsResponse.UnionStudent unionStudent : studentList) {
            // Integer status = uIdStatusWithdrawMap.get(unionStudent.getUserId());
            // unionStudent.setStatus(null != status ? status : StudentCourseStatus.NORMAL.getCode());
            unionStudent.setLessonIds(userShowTimes.get(unionStudent.getUserId()));
            unionStudent.setArrangedLessonNum(userShowTimes.get(unionStudent.getUserId()).size());
            if (unionStudent.getArrangedLessonNum() == lessonIds.size()) {
                response.getStudentsInAllLessons().add(unionStudent.getStudentId());
            } else {
                response.getStudentsInPartLessons().add(unionStudent.getStudentId());
            }
        }
        response.setUnionStudents(studentList);

        return response;
    }

    private List<MultiLessonsUnionStudentsResponse.UnionStudent> makeUnionStudentList(List<OrgStudent> orgStudentList) {
        Map<Long, String> urlMap = studentApiService.batchGetStudentAvatarUrl(orgStudentList);

        List<MultiLessonsUnionStudentsResponse.UnionStudent> result = Lists.newArrayList();

        for (OrgStudent student : orgStudentList) {
            MultiLessonsUnionStudentsResponse.UnionStudent unionStudent =
                new MultiLessonsUnionStudentsResponse.UnionStudent();
            unionStudent.setStudentId(student.getId());
            unionStudent.setUserId(student.getUserId());
            unionStudent.setMobile(student.getMobile());
            unionStudent.setName(student.getName());
            unionStudent.setName(StudentNameUtil.buildStudentName(student));
            unionStudent.setPinyinName(student.getPinyin());
            if (student.getPinyin() != null // set initial
                && StringUtils.isNotEmpty(student.getPinyin().trim()) && com.baijia.tianxiao.util.StringUtils
                    .letterValidate(String.valueOf(student.getPinyin().trim().charAt(0)))) {
                unionStudent.setInitial(String.valueOf(student.getPinyin().trim().charAt(0)).toUpperCase());
            } else {
                unionStudent.setInitial("#");
            }
            unionStudent.setAvatarUrl(urlMap.get(student.getId()));
            result.add(unionStudent);
        }
        return result;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteOrgCourseStudentForDelStudent(Long orgId, Long studentId) {
        Long userId = this.orgStudentDao.getUserId(studentId);
        List<Long> courseIds =
            orgStudentCourseDao.getStudentCourseIds(orgId, userId, StudentCourseStatus.NORMAL.getCode());

        for (Long courseId : courseIds) {
            deleteOrgCourseStudent(orgId, courseId, studentId, "学员删除");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteOrgCourseStudent(Long orgId, Long courseId, Long studentId, String cause)
        throws BussinessException {

        log.debug("删除 orgId = {}, courseId = {}, studentId = {} cause = {} ", orgId, courseId, studentId, cause);

        Long userId = this.orgStudentDao.getUserId(studentId);

        if (userId == null) {
            log.error("userId == null, studentId = {}", studentId);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId);

        if (orgCourse == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "班级不存在");
        }
        boolean delLessons = false;

        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {

            orgCourseDao.updateFinish(courseId, 1);

            delLessons = true;
        }
        // 从课程中删除(解绑状态,逻辑删除)
        orgStudentCourseDao.deleteOrgCourseStudent(orgId, courseId, userId, StudentCourseStatus.WITHDRAW.getCode());

        // 从未上完课节删除(解绑状态,逻辑删除
        this.deleteStudentFromCourseLesson(orgId, courseId, userId, delLessons);

        // 从未上完课节删除
        this.orgCourseSmsDao.delCourseSmsRecord(orgId, courseId, UserRole.STUDENT.getRole(),
            Lists.newArrayList(userId));
        // 添加退班标记
        OrgCourseStudentOp orgCourseStudentStatus = new OrgCourseStudentOp();
        orgCourseStudentStatus.setCause(cause);
        orgCourseStudentStatus.setFromCourseId(courseId);
        orgCourseStudentStatus.setStatus(StudentCourseStatus.WITHDRAW.getCode());
        orgCourseStudentStatus.setStudentId(studentId);
        // orgCourseStudentStatus.setToCourseId(toCourseId);
        orgCourseStudentStatus.setOrgId(orgId);
        orgCourseStudentOpDao.save(orgCourseStudentStatus);

    }

    @Override
    public Map<Long, Integer> getCourseStudentCntMap(Long orgId, Collection<Long> courseIds, Boolean tradeComplete) {
        return this.orgStudentCourseDao.getStudentCount(orgId, courseIds, tradeComplete);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void transferOrgCourseStudent(Long orgId, Long studentId, Long fromCourseId, Long toCourseId, String cause)
        throws BussinessException {
        log.debug("course student transfer orgId = {}, from = {}, to = {}, åstudentId = {} cause = {} ", orgId,
            fromCourseId, toCourseId, studentId, cause);
        Long userId = this.orgStudentDao.getUserId(studentId);

        if (userId == null) {
            log.error("userId == null, studentId = {}", studentId);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(fromCourseId);

        if (orgCourse == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "班级不存在");
        }
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "1对1课程不能转班");
        }
        // 从课程中删除
        orgStudentCourseDao.deleteOrgCourseStudent(orgId, fromCourseId, userId, StudentCourseStatus.TRANSFER.getCode());

        // 从未上完课节删除
        this.deleteStudentFromCourseLesson(orgId, fromCourseId, userId, false);

        // 删除短信发送记录

        this.orgCourseSmsDao.delCourseSmsRecord(orgId, fromCourseId, UserRole.STUDENT.getRole(),
            Lists.newArrayList(userId));

        // 添加转班标记
        OrgCourseStudentOp orgCourseStudentStatus = new OrgCourseStudentOp();
        orgCourseStudentStatus.setCause(cause);
        orgCourseStudentStatus.setFromCourseId(fromCourseId);
        orgCourseStudentStatus.setToCourseId(toCourseId);
        orgCourseStudentStatus.setStatus(StudentCourseStatus.TRANSFER.getCode());
        orgCourseStudentStatus.setStudentId(studentId);
        orgCourseStudentStatus.setOrgId(orgId);
        orgCourseStudentOpDao.save(orgCourseStudentStatus);

    }

    /**
     * 学生id和头像url映射
     *
     * @return
     */
    /*
     * private Map<Long, String> getOrgStudentAvatarUrlMap(Collection<Long> usrIds) { Map<Long, String> map =
     * Maps.newHashMap(); if (CollectionUtils.isEmpty(usrIds)) { return map; }
     * 
     * List<Student> students = studentDao.getByUserIds(usrIds, "userId", "avatar");
     * 
     * // log.debug("students = {}", students); Map<Long, Integer> userIdStorageIdMap = Maps.newHashMap();//
     * 学生id到头像id的map
     * 
     * Set<Integer> avatarIds = Sets.newHashSet(); for (Student student : students) { if (student.getAvatar() != null) {
     * avatarIds.add(student.getAvatar()); } userIdStorageIdMap.put(student.getUserId(), student.getAvatar()); } //
     * log.debug("userIdStorageIdMap={}", userIdStorageIdMap); Map<Long, String> storageIdUrlMap = Maps.newHashMap();//
     * 头像id到url的map // log.debug("avatarIds = {}", avatarIds); List<Storage> storages = storageDao.getByIds(avatarIds);
     * for (Storage storage : storages) { storageIdUrlMap.put(storage.getId(),
     * StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn())); } // log.debug(
     * "storageIdUrlMap = {}", storageIdUrlMap);
     * 
     * for (Student student : students) { if (student.getAvatar() != null) { // log.debug("{} -> {} -> {}",
     * student.getUserId(), userIdStorageIdMap.get(student.getUserId()), //
     * storageIdUrlMap.get(userIdStorageIdMap.get(student.getUserId().longValue()))); map.put(student.getUserId(),
     * storageIdUrlMap.get(userIdStorageIdMap.get(student.getUserId()).longValue())); } } return map; }
     */

    @Override
    @Transactional(readOnly = true)
    public List<StudentResponseDto> getOrgCourseStudentList(@NonNull Long orgId, @NonNull Long courseId) {
        List<OrgStudentCourse> courseStudents = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId);
        // log.debug("courseStudents = {}", courseStudents);
        Map<Long, OrgStudentCourse> map = Maps.newHashMap();
        Set<Long> userIds = Sets.newHashSet();
        for (OrgStudentCourse orgStudentCourse : courseStudents) {
            if (orgStudentCourse.getStatus().intValue() == 0) {
                userIds.add(orgStudentCourse.getUserId());
                map.put(orgStudentCourse.getUserId(), orgStudentCourse);
            }
        }

        log.debug("userIds = {}", userIds);
        List<OrgStudent> orgStudents = orgStudentDao.getStudentByUserIds(orgId, userIds);
        Map<Long, String> studentUrlMap = studentApiService.batchGetStudentAvatarUrl(orgStudents);
        // log.debug("studentUrlMap = {}", studentUrlMap);

        OrgCourse orgcourse = orgCourseDao.getByCourseId(courseId);
        if (orgcourse == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程ID不正确");
        }
        List<Long> ids = Lists.newArrayList(userIds);
        Map<Long, StudentCourseBase> baseMap = studentCourseApi.getAllData(ids, courseId, orgId);
        boolean isShow = txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        // 这门课报名的所有学生userId
        Long tempId = 0L;
        if (CourseTypeEnum.IS_CLASS_TRUE.getCode() == orgcourse.getIsClass()
            && CourseTypeEnum.IS_COURSE_FALSE.getCode() == orgcourse.getIsCourse()) {
            tempId = orgcourse.getParentId();
        } else {
            tempId = courseId;
        }
        Map<Long, Object> signupedUserIdsMap = orgSignupCourseDao.getSignupedUserIdsByCourseId(orgId, tempId);
        List<StudentResponseDto> orgStudentCourseResponseDtos = Lists.newLinkedList();
        for (OrgStudent orgStudent : orgStudents) {
            StudentResponseDto studentResponseDto = new StudentResponseDto();
            studentResponseDto.setStatus(map.get(orgStudent.getUserId()).getStatus());
            studentResponseDto.setPinyin(orgStudent.getPinyin());
            buildStudentResponseDto(studentResponseDto, orgStudent, studentUrlMap);
            if (!isShow) {
                studentResponseDto.setMobile(MaskUtil.maskMobile(studentResponseDto.getMobile()));
            }
            if (orgStudent.getPinyin() != null && StringUtils.isNotEmpty(orgStudent.getPinyin().trim())
                && com.baijia.tianxiao.util.StringUtils
                    .letterValidate(String.valueOf(orgStudent.getPinyin().trim().charAt(0)))) {
                studentResponseDto.setInitial(String.valueOf(orgStudent.getPinyin().trim().charAt(0)).toUpperCase());
            } else {
                studentResponseDto.setInitial("#");
            }
            StudentCourseBase base = baseMap.get(orgStudent.getUserId());
            studentResponseDto
                .setRemainClassHour(base != null ? (base.getBuyTime() > base.getLessonNormalTime() ? 1 : 0) : 0);
            studentResponseDto
                .setRemainClassTime(base != null ? (base.getBuyCount() > base.getLessonNormalCount() ? 1 : 0) : 0);
            if (signupedUserIdsMap.containsKey(orgStudent.getUserId())) {
                studentResponseDto.setSignuped(BooleanEnum.TRUE.getStatus());
            } else {
                studentResponseDto.setSignuped(BooleanEnum.FALSE.getStatus());
            }
            orgStudentCourseResponseDtos.add(studentResponseDto);
        }
        // sort by pinyin
        Collections.sort(orgStudentCourseResponseDtos,
            Ordering.usingToString().onResultOf(new Function<StudentResponseDto, String>() {
                @Override
                public String apply(StudentResponseDto input) {
                    return input.getPinyin();
                }
            }));
        // make # last
        List<StudentResponseDto> specialLetter = Lists.newLinkedList();
        Iterator<StudentResponseDto> iter = orgStudentCourseResponseDtos.iterator();
        while (iter.hasNext()) {
            StudentResponseDto dto = iter.next();
            if (dto.getInitial().equals("#")) {
                specialLetter.add(dto);
                iter.remove();
            }
        }
        orgStudentCourseResponseDtos.addAll(specialLetter);
        // log.debug("orgStudentCourseResponseDtos = {}", orgStudentCourseResponseDtos);
        return orgStudentCourseResponseDtos;
    }

    @Override
    @Transactional(readOnly = true)
    public List<StudentResponseDto> getOrgCourseStudentList(Long orgId, Long courseId, String key) {
        List<OrgStudentCourse> courseStudents = this.orgStudentCourseDao.listByCourseId(orgId, courseId,
            StudentCourseStatus.NORMAL.getCode(), DeleteStatus.NORMAL.getValue());
        // log.debug("courseStudents = {}", courseStudents);
        Map<Long, OrgStudentCourse> map = Maps.newHashMap();
        Set<Long> userIds = Sets.newHashSet();
        for (OrgStudentCourse orgStudentCourse : courseStudents) {
            if (orgStudentCourse.getStatus().intValue() == 0) {
                userIds.add(orgStudentCourse.getUserId());
                map.put(orgStudentCourse.getUserId(), orgStudentCourse);
            }
        }
        List<OrgStudent> orgStudents = orgStudentDao.getStudentByUserIds(orgId, userIds);
        Map<Long, String> studentUrlMap = studentApiService.batchGetStudentAvatarUrl(orgStudents);
        // log.debug("studentUrlMap = {}", studentUrlMap);

        boolean isShow = txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        List<StudentResponseDto> orgStudentCourseResponseDtos = Lists.newLinkedList();

        OrgCourse course = orgCourseDao.getByCourseId(courseId);
        // 这门课报名的所有学生userId
        Long tempId = 0L;
        if (CourseTypeEnum.IS_CLASS_TRUE.getCode() == course.getIsClass()
            && CourseTypeEnum.IS_COURSE_FALSE.getCode() == course.getIsCourse()) {
            tempId = course.getParentId();
        } else {
            tempId = courseId;
        }
        Map<Long, Object> signupedUserIdsMap = orgSignupCourseDao.getSignupedUserIdsByCourseId(orgId, tempId);
        List<Long> userIdList = Lists.newArrayList(userIds);
        // 所有已上已排已购
        Map<Long, StudentCourseBase> baseMap = studentCourseApi.getAllData(userIdList, courseId, orgId);

        List<OrgSignupCourse> signupCourseList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(userIds)) {
            signupCourseList = orgSignupCourseDao.searchByUserIdsAndCourseId(userIds, courseId, orgId,
                SignupCourseStatus.inClassStatus);
        }

        Map<Long, List<OrgSignupCourse>> signupCourseMap = getSignupCourseMap(signupCourseList);

        for (OrgStudent orgStudent : orgStudents) {
            StudentResponseDto studentResponseDto = new StudentResponseDto();
            studentResponseDto.setStatus(map.get(orgStudent.getUserId()).getStatus());
            studentResponseDto.setPinyin(orgStudent.getPinyin());
            buildStudentResponseDto(studentResponseDto, orgStudent, studentUrlMap);
            if (!isShow) {
                studentResponseDto.setMobile(MaskUtil.maskMobile(studentResponseDto.getMobile()));
            }
            if (orgStudent.getPinyin() != null && StringUtils.isNotEmpty(orgStudent.getPinyin().trim())
                && com.baijia.tianxiao.util.StringUtils
                    .letterValidate(String.valueOf(orgStudent.getPinyin().trim().charAt(0)))) {
                studentResponseDto.setInitial(String.valueOf(orgStudent.getPinyin().trim().charAt(0)).toUpperCase());
            } else {
                studentResponseDto.setInitial("#");
            }
            studentResponseDto.setChargeUnit(course.getChargeUnit());
            if (signupedUserIdsMap.containsKey(orgStudent.getUserId())) {
                studentResponseDto.setSignuped(BooleanEnum.TRUE.getStatus());
            } else {
                studentResponseDto.setSignuped(BooleanEnum.FALSE.getStatus());
            }
            StudentCourseBase base = baseMap.get(orgStudent.getUserId());
            studentResponseDto.setFinishedLessons(base != null ? base.getFinishCount() : 0);
            studentResponseDto.setArrangedLessons(base != null ? base.getLessonCount() : 0);
            studentResponseDto.setPaidLessons(base != null ? base.getBuyCount() : 0);
            studentResponseDto.setFinishedMinutes(base != null ? base.getFinishTime() : 0);
            studentResponseDto.setArrangedMinutes(base != null ? base.getLessonTime() : 0);
            studentResponseDto.setMinusSign(BooleanEnum.FALSE.getStatus());
            List<OrgSignupCourse> temp = signupCourseMap.get(orgStudent.getUserId());
            log.debug("-------------OrgSignupCourse list={}", temp);
            boolean flag = false; // 默认代表没有学员在新数据下购买直接入班的班级
            if (CollectionUtils.isNotEmpty(temp) && temp.size() > 0) {
                // 历史数据，不管报名还是直接入班的
                for (OrgSignupCourse signupCourse : temp) {
                    if (signupCourse.getLessonCount().intValue() == 0) {
                        flag = true;
                    }
                }
                if (flag) {
                    studentResponseDto.setMinusSign(BooleanEnum.TRUE.getStatus());
                }
            }
            studentResponseDto.setPaidMinutes(base != null ? base.getBuyTime() : 0);
            studentResponseDto
                .setRemainClassHour(base != null ? (base.getBuyTime() > base.getLessonNormalTime() ? 1 : 0) : 0);
            studentResponseDto
                .setRemainClassTime(base != null ? (base.getBuyCount() > base.getLessonNormalCount() ? 1 : 0) : 0);

            orgStudentCourseResponseDtos.add(studentResponseDto);
        }
        // sort by pinyin
        Collections.sort(orgStudentCourseResponseDtos,
            Ordering.usingToString().onResultOf(new Function<StudentResponseDto, String>() {
                @Override
                public String apply(StudentResponseDto input) {
                    return input.getPinyin();
                }
            }));
        // make # last
        List<StudentResponseDto> specialLetter = Lists.newLinkedList();
        Iterator<StudentResponseDto> iter = orgStudentCourseResponseDtos.iterator();
        while (iter.hasNext()) {
            StudentResponseDto dto = iter.next();
            if (dto.getInitial().equals("#")) {
                specialLetter.add(dto);
                iter.remove();
            }
        }
        orgStudentCourseResponseDtos.addAll(specialLetter);

        if (StringUtils.isNotEmpty(key)) {// search
            Iterator<StudentResponseDto> filter = orgStudentCourseResponseDtos.iterator();
            StudentResponseDto dto;
            while (filter.hasNext()) {
                dto = filter.next();
                if (!dto.getPinyin().contains(key.trim()) && !dto.getName().contains(key.trim())
                    && !dto.getMobile().contains(key.trim())) {
                    filter.remove();
                }
            }
        }
        return orgStudentCourseResponseDtos;
    }

    @Override
    @Transactional(readOnly = true)
    public List<StudentResponseDto> getLessonsStudentList(@NonNull Long orgId, @NonNull Long courseId,
        @NonNull List<Long> lessonIds) {
        List<Long> studentUserIds = orgStudentLessonDao.getUserIdsByLessonIds(orgId, lessonIds);

        Set<Long> idSet = new HashSet<Long>(studentUserIds);
        List<OrgStudent> orgStudents = orgStudentDao.getStudentByUserIds(orgId, idSet);

        Map<Long, String> studentUrlMap = studentApiService.batchGetStudentAvatarUrl(orgStudents);

        boolean isShow = txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        List<StudentResponseDto> orgStudentCourseResponseDtos = Lists.newArrayList();
        for (OrgStudent orgStudent : orgStudents) {
            StudentResponseDto studentResponseDto = new StudentResponseDto();
            buildStudentResponseDto(studentResponseDto, orgStudent, studentUrlMap);
            if (!isShow) {
                studentResponseDto.setMobile(MaskUtil.maskMobile(studentResponseDto.getMobile()));
            }
            orgStudentCourseResponseDtos.add(studentResponseDto);
        }
        return orgStudentCourseResponseDtos;
    }

    @Override
    @Transactional(readOnly = true)
    public List<OrgStudentsChooseListDto> getStudentChooseList(@NonNull Long orgId, @NonNull Long courseId, String key,
        PageDto page) {
        // 获取已选本课程的学生的UserIds,没有转班退班
        Set<Long> userIds = Sets.newHashSet();
        if (courseId != null && courseId > 0) {
            List<Long> userIdList = this.orgStudentCourseDao.getStudents(orgId, courseId, 0);
            log.debug("userIdList= {}", userIdList);
            userIds.addAll(userIdList);
        }

        List<OrgStudent> students =
            this.orgStudentDao.getStudentsNotInUserIds(orgId, userIds, key, DeleteStatus.NORMAL.getValue(), page);
        log.debug("students= {}", students);
        List<OrgStudentsChooseListDto> chooseList = Lists.newLinkedList();

        List<Long> studentUserIds = Lists.newArrayList();
        for (OrgStudent stu : students) {
            studentUserIds.add(stu.getUserId().longValue());
        }

        Map<Long, String> studentAvatarUrlMap = studentApiService.batchGetStudentAvatarUrl(students);

        boolean isMaskMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());

        log.debug("studentAvatarUrlMap= {}", studentAvatarUrlMap);
        for (OrgStudent stu : students) {
            OrgStudentsChooseListDto dto = new OrgStudentsChooseListDto();
            dto.setStudentId(stu.getId());
            dto.setMobile(stu.getMobile());
            if (!isMaskMobile) {
                dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
            }
            dto.setIsChosen(userIds.contains(stu.getUserId()));
            dto.setName(StudentNameUtil.buildStudentName(stu));
            dto.setPinyinName(stu.getPinyin());
            dto.setAvatarUrl(studentAvatarUrlMap.get(stu.getId()));
            dto.setOpenId(stu.getWeixin());

            if (stu.getPinyin() != null && StringUtils.isNotEmpty(stu.getPinyin().trim())
                && com.baijia.tianxiao.util.StringUtils
                    .letterValidate(String.valueOf(stu.getPinyin().trim().charAt(0)))) {
                dto.setInitial(String.valueOf(stu.getPinyin().trim().charAt(0)).toUpperCase());
            } else {
                dto.setInitial("#");
            }

            chooseList.add(dto);
        }

        return chooseList;
    }

    @Override
    @Transactional(readOnly = true)
    public List<OrgStudentsChooseListDto> getAllStudentChooseList(@NonNull Long orgId, @NonNull Long courseId,
        String key, PageDto page) {
        // 获取已选本课程的学生的UserIds,没有转班退班
        Set<Long> userIds = Sets.newHashSet();
        if (courseId != null && courseId > 0) {
            List<Long> userIdList = this.orgStudentCourseDao.getStudents(orgId, courseId, 0);
            log.debug("userIdList= {}", userIdList);
            userIds.addAll(userIdList);
        }

        List<OrgStudent> students =
            this.orgStudentDao.getStudentsUserIdsSortedByPinyin(orgId, key, DeleteStatus.NORMAL.getValue(), page);
        log.debug("students= {}", students);
        List<OrgStudentsChooseListDto> chooseList = Lists.newLinkedList();

        List<Long> studentUserIds = Lists.newArrayList();
        for (OrgStudent stu : students) {
            studentUserIds.add(stu.getUserId().longValue());
        }

        Map<Long, String> studentAvatarUrlMap = studentApiService.batchGetStudentAvatarUrl(students);

        boolean isMaskMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());

        log.debug("studentAvatarUrlMap= {}", studentAvatarUrlMap);
        for (OrgStudent stu : students) {
            OrgStudentsChooseListDto dto = new OrgStudentsChooseListDto();
            dto.setStudentId(stu.getId());
            dto.setMobile(stu.getMobile());
            if (!isMaskMobile) {
                dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
            }
            dto.setIsChosen(userIds.contains(stu.getUserId()));
            dto.setName(StudentNameUtil.buildStudentName(stu));
            dto.setPinyinName(stu.getPinyin());
            dto.setAvatarUrl(studentAvatarUrlMap.get(stu.getId()));
            dto.setOpenId(stu.getWeixin());

            if (stu.getPinyin() != null && StringUtils.isNotEmpty(stu.getPinyin().trim())
                && com.baijia.tianxiao.util.StringUtils
                    .letterValidate(String.valueOf(stu.getPinyin().trim().charAt(0)))) {
                dto.setInitial(String.valueOf(stu.getPinyin().trim().charAt(0)).toUpperCase());
            } else {
                dto.setInitial("#");
            }

            chooseList.add(dto);
        }
        return chooseList;
    }

    private String getShowMobile(OrgStudent stu) {
        if (StringUtils.isNotBlank(stu.getShowMobile()) && !stu.getShowMobile().contains("*")) {
            return stu.getShowMobile();
        }
        return stu.getMobile();
    }

    /**
     * 把学生从课程的未上课节中删除
     *
     * @param orgId
     * @param courseId
     */
    private void deleteStudentFromCourseLesson(Long orgId, Long courseId, Long userId, boolean delLesson) {
        List<Long> leftLessonIds = this.orgClassLessonDao.getLeftLessonIds(orgId, courseId);
        log.info("leftLessonIds = {}", leftLessonIds);
        this.orgStudentLessonDao.delStudentFromLesson(orgId, leftLessonIds, userId);
        // 签到记录也删除
        Map<String, Object> condition = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(leftLessonIds)) {
            condition.put("lessonId", leftLessonIds);
            condition.put("userId", userId);
            condition.put("orgId", orgId);
            this.orgLessonSignDao.delByCondition(condition);
        }

        if (delLesson) {
            orgClassLessonDao.updateDelByLessonIds(orgId, leftLessonIds);
            orgLessonConflictService.delByLessonIds(orgId, leftLessonIds);
        }

    }

    private void buildStudentResponseDto(StudentResponseDto studentResponseDto, OrgStudent orgStudent,
        Map<Long, String> urlMap) {
        studentResponseDto.setStudentId(orgStudent.getId());
        studentResponseDto.setMobile(orgStudent.getMobile());
        studentResponseDto.setWeixin(orgStudent.getWeixin());
        studentResponseDto.setName(StudentNameUtil.buildStudentName(orgStudent));
        studentResponseDto.setAvatarUrl(urlMap.get(orgStudent.getId()));
    }

    public static void main(String[] args) {
        Double numValueFromStr = GenericsUtils.getNumValueFromStr(Double.class, "123.45");
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        String value = decimalFormat.format(numValueFromStr);
        System.out.println(value);
    }

    @Override
    @Transactional(readOnly = true)
    public CourseStudentDetailDto getCourseStudentDetail(@NonNull Long orgId, @NonNull Long classId,
        @NonNull Long studentId) {
        CourseStudentDetailDto detailDto = new CourseStudentDetailDto();
        OrgCourse orgCourse = this.orgCourseDao.getById(classId);
        OrgStudent orgStudent = this.orgStudentDao.getById(studentId);
        if (orgStudent == null) {
            log.error("student{} not exist!", studentId);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        if(orgCourse == null){
            log.error("course not exist!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        List<Long> singleUserIdList = Arrays.asList(orgStudent.getUserId());
        List<Long> singleClassIdList = Arrays.asList(classId);

        //设置课程信息
        List<OrgStudentCourse> studentCourseList = this.orgStudentCourseDao.getByCourseIdsStudentId(orgId,
                singleClassIdList, singleUserIdList, null, DeleteStatus.NORMAL.getValue());
        log.info("OrgStudentCourse are :{} ", studentCourseList);
        if (GenericsUtils.notNullAndEmpty(studentCourseList)) {
            OrgStudentCourse osc = studentCourseList.get(0);
            detailDto.setStatus(osc.getStatus());
        }
        fillOrgCourseInfo(orgCourse,detailDto);
        //设置学员信息
        fillStudentInfo(orgId,orgStudent,detailDto);

        // 设置课消规则信息
        Long courseId = classId;
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            courseId = orgCourse.getParentId();
        }
        Integer consumeRule = orgCourseConsumeRuleService.getRuleValueByCourseId(orgId, courseId);
        fillConsumeRule(consumeRule,detailDto);
        OrgStudentCourse orgStudentCourse = orgStudentCourseDao.getStudentCourse(orgId, classId, orgStudent.getUserId());
        appendQuitClassInfo(orgStudentCourse,detailDto);

        // 设置统计数据
        Collection<? extends KexiaoStatisticsSuper> studentRequest = Arrays.asList(detailDto);
        this.studentKexiaoStatisticsApiService.fillStudentKeXiaoStatistics(orgId, studentRequest, 3);
        if (detailDto.isCurrentCourseCanSetInfo()) {
            if (detailDto.getRemainTuition() == null) {
                detailDto.setRemainTuition("0.00");
            }
        } else {
            detailDto.setRemainTuition("--");
        }

        List<OrgStudentLesson> studentLessons = orgStudentLessonDao.getByCourseIdsUserIds(orgId,singleClassIdList, singleUserIdList);
        if(studentLessons==null || studentLessons.size()<1){
            log.info("[StudentLesson] No lesson info.orgId={},studentId={},courseId={}",orgId,studentId,classId);
            return detailDto;
        }

        //设置是否能排正价课
        setScheduleStatus(orgId,singleUserIdList,classId,detailDto);

        //设置课节详情信息
        List<Long> lessonIds = ListUtil.toKeyList(studentLessons, "lessonId", OrgStudentLesson.class);
        Map<Long, OrgClassLesson> lessonMap = orgClassLessonDao.getClassLessonMap(orgId, lessonIds, 0);
        List<OrgLessonSign> orgLessonSign = getStuLessonSignList(orgId,orgStudent.getUserId(),studentLessons,lessonMap);
        log.info("orgLessonSign = {}, orgId = {}, courseId ={},  userId = {}", orgLessonSign, orgId, classId,
            orgStudent.getUserId());
        Map<Long, OrgStudentLesson> orgStudentLessonMap = CollectionHelper.toKeyMap(studentLessons, "lessonId");
        List<ClassLessonInfoDto> lessons = getLessonDtoList(orgLessonSign,lessonMap,orgStudentLessonMap,consumeRule);
        Map<Long, KexiaoStatisticss> kexiaoStatMap =
                OrgStudentKexiaoRecordDao.findLessonKexiaoStatistics(orgId, singleUserIdList, lessonMap.keySet());
        setTipInfo(kexiaoStatMap,lessons,detailDto.isCurrentCourseCanSetInfo(),detailDto.isHasSignupCourseRecord());
        detailDto.setLessons(lessons);

        return detailDto;
    }

    private void fillOrgCourseInfo(OrgCourse orgCourse,CourseStudentDetailDto detailDto){
        detailDto.setCourseType(orgCourse.getCourseType().intValue());
        detailDto.setParentCourseId(orgCourse.getParentId());
        detailDto.setCourseName(orgCourse.getName());
        detailDto.setCourseId(orgCourse.getId());
        detailDto.setChargeUnit(orgCourse.getChargeUnit());
    }

    private void fillConsumeRule(Integer consumeRule,CourseStudentDetailDto detailDto){
        detailDto.setConsumeRule(consumeRule);
        detailDto.setConsumeRuleStr(CourseConsumeRuleEnum.getRuleDescByValue(consumeRule));
    }

    private void appendQuitClassInfo(OrgStudentCourse orgStudentCourse,CourseStudentDetailDto detailDto){
        if (orgStudentCourse.getStatus() != 0) {
            detailDto.setConsumeRuleStr(detailDto.getConsumeRuleStr() + " (以下是退班时已结束的课节列表)");
        }
    }

    private void fillStudentInfo(Long orgId,OrgStudent orgStudent,CourseStudentDetailDto detailDto){
        boolean isShow = txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        log.debug("orgStudent = {}", orgStudent);
        detailDto.setStudentId(orgStudent.getId());
        detailDto.setUserId(orgStudent.getUserId());
        detailDto.setStudentName(StudentNameUtil.buildStudentName(orgStudent));
        detailDto.setMobile(orgStudent.getMobile());
        if (!isShow) {
            detailDto.setMobile(MaskUtil.maskMobile(detailDto.getMobile()));
        }
        List<OrgStudent> orgStudents = Lists.newArrayList();
        orgStudents.add(orgStudent);
        Map<Long, String> mapUrl = studentApiService.batchGetStudentAvatarUrl(orgStudents);
        detailDto.setAvatarUrl(mapUrl.get(orgStudent.getId()));
    }

    private List<OrgLessonSign> getStuLessonSignList(Long orgId,Long userId,List<OrgStudentLesson> studentLessons,Map<Long, OrgClassLesson> lessonMap){
        List<OrgLessonSign> lessonSigns = new ArrayList<>();
        List<Long> lessonIds = ListUtil.toKeyList(studentLessons, "lessonId", OrgStudentLesson.class);
        List<OrgLessonSign> signedLesson =
                this.orgLessonSignDao.getStudentSign(orgId, userId, UserRoleEnum.STUDENT.getCode(), lessonIds);
        Map<Long,OrgLessonSign> signMap = CollectionHelper.toKeyMap(signedLesson, "lessonId");
        for (OrgStudentLesson studentLesson:studentLessons){
            OrgLessonSign lessonSign = new OrgLessonSign();
            lessonSign.setLessonId(studentLesson.getLessonId());
            lessonSign.setOrgId(studentLesson.getOrgId());
            if(signMap.get(studentLesson.getLessonId())!=null){
                lessonSign.setStatus(signMap.get(studentLesson.getLessonId()).getStatus());
            }
            if(lessonMap.get(studentLesson.getLessonId())!=null){
                lessonSign.setIndex(lessonMap.get(studentLesson.getLessonId()).getNumber());
            }
            lessonSigns.add(lessonSign);
        }
        return lessonSigns;
    }

    private List<ClassLessonInfoDto> getLessonDtoList(List<OrgLessonSign> orgLessonSign,
                                                      Map<Long, OrgClassLesson> lessonMap,
                                                      Map<Long, OrgStudentLesson> orgStudentLessonMap,
                                                      int rule){
        List<ClassLessonInfoDto> lessons = Lists.newArrayList();
        for (OrgLessonSign sign : orgLessonSign) {
            ClassLessonInfoDto lessonDto = new ClassLessonInfoDto();
            OrgClassLesson orgClassLesson = lessonMap.get(sign.getLessonId());
            OrgStudentLesson orgStudentLesson = orgStudentLessonMap.get(sign.getLessonId());
            lessonDto.setStatus(sign.getStatus() == null ? 0 : sign.getStatus());
            if (orgClassLesson != null) {
                lessonDto.setStartTime(orgClassLesson.getStartTime());
                lessonDto.setEndTime(orgClassLesson.getEndTime());
                lessonDto.setLessonName(orgClassLesson.getName());
            } else {
                continue;
            }
            lessonDto.setLessonId(sign.getLessonId());
            if (orgStudentLesson != null) {
                lessonDto.setLessonType(orgStudentLesson.getLessonType());
            }
            lessonDto.setIndex(sign.getIndex());
            if(rule>0){
                lessonDto.setKexiaoStatus(kexiaoApiService.getKexiaoStatus(sign,rule).getStatus());
            }else {
                lessonDto.setKexiaoStatus(kexiaoApiService.getKexiaoStatus(orgClassLesson.getStartTime()).getStatus());
            }

            lessons.add(lessonDto);
        }
        Collections.sort(lessons, new Comparator<ClassLessonInfoDto>() {
            @Override
            public int compare(ClassLessonInfoDto o1, ClassLessonInfoDto o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
        return lessons;
    }

    private void setTipInfo(Map<Long, KexiaoStatisticss> kexiaoStatMap,
                            List<ClassLessonInfoDto> lessonDtos,
                            boolean canSetInfo,
                            boolean isHasSignupCourseRecord){
        for (ClassLessonInfoDto dto:lessonDtos){
            KexiaoStatisticss stat = kexiaoStatMap.get(dto.getLessonId());
            createTipInfo(dto, stat, canSetInfo,isHasSignupCourseRecord);
        }
    }

    private void setScheduleStatus(Long orgId,List<Long> userIds,Long classId,CourseStudentDetailDto detailDto){
        Map<Long,StudentCourseBase> baseMap = studentCourseApi.getNormalData(userIds,classId,orgId);
        if (detailDto.isCurrentCourseCanSetInfo()){
            StudentCourseBase base = baseMap.get(detailDto.getUserId());
            log.info("[StudentLesson] StudentCourseBase={},CourseStudentDetailDto={}",base,detailDto);
            if(ChargeUnit.isByTime(detailDto.getChargeUnit())){
                if (base!=null && detailDto.getBuyCount()<=base.getLessonNormalTime()){
                    detailDto.setScheduleStatus(LessonType.FREE.getCode());
                }
            }else{
                if (base!=null && detailDto.getBuyCount()<=base.getLessonNormalCount()){
                    detailDto.setScheduleStatus(LessonType.FREE.getCode());
                }
            }
        }
    }

    /**
     * @param lessonDto
     * @param kexiaoStatisticss
     * @param isCanSetKexiaoInfo
     * @param
     * @return
     */
    private void createTipInfo(ClassLessonInfoDto lessonDto, KexiaoStatisticss kexiaoStatisticss,
        boolean isCanSetKexiaoInfo, boolean hasSignupCourseRecord) {
        log.info("lessonDto is:{} and kexiaoStatistics is:{} ", lessonDto, kexiaoStatisticss);
        String kexiaoMoney = "0.00";
        String tipInfo = "";
        if (kexiaoStatisticss == null && lessonDto.getStartTime() != null
            && (lessonDto.getStartTime().getTime() > System.currentTimeMillis())) {
            tipInfo = KexiaoReason.NOT_START.getReason();
        } else {
            if (!hasSignupCourseRecord) {
                tipInfo = KexiaoReason.NO_SIGNUP_INFO.getReason();
            } else if (!isCanSetKexiaoInfo) {
                tipInfo = KexiaoReason.SIGNUP_INFO_LOST.getReason();
            } else if (lessonDto.getStatus() == 1 || kexiaoStatisticss != null) {
                if (kexiaoStatisticss != null) {
                    Integer lssonType = kexiaoStatisticss.getLessonType();
                    if (lssonType == 2) {
                        tipInfo = KexiaoReason.GIVEN_COURSE.getReason();
                    } else {
                        kexiaoMoney = kexiaoStatisticss.getKexiaoMoneyStr();
                    }
                }
            } else if(lessonDto.getKexiaoStatus() == LessonStatus.FINISHED.getStatus()){//课消计算延迟
                tipInfo = KexiaoReason.DELAY_COMPUTE.getReason();
            }else if (lessonDto.getStatus() == 0) {
                tipInfo = KexiaoReason.NOT_SIGNIN.getReason();
            } else if (lessonDto.getStatus() == 2) {
                tipInfo = KexiaoReason.ASKED_FOR_LEAVE.getReason();
            } else if (lessonDto.getStatus() == 3) {
                tipInfo = KexiaoReason.NOT_PRESENT.getReason();
            } else {
                tipInfo = KexiaoReason.OTHER_INFOS.getReason();
            }
        }
        lessonDto.setKexiaoMoney(kexiaoMoney);
        lessonDto.setTipInfo(tipInfo);
    }

    @Override
    @Transactional(readOnly = true)
    public List<OrgStudentsChooseListDto> getLessonStudent(@NonNull Long orgId, @NonNull Long lessonId,
        boolean needSignStatus) {
        LinkedList<OrgStudentsChooseListDto> chooseList = Lists.newLinkedList();
        // 获取已选本课节的学生的UserIds
        List<Long> userIdList = this.orgStudentLessonDao.getUserIds(lessonId, orgId);
        Set<Long> userIds = Sets.newHashSet(userIdList);

        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        // 退转班的学生
        Map<Long, Integer> uIdStatusWithdrawMap =
            orgStudentCourseDao.userMapByStatus(orgId, orgClassLessonDao.getById(lessonId, "courseId").getCourseId(),
                userIds, Arrays.asList(StudentCourseStatus.WITHDRAW.getCode(), StudentCourseStatus.TRANSFER.getCode()));

        Map<Long, OrgStudent> studentMap = orgStudentDao.getStudentMap(userIds, orgId);
        Map<Long, String> studentAvatarUrlMap = studentApiService.batchGetStudentAvatarUrl(studentMap.values());

        Map<Long, OrgLessonSign> studentSignMap = Maps.newHashMap();
        if (needSignStatus) {
            List<OrgLessonSign> lessonSigns =
                orgLessonSignDao.getLessonSignList(orgId, null, lessonId, null, UserRole.STUDENT.getRole(), null, true,
                    null, null, "userId", "status", "updateTime", "signRemark", "sendToStu");
            for (OrgLessonSign lessonSign : lessonSigns) {
                studentSignMap.put(lessonSign.getUserId(), lessonSign);
            }
        }

        log.debug("student avatar:{}", studentAvatarUrlMap);
        for (OrgStudent stu : studentMap.values()) {
            OrgStudentsChooseListDto dto = new OrgStudentsChooseListDto();
            dto.setStudentId(stu.getId());
            dto.setUserId(stu.getUserId());
            dto.setMobile(stu.getMobile());
            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
            }
            dto.setIsChosen(userIds.contains(stu.getUserId()));
            dto.setName(StudentNameUtil.buildStudentName(stu));
            dto.setPinyinName(stu.getPinyin());

            if (stu.getPinyin() != null // set initial
                && StringUtils.isNotEmpty(stu.getPinyin().trim()) && com.baijia.tianxiao.util.StringUtils
                    .letterValidate(String.valueOf(stu.getPinyin().trim().charAt(0)))) {
                dto.setInitial(String.valueOf(stu.getPinyin().trim().charAt(0)).toUpperCase());
            } else {
                dto.setInitial("#");
            }

            dto.setAvatarUrl(studentAvatarUrlMap.get(stu.getId()));
            OrgLessonSign lessonSign = studentSignMap.get(stu.getUserId());
            if (lessonSign != null) {
                dto.setStudentSignStatus(SignStatus.getSignStatusByCode(lessonSign.getStatus()));
                dto.setSignInTime(lessonSign.getUpdateTime());
            } else {
                dto.setStudentSignStatus(SignStatus.UNSIGN);
            }
            dto.setSignRemark(lessonSign != null ? lessonSign.getSignRemark() : "");
            dto.setSendToStu(lessonSign != null ? lessonSign.getSendToStu() : 0);
            Integer status = uIdStatusWithdrawMap.get(stu.getUserId());
            dto.setStatus(null == status ? StudentCourseStatus.NORMAL.getCode() : status);
            chooseList.add(dto);
        }
        Collections.sort(chooseList, new Comparator<OrgStudentsChooseListDto>() {
            @Override
            public int compare(OrgStudentsChooseListDto o1, OrgStudentsChooseListDto o2) {
                if (o1.getSignStatus() == null) {
                    o1.setStudentSignStatus(SignStatus.UNSIGN);
                }
                if (o2.getSignStatus() == null) {
                    o2.setStudentSignStatus(SignStatus.UNSIGN);
                }
                return o1.getSignStatus().compareTo(o2.getSignStatus());
            }
        });
        Iterator<OrgStudentsChooseListDto> iter = chooseList.iterator();
        List<OrgStudentsChooseListDto> backList = Lists.newLinkedList();
        while (iter.hasNext()) {
            OrgStudentsChooseListDto next = iter.next();
            if (next.getStatus() != StudentCourseStatus.NORMAL.getCode()) {
                backList.add(next);
                iter.remove();
            }
        }
        for (OrgStudentsChooseListDto dto : backList) {
            chooseList.addLast(dto);
        }
        return chooseList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int delLessonStudent(Long orgId, Long lessonId, Long studentId) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(studentId != null && studentId > 0, "studentId is illegal");
        Preconditions.checkArgument(lessonId != null && lessonId > 0, "lessonId is illegal");

        Long userId = orgStudentDao.getUserId(studentId);

        OrgClassLesson lesson = orgClassLessonDao.getById(lessonId);

        if (lesson == null) {
            log.warn("can not found lesson by lessonId:{}", lessonId);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节ID不正确");
        }

        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(lesson.getCourseId());

        if (orgCourse == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "班级不存在");
        }
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "1对1课程不能删除学生");
        }
        // TODO 建议后续加上课节时间判断,如果是已经结束课节,不让删除学生

        boolean isSign = orgLessonSignDao.isStudentSignInLesson(orgId, lessonId, userId);
        if (isSign) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "该学生已签到不能删除");
        }
        OrgLessonComment comment =
            orgLessonCommentDao.getLessonCommentDetail(lessonId, userId, UserRole.STUDENT.getRole(), false, "id");

        if (comment != null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "该学生已经进行了评价,不能删除");
        }

        List<Long> lessonIds = Lists.newArrayList();
        lessonIds.add(lessonId);
        orgStudentLessonDao.delStudentFromLesson(orgId, lessonIds, userId);
        signupCourseLessonService.deleteStudentLessons(orgId, Arrays.asList(userId), lessonIds);
        return lessonIds.size();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int deleteStudentFromLesson(Long orgId, Long lessonId, Collection<Long> userIds) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(lessonId != null && lessonId > 0, "lessonId is illegal");

        OrgClassLesson lesson = orgClassLessonDao.getById(lessonId, "startTime", "endTime");
        if (lesson == null) {
            log.warn("can not found lesson by lessonId:{}", lessonId);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节ID不正确");
        }
        // TODO 建议后续加上课节时间判断,如果是已经结束课节,不让删除学生
        Map<String, Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonId);
        if (CollectionUtils.isNotEmpty(userIds)) {
            condition.put("userId", userIds);
        }
        signupCourseLessonService.deleteStudentLessons(orgId, userIds, Arrays.asList(lessonId));
        return orgStudentLessonDao.delStudentFromLesson(orgId, Arrays.asList(lessonId), userIds);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addStudentToLesson(Long orgId, Long courseId, Long lessonId, Collection<Long> studentIds,
        boolean isStudentId) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        // Preconditions.checkArgument(courseId != null && courseId > 0, "courseId is illegal");
        Preconditions.checkArgument(lessonId != null && lessonId > 0, "lessonId is illegal");
        if (CollectionUtils.isEmpty(studentIds)) {
            log.warn("add student ids is empty");
            return;
        }
        if (isStudentId) {
            Map<Long, Long> userIdMap = orgStudentDao.getStudentIdUserIdMap(studentIds);
            if (MapUtils.isEmpty(userIdMap)) {
                log.warn("add student ids is empty");
                return;
            }
            studentIds = userIdMap.values();
        }
        OrgClassLesson lesson = orgClassLessonDao.getById(lessonId, "courseId", "orgId", "startTime", "endTime");
        if (courseId == null) {
            Preconditions.checkArgument(lesson != null && lesson.getOrgId().equals(orgId), "课节ID不正确");
            courseId = lesson.getCourseId();
        }

        List<Long> courseStudents = orgStudentCourseDao.getStudents(orgId, courseId, 0);
        if (!courseStudents.containsAll(studentIds)) {
            log.warn("lesson students:{} is not all course students ids:{}", studentIds, courseStudents);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "必须从课程学生中添加课节学生");
        }

        List<Long> lessonIds = Lists.newArrayList(lessonId);
        Map<Long, List<Long>> lessonStudentIds = orgStudentLessonDao.getLessonStudentList(lessonIds);
        List<OrgStudentLesson> delLessonStudent = orgStudentLessonDao.getLessonStudentListDelStatus(lessonIds);
        Map<String, OrgStudentLesson> lesseonStudentMap = Maps.newHashMap();
        for (OrgStudentLesson orgStudentLesson : delLessonStudent) {
            String tempKey = orgStudentLesson.getUserId() + "|" + orgStudentLesson.getLessonId();
            lesseonStudentMap.put(tempKey, orgStudentLesson);
        }
        if (lessonStudentIds.containsKey(lessonId)) {
            List<Long> addedStuIds = lessonStudentIds.get(lessonId);
            if (CollectionUtils.isNotEmpty(addedStuIds)) {
                studentIds.removeAll(addedStuIds);
            }
        }
        List<OrgStudentLesson> saveStudentLessons = Lists.newArrayList();
        List<OrgStudentLesson> updateStudentLessons = Lists.newArrayList();
        OrgStudentLesson po = null;
        int lessonDuration = DateUtil.getMinuteDiff(lesson.getStartTime(), lesson.getEndTime());
        for (Long studentId : studentIds) {
            po = new OrgStudentLesson();
            po.setCreateTime(new Date());
            po.setLessonId(lessonId);
            po.setOrgId(orgId);
            po.setUserId(studentId);
            po.setCourseId(courseId);
            po.setLessonDuration(lessonDuration);
            String tempKey = studentId + "|" + lessonId;
            if (lesseonStudentMap.containsKey(tempKey)) {
                OrgStudentLesson tempStudentLesson = lesseonStudentMap.get(tempKey);
                po.setId(tempStudentLesson.getId());
                po.setDelStatus(0);
                po.setStartStatus(0);
                po.setCourseId(courseId);
                updateStudentLessons.add(po);
            } else {
                saveStudentLessons.add(po);
            }

        }

        log.info("save students :{} to lessonid:{}", saveStudentLessons, lessonId);
        if (CollectionUtils.isNotEmpty(saveStudentLessons)) {
            signupCourseLessonService.saveSignupCourseLessons(orgId, courseId, saveStudentLessons);
            orgStudentLessonDao.saveAll(saveStudentLessons, false, "courseId", "createTime", "lessonId", "orgId",
                "userId", "lessonType", "lessonDuration", "kexiaoDuration");
        }
        for (OrgStudentLesson updateStudentLesson : updateStudentLessons) {
            orgStudentLessonDao.update(updateStudentLesson, "createTime", "delStatus", "startStatus", "courseId");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void resetLessonStudent(Long orgId, Long courseId, Long lessonId, Collection<Long> studentIds) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(courseId != null && courseId > 0, "courseId is illegal");
        Preconditions.checkArgument(lessonId != null && lessonId > 0, "lessonId is illegal");
        // if (CollectionUtils.isEmpty(studentIds)) {
        // log.warn("add student ids is empty");
        // return;
        // }
        deleteStudentFromLesson(orgId, lessonId, null);
        Map<Long, Long> userIdMap = orgStudentDao.getStudentIdUserIdMap(studentIds);
        if (MapUtils.isEmpty(userIdMap)) {
            log.warn("add student ids is empty");
            return;
        }
        Collection<Long> userIds = userIdMap.values();
        // 清除课节中的学生信息
        // 添加学生到课节
        addStudentToLesson(orgId, courseId, lessonId, userIds, false);
    }

    @Override
    @Transactional(readOnly = true)
    public List<Long> getStudentLessonIds(@NonNull Long orgId, @NonNull Long studentId) {
        Long userId = this.orgStudentDao.getUserId(studentId);
        if (userId == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "student not found!");
        }
        return orgStudentLessonDao.getLessonIdsOfStudent(orgId, userId);
    }

    @Override
    @Transactional(readOnly = true)
    public List<Long> getCourseStudentUserIdsByOrgIdCourseId(Long orgId, Long courseId) {
        return this.orgStudentCourseDao.getStudents(orgId, courseId, StudentCourseStatus.NORMAL.getCode());
    }

    @Override
    @Transactional(readOnly = true)
    public Map<String, String> getStudentNameAndAvatar(Long orgId, Long studentId) {

        // Long userId = this.orgStudentDao.getUserId(studentId);

        OrgStudent orgStudent = this.orgStudentDao.getById(studentId);
        // log.debug("getStudentNameAndAvatar orgStudent ={},orgId={},studentId={}",orgStudent,orgId,studentId);
        Preconditions.checkArgument(
            orgStudent != null && orgStudent.getUserId() > 0 && orgStudent.getOrgId().longValue() == orgId,
            "student not found!");
        List<OrgStudent> orgStudents = Lists.newArrayList();
        orgStudents.add(orgStudent);
        Map<Long, String> urlMap = studentApiService.batchGetStudentAvatarUrl(orgStudents);
        String avatarUrl = urlMap.get(orgStudent.getId());
        Map<String, String> map = Maps.newHashMap();

        map.put("name", orgStudent != null ? orgStudent.getName() : "");
        map.put("avatarUrl", avatarUrl);
        // log.debug("getStudentNameAndAvatar map ={},orgId={},studentId={}",map,orgId,studentId);
        return map;
    }

    @Override
    @Transactional(readOnly = true)
    public Map<String, Integer> getStudentCourseLessonInfo(Long orgId, Long studentId) {
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument(userId != null && userId > 0, "student not exists!");
        Map<String, Integer> map = Maps.newHashMap();

        List<Long> courseIds =
            this.orgStudentCourseDao.getStudentCourseIds(orgId, userId, StudentCourseStatus.NORMAL.getCode());
        Integer courseCount = 0;
        OrgAccount orgAccount = this.orgAccountDao.getById(orgId, "number");
        if (orgAccount == null) {
            log.error("orgId = {} not exist in orgAccount", orgId);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "机构帐号错误");
        }
        Long orgNumber = orgAccount.getNumber().longValue();
        List<OrgCourse> orgCourses = this.orgCourseDao.getByIds(courseIds);
        List<Long> courseNoDeleteIds = Lists.newArrayList();
        for (OrgCourse orgCourse : orgCourses) {
            if (orgCourse.getIsDel() == 0 && orgCourse.getOrgNumber().equals(orgNumber)
                && orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode()) {
                courseCount++;
                courseNoDeleteIds.add(orgCourse.getId());
            }
        }
        log.info("courseNoDeleteIds:{}", courseNoDeleteIds);
        map.put("lessonToday",
            this.orgStudentLessonDao.getStudentLessonCountTodayByCourseId(orgId, userId, courseNoDeleteIds));
        map.put("courseCount", courseCount);
        map.put("commentCount", this.orgLessonCommentDao.getStudentLessonCommentCount(orgId, userId, null));
        return map;
    }

    @Override
    public List<CourseStudentSumDto> getCourseStudents(Long orgId, Long courseId, PageDto pageDto) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(courseId != null && courseId > 0, "courseId is illegal");
        long l = System.currentTimeMillis();
        List<CourseStudentSumDto> result = Lists.newArrayList();

        List<OrgStudentCourse> courseStudents = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId);
        if (CollectionUtils.isEmpty(courseStudents)) {
            return result;
        }
        List<Long> normalStudents = Lists.newArrayList();
        for (OrgStudentCourse orgStudentCourse : courseStudents) {
            if (orgStudentCourse.getStatus().intValue() == 0) {
                normalStudents.add(orgStudentCourse.getUserId());
            }
        }
        if (CollectionUtils.isEmpty(normalStudents)) {
            return result;
        }

        List<OrgStudent> orgStudents = this.orgStudentDao.getStudents(orgId, normalStudents, "",
            DeleteStatus.NORMAL.getValue(), pageDto, "id", "name", "userId", "avatar");
        if (CollectionUtils.isNotEmpty(orgStudents)) {
            Set<Long> queryStudents = BaseUtils.getPropertiesList(orgStudents, "userId");

            // 头像
            Map<Long, String> studentUrlMap = studentApiService.batchGetStudentAvatarUrl(orgStudents);
            // 签到统计
            Map<Long, Integer> studentCourseSignMap =
                this.orgLessonSignDao.getOrgCourseStudentSignCount(orgId,queryStudents, courseId);
            // 学生班级总课节
            Map<Long, List<Long>> studentLessonMap =
                this.orgStudentLessonDao.getStudentCourseLessonMap(orgId, courseId, queryStudents);
            // 剩余课节
            Map<Long, Integer> studentLeftLessonMap = Maps.newHashMap();
            Integer ruleValue = this.orgCourseConsumeRuleService.getRuleValueByCourseId(orgId, courseId);
            List<Long> ids = getUserIds(orgStudents);
            Map<Long, StudentCourseBase> baseMap = studentCourseApi.getAllData(ids, courseId, orgId);
            if (ruleValue == null || ruleValue == 0) {
                // 默认按时间节点计算课消
                studentLeftLessonMap =
                    this.orgStudentLessonDao.getStudentsLeftLessonMap(orgId, courseId, queryStudents);
            } else {
                // 各种签到状态，用于按到课/请假/缺课算课消时使用
                Map<Long, List<Integer>> studentSignStatusMap =
                    this.orgLessonSignDao.getOrgCourseStudentSignMap(queryStudents, courseId);
                for (Long userId : queryStudents) {
                    int finish = 0;
                    if (studentSignStatusMap.containsKey(userId)) {
                        finish = CourseConsumeRuleEnum.calculateConsumeTimesBySignCodeList(ruleValue,
                            studentSignStatusMap.get(userId));
                    }
                    // 有的学生无排课信息,需要判断
                    if (studentLessonMap.containsKey(userId)) {
                        studentLeftLessonMap.put(userId, studentLessonMap.get(userId).size() - finish);
                    }
                }
            }
            for (OrgStudent orgStudent : orgStudents) {
                StudentCourseBase base = baseMap.get(orgStudent.getUserId());
                CourseStudentSumDto dto = new CourseStudentSumDto();
                dto.setStudentId(orgStudent.getId());
                dto.setName(orgStudent.getName());
                dto.setAvatarUrl(studentUrlMap.get(orgStudent.getId()));

                dto.setSignedLessons(studentCourseSignMap.containsKey(orgStudent.getUserId())
                    ? studentCourseSignMap.get(orgStudent.getUserId()) : 0);
                if(base.getChargeUnit().getCode() == ChargeUnit.BY_HOUR.getCode()){
                    dto.setTotalLessons(base!=null?base.getLessonTime():0);
                    dto.setFinishLessons(base!=null?base.getFinishTime():0);
                    int left = 0;
                    if(base!=null){
                        int lessonTime = Math.max(base.getLessonTime(),base.getBuyTime());
                        left = lessonTime - base.getFinishTime();
                    }
                    dto.setLeftLessons(left);
                }else {
                    dto.setTotalLessons(base!=null?base.getLessonCount() : 0);
                    dto.setFinishLessons(base!=null?base.getFinishCount():0);
                    int left = 0;
                    if(base!=null){
                        int lessonCount = Math.max(base.getLessonCount(),base.getBuyCount());
                        left = lessonCount - base.getFinishCount();
                    }
                    dto.setLeftLessons(left);
                }
                result.add(dto);
            }
        }

        return result;
    }

    private List<Long> getUserIds(List<OrgStudent> orgStudents) {
        List<Long> ids = Lists.newArrayList();
        if(CollectionUtils.isEmpty(orgStudents)){
            return ids;
        }
        for(OrgStudent o : orgStudents){
            ids.add(o.getUserId());
        }
        return ids;
    }

    @Override
    public List<PersonBaseDto> getCourseStudentsBase(Long orgId, Long courseId) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(courseId != null && courseId > 0, "courseId is illegal");

        OrgCourse byId = this.orgCourseDao.getById(courseId, "id", "chargeUnit", "isDel", "chargeType");
        if (byId == null || byId.getIsDel() == 1) {
            throw new BussinessException(CommonErrorCode.NOT_FOUND, "未找到该班级:" + courseId);
        }
        Long parentCourseId = byId.getParentId();

        List<PersonBaseDto> result = Lists.newArrayList();
        List<OrgStudentCourse> courseStudents = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId);
        if (CollectionUtils.isEmpty(courseStudents)) {
            return result;
        }

        Set<Long> normalStudents = Sets.newHashSet();
        for (OrgStudentCourse orgStudentCourse : courseStudents) {
            if (orgStudentCourse.getStatus().intValue() == 0) {
                normalStudents.add(orgStudentCourse.getUserId());
            }
        }

        if (CollectionUtils.isEmpty(normalStudents)) {
            return result;
        }

        List<OrgStudent> orgStudents = this.orgStudentDao.getStudents(orgId, normalStudents,
            DeleteStatus.NORMAL.getValue(), null, "id", "name", "userId", "mobile", "avatar", "lessonStatus");

        List<OrgSignupCourse> signupCourseList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(normalStudents)) {
            signupCourseList = orgSignupCourseDao.searchByUserIdsAndCourseId(normalStudents, courseId, orgId,
                SignupCourseStatus.inClassStatus);
        }
        Map<Long, List<OrgSignupCourse>> signupCourseMap = getSignupCourseMap(signupCourseList);

        if (CollectionUtils.isNotEmpty(orgStudents)) {
            // 头像
            Map<Long, String> studentUrlMap = studentApiService.batchGetStudentAvatarUrl(orgStudents);
            boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());

            for (OrgStudent orgStudent : orgStudents) {
                PersonBaseDto dto = new PersonBaseDto();
                dto.setId(orgStudent.getId());
                dto.setName(orgStudent.getName());
                dto.setAvatarUrl(studentUrlMap.get(orgStudent.getId()));
                dto.setPinyinName(HanZiPinYinUtils.getLowerCasePinYin(orgStudent.getName()));
                dto.setStudentId(orgStudent.getId());
                dto.setUserId(orgStudent.getUserId());
                dto.setChargeUnit(byId.getChargeUnit());
                dto.setCourseId(courseId);
                if (!isShowMobile) {
                    dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
                } else {
                    dto.setMobile(orgStudent.getMobile());
                }
                dto.setMinusSign(BooleanEnum.FALSE.getStatus());
                List<OrgSignupCourse> temp = signupCourseMap.get(orgStudent.getUserId());
                boolean flag = false; // 默认代表没有学员在新数据下购买直接入班的班级
                if (CollectionUtils.isNotEmpty(temp) && temp.size() > 0) {
                    // 历史数据，不管报名还是直接入班的
                    for (OrgSignupCourse signupCourse : temp) {
                        if (signupCourse.getLessonCount().intValue() == 0) {
                            flag = true;
                        }
                    }
                    if (flag) {
                        dto.setMinusSign(BooleanEnum.TRUE.getStatus());
                    }
                }
                result.add(dto);
            }
        }

        // 这个地方应该需要分页 TODO
        Collection<KexiaoStatisticsSuper> studentRequest = Lists.newArrayListWithCapacity(result.size());
        Map<Long, PersonBaseDto> personBaseDtoMap = Maps.newHashMap();
        for (PersonBaseDto pbd : result) {
            KexiaoStatisticsSuper kss =
                KexiaoStatisticsSuper.newInstance(pbd.getStudentId(), pbd.getUserId(), pbd.getCourseId());
            kss.setParentCourseId(parentCourseId);
            studentRequest.add(kss);
            personBaseDtoMap.put(pbd.getStudentId(), pbd);
        }
        studentKexiaoStatisticsApiService.fillStudentKeXiaoStatistics(orgId, studentRequest, 3);
        for (KexiaoStatisticsSuper kss : studentRequest) {
            PersonBaseDto personBaseDto = personBaseDtoMap.get(kss.getStudentId());
            boolean hasSignupRecord = kss.isHasSignupCourseRecord();
            Integer leftClassTimes = kss.getLeftClassTimesForKexiaoValue();
            Integer totalClassTimes = kss.getTotalClassTimesForKexiaoValue();
            int status = 0;
            if (!hasSignupRecord) {
                status = 0;
            } else if (leftClassTimes != null && totalClassTimes != null) {
                if (leftClassTimes < totalClassTimes) {
                    status = 1;
                } else {
                    status = 2;
                }
            }
            personBaseDto.setStudentClassStatus(status);
            personBaseDto.setFinishClassHourForKexiao(kss.getFinishClassTimesForKexiao());
            personBaseDto.setTotalClassHourForKexiao(kss.getTotalClassTimesForKexiao());
        }

        return result;
    }

    Map<Long, List<OrgSignupCourse>> getSignupCourseMap(List<OrgSignupCourse> signupCourseList) {
        Map<Long, List<OrgSignupCourse>> signupCourseMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(signupCourseList)) {
            return signupCourseMap;
        }
        for (OrgSignupCourse o : signupCourseList) {
            if (signupCourseMap.get(o.getUserId()) == null) {
                List<OrgSignupCourse> list = Lists.newArrayList();
                list.add(o);
                signupCourseMap.put(o.getUserId(), list);
            } else {
                List<OrgSignupCourse> list = signupCourseMap.get(o.getUserId());
                list.add(o);
            }
        }
        return signupCourseMap;
    }

    /**
     * @param dto
     */

    public void setStudentLessonStatus(Integer lessonStatus, PersonBaseDto dto) {
        if (lessonStatus == null) {
            lessonStatus = StudentLessonStatus.NOT_ENROLL.getStatus();
        }
        if (StudentLessonStatus.NOT_ENROLL.getStatus() == lessonStatus) {
            dto.setStudentClassStatus(0);
        } else if (StudentLessonStatus.STUDYING.getStatus() == lessonStatus
            || StudentLessonStatus.TO_CHARGE.getStatus() == lessonStatus) {
            dto.setStudentClassStatus(1);
        } else if (StudentLessonStatus.PAST.getStatus() == lessonStatus) {
            dto.setStudentClassStatus(2);
        } else {
            dto.setStudentClassStatus(0);
        }
    }

    @Override
    public List<PersonBaseDto> getCourseStudentsNotInLesson(Long orgId, Long lessonId) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(lessonId != null && lessonId > 0, "lessonId is illegal");
        OrgClassLesson lesson = this.orgClassLessonDao.getById(lessonId, "id", "orgId", "courseId", "delStatus");
        if (lesson == null || lesson.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()
            || lesson.getOrgId().longValue() != orgId) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节不存在或已被删除");
        }

        List<PersonBaseDto> result = Lists.newArrayList();
        List<OrgStudentCourse> courseStudents =
            this.orgStudentCourseDao.getStudentListByCourseId(orgId, lesson.getCourseId());
        if (CollectionUtils.isEmpty(courseStudents)) {
            return result;
        }

        Set<Long> normalStudents = Sets.newHashSet();
        for (OrgStudentCourse orgStudentCourse : courseStudents) {
            if (orgStudentCourse.getStatus().intValue() == 0) {
                normalStudents.add(orgStudentCourse.getUserId());
            }
        }

        if (CollectionUtils.isEmpty(normalStudents)) {
            return result;
        }

        List<Long> lessonStudents = this.orgStudentLessonDao.getUserIdsByLessonIds(orgId, Lists.newArrayList(lessonId));
        // 在班级中，但是不在课节中
        normalStudents.removeAll(lessonStudents);

        List<OrgStudent> orgStudents = this.orgStudentDao.getStudents(orgId, normalStudents,
            DeleteStatus.NORMAL.getValue(), null, "id", "name", "userId", "mobile", "avatar");
        if (CollectionUtils.isNotEmpty(orgStudents)) {
            // Set<Long> queryStudents = BaseUtils.getPropertiesList(orgStudents, "userId");
            // 头像
            Map<Long, String> studentUrlMap = studentApiService.batchGetStudentAvatarUrl(orgStudents);
            for (OrgStudent orgStudent : orgStudents) {
                PersonBaseDto dto = new PersonBaseDto();
                dto.setId(orgStudent.getId());
                dto.setName(orgStudent.getName());
                dto.setAvatarUrl(studentUrlMap.get(orgStudent.getId()));
                result.add(dto);
            }
        }
        return result;
    }
}
