
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.course.service;

import com.baijia.tianxiao.sal.course.dto.response.AppTeacherResponseDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherRespDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Collection;
import java.util.List;

/**
 * @title CourseTeacherService
 * @desc 操作
 * @author cxm
 * @date 2015年12月25日
 * @version 1.0
 */
public interface CourseTeacherService {

    /**
     * 获取机构的老师列表
     * 
     * @param key 老师的名称,老师的手机号,老师的唯一标识
     * @param orgId
     * @param branchId
     * @param page
     * @return
     */
    List<TeacherResponseDto> listOrgTeacher(String key, Long orgId, Long branchId, Long courseId, PageDto page);

    /**
     * 机构所有的老师列表，标识属于该课程的数据
     * @param key
     * @param orgId
     * @param courseid
     * @return
     */
    List<AppTeacherResponseDto> listOrgTeacherWithCourse(String key,Long orgId,Long courseid);

    /**
     * 获取指定课程下的老师信息
     * 
     * @param orgId
     * @param courseId
     * @return
     */
    List<TeacherResponseDto> listCourseTeacher(Long orgId, Long courseId);

    /**
     * 获取指定课程下的老师信息
     * 
     * @param orgId
     * @param courseIds
     * @param pageDto
     * 
     * @return
     */
    List<TeacherResponseDto> listCourseTeacher(Long orgId, Collection<Long> courseIds, String key,PageDto pageDto);

    /**
     * 批量添加老师到课程
     * 
     * @param orgId
     * @param courseId
     * @param teacherIds
     */
    void addTeacherToCourse(Long orgId, Long courseId, Collection<Long> teacherIds);

    /**
     * 批量从课程关联老师列表中删除老师
     * 
     * @param orgId
     * @param courseId
     * @param teacherIds
     */
    int delTeacherFromCourse(Long orgId, Long courseId, Collection<Long> teacherIds);
    
    /**
     * 删除课程老师，校验老师是否已经排过课节，如果未排过课，则可以删除，返回成功删除的个数，否则返回0
     * 
     * @param orgId
     * @param courseId
     * @param teacherIds
     * @return
     */
        
    public int delTeacherFromCourseForLessonCheck(Long orgId, Long courseId, Collection<Long> teacherIds);

    /**
     * 获取老师信息
     * 
     * @param teacherIds
     * @return
     */
    List<TeacherResponseDto> getTeachers(Collection<Long> teacherIds, Long orgId);

    /**
     * 获取老师信息
     * 
     * @param teacherIds
     * @return
     */
    TeacherResponseDto getTeacher(Long teacherId, Long orgId);

    /**
     * 查询课节的老师信息
     * 
     * @param orgId
     * @param lessonId
     * @return
     */
    List<TeacherResponseDto> getLessonTeacher(Long orgId, Long lessonId);

    /**
     * 删除课节老师
     * 
     * @param orgId
     * @param lessonId
     * @param teacherIds
     * @return
     */
    int delTeacherFromLesson(Long orgId, Long lessonId, Collection<Long> teacherIds);

    /**
     * 添加课节老师
     * 
     * @param orgId
     * @param courseId
     * @param lessonId
     * @param teacherIds
     */
    void addTeacherToLesson(Long orgId, Long courseId, Long lessonId, Collection<Long> teacherIds);

    /**
     * 重置课节的老师
     * 
     * @param orgId
     * @param courseId
     * @param lessonId
     * @param teacherIds
     */
    void resetLessonTeacher(Long orgId, Long courseId, Long lessonId, Collection<Long> teacherIds);

    /**
     * 根据查询字符串筛选对老师进行筛选
     * @param orgId：机构id
     * @param key：查询字符串
     * @param courseId：课程id
     * @param pageDto：页面信息
     * @return
     */
	List<TeacherRespDto> listPcOrgTeacher(Long orgId, String key, Long courseId, PageDto pageDto);

	/**
	 * 根据教室、课程信息筛选老师列表
	 * @param orgId：机构id
	 * @param classRoomIds：教室id集合
	 * @param courseIds：课程id集合
	 * @param type：筛选类型  0:全部 1:有冲突课程
	 * @return
	 */
	List<TeacherDto> selectTeacher(Long orgId, List<Long> classRoomIds, List<Long> courseIds, Integer type);

}
