package com.baijia.tianxiao.sal.course.dto.response;

import java.util.List;

import com.baijia.tianxiao.dal.user.po.Teacher;
import com.google.common.collect.Lists;

import lombok.Data;

@Data
public class TeacherDto {

	//教师id
	private Long id;
	
	//教师名称
	private String name;
	
	public static TeacherDto converToDto(Teacher teacher) {
		TeacherDto dto = new TeacherDto();
		dto.setId(teacher.getId());
		dto.setName(teacher.getRealName());
		return dto;
	}

	public static List<TeacherDto> converToDto(List<Teacher> teachers) {
		List<TeacherDto> dtos = Lists.newArrayList();
		for(Teacher teacher : teachers) {
			TeacherDto dto = converToDto(teacher);
			dtos.add(dto);
		}
		return dtos;
	}
	
}
