package com.baijia.tianxiao.sal.course.service.syncThread;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.PreDestroy;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * @author weihongyan
 * @description 课消上线前使用,同步报名信息来补充报名信息
 * @date 24/12/2016
 */
@Slf4j
@Service
@Deprecated
public class SyncOrgSignupCourseServiceImpl {

    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgSignupCourseService orgSignupCourseService;
    @Autowired
    private OrgCourseDao orgCourseDao;

    @Setter
    private Integer BATCH_SYNC_NUMBER = 1000;
    private List<Long> orgIds = null;

    private volatile Boolean flag;
    private SyncSignupThread thread;

    public void start(Integer startId, Integer endId, List<Long> orgIds) {
        this.orgIds = orgIds;
        if (null == thread) {
            flag = true;
            thread = new SyncSignupThread(startId, endId);
            new Thread(thread).start();
        } else {
            if (flag) {
                return;
            } else {
                flag = true;
                thread = new SyncSignupThread(startId, endId);
                new Thread(thread).start();
            }
        }
    }

    @PreDestroy
    public void preDestory() {
        stop();
    }

    public void stop() {
        flag = false;
    }

    private class SyncSignupThread implements Runnable {

        private Integer startId;
        private Integer endId;
        private Integer temp;
        private Integer batchTimes;

        public SyncSignupThread(Integer startId, Integer endId) {
            this.startId = startId;
            this.endId = endId;
            this.temp = startId;
            this.batchTimes = (endId - startId) / BATCH_SYNC_NUMBER;
        }

        @Override
        public void run() {
            try {
                log.info(
                    "sync orgSignupCourse is going to start from {}, to {}, by {} batches transection with checking {} courseStudent records per batch.",
                    startId, endId, batchTimes + 1, BATCH_SYNC_NUMBER);
                int i = 0;
                while (flag) {
                    int dataSize;
                    if (i < batchTimes) {
                        dataSize = syncBetween(temp, temp + BATCH_SYNC_NUMBER);
                        temp += BATCH_SYNC_NUMBER;
                        i++;
                    } else {
                        dataSize = syncBetween(temp, endId);
                        temp = endId;
                        break;
                    }
                    log.info("sleep for {} mills ...", dataSize / 3);
                    Thread.sleep(dataSize / 3);
                }
                log.info(
                    "sync orgSignupCourse is finished from {}, to {}, by {} batches transection with checking {} courseStudent records per batch.",
                    startId, temp, batchTimes + 1, BATCH_SYNC_NUMBER);
            } catch (Exception e) {
                log.error("sync orgSignupCourse is error from {}, to {}", startId, temp, e.getMessage());
                log.error("task error occured :{}", e);
            } finally {
                flag = false;
            }
        }
    }

    @Transactional
    private int syncBetween(Integer startId, Integer endId) {

        // 获取区间进班列表
        List<OrgStudentCourse> studentCourseList = orgStudentCourseDao.getBetweenId(startId, endId, orgIds,
            StudentCourseStatus.NORMAL.getCode(), DeleteStatus.NORMAL.getValue());

        log.info("syncBetween [{},{}) get List<OrgStudentCourse> size:{}", startId, endId, studentCourseList.size());

        // 获取进班列表对应的报名列表
        Set<Long> orgIds = Sets.newHashSet();
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> userIds = Sets.newHashSet();
        for (OrgStudentCourse orgStudentCourse : studentCourseList) {
            orgIds.add(orgStudentCourse.getOrgId());
            courseIds.add(orgStudentCourse.getCourseId());
            userIds.add(orgStudentCourse.getUserId());
        }

        // 找出班级信息//子
        Map<Long, OrgCourse> classMap = orgCourseDao.getOrgCourseMap(courseIds, "id", "number", "price", "isDel",
            "isCourse", "isClass", "parentId", "courseType");
        // 1v1班级id
        Set<Long> parentIds = Sets.newHashSet();
        for (OrgCourse course : classMap.values()) {
            if (course.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                if (course.getIsCourse() == CourseTypeEnum.IS_COURSE_FALSE.getCode()
                    && course.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode()) {
                    parentIds.add(course.getParentId());
                } else {
                    log.error("数据错误, 不该出现1v1课程, 应该都是1V1班级 :{}", course);
                }
            }
        }
        // 找出课程信息
        Map<Long, OrgCourse> courseMap = com.baijia.tianxiao.util.CollectorUtil
            .collectMap(orgCourseDao.getCoursesByParentIdsIgnoreDel(null, parentIds, "id", "number", "price", "isDel",
                "isCourse", "isClass", "parentId", "courseType"), new Function<OrgCourse, Long>() {
                @Override
                public Long apply(OrgCourse input) {
                    return input.getId();
                }
            });
        // 班级对应课程一对多Map
        Map<Long, Long> classCourseMap = Maps.newHashMap();
        for (OrgCourse course : courseMap.values()) {
            classCourseMap.put(course.getId(), course.getParentId());
        }

        Map<Long, OrgCourse> allCourseMap = Maps.newHashMap();
        allCourseMap.putAll(classMap);
        allCourseMap.putAll(courseMap);
        allCourseMap.putAll(orgCourseDao.getOrgCourseMap(parentIds, "id", "number", "price", "isDel", "isCourse",
            "isClass", "parentId", "courseType"));

        Map<String, OrgStudentCourse> courseStuStrMap = Maps.newHashMap();// 生成进班索引map
        for (OrgStudentCourse orgStudentCourse : studentCourseList) {
            Long parentId = classCourseMap.get(orgStudentCourse.getCourseId());
            if (null != parentId) {// 把班级转换成课程
                courseStuStrMap.put(orgStudentCourse.getOrgId() + "," + parentId + "," + orgStudentCourse.getUserId(),
                    orgStudentCourse);
            } else {
                courseStuStrMap.put(orgStudentCourse.getOrgId() + "," + orgStudentCourse.getCourseId() + ","
                    + orgStudentCourse.getUserId(), orgStudentCourse);
            }
        }

        List<OrgSignupCourse> signupCourseList =
            orgSignupCourseDao.getByCourseIdsAndStudentIds(orgIds, allCourseMap.keySet(), userIds);
        log.info("syncBetween [{},{}) get List<OrgSignupCourse> size:{}", startId, endId, signupCourseList.size());

        // 找出没报名记录的进班
        List<String> signupKeys = Lists.transform(signupCourseList, new Function<OrgSignupCourse, String>() {
            @Override
            public String apply(OrgSignupCourse input) {
                return input.getOrgId() + "," + input.getOrgCourseId() + "," + input.getUserId();// 课程id
            }
        });

        Set<String> allKeys = courseStuStrMap.keySet();
        allKeys.removeAll(signupKeys);// 移除存在的报名的key, 剩下的都是需要补充报名的进班.
        log.info("syncBetween [{},{}) find no signup size:{}", startId, endId, allKeys.size());
        // log.info("keys are :{}", allKeys);

        // 要插入的记录
        List<OrgSignupCourse> newSignupCourses = Lists.newArrayList();
        for (String courseKey : allKeys) {
            OrgStudentCourse orgStudentCourse = courseStuStrMap.get(courseKey);
            OrgCourse course = allCourseMap.get(Long.parseLong(courseKey.split(",")[1]));
            if (null == course) {
                log.info("****************** dirty data! orgId,courseId,userId is:{} course is :{}", courseKey, course);
                continue;
            }
            OrgSignupCourse signupCourse = new OrgSignupCourse();
        
            signupCourse.setSignupPurchaseId(orgSignupCourseService.randomSignupPurchaseId4Excel(orgStudentCourse.getCreateTime()));
            signupCourse.setOrgId(orgStudentCourse.getOrgId());
            signupCourse.setUserId(orgStudentCourse.getUserId());
            signupCourse.setOrgCourseId(course.getId());
            signupCourse.setClassId(orgStudentCourse.getCourseId());
            signupCourse.setOrgCourseNumber(course.getNumber());
            signupCourse.setOriginPrice(new Double(course.getPrice() * 100).intValue());
            signupCourse.setPreferential(signupCourse.getOriginPrice());
            signupCourse.setCount(1);
            signupCourse.setLessonCount(0);
            signupCourse.setCreateTime(orgStudentCourse.getCreateTime());
            signupCourse.setUpdateTime(new Date());
            signupCourse.setStatus(SignupCourseStatus.INIT.getCode());
            signupCourse.setSyncLessonCount(Flag.TRUE.getInt());

            newSignupCourses.add(signupCourse);
        }

        log.info("---------------------------------------------------------------");

        if (CollectionUtils.isNotEmpty(newSignupCourses)) {
            try {
                long now = System.currentTimeMillis();
                orgSignupCourseDao.saveAll(newSignupCourses, false, "orgId", "userId", "orgCourseId", "orgCourseNumber",
                    "originPrice", "preferential", "count", "lessonCount", "createTime", "updateTime", "classId",
                    "signupPurchaseId", "syncLessonCount", "status");
                log.info("insert done! insert size:{}, cost:{}ms", newSignupCourses.size(), System.currentTimeMillis() - now);
            }catch (Exception e){
                log.error("error! :{}", e.getMessage());
                log.error("error! :{}", e);
                throw e;
            }
        }

        return newSignupCourses.size();
    }

}
