
package com.baijia.tianxiao.sal.course.service;

import java.util.List;

/**
 * 发送课表
 * 
 * @title SmsServiceImpl
 * @desc TODO
 * @author shizuwei
 * @date 2015年12月29日
 * @version 1.0
 */
public interface SmsService {

    /**
     * 用于发送课表短信
     * 
     * @param orgId 机构ID
     * @param courseId 课程ID
     * @param userRole 用户：老师，学生
     * @param userIds 学生id，老师user_id
     * @return
     */
    List<Long> sendCourseSms(Long orgId, Long courseId, Integer userRole, List<Long> userIds);

    /**
     * 查看短信，用于更新短信查看状态
     * 
     * @param orgId
     * @param courseId
     * @param userRole
     */
    void viewSms(Long orgId, Long courseId, Long userId, Integer userRole);


    /**
     * 短信发送接口调用，保存短信发送记录
     * 
     * @param mobile
     * @param content
     * @return
     */
    boolean saveAndSendSms(Long operatorId, Long smsKey, Integer userRole, Long userId, String mobile, String content);
}
