
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.course.service;

import com.baijia.tianxiao.dal.course.po.OrgCoursePhoto;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.sal.course.dto.request.WeikeRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.List;
import java.util.Map;

import lombok.Data;

/**
 * @title OrgCourseListService
 * @desc TODO
 * @author shanyu
 * @date 2015年12月25日
 * @version 1.0
 */

public interface OrgCourseListService {

    /**
     * 查询机构班级列表
     * 
     * @param dto 请求实体
     * @param orgId 机构id
     * @param needLesson 是否需要课节统计
     * @param needSms 是否需要短信统计
     * @param needTeacher 是否需要老师统计
     * @param needStudent 是否需要学生统计
     * @param needRoom 是否需要教室统计
     * @param needCover 是否需要封面
     * @param needUrl 是否需要url
     * @return
     */
    
    public static class CourseListParam{
        public List<OrgCourse> getCourses() {
        
            return courses;
        }
        public CourseListParam setCourses(List<OrgCourse> courses) {
        
            this.courses = courses;
            return this;
        }
        public Long getOrgId() {
        
            return orgId;
        }
        public CourseListParam setOrgId(Long orgId) {
        
            this.orgId = orgId;
            return this;
        }
        public boolean isNeedLesson() {
        
            return needLesson;
        }
        public CourseListParam setNeedLesson(boolean needLesson) {
        
            this.needLesson = needLesson;
            return this;
        }
        public boolean isNeedSms() {
        
            return needSms;
        }
        public CourseListParam setNeedSms(boolean needSms) {
        
            this.needSms = needSms;
            return this;
        }
        public boolean isNeedTeacher() {
        
            return needTeacher;
        }
        public CourseListParam setNeedTeacher(boolean needTeacher) {
        
            this.needTeacher = needTeacher;
            return this;
        }
        public boolean isNeedStudent() {
        
            return needStudent;
        }
        public CourseListParam setNeedStudent(boolean needStudent) {
        
            this.needStudent = needStudent;
            return this;
        }
        public boolean isNeedRoom() {
        
            return needRoom;
        }
        public CourseListParam setNeedRoom(boolean needRoom) {
        
            this.needRoom = needRoom;
            return this;
        }
        public boolean isNeedCover() {
        
            return needCover;
        }
        public CourseListParam setNeedCover(boolean needCover) {
        
            this.needCover = needCover;
            return this;
        }
        public boolean isNeedUrl() {
        
            return needUrl;
        }
        public CourseListParam setNeedUrl(boolean needUrl) {
        
            this.needUrl = needUrl;
            return this;
        }
        public Long getStudentId() {
        
            return studentId;
        }
        public CourseListParam setStudentId(Long studentId) {
        
            this.studentId = studentId;
            return this;
        }
        public Long getTeacherId() {
        
            return teacherId;
        }
        public CourseListParam setTeacherId(Long teacherId) {
        
            this.teacherId = teacherId;
            return this;
        }
        private List<OrgCourse> courses;
        private Long orgId;
        private boolean needLesson = false;
        private boolean needSms = false;
        private boolean needTeacher = false;
        private boolean needStudent = false;
        private boolean needRoom = false;
        private boolean needCover = false;
        private boolean needUrl = false;
        private Long studentId=null;
        private Long teacherId=null;
    }
    
    public List<CourseListReponseDto> getCourseList(List<OrgCourse> courses, Long orgId, boolean needLesson,
        boolean needSms, boolean needTeacher, Boolean needStudent, boolean needRoom, boolean needCover,
        boolean needUrl);

    /**
     * 查询机构班级列表
     * 
     * @param dto 请求实体
     * @param studentId 学生userId
     * @param teacherId teacherId
     * @param orgId 机构id
     * @param needLesson 是否需要课节统计
     * @param needSms 是否需要短信统计
     * @param needTeacher 是否需要老师统计
     * @param needStudent 是否需要学生统计
     * @param needRoom 是否需要教室统计
     * @param needCover 是否需要封面
     * @param needUrl 是否需要url
     * @return
     */
    public List<CourseListReponseDto> getCourseList(CourseListParam param);

    /**      
     * 获取课程详情
     * 
     * @param orgId
     * @param orgCourseId
     * @return
     */
    CourseListReponseDto getCourseDetail(Long orgId, Long orgCourseId);

    /**
     * 返回机构某个学生的课程列表,用于ERP学生中心班级列表
     * 
     * @author shizuwei
     * @param orgId
     * @param studentId 学生ID
     * @param pageDto
     * @return
     */
    List<CourseListReponseDto> getCourseList(Long orgId, Long studentId, PageDto pageDto);

    List<CourseListReponseDto> getWeikeList(Long orgId, WeikeRequestDto requestDto);
    
    public Map<Long,OrgCoursePhoto> getPhoteMap(List<Long> courseIds);
    
    public Map<Integer, String> getCoverMap(List<OrgCourse> courses);

    public Integer syncColors(PageDto pageDto);

    public Integer syncColorsByOrg(Long orgNumber);

}
