
package com.baijia.tianxiao.sal.course.dto.response;

import java.io.Serializable;
import java.util.Date;

import com.baijia.tianxiao.util.date.DateUtil;

import lombok.Data;

@Data
public class ClassLessonInfoDto implements Serializable {

    private static final long serialVersionUID = 5877701720695650405L;
    /**
     * 课节id
     */
    private Long lessonId;
    /**
     * 课节名称
     */
    private String lessonName;
    /**
     * 课节编号
     */
    private Integer index;
    /**
     * 课节签到状态 0,未签到；1，签到；2，请假；3，旷课
     */
    private Integer status;

    /**
     * 开始时间
     */
    private Date startTime;

    private Integer weekDay;

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
        weekDay = DateUtil.getWeekDay(startTime);
    }

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 是否被学生评论
     */
    private Boolean hasComment;

    // 是否结束
    private Integer isOver = 0;

    // 老师姓名
    private String teacherName;

    // 教室名称
    private String roomName;

    // 课程名称
    private String courseName;

    /**
     * 签到状态
     */
    private Integer signStatus;

    private String signStatusStr;

    // 可笑 2.0 需求
    private String kexiaoMoney;
    private String tipInfo; // 1:无签到记录 2:课节为赠送课
    private Integer lessonType = -1;
    // 可笑 2.0 需求

}
