package com.baijia.tianxiao.sal.course.dto.request;

import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.util.List;
import java.util.Map;

@Data
@Slf4j
public class WeikeRequestDto extends PageDto {
    private String searchKey;
    private String teacherIds;
    private String groupIds;
    private String exGroupIds;
    private List<Long> teacherIdList;
    private List<Integer> groupIdList;
    private List<Integer> exGroupIdList;
    private String price;
    private String orderCondition;
    private Map<String, String> orderConditionMap;
    private Double hPrice;
    private Double lPrice;
    private Integer status;
    private Boolean loadTeacherList = false;
    private Integer courseType;
    private Integer chargeType;

    @SuppressWarnings("unchecked")
    public WeikeRequestDto build() throws JsonParseException, JsonMappingException, IOException {
        if (StringUtils.isNoneBlank(price)) {
            List<Double> priceList = JacksonUtil.str2List(this.price, Double.class);
            if (CollectionUtils.isNotEmpty(priceList)) {
                if (priceList.size() == 1) {
                    this.lPrice = priceList.get(0);
                }
                if (priceList.size() >= 2) {
                    this.lPrice = priceList.get(0);
                    this.hPrice = priceList.get(1);
                }
            }
        }
        if (StringUtils.isNoneBlank(orderCondition)) {
            this.orderConditionMap = (Map<String, String>) JacksonUtil.str2Obj(this.orderCondition, Map.class);
        }

        if (StringUtils.isNoneBlank(groupIds)) {
            groupIdList = JacksonUtil.str2List(this.groupIds, Integer.class);

        }
        
        if (StringUtils.isNoneBlank(exGroupIds)) {
            exGroupIdList = JacksonUtil.str2List(this.exGroupIds, Integer.class);

        }


        if (StringUtils.isNoneBlank(teacherIds)) {
            teacherIdList = JacksonUtil.str2List(this.teacherIds, Long.class);

        }

        return this;
    }

    @SuppressWarnings({ "unused", "unchecked" })
    public static void main(String[] args) throws JsonParseException, JsonMappingException, IOException {

        Map<String, String> m = (Map<String, String>) JacksonUtil.str2Obj("{\"sss\":\"ttt\"}", Map.class);
        log.debug("m={}", m);
    }
}
