/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.sal.course.constant.ChargeUnit;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoChangeLogService;
import com.baijia.tianxiao.util.ListUtil;
import com.beust.jcommander.internal.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgSignupCourseLessonServiceImpl
implements OrgSignupCourseLessonService {
    private static final Logger log = LoggerFactory.getLogger(OrgSignupCourseLessonServiceImpl.class);
    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private KexiaoChangeLogService changeLogService;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    private static final int HOUR = 60;
    private static final int HALF_HOUR = 30;

    @Override
    public void saveSignupCourseLessons(Long orgId, Long classId, Collection<OrgStudentLesson> studentLessons) {
        Long courseId = 0L;
        OrgCourse orgCourse = (OrgCourse)this.courseDao.getById((Serializable)classId, new String[]{"isClass", "isCourse", "parentId", "chargeUnit"});
        courseId = CourseTypeEnum.IS_CLASS_TRUE.getCode() == orgCourse.getIsClass() && CourseTypeEnum.IS_COURSE_FALSE.getCode() == orgCourse.getIsCourse() ? orgCourse.getParentId() : classId;
        List userIds = ListUtil.toKeyList(studentLessons, (String)"userId", OrgStudentLesson.class);
        List signupCourses = this.signupCourseDao.searchByUserIdsAndCourseId((Collection)userIds, courseId, orgId, (Collection)Lists.newArrayList((Object[])new Integer[]{2, 3, 4, 5, 6}));
        HashMap<Long, List<OrgSignupCourse>> stuSignupMap = new HashMap<Long, List<OrgSignupCourse>>();
        for (OrgSignupCourse signupCourse : signupCourses) {
            ArrayList<OrgSignupCourse> list = (ArrayList<OrgSignupCourse>)stuSignupMap.get(signupCourse.getUserId());
            if (list == null) {
                list = new ArrayList<OrgSignupCourse>();
                stuSignupMap.put(signupCourse.getUserId(), list);
            }
            list.add(signupCourse);
        }
        Map<Long, List<OrgSignupCourse>> unCompleteSignupMap = this.filterUnHandleStudent(stuSignupMap);
        log.info("[SignupCourseLesson] Validate userIds={}", stuSignupMap.keySet());
        Map<Long, Object> signupLessonMap = new HashMap<Long, OrgSignupCourseLesson>();
        if (!stuSignupMap.isEmpty()) {
            signupLessonMap = this.signupCourseLessonDao.selectSignUpLessons(stuSignupMap.keySet(), classId, orgId);
        }
        Map<Long, List<OrgSignupCourse>> unfinishedSignupCourseMap = this.getUnFinishedOrgSignupCourse(signupLessonMap, stuSignupMap);
        for (OrgStudentLesson studentLesson : studentLessons) {
            OrgSignupCourseLesson courseLesson = this.createOrgSignupCourseLesson(orgId, studentLesson, studentLesson.getLessonDuration(), courseId);
            if (stuSignupMap.keySet().contains(studentLesson.getUserId())) {
                List<OrgSignupCourse> courseList = unfinishedSignupCourseMap.get(studentLesson.getUserId());
                int lessonTime = studentLesson.getLessonDuration();
                if (courseList != null && !courseList.isEmpty()) {
                    OrgSignupCourse course = courseList.get(0);
                    studentLesson.setLessonType(LessonType.NORMAL.getCode());
                    if (ChargeUnit.BY_TIMES.getCode() == course.getChargeUnit()) {
                        courseLesson.setLessonType(LessonType.NORMAL.getCode());
                        OrgSignupCourseLesson stat = (OrgSignupCourseLesson)signupLessonMap.get(course.getId());
                        int completeCount = stat == null ? 0 : stat.getLessonCount();
                        courseLesson.setAmount(Long.valueOf(this.getCountAmount(course, completeCount)));
                        courseLesson.setSignupCourseId(course.getId());
                    } else if (ChargeUnit.isByTime(course.getChargeUnit())) {
                        int leftTime = lessonTime;
                        for (OrgSignupCourse signupCourse : courseList) {
                            int totalTime = this.getTotalTime(signupCourse);
                            long usedAmount = 0L;
                            OrgSignupCourseLesson stat = (OrgSignupCourseLesson)signupLessonMap.get(signupCourse.getId());
                            if (stat != null) {
                                totalTime -= stat.getLessonDuration().intValue();
                                usedAmount = stat.getAmount();
                            }
                            if (leftTime <= totalTime) {
                                courseLesson.setLessonType(LessonType.NORMAL.getCode());
                                courseLesson.setSignupCourseId(course.getId());
                                courseLesson.setLessonDuration(Integer.valueOf(leftTime));
                                if ((leftTime -= totalTime) == 0) {
                                    courseLesson.setAmount(Long.valueOf(signupCourse.getStudentPayPrice() + signupCourse.getPayPrice() - usedAmount));
                                    break;
                                }
                                courseLesson.setAmount(Long.valueOf(this.getHourAmount(signupCourse, lessonTime)));
                                break;
                            }
                            OrgSignupCourseLesson splitLesson = this.createOrgSignupCourseLesson(orgId, studentLesson, studentLesson.getLessonDuration(), courseId);
                            splitLesson.setLessonType(LessonType.NORMAL.getCode());
                            splitLesson.setLessonDuration(Integer.valueOf(totalTime));
                            splitLesson.setSignupCourseId(signupCourse.getId());
                            splitLesson.setAmount(Long.valueOf(signupCourse.getStudentPayPrice() + signupCourse.getPayPrice() - usedAmount));
                            splitLesson.setChargeUnit(orgCourse.getChargeUnit());
                            this.signupCourseLessonDao.save((Object)splitLesson, new String[0]);
                            leftTime -= totalTime;
                        }
                        if (leftTime > 0) {
                            courseLesson.setLessonType(LessonType.FREE.getCode());
                            courseLesson.setLessonDuration(Integer.valueOf(leftTime));
                        }
                    } else {
                        log.error("[SignupCourseLesson] Type error.{}", courseList);
                    }
                } else {
                    studentLesson.setLessonType(LessonType.FREE.getCode());
                    courseLesson.setLessonType(LessonType.FREE.getCode());
                }
                courseLesson.setChargeUnit(orgCourse.getChargeUnit());
                this.signupCourseLessonDao.save((Object)courseLesson, new String[0]);
                continue;
            }
            if (unCompleteSignupMap.get(studentLesson.getUserId()) != null) {
                studentLesson.setLessonType(LessonType.OTHER.getCode());
                continue;
            }
            studentLesson.setLessonType(LessonType.FREE.getCode());
            courseLesson.setChargeUnit(orgCourse.getChargeUnit());
            courseLesson.setLessonType(LessonType.FREE.getCode());
            this.signupCourseLessonDao.save((Object)courseLesson, new String[0]);
        }
    }

    private long getCountAmount(OrgSignupCourse course, int completeCount) {
        long total = course.getStudentPayPrice() + course.getPayPrice();
        long unit = total / (long)course.getLessonCount().intValue();
        if (course.getLessonCount() - completeCount > 1) {
            return unit;
        }
        return total - unit * (long)(course.getLessonCount() - 1);
    }

    private long getHourAmount(OrgSignupCourse course, int lessonTime) {
        long totalTime = this.getTotalTime(course);
        return (long)lessonTime * (course.getPayPrice() + course.getStudentPayPrice()) / totalTime;
    }

    private int getTotalTime(OrgSignupCourse signupCourse) {
        return signupCourse.getChargeUnit() == ChargeUnit.BY_HOUR.getCode() ? signupCourse.getLessonCount() * 60 : signupCourse.getLessonCount() * 30;
    }

    private OrgSignupCourseLesson createOrgSignupCourseLesson(Long orgId, OrgStudentLesson studentLesson, int lessonDuration, Long courseId) {
        OrgSignupCourseLesson courseLesson = new OrgSignupCourseLesson();
        courseLesson.setOrgId(orgId);
        courseLesson.setCreateTime(new Date());
        courseLesson.setSignupCourseId(Long.valueOf(-1L));
        courseLesson.setLessonDuration(Integer.valueOf(lessonDuration));
        courseLesson.setClassId(studentLesson.getCourseId());
        courseLesson.setCourseId(courseId);
        courseLesson.setLessonId(studentLesson.getLessonId());
        courseLesson.setUserId(studentLesson.getUserId());
        return courseLesson;
    }

    private int diffTime(Date startTime, Date endTime) {
        Calendar start = Calendar.getInstance();
        start.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return end.get(12) - start.get(12);
    }

    private Map<Long, List<OrgSignupCourse>> filterUnHandleStudent(Map<Long, List<OrgSignupCourse>> stuSignupMap) {
        HashMap<Long, List<OrgSignupCourse>> unCompleteSignupMap = new HashMap<Long, List<OrgSignupCourse>>();
        Set<Map.Entry<Long, List<OrgSignupCourse>>> set = stuSignupMap.entrySet();
        Iterator<Map.Entry<Long, List<OrgSignupCourse>>> iter = set.iterator();
        block0: while (iter.hasNext()) {
            Map.Entry<Long, List<OrgSignupCourse>> entry = iter.next();
            for (OrgSignupCourse course : entry.getValue()) {
                if (course.getChargeUnit() != null && course.getChargeUnit() >= 0) continue;
                unCompleteSignupMap.put(entry.getKey(), entry.getValue());
                iter.remove();
                continue block0;
            }
        }
        return unCompleteSignupMap;
    }

    private Map<Long, List<OrgSignupCourse>> getUnFinishedOrgSignupCourse(Map<Long, OrgSignupCourseLesson> signupLessonsMap, Map<Long, List<OrgSignupCourse>> stuSignupMap) {
        HashMap<Long, List<OrgSignupCourse>> unFinishedSignup = new HashMap<Long, List<OrgSignupCourse>>();
        Set<Map.Entry<Long, List<OrgSignupCourse>>> set = stuSignupMap.entrySet();
        for (Map.Entry<Long, List<OrgSignupCourse>> entry : set) {
            for (OrgSignupCourse course : entry.getValue()) {
                OrgSignupCourseLesson stat = signupLessonsMap.get(course.getId());
                ArrayList<OrgSignupCourse> list = (ArrayList<OrgSignupCourse>)unFinishedSignup.get(entry.getKey());
                if (list == null) {
                    list = new ArrayList<OrgSignupCourse>();
                }
                if (stat == null) {
                    list.add(course);
                } else if (ChargeUnit.BY_TIMES.getCode() == course.getChargeUnit()) {
                    if (course.getLessonCount() > stat.getLessonCount()) {
                        if (log.isDebugEnabled()) {
                            log.debug("[SignupCourseLesson] contract count={},lesson count={},unit={}", new Object[]{course.getLessonCount(), stat.getLessonCount(), course.getChargeUnit()});
                        }
                        list.add(course);
                    }
                } else if (ChargeUnit.BY_HOUR.getCode() == course.getChargeUnit()) {
                    if (course.getLessonCount() * 60 > stat.getLessonDuration()) {
                        if (log.isDebugEnabled()) {
                            log.debug("[SignupCourseLesson] contract count={},lesson time={},unit={}", new Object[]{course.getLessonCount(), stat.getLessonDuration(), course.getChargeUnit()});
                        }
                        list.add(course);
                    }
                } else if (ChargeUnit.BY_HOUR.getCode() == course.getChargeUnit()) {
                    if (course.getLessonCount() * 30 > stat.getLessonDuration()) {
                        if (log.isDebugEnabled()) {
                            log.debug("[SignupCourseLesson] contract count={},lesson time={},unit={}", new Object[]{course.getLessonCount(), stat.getLessonDuration(), course.getChargeUnit()});
                        }
                        list.add(course);
                    }
                } else {
                    log.error("[SignupCourseLesson] OrgSignupCourseLessonStat data error={}", (Object)stat);
                }
                if (list.isEmpty()) continue;
                unFinishedSignup.put(entry.getKey(), list);
            }
        }
        return unFinishedSignup;
    }

    @Override
    public void deleteClassLessons(Long orgId, Collection<Long> lessonIds) {
        this.signupCourseLessonDao.batchDelLesson(orgId.longValue(), lessonIds);
        this.changeLogService.addDelLessonsLog(orgId, lessonIds);
    }

    @Override
    public void updateSign(Long orgId, Long lessonId, Collection<Long> userIds) {
        this.signupCourseLessonDao.batchCancelLesson(orgId, lessonId, userIds);
    }

    @Override
    public void deleteStudentLessons(Long orgId, Collection<Long> userIds, Collection<Long> lessonIds) {
        this.signupCourseLessonDao.batchDelStuLesson(orgId.longValue(), userIds, lessonIds);
        List studentLessons = this.studentLessonDao.getAllStuLessonsBy(orgId, userIds, lessonIds, new String[]{"id"});
        if (studentLessons != null && studentLessons.size() > 0) {
            List ids = ListUtil.toKeyList((Collection)studentLessons, (String)"id", OrgStudentLesson.class);
            this.changeLogService.addDelStuLessonsLog(orgId, (Collection)ids);
        }
    }
}

