/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.dao.OrgCoursePhotoDao;
import com.baijia.tianxiao.dal.course.po.OrgCoursePhoto;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseRoom;
import com.baijia.tianxiao.dal.org.po.OrgCourseSms;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.StudentCourseApi;
import com.baijia.tianxiao.sal.common.dto.StudentCourseBase;
import com.baijia.tianxiao.sal.course.constant.ArrangeStatus;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.constant.ViewStatus;
import com.baijia.tianxiao.sal.course.dto.request.WeikeRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgCourseListServiceImpl
implements OrgCourseListService {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseListServiceImpl.class);
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgClassRoomDao orgClassRoomDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgTeacherDao orgTeacherDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private Environment environment;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Resource
    private OrgCoursePhotoDao orgCoursePhotoDao;
    @Resource
    private StudentCourseApi studentCourseApi;

    @Override
    public List<CourseListReponseDto> getCourseList(List<OrgCourse> courses, Long orgId, boolean needLesson, boolean needSms, boolean needTeacher, Boolean needStudent, boolean needRoom, boolean needCover, boolean needUrl) {
        OrgCourseListService.CourseListParam param = new OrgCourseListService.CourseListParam();
        param.setCourses(courses).setNeedLesson(needLesson).setNeedSms(needSms).setNeedTeacher(needTeacher).setNeedStudent(needStudent).setNeedRoom(needRoom).setNeedCover(needCover).setNeedUrl(needUrl).setOrgId(orgId);
        return this.getCourseList(param);
    }

    @Override
    public List<CourseListReponseDto> getWeikeList(Long orgId, WeikeRequestDto requestDto) {
        List courseIds;
        log.info("{},{}", (Object)orgId, (Object)requestDto);
        String key = requestDto.getSearchKey();
        List<Long> teacherIds = requestDto.getTeacherIdList();
        List<Integer> groupIds = requestDto.getGroupIdList();
        List<Integer> exGroupIds = requestDto.getExGroupIdList();
        Long orgNumber = this.getOrgNumber(orgId);
        List courseIdsOfTeachers = null;
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            courseIdsOfTeachers = this.orgCourseTeacherDao.getCourseIdsByteacherIds(teacherIds);
        }
        Collection courseOfGroups = null;
        if (CollectionUtils.isNotEmpty(groupIds)) {
            courseOfGroups = this.orgCourseGroupRelateDao.getCourseIdsByGroups(groupIds, Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        }
        Collection exCourseOfGroups = null;
        if (CollectionUtils.isNotEmpty(exGroupIds)) {
            exCourseOfGroups = this.orgCourseGroupRelateDao.getCourseIdsByGroups(exGroupIds, Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        }
        Collection filteredCourses = null;
        if (courseIdsOfTeachers != null) {
            filteredCourses = courseIdsOfTeachers;
            if (courseOfGroups != null) {
                filteredCourses.retainAll(courseOfGroups);
            }
        } else {
            filteredCourses = courseOfGroups;
        }
        if (CollectionUtils.isNotEmpty((Collection)(courseIds = this.orgCourseDao.getCourseList(orgNumber, filteredCourses, requestDto.getLPrice(), requestDto.getHPrice(), null, key, requestDto.getStatus(), CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, requestDto.getCourseType(), requestDto.getChargeType()))) && CollectionUtils.isNotEmpty((Collection)exCourseOfGroups)) {
            courseIds.removeAll(exCourseOfGroups);
        }
        Map<String, String> orderConditionMap = requestDto.getOrderConditionMap();
        OrgCourseDao.OrgCourseListParam param = new OrgCourseDao.OrgCourseListParam();
        param.setPage((PageDto)requestDto);
        param.setStatus(requestDto.getStatus());
        param.setIsCourse(Integer.valueOf(1));
        param.setIsClass(null);
        param.setChargeType(requestDto.getChargeType());
        if (MapUtils.isNotEmpty(orderConditionMap)) {
            String studentCountOrder = orderConditionMap.get("studentCount");
            if (StringUtils.isNotBlank((String)studentCountOrder)) {
                if ("ASC".equals(studentCountOrder)) {
                    courseIds = this.orgStudentCourseDao.getOrgCourseIds(orgId, courseIds, true, (PageDto)requestDto);
                } else if ("DESC".equals(studentCountOrder)) {
                    courseIds = this.orgStudentCourseDao.getOrgCourseIds(orgId, courseIds, false, (PageDto)requestDto);
                }
                param.setPage(null);
            } else {
                for (Map.Entry<String, String> entry : orderConditionMap.entrySet()) {
                    param.setOrderType(entry.getValue());
                    param.setOrderField(entry.getKey());
                }
            }
        } else {
            param.setOrderType("DESC");
            param.setOrderField("createTime");
        }
        List orgCourses = this.orgCourseDao.getCourseList(orgNumber, (Collection)courseIds, param, new String[0]);
        OrgCourseListService.CourseListParam courseListParam = new OrgCourseListService.CourseListParam();
        courseListParam.setCourses(orgCourses).setNeedCover(true).setNeedUrl(true).setNeedTeacher(requestDto.getLoadTeacherList()).setOrgId(orgId);
        return this.getCourseList(courseListParam);
    }

    @Override
    public Integer syncColors(PageDto pageDto) {
        String colorsStr = "";
        try {
            colorsStr = PropertiesReader.getValueNoCache((String)"erp.properties", (String)"course.colors");
        }
        catch (Exception exception) {
            // empty catch block
        }
        List courses = this.orgCourseDao.getByPage(pageDto, new String[]{"id", "color"});
        Random rd = new Random();
        String[] colors = null;
        if (StringUtils.isNotBlank((String)colorsStr)) {
            colors = colorsStr.split(",");
        }
        for (OrgCourse orgCourse : courses) {
            if (colors == null) continue;
            orgCourse.setColor(colors[rd.nextInt(colors.length - 1)]);
        }
        if (colors != null) {
            this.orgCourseDao.changeCourseColor((Collection)courses);
        }
        return courses.size();
    }

    private void batchUpdateColor(Set<Long> courseIds, List<OrgCourse> courses) {
        ArrayList courseList = Lists.newArrayList();
        String colorsStr = "";
        try {
            colorsStr = PropertiesReader.getValueNoCache((String)"erp.properties", (String)"course.colors");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] colors = null;
        if (StringUtils.isNotBlank((String)colorsStr)) {
            colors = colorsStr.split(",");
        }
        Random rd = new Random();
        for (OrgCourse orgCourse : courses) {
            if (StringUtils.isBlank((String)orgCourse.getColor())) {
                if (colors != null) {
                    orgCourse.setColor(colors[rd.nextInt(colors.length - 1)]);
                }
                courseList.add(orgCourse);
            }
            courseIds.add(orgCourse.getId());
        }
        if (colors != null) {
            this.orgCourseDao.changeCourseColor((Collection)courseList);
        }
    }

    private void getSmsCount(Map<Long, Integer> studentSms, Map<Long, Integer> teacherSms, Map<Long, Integer> studentView, Map<Long, Integer> teacherView, List<OrgCourseSms> courseSms, Map<Long, List<Long>> courseStudentMap, Map<Long, List<Long>> courseTeacherMap) {
        for (OrgCourseSms orgCourseSms : courseSms) {
            if (!studentSms.containsKey(orgCourseSms.getCourseId())) {
                studentSms.put(orgCourseSms.getCourseId(), 0);
            }
            if (!teacherSms.containsKey(orgCourseSms.getCourseId())) {
                teacherSms.put(orgCourseSms.getCourseId(), 0);
            }
            if (!studentView.containsKey(orgCourseSms.getCourseId())) {
                studentView.put(orgCourseSms.getCourseId(), 0);
            }
            if (!teacherView.containsKey(orgCourseSms.getCourseId())) {
                teacherView.put(orgCourseSms.getCourseId(), 0);
            }
            if (orgCourseSms.getUserRole().intValue() == UserRole.STUDENT.getRole()) {
                List<Long> studentIds = courseStudentMap.get(orgCourseSms.getCourseId());
                if (studentIds == null || !studentIds.contains(orgCourseSms.getUserId())) continue;
                if (orgCourseSms.getSend() > 0) {
                    studentSms.put(orgCourseSms.getCourseId(), studentSms.get(orgCourseSms.getCourseId()) + 1);
                }
                if (orgCourseSms.getViewStatus().intValue() != ViewStatus.VIEW.getCode()) continue;
                studentView.put(orgCourseSms.getCourseId(), studentView.get(orgCourseSms.getCourseId()) + 1);
                continue;
            }
            List<Long> teacherIds = courseTeacherMap.get(orgCourseSms.getCourseId());
            if (teacherIds == null || !teacherIds.contains(orgCourseSms.getUserId())) continue;
            if (orgCourseSms.getSend() > 0) {
                teacherSms.put(orgCourseSms.getCourseId(), teacherSms.get(orgCourseSms.getCourseId()) + 1);
            }
            if (orgCourseSms.getViewStatus().intValue() != ViewStatus.VIEW.getCode()) continue;
            teacherView.put(orgCourseSms.getCourseId(), teacherView.get(orgCourseSms.getCourseId()) + 1);
        }
    }

    @Override
    public Map<Integer, String> getCoverMap(List<OrgCourse> courses) {
        Collection coverList = CollectorUtil.collect(courses, (Function)new Function<OrgCourse, Integer>(){

            public Integer apply(OrgCourse arg0) {
                return arg0.getCover();
            }
        });
        List storages = this.storageDao.getByIds(coverList, new String[0]);
        return CollectorUtil.collectMap((Collection)storages, (Function)new Function<Storage, Integer>(){

            public Integer apply(Storage arg0) {
                return arg0.getId().intValue();
            }
        }, (Function)new Function<Storage, String>(){

            public String apply(Storage arg0) {
                if (StringUtils.isNotBlank((String)arg0.getAttach_url())) {
                    return arg0.getAttach_url();
                }
                return StorageUtil.constructUrl((Long)arg0.getFid(), (String)arg0.getMimetype(), (String)arg0.getSn());
            }
        });
    }

    @Override
    public Map<Long, OrgCoursePhoto> getPhoteMap(List<Long> courseIds) {
        HashMap<String, List<Long>> condition = new HashMap<String, List<Long>>();
        condition.put("orgCourseId", courseIds);
        List list = this.orgCoursePhotoDao.queryByCourseIds(courseIds);
        HashMap<Long, OrgCoursePhoto> map = new HashMap<Long, OrgCoursePhoto>();
        for (OrgCoursePhoto coursePhoto : list) {
            map.put(coursePhoto.getOrgCourseId(), coursePhoto);
        }
        return map;
    }

    private void buildCourseListResponseDto(OrgCourse po, CourseListReponseDto dto) {
        dto.setOrgCourseId(po.getId());
        dto.setOrgCourseNumber(po.getNumber());
        dto.setColor(po.getColor());
        dto.setCourseName(po.getName());
        dto.setMaxStudent(po.getMaxStudent());
        dto.setFreq(po.getFreq());
        dto.setStartTime(po.getBeginTime());
        dto.setEndTime(po.getEndTime());
        dto.setPrice(po.getPrice());
        dto.setStatus(po.getStatus());
        String intro = BaseUtils.blobToString((Blob)po.getIntroduction(), (String)"UTF-8");
        dto.setIntroduction(intro);
        dto.setIsCourse(po.getIsCourse());
        dto.setIsClass(po.getIsClass());
        dto.setCourseType(po.getCourseType());
        dto.setIsFinish(po.getIsFinish());
    }

    private void buildLessonCount(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> arrangeMap, Map<Long, Integer> finishMap) {
        if (arrangeMap.containsKey(po.getId())) {
            dto.setLessonCount(arrangeMap.get(po.getId()));
        } else {
            dto.setLessonCount(0);
        }
        if (finishMap.containsKey(po.getId())) {
            dto.setLessonFinish(finishMap.get(po.getId()));
        } else {
            dto.setLessonFinish(0);
        }
        if (dto.getLessonCount() != null && dto.getLessonFinish() != null && dto.getLessonCount() > dto.getLessonFinish() && dto.getLessonFinish() > 0) {
            dto.setArrageStatus(ArrangeStatus.BEGIN.getCode());
        } else if (dto.getLessonCount() != null && dto.getLessonCount() > 0) {
            dto.setArrageStatus(ArrangeStatus.ARRANGEED.getCode());
        } else {
            dto.setArrageStatus(ArrangeStatus.UNARRANGE.getCode());
        }
    }

    private void buildTeacher(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> teacherMap) {
        Integer count = teacherMap.get(po.getId());
        if (count != null) {
            dto.setTeacherCount(count);
        } else {
            dto.setTeacherCount(0);
        }
    }

    private void buildStudent(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> studentMap) {
        Integer count = studentMap.get(po.getId());
        if (count != null) {
            dto.setStudentCount(count);
        } else {
            dto.setStudentCount(0);
        }
    }

    private void buildRoom(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> roomMap) {
        Integer count = roomMap.get(po.getId());
        if (count != null) {
            dto.setRoomCount(count);
        } else {
            dto.setRoomCount(0);
        }
    }

    private void buildSmsCount(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> studentSms, Map<Long, Integer> teacherSms, Map<Long, Integer> studentView, Map<Long, Integer> teacherView) {
        int studentSmsCount = 0;
        int teacherSmsCount = 0;
        int studentViewCount = 0;
        int teacherViewCount = 0;
        if (studentSms.get(po.getId()) != null) {
            studentSmsCount = studentSms.get(po.getId());
        }
        if (teacherSms.get(po.getId()) != null) {
            teacherSmsCount = teacherSms.get(po.getId());
        }
        if (studentView.get(po.getId()) != null) {
            studentViewCount = studentView.get(po.getId());
        }
        if (teacherView.get(po.getId()) != null) {
            teacherViewCount = teacherView.get(po.getId());
        }
        log.debug("studentSmsCount={}, teacherSmsCount={}", (Object)studentSmsCount, (Object)teacherSmsCount);
        dto.setSmsStudent(dto.getStudentCount() - studentSmsCount);
        dto.setViewStudent(dto.getStudentCount() - studentViewCount);
        dto.setSmsTeacher(dto.getTeacherCount() - teacherSmsCount);
        dto.setViewTeacher(dto.getTeacherCount() - teacherViewCount);
    }

    private Long getOrgNumber(Long orgId) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (orgAccount == null) {
            log.error("orgId={} not exist in orgAccount.", (Object)orgId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u5e10\u53f7\u9519\u8bef");
        }
        return orgAccount.getNumber().longValue();
    }

    @Override
    @Transactional(readOnly=true)
    public List<CourseListReponseDto> getCourseList(@NonNull Long orgId, @NonNull Long studentId, PageDto pageDto) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"student not exits!");
        List stuCourses = this.orgStudentCourseDao.getOrgCourseIds(orgId, userId, pageDto);
        if (CollectionUtils.isEmpty((Collection)stuCourses)) {
            return Collections.emptyList();
        }
        HashMap idCourseMap = Maps.newHashMap();
        for (OrgStudentCourse course : stuCourses) {
            idCourseMap.put(course.getCourseId(), course);
        }
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (orgAccount == null) {
            log.error("orgId={} not exist in orgAccount.", (Object)orgId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u5e10\u53f7\u9519\u8bef");
        }
        Long orgNumber = orgAccount.getNumber().longValue();
        List courses = this.orgCourseDao.getCourseList(idCourseMap.keySet(), orgNumber, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null, null, new String[0]);
        log.info("OrgStudentCourses = {}, courses = {}, page = {}", new Object[]{stuCourses, courses, pageDto});
        if (CollectionUtils.isEmpty((Collection)courses)) {
            return Collections.emptyList();
        }
        List<CourseListReponseDto> list = this.getCourseList(courses, orgId, true, false, false, false, false, true, false);
        if (CollectionUtils.isNotEmpty(list)) {
            Map lessonCountMap = this.orgStudentLessonDao.getStudentLessonCountOfCourses(orgId, userId, idCourseMap.keySet());
            log.debug("list={},lessonCountMap={}", list, (Object)lessonCountMap);
            for (CourseListReponseDto dto : list) {
                Integer lessonCount = (Integer)lessonCountMap.get(dto.getOrgCourseId());
                if (lessonCount == null) {
                    lessonCount = 0;
                }
                dto.setLessonCount(lessonCount);
                dto.setStatus(((OrgStudentCourse)idCourseMap.get(dto.getOrgCourseId())).getStatus());
            }
        }
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public CourseListReponseDto getCourseDetail(Long orgId, Long orgCourseId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((orgCourseId != null ? 1 : 0) != 0, (Object)"orgCourseId is null!");
        OrgCourse course = this.orgCourseDao.getByCourseId(orgCourseId, new String[0]);
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        if (course == null || account == null || course.getOrgNumber().longValue() != account.getNumber().longValue()) {
            log.warn("orgId or courseId not exist error,orgId={},courseId={}", (Object)orgId, (Object)orgCourseId);
            throw new BussinessException((UniverseErrorCode)CourseErrorCode.COURSE_NOT_EXIST);
        }
        Integer lessonCount = this.orgClassLessonDao.getLessonCount(orgId, orgCourseId, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Integer finishCount = this.orgClassLessonDao.getFinishLessonCount(orgId, orgCourseId, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        List roomIds = this.orgCourseRoomDao.getCourseRoomIds(orgId, orgCourseId);
        HashSet roomIdSet = Sets.newHashSet();
        for (Long roomId : roomIds) {
            roomIdSet.add(roomId);
        }
        List teacherIds = this.orgCourseTeacherDao.getTeacherIdsByCourseId(orgCourseId);
        List studentIds = this.orgStudentCourseDao.getStudents(orgId, orgCourseId, Integer.valueOf(0));
        List teacherList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)teacherIds)) {
            teacherList = this.orgTeacherDao.getTeacherByUserIdsAndOrgId(orgId, (Collection)teacherIds, Integer.valueOf(1), new String[]{"userId"});
        }
        List studentlist = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)studentIds)) {
            studentlist = this.orgStudentDao.getStudentByUserIds(orgId, (Collection)studentIds, new String[]{"userId", "id"});
        }
        CourseListReponseDto temp = this.fillMinutesInfo(course, studentIds, orgId);
        CourseListReponseDto dto = new CourseListReponseDto();
        dto.setCourseType((int)course.getCourseType());
        dto.setCourseName(course.getName());
        dto.setOrgCourseId(orgCourseId);
        dto.setOrgCourseNumber(course.getNumber());
        dto.setFreq(temp.getFreq());
        String courseUrl = this.environment.getProperty("org_class_course.url");
        dto.setCourseUrl(course.getNumber() == null ? "" : courseUrl + course.getNumber());
        if (course.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && course.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode() && course.getParentId() > 0L) {
            OrgCourse parentCourse = this.orgCourseDao.getByCourseId(course.getParentId(), new String[0]);
            dto.setCourseUrl(parentCourse.getNumber() == null ? "" : courseUrl + parentCourse.getNumber());
        }
        dto.setLessonCount(lessonCount);
        dto.setLessonFinish(finishCount);
        dto.setRoomCount(roomIdSet.size());
        dto.setTeacherCount(teacherList.size());
        dto.setStudentCount(studentlist.size());
        dto.setStatus(course.getStatus());
        dto.setMaxStudent(course.getMaxStudent());
        dto.setColor(course.getColor());
        dto.setCreateTime(course.getCreateTime());
        dto.setCascadeId(course.getCascadeId());
        dto.setIsCourse(course.getIsCourse());
        dto.setIsClass(course.getIsClass());
        dto.setIsFinish(course.getIsFinish());
        dto.setPrice(course.getPrice());
        dto.setChargeType(course.getChargeType());
        dto.setChargeUnit(course.getChargeUnit());
        dto.setKexiaoTime(course.getKexiaoTime());
        dto.setKexiaoCascadeId(course.getKexiaoCascadeId());
        dto.setPaidMinutes(temp.getPaidMinutes());
        dto.setArrangedMinutes(temp.getArrangedMinutes());
        dto.setFinishedMinutes(temp.getFinishedMinutes());
        dto.setRemainClassHour(temp.getRemainClassHour());
        dto.setRemainClassTime(temp.getRemainClassTime());
        dto.setStudentId(temp.getStudentId());
        dto.setStudentName(temp.getStudentName());
        dto.setStudentMobile(temp.getStudentMobile());
        Long signupId = 0L;
        signupId = CourseTypeEnum.IS_CLASS_TRUE.getCode() == course.getIsClass() && CourseTypeEnum.IS_COURSE_FALSE.getCode() == course.getIsCourse() ? course.getParentId() : course.getId();
        dto.setSignUpCourseId(signupId);
        dto.setSignUpCourseName(course.getSnapshotName());
        return dto;
    }

    private CourseListReponseDto fillMinutesInfo(OrgCourse course, List<Long> studentIds, Long orgId) {
        int paid = 0;
        int arrange = 0;
        int finish = 0;
        int freq = 0;
        int remainClassHour = 0;
        int remainClassTime = 0;
        long studentId = 0L;
        String name = "";
        String mobile = "";
        CourseListReponseDto dto = new CourseListReponseDto();
        if (course.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            if (CollectionUtils.isNotEmpty(studentIds)) {
                Long userId = studentIds.get(0);
                OrgStudent student = this.orgStudentDao.getStudentByUserId(orgId, userId, new String[0]);
                ArrayList ids = Lists.newArrayList();
                ids.add(userId);
                Map baseMap = this.studentCourseApi.getAllData((List)ids, course.getId(), orgId);
                log.debug("--------------userId={},baseMap={}", (Object)userId, (Object)baseMap);
                StudentCourseBase base = (StudentCourseBase)baseMap.get(userId);
                if (course.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode()) {
                    paid = base != null ? base.getBuyTime() : 0;
                    arrange = base != null ? base.getLessonTime() : 0;
                    int n = finish = base != null ? base.getFinishTime() : 0;
                    int n2 = base != null ? (base.getBuyTime() > base.getLessonNormalTime() ? 1 : 0) : (remainClassHour = 0);
                }
                if (course.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    remainClassTime = base != null ? (base.getBuyCount() > base.getLessonNormalCount() ? 1 : 0) : 0;
                    freq = base != null ? base.getBuyCount() : 0;
                }
                studentId = student.getId();
                name = student.getName();
                mobile = student.getMobile();
            }
        } else {
            ArrayList courseIds = Lists.newArrayList();
            courseIds.add(course.getId());
            Map arrangeLessonLengthMap = null;
            Map finishLessonLengthMap = null;
            arrangeLessonLengthMap = this.orgClassLessonDao.getLessonLengthMap(orgId, (Collection)courseIds, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            finishLessonLengthMap = this.orgClassLessonDao.getFinishLessonLengthMap(orgId, (Collection)courseIds, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            Map fMap = (Map)finishLessonLengthMap.get(course.getId());
            Map aMap = (Map)arrangeLessonLengthMap.get(course.getId());
            finish = fMap != null ? this.intSum(fMap.values()) : 0;
            arrange = aMap != null ? this.intSum(aMap.values()) : 0;
            freq = course.getFreq() != null ? course.getFreq() : 0;
            log.debug("ban ke--------------arrange={},finish={}", (Object)arrange, (Object)finish);
        }
        dto.setFinishedMinutes(finish);
        dto.setPaidMinutes(paid);
        dto.setArrangedMinutes(arrange);
        dto.setRemainClassHour(remainClassHour);
        dto.setRemainClassTime(remainClassTime);
        dto.setStudentId(studentId);
        dto.setStudentName(name);
        dto.setStudentMobile(mobile);
        dto.setFreq(freq);
        log.debug("-----------------u={},p={},a={},h={},t={}", new Object[]{course.getChargeUnit(), paid, arrange, remainClassHour, remainClassTime});
        return dto;
    }

    private Integer intSum(Collection<Integer> values) {
        int sum = 0;
        if (CollectionUtils.isNotEmpty(values)) {
            for (Integer value : values) {
                sum += value.intValue();
            }
        }
        return sum;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional(noRollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public List<CourseListReponseDto> getCourseList(OrgCourseListService.CourseListParam param) {
        long l = System.currentTimeMillis();
        List<OrgCourse> courses = param.getCourses();
        Long studentId = param.getStudentId();
        Long teacherId = param.getTeacherId();
        Long orgId = param.getOrgId();
        boolean needLesson = param.isNeedLesson();
        boolean needSms = param.isNeedSms();
        boolean needTeacher = param.isNeedTeacher();
        boolean needStudent = param.isNeedStudent();
        boolean needRoom = param.isNeedRoom();
        boolean needCover = param.isNeedCover();
        boolean needUrl = param.isNeedUrl();
        log.debug("needLesson={},needSms={},needTeacher={},needStudent={},needRoom={},needCover={},needUrl={}", new Object[]{needLesson, needSms, needTeacher, needStudent, needRoom, needCover, needUrl});
        LinkedList response = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty(courses)) {
            HashSet courseIds = Sets.newHashSet();
            this.batchUpdateColor(courseIds, courses);
            HashMap<Long, Integer> courseTypeMap = new HashMap<Long, Integer>();
            HashSet parentIds = Sets.newHashSet();
            Map<Integer, String> coverMap = null;
            Map arrangeMap = null;
            Map finishMap = null;
            Map courseTeacherIdsMap = null;
            Map arrangeLessonLengthMap = null;
            Map finishLessonLengthMap = null;
            for (OrgCourse orgCourse : courses) {
                courseTypeMap.put(orgCourse.getId(), orgCourse.getCourseType());
                if (orgCourse.getIsCourse() != CourseTypeEnum.IS_COURSE_FALSE.getCode() || orgCourse.getParentId() == null || orgCourse.getParentId() <= 0L) continue;
                parentIds.add(orgCourse.getParentId());
            }
            if (needCover) {
                coverMap = this.getCoverMap(courses);
            }
            if (needLesson) {
                arrangeMap = this.orgClassLessonDao.getCourseLessonCount(orgId, (Collection)courseIds, studentId, teacherId, null);
                finishMap = this.orgClassLessonDao.getCourseLessonCount(orgId, (Collection)courseIds, studentId, teacherId, new Date());
                arrangeLessonLengthMap = this.orgClassLessonDao.getLessonLengthMap(orgId, (Collection)courseIds, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                finishLessonLengthMap = this.orgClassLessonDao.getFinishLessonLengthMap(orgId, (Collection)courseIds, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            }
            if (needTeacher) {
                courseTeacherIdsMap = this.orgCourseTeacherDao.getTeacherMap((Collection)courseIds);
                List allTeacherUserIds = this.orgTeacherDao.getTeacherIds(orgId, Integer.valueOf(1));
                for (Map.Entry entry : courseTeacherIdsMap.entrySet()) {
                    List tempIds = (List)entry.getValue();
                    tempIds.retainAll(allTeacherUserIds);
                }
            }
            Map studentIdMap = null;
            Object var26_28 = null;
            if (needStudent) {
                Map map = this.orgStudentCourseDao.getStudentMapBycourseIds((Collection)courseIds, 0, new String[]{"courseId", "userId"});
                studentIdMap = this.orgStudentCourseDao.getStudentIdMapBycourseIds((Collection)courseIds, orgId);
            }
            Object var27_32 = null;
            Map roomNameMap = null;
            if (needRoom) {
                Map map = this.orgCourseRoomDao.getCourseRoomMap(orgId, (Collection)courseIds, new String[0]);
                HashSet roomIds = Sets.newHashSet();
                for (Long k : map.keySet()) {
                    List rooms = (List)map.get(k);
                    for (OrgCourseRoom room : rooms) {
                        roomIds.add(room.getRoomId());
                    }
                }
                roomNameMap = this.orgClassRoomDao.getRoomName(orgId, (Collection)roomIds);
            }
            HashMap studentSms = Maps.newHashMap();
            HashMap teacherSms = Maps.newHashMap();
            HashMap studentView = Maps.newHashMap();
            HashMap teacherView = Maps.newHashMap();
            if (needSms) {
                if (studentIdMap == null) {
                    studentIdMap = this.orgStudentCourseDao.getStudentIdMapBycourseIds((Collection)courseIds, orgId);
                }
                Map courseTeacherIdMap = this.orgCourseTeacherDao.getTeacherMap((Collection)courseIds);
                List courseSms = this.orgCourseSmsDao.getOrgCourseSmsList(orgId, (Collection)courseIds, null, new String[0]);
                this.getSmsCount(studentSms, teacherSms, studentView, teacherView, courseSms, studentIdMap, courseTeacherIdMap);
                log.debug("student sms count ={},teacher sms count ={}", (Object)studentSms, (Object)teacherSms);
            }
            String url = this.environment.getProperty("org_class_course.url");
            for (OrgCourse course : courses) {
                void var27_34;
                List roomsOfCourse;
                CourseListReponseDto responseDto = new CourseListReponseDto();
                this.buildCourseListResponseDto(course, responseDto);
                responseDto.setCourseType((Integer)courseTypeMap.get(course.getId()));
                if (needCover) {
                    responseDto.setCoverUrl(coverMap.get(course.getCover()));
                }
                if (needUrl) {
                    OrgCourse parentCourse;
                    Long number = course.getNumber();
                    Map parentCourseMap = this.orgCourseDao.getOrgCourseMap((Collection)parentIds, new String[0]);
                    if (course.getIsCourse() == CourseTypeEnum.IS_COURSE_FALSE.getCode() && course.getParentId() != null && course.getParentId() > 0L && (parentCourse = (OrgCourse)parentCourseMap.get(course.getParentId())) != null) {
                        number = parentCourse.getNumber();
                    }
                    responseDto.setCourseUrl(url + number);
                }
                if (needLesson) {
                    this.buildLessonCount(course, responseDto, arrangeMap, finishMap);
                    Map fMap = (Map)finishLessonLengthMap.get(course.getId());
                    Map aMap = (Map)arrangeLessonLengthMap.get(course.getId());
                    responseDto.setFinishedMinutes(fMap != null ? this.intSum(fMap.values()) : 0);
                    responseDto.setArrangedMinutes(aMap != null ? this.intSum(aMap.values()) : 0);
                }
                if (needTeacher) {
                    List teacherIdList = (List)courseTeacherIdsMap.get(course.getId());
                    if (teacherIdList != null) {
                        responseDto.setTeacherCount(teacherIdList.size());
                    } else {
                        responseDto.setTeacherCount(0);
                    }
                }
                if (needStudent) {
                    void var26_30;
                    List courseList = (List)var26_30.get(course.getId());
                    if (courseList == null) {
                        courseList = Lists.newArrayList();
                    }
                    ArrayList students = Lists.newArrayList();
                    List studentIdList = (List)studentIdMap.get(course.getId());
                    if (studentIdList != null) {
                        responseDto.setStudentCount(studentIdList.size());
                    } else {
                        responseDto.setStudentCount(0);
                    }
                }
                if (needRoom && CollectionUtils.isNotEmpty((Collection)(roomsOfCourse = (List)var27_34.get(course.getId())))) {
                    String roomNames = "";
                    log.debug("roomsOfCourse ==={}", (Object)roomsOfCourse);
                    HashSet roomIdSet = Sets.newHashSet();
                    for (OrgCourseRoom room : roomsOfCourse) {
                        if (roomIdSet.contains(room.getRoomId())) continue;
                        roomIdSet.add(room.getRoomId());
                        ArrayList roomNamesList = Lists.newArrayList();
                        roomNamesList.add(roomNameMap.get(room.getRoomId()));
                        roomNames = StringUtils.join((Collection)roomNamesList, (String)",");
                        if (!room.isDefault()) continue;
                        break;
                    }
                    responseDto.setRoomCount(roomIdSet.size());
                    responseDto.setRoomNames(roomNames);
                }
                if (needSms) {
                    this.buildSmsCount(course, responseDto, studentSms, teacherSms, studentView, teacherView);
                }
                responseDto.setCreateTime(course.getCreateTime());
                responseDto.setCascadeId(course.getCascadeId());
                responseDto.setAddress(course.getAddress());
                responseDto.setStartTime(course.getBeginTime());
                responseDto.setEndTime(course.getEndTime());
                responseDto.setCourseType(course.getCourseType());
                responseDto.setChargeType(course.getChargeType());
                responseDto.setChargeUnit(course.getChargeUnit());
                responseDto.setKexiaoTime(course.getKexiaoTime());
                responseDto.setKexiaoCascadeId(course.getKexiaoCascadeId());
                response.add(responseDto);
            }
        }
        return response;
    }

    private Map<Long, Integer> getCourseStudentMap(Map<Long, List<Long>> courseStudentMap, Long orgId) {
        HashMap result = Maps.newHashMap();
        HashSet userIds = Sets.newHashSet();
        for (Map.Entry<Long, List<Long>> entry : courseStudentMap.entrySet()) {
            List<Long> value = entry.getValue();
            userIds.addAll(value);
        }
        log.info("userIds in course ={}", (Object)userIds);
        Map userIdStudentMap = this.orgStudentDao.getUserIdStudentIdMap((Collection)userIds, orgId, true);
        userIds.removeAll(userIdStudentMap.keySet());
        log.info("userIds not in org course ={}", (Object)userIds);
        for (Map.Entry<Long, List<Long>> entry : courseStudentMap.entrySet()) {
            Long key = entry.getKey();
            List<Long> value = entry.getValue();
            value.removeAll(userIds);
            result.put(key, value.size());
        }
        return result;
    }
}

