/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.OrgErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.response.OrgCourseGroupDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgCourseGroupServiceImpl
implements OrgCourseGroupService {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseGroupServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(OrgCourseGroupServiceImpl.class);
    @Autowired
    private OrgCourseGroupDao orgCourseGroupDao;
    @Autowired
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgCourseDao orgCourseDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modify(Integer orgId, Integer courseGroupId, String groupName) throws BussinessException {
        logger.info("modify.orgId:{}, courseGroupId:{}", (Object)orgId, (Object)courseGroupId);
        OrgCourseGroup orgCourseGroup = (OrgCourseGroup)this.orgCourseGroupDao.getById((Serializable)courseGroupId, new String[0]);
        if (orgCourseGroup == null) {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.NO_SUBJECT_FOR_REQ);
        }
        if (orgCourseGroup.getOrgId().intValue() != orgId.intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PERMISSION_DENY);
        }
        if (!groupName.equals(orgCourseGroup.getName())) {
            orgCourseGroup.setName(groupName);
            orgCourseGroup.setUpdateTime(new Date());
            this.orgCourseGroupDao.update((Object)orgCourseGroup, new String[]{"name", "updateTime"});
        }
    }

    @Override
    public Integer add(Integer orgId, String groupName) {
        if (this.orgCourseGroupDao.countByName(orgId, groupName) > 0) {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.COURSE_GROUP_NAME_EXISTS);
        }
        OrgCourseGroup orgCourseGroup = new OrgCourseGroup();
        orgCourseGroup.setName(groupName);
        orgCourseGroup.setOrgId(orgId);
        this.orgCourseGroupDao.save((Object)orgCourseGroup, new String[]{"name", "orgId"});
        return orgCourseGroup.getId();
    }

    @Override
    public Integer addLast(Integer orgId, String groupName) {
        if (this.orgCourseGroupDao.countByName(orgId, groupName) > 0) {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.COURSE_GROUP_NAME_EXISTS);
        }
        List orgCourseGroups = this.orgCourseGroupDao.getOrgCourseGroupList(orgId);
        Collection<Integer> groupIds = this.group2Ids(orgCourseGroups);
        OrgCourseGroup orgCourseGroup = new OrgCourseGroup();
        orgCourseGroup.setName(groupName);
        orgCourseGroup.setOrgId(orgId);
        this.orgCourseGroupDao.save((Object)orgCourseGroup, new String[]{"name", "orgId"});
        groupIds.add(orgCourseGroup.getId());
        this.order(groupIds);
        return orgCourseGroup.getId();
    }

    private Collection<Integer> group2Ids(Collection<OrgCourseGroup> orgCourseGroups) {
        ArrayList result = Lists.newArrayList();
        for (OrgCourseGroup group : orgCourseGroups) {
            result.add(group.getId());
        }
        return result;
    }

    private Long getOrgNumber(Long orgId) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (orgAccount == null) {
            log.error("orgId={} not exist in orgAccount.", (Object)orgId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u5e10\u53f7\u9519\u8bef");
        }
        return orgAccount.getNumber().longValue();
    }

    @Override
    public List<OrgCourseGroupDto> getByCourseId(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId!");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"illegal courseId!");
        ArrayList list = Lists.newArrayList();
        List groupIds = this.orgCourseGroupRelateDao.getGroupIdByCourseId(courseId, Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        if (CollectionUtils.isEmpty((Collection)groupIds)) {
            return Collections.emptyList();
        }
        Long orgNumber = this.getOrgNumber(orgId);
        List courseIds = this.orgCourseDao.getCourseIds(orgNumber, null, CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null);
        Map cntMap = this.orgCourseGroupDao.getCourseCountMap(Integer.valueOf(orgId.intValue()), (Collection)courseIds, (Collection)groupIds);
        List orgCourseGroups = this.orgCourseGroupDao.getByIds((Collection)groupIds, new String[0]);
        for (OrgCourseGroup group : orgCourseGroups) {
            if (group.getIsDeleted().intValue() == DeleteStatus.DELETED.getValue()) continue;
            OrgCourseGroupDto orgCourseGroupDto = new OrgCourseGroupDto();
            orgCourseGroupDto.setGroupId(group.getId());
            orgCourseGroupDto.setGroupName(group.getName());
            Integer cnt = (Integer)cntMap.get(group.getId());
            orgCourseGroupDto.setCourseNum(cnt == null ? 0 : cnt);
            list.add(orgCourseGroupDto);
        }
        return list;
    }

    @Override
    public List<OrgCourseGroupDto> list(Integer orgId) {
        Preconditions.checkArgument((orgId != null && orgId > 0 ? 1 : 0) != 0, (Object)"illegal orgId!");
        ArrayList list = Lists.newArrayList();
        List orgCourseGroups = this.orgCourseGroupDao.getOrgCourseGroupList(orgId);
        log.debug("orgCourseGroups={}", (Object)orgCourseGroups);
        if (CollectionUtils.isEmpty((Collection)orgCourseGroups)) {
            return Collections.emptyList();
        }
        Collection<Integer> groupIds = this.group2Ids(orgCourseGroups);
        Long orgNumber = this.getOrgNumber(orgId.longValue());
        List courseIds = this.orgCourseDao.getCourseIds(orgNumber, null, CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null);
        Map cntMap = this.orgCourseGroupDao.getCourseCountMap(orgId, (Collection)courseIds, groupIds);
        for (OrgCourseGroup group : orgCourseGroups) {
            OrgCourseGroupDto orgCourseGroupDto = new OrgCourseGroupDto();
            orgCourseGroupDto.setGroupId(group.getId());
            orgCourseGroupDto.setGroupName(group.getName());
            Integer cnt = (Integer)cntMap.get(group.getId());
            orgCourseGroupDto.setCourseNum(cnt == null ? 0 : cnt);
            list.add(orgCourseGroupDto);
        }
        return list;
    }

    @Override
    public List<OrgCourseGroupDto> listNoCount(Integer orgId) {
        Preconditions.checkArgument((orgId != null && orgId > 0 ? 1 : 0) != 0, (Object)"illegal orgId!");
        ArrayList list = Lists.newArrayList();
        List orgCourseGroups = this.orgCourseGroupDao.getOrgCourseGroupList(orgId);
        if (CollectionUtils.isEmpty((Collection)orgCourseGroups)) {
            return Collections.emptyList();
        }
        for (OrgCourseGroup group : orgCourseGroups) {
            OrgCourseGroupDto orgCourseGroupDto = new OrgCourseGroupDto();
            orgCourseGroupDto.setGroupId(group.getId());
            orgCourseGroupDto.setGroupName(group.getName());
            list.add(orgCourseGroupDto);
        }
        return list;
    }

    @Override
    public Integer delete(Integer groupId) {
        OrgCourseGroup orgCourseGroup = new OrgCourseGroup();
        orgCourseGroup.setId(groupId);
        orgCourseGroup.setIsDeleted(Integer.valueOf(1));
        return this.orgCourseGroupDao.update((Object)orgCourseGroup, new String[]{"isDeleted"});
    }

    @Override
    public void order(Collection<Integer> groupIds) {
        if (CollectionUtils.isEmpty(groupIds)) {
            return;
        }
        int order = groupIds.size();
        for (Integer id : groupIds) {
            OrgCourseGroup orgCourseGroup = (OrgCourseGroup)this.orgCourseGroupDao.getById((Serializable)id, new String[0]);
            orgCourseGroup.setDisplayOrder(Integer.valueOf(order--));
            orgCourseGroup.setUpdateTime(new Date());
            this.orgCourseGroupDao.saveOrUpdate((Object)orgCourseGroup, new String[0]);
        }
    }

    @Override
    public List<OrgCourseGroupDto> list(Integer orgId, String key, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null && orgId > 0 ? 1 : 0) != 0, (Object)"illegal orgId!");
        ArrayList list = Lists.newArrayList();
        List orgCourseGroups = this.orgCourseGroupDao.getOrgCourseGroupList(orgId, key, pageDto);
        log.debug("orgCourseGroups={}", (Object)orgCourseGroups);
        if (CollectionUtils.isEmpty((Collection)orgCourseGroups)) {
            return Collections.emptyList();
        }
        Collection<Integer> groupIds = this.group2Ids(orgCourseGroups);
        Long orgNumber = this.getOrgNumber(orgId.longValue());
        List courseIds = this.orgCourseDao.getCourseIds(orgNumber, null, CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null);
        Map cntMap = this.orgCourseGroupDao.getCourseCountMap(orgId, (Collection)courseIds, groupIds);
        for (OrgCourseGroup group : orgCourseGroups) {
            OrgCourseGroupDto orgCourseGroupDto = new OrgCourseGroupDto();
            orgCourseGroupDto.setGroupId(group.getId());
            orgCourseGroupDto.setGroupName(group.getName());
            Integer cnt = (Integer)cntMap.get(group.getId());
            orgCourseGroupDto.setCourseNum(cnt == null ? 0 : cnt);
            list.add(orgCourseGroupDto);
        }
        return list;
    }
}

