/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.ClassHour;
import com.baijia.tianxiao.dal.org.po.LessonSignAudit;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.request.TeacherClassHourRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgTeacherLessonInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherClassHourDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherCourseDto;
import com.baijia.tianxiao.sal.course.service.OrgTeacherClassHourService;
import com.baijia.tianxiao.sal.course.util.ExcelExportService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgTeacherClassHourServiceImpl
implements OrgTeacherClassHourService {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherClassHourServiceImpl.class);
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgClassRoomDao orgClassRoomDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgInfoDao orgInfoDao;

    @Override
    public List<TeacherClassHourDto> queryTeacherClassHourList(Long orgId, TeacherClassHourRequestDto params, PageDto page) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((params.getStartTimeDate() != null ? 1 : 0) != 0, (Object)"startTime is null!");
        Preconditions.checkArgument((params.getEndTimeDate() != null ? 1 : 0) != 0, (Object)"endTime is null!");
        log.info("query classHour list of teacher, orgId={},params={},page={}", new Object[]{orgId, params, page});
        List lessonIds = this.orgClassLessonDao.queryFinishedLessonIds(orgId, null, params.getStartTimeDate(), params.getEndTimeDate());
        log.debug("teacher lessonIds={},size={}", (Object)lessonIds, (Object)lessonIds.size());
        if (CollectionUtils.isEmpty((Collection)lessonIds)) {
            return Lists.newArrayList();
        }
        List classHourList = this.orgClassLessonDao.queryTeacherClassHourList((Collection)lessonIds, null, page, false);
        log.debug("teacher ClassHourList={},size={}", (Object)classHourList, (Object)classHourList.size());
        HashSet teacherIds = Sets.newHashSet();
        for (ClassHour classHour : classHourList) {
            teacherIds.add(classHour.getTeacherId());
        }
        List teacherList = this.teacherDao.getByTeacherIds((Collection)teacherIds, new String[0]);
        Map teacherMap = CollectorUtil.collectMap((Collection)teacherList, (Function)new Function<Teacher, Long>(){

            public Long apply(Teacher arg0) {
                return arg0.getUserId();
            }
        });
        Map signAuditMap = this.orgLessonSignDao.queryLessonSignAudit(orgId, (Collection)lessonIds);
        Map lessonStudentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
        Map lessonTeacherMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
        Map<Long, Integer> teacherSignCountMap = this.buildAllTeacherLessonSign(lessonIds, lessonTeacherMap, signAuditMap, lessonStudentCountMap);
        return this.buildDtoList(classHourList, teacherMap, teacherSignCountMap);
    }

    private Map<Long, Integer> buildAllTeacherLessonSign(List<Long> lessonIds, Map<Long, Long> lessonTeacherMap, Map<Long, LessonSignAudit> signAuditMap, Map<Long, Integer> lessonStudentCountMap) {
        HashMap teacherSignCountMap = Maps.newHashMap();
        for (Long lessonId : lessonIds) {
            Long teacherId = lessonTeacherMap.get(lessonId);
            if (teacherId == null || signAuditMap == null || !signAuditMap.containsKey(lessonId) || !lessonStudentCountMap.containsKey(lessonId)) continue;
            int studentCount = lessonStudentCountMap.get(lessonId);
            LessonSignAudit signAudit = signAuditMap.get(lessonId);
            int signCount = signAudit.getSignCount() > studentCount ? studentCount : signAudit.getSignCount();
            int leaveCount = signAudit.getLeaveCount() > studentCount ? studentCount : signAudit.getLeaveCount();
            int absentCount = signAudit.getAbsentCount() > studentCount ? studentCount : signAudit.getAbsentCount();
            int unsignCount = studentCount - signCount - leaveCount - absentCount;
            unsignCount = unsignCount < 0 ? 0 : unsignCount;
            Integer teacherSignCount = (Integer)teacherSignCountMap.get(teacherId);
            if (teacherSignCount == null) {
                teacherSignCount = new Integer(0);
            }
            teacherSignCount = teacherSignCount + signCount;
            teacherSignCountMap.put(teacherId, teacherSignCount);
        }
        return teacherSignCountMap;
    }

    private List<TeacherClassHourDto> buildDtoList(List<ClassHour> classHourList, Map<Long, Teacher> teacherMap, Map<Long, Integer> teacherSignCountMap) {
        if (!teacherMap.isEmpty()) {
            ArrayList result = Lists.newArrayList();
            HashSet avatarIds = Sets.newHashSet();
            for (Teacher teacher : teacherMap.values()) {
                if (teacher.getAvatar() == null || teacher.getAvatar() <= 0L) continue;
                avatarIds.add(teacher.getAvatar());
            }
            List storageList = this.storageDao.getByIds((Collection)avatarIds, new String[0]);
            Map<Long, String> avatarMap = this.getAvatarMap(storageList);
            for (ClassHour classHour : classHourList) {
                TeacherClassHourDto dto = new TeacherClassHourDto();
                Teacher teacher = teacherMap.get(classHour.getTeacherId());
                if (teacher == null) continue;
                dto.setTeacherId(teacher.getUserId());
                dto.setTeacherName(teacher.getRealName());
                dto.setAvatar(avatarMap.get(teacher.getAvatar()));
                dto.setMinutes(classHour.getMinutes());
                dto.setLessonCount(classHour.getLessonCount());
                Integer signCount = teacherSignCountMap.get(classHour.getTeacherId());
                if (signCount != null) {
                    dto.setSignCount(signCount);
                }
                result.add(dto);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private Map<Long, String> getAvatarMap(List<Storage> storageList) {
        if (CollectionUtils.isNotEmpty(storageList)) {
            HashMap result = Maps.newHashMap();
            for (Storage storage : storageList) {
                result.put(storage.getId(), StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    public TeacherClassHourDto queryTeacherClassHourDetail(Long orgId, TeacherClassHourRequestDto params, PageDto page) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((params.getStartTimeDate() != null ? 1 : 0) != 0, (Object)"startTime is null!");
        Preconditions.checkArgument((params.getEndTimeDate() != null ? 1 : 0) != 0, (Object)"endTime is null!");
        Preconditions.checkArgument((params.getTeacherId() != null ? 1 : 0) != 0, (Object)"teacherId is null!");
        log.info("query classHour detail of teacher, orgId={},page={},params={}", new Object[]{orgId, page, params});
        List lessonIds = this.orgClassLessonDao.queryFinishedLessonIds(orgId, params.getTeacherId(), params.getStartTimeDate(), params.getEndTimeDate());
        log.debug("teacher lessonIds={},size={}", (Object)lessonIds, (Object)lessonIds.size());
        TeacherClassHourDto teacherClassHourDto = new TeacherClassHourDto();
        if (CollectionUtils.isEmpty((Collection)lessonIds)) {
            return teacherClassHourDto;
        }
        teacherClassHourDto.setLessonCount(lessonIds.size());
        List classHourList = this.orgClassLessonDao.queryTeacherClassHourList((Collection)lessonIds, params.getTeacherId(), page, true);
        ClassHour teacherClassHour = this.orgClassLessonDao.queryTeacherClassHour((Collection)lessonIds, params.getTeacherId());
        teacherClassHourDto.setMinutes(teacherClassHour.getMinutes());
        log.debug("teacher classHourList={},size={}", (Object)classHourList, (Object)classHourList.size());
        Map classHourMap = CollectorUtil.collectMap((Collection)classHourList, (Function)new Function<ClassHour, Long>(){

            public Long apply(ClassHour arg0) {
                return arg0.getCourseId();
            }
        });
        log.debug("teacher courseIds={},size={}", classHourMap.keySet(), (Object)classHourMap.keySet().size());
        Map lessonMap = this.orgClassLessonDao.getLessonMapByCourseAndLessonIds(orgId, classHourMap.keySet(), (Collection)lessonIds);
        Map courseNameMap = this.orgCourseDao.getCourseNameMap(classHourMap.keySet());
        log.debug("courseNameMap={}", (Object)courseNameMap);
        Map signAuditMap = this.orgLessonSignDao.queryLessonSignAudit(orgId, (Collection)lessonIds);
        Map lessonStudentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
        ArrayList result = Lists.newArrayList();
        for (ClassHour classHour : classHourList) {
            result.add(this.buildTeacherCourseDto((ClassHour)classHourMap.get(classHour.getCourseId()), (List)lessonMap.get(classHour.getCourseId()), (String)courseNameMap.get(classHour.getCourseId()), null, signAuditMap, lessonStudentCountMap));
        }
        teacherClassHourDto.setCourses(result);
        return teacherClassHourDto;
    }

    private TeacherCourseDto buildTeacherCourseDto(ClassHour classHour, List<OrgClassLesson> lessons, String courseName, Map<Long, String> roomNameMap, Map<Long, LessonSignAudit> signAuditMap, Map<Long, Integer> lessonStudentCountMap) {
        TeacherCourseDto teacherCourseDto = new TeacherCourseDto();
        teacherCourseDto.setCourseId(classHour.getCourseId());
        teacherCourseDto.setCourseName(courseName);
        teacherCourseDto.setMinutes(classHour.getMinutes());
        teacherCourseDto.setLessonCount(classHour.getLessonCount());
        ArrayList teacherLessons = Lists.newArrayList();
        for (OrgClassLesson lesson : lessons) {
            OrgTeacherLessonInfoDto dto = new OrgTeacherLessonInfoDto();
            dto.setLessonId(lesson.getId());
            dto.setStartTime(lesson.getStartTime());
            dto.setEndTime(lesson.getEndTime());
            dto.setMinutes(DateUtil.getMinuteDiff((Date)lesson.getStartTime(), (Date)lesson.getEndTime()));
            dto.setIndex(lesson.getNumber());
            if (roomNameMap != null && lesson.getRoomId() != null) {
                dto.setRoomName(roomNameMap.get(lesson.getRoomId()));
            }
            if (lessonStudentCountMap != null && lessonStudentCountMap.containsKey(lesson.getId())) {
                dto.setStudentCount(lessonStudentCountMap.get(lesson.getId()));
            }
            if (signAuditMap != null && signAuditMap.containsKey(lesson.getId())) {
                LessonSignAudit signAudit = signAuditMap.get(lesson.getId());
                int signCount = signAudit.getSignCount() > dto.getStudentCount() ? dto.getStudentCount() : signAudit.getSignCount().intValue();
                int leaveCount = signAudit.getLeaveCount() > dto.getStudentCount() ? dto.getStudentCount() : signAudit.getLeaveCount().intValue();
                int absentCount = signAudit.getAbsentCount() > dto.getStudentCount() ? dto.getStudentCount() : signAudit.getAbsentCount().intValue();
                int unsignCount = dto.getStudentCount() - signCount - leaveCount - absentCount;
                unsignCount = unsignCount < 0 ? 0 : unsignCount;
                dto.setSignCount(signCount);
                dto.setLeaveCount(leaveCount);
                dto.setAbsentCount(absentCount);
                dto.setUnsignCount(unsignCount);
            }
            teacherLessons.add(dto);
        }
        teacherCourseDto.setLessons(teacherLessons);
        return teacherCourseDto;
    }

    @Override
    public List<TeacherClassHourDto> exportTeacherClassHoursData(Long orgId, TeacherClassHourRequestDto params) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((params.getStartTimeDate() != null ? 1 : 0) != 0, (Object)"startTime is null!");
        Preconditions.checkArgument((params.getEndTimeDate() != null ? 1 : 0) != 0, (Object)"endTime is null!");
        log.info("export teacher classHour List data,orgId={},params={}", (Object)orgId, (Object)params);
        List lessonIds = this.orgClassLessonDao.queryFinishedLessonIds(orgId, params.getTeacherId(), params.getStartTimeDate(), params.getEndTimeDate());
        log.debug("lessonIds={}", (Object)lessonIds);
        if (CollectionUtils.isEmpty((Collection)lessonIds)) {
            return Lists.newArrayList();
        }
        List classHourList = this.orgClassLessonDao.queryTeacherClassHourList((Collection)lessonIds, params.getTeacherId(), null, true);
        Map classHourMap = CollectorUtil.group((Collection)classHourList, (Function)new Function<ClassHour, Long>(){

            public Long apply(ClassHour arg0) {
                return arg0.getTeacherId();
            }
        });
        List teacherList = this.teacherDao.getByTeacherIds(classHourMap.keySet(), new String[0]);
        List lessons = this.orgClassLessonDao.getByIds((Collection)lessonIds, new String[0]);
        Map lessonTeacherMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
        log.debug("lessonTeacherMap={}", (Object)lessonTeacherMap);
        final HashSet roomIds = Sets.newHashSet();
        Map lessonMap = CollectorUtil.group((Collection)lessons, (Function)new Function<OrgClassLesson, Long>(){

            public Long apply(OrgClassLesson arg0) {
                roomIds.add(arg0.getRoomId());
                return arg0.getCourseId();
            }
        });
        Map roomNameMap = this.orgClassRoomDao.getRoomName(orgId, (Collection)roomIds);
        ArrayList result = Lists.newArrayList();
        Map courseNameMap = this.orgCourseDao.getCourseNameMap(lessonMap.keySet());
        Map signAuditMap = this.orgLessonSignDao.queryLessonSignAudit(orgId, (Collection)lessonIds);
        Map lessonStudentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
        log.debug("signAuditMap={}", (Object)signAuditMap);
        log.debug("lessonStudentCountMap={}", (Object)lessonStudentCountMap);
        for (Teacher teacher : teacherList) {
            result.add(this.buildTeacherClassHourDto(teacher, (List)classHourMap.get(teacher.getUserId()), lessonMap, courseNameMap, roomNameMap, signAuditMap, lessonStudentCountMap, lessonTeacherMap));
        }
        this.sortTeacherClassHourDto(result);
        return result;
    }

    private void sortTeacherClassHourDto(List<TeacherClassHourDto> result) {
        Collections.sort(result, new Comparator<TeacherClassHourDto>(){

            @Override
            public int compare(TeacherClassHourDto o1, TeacherClassHourDto o2) {
                Integer minute1 = 0;
                Integer minute2 = 0;
                if (CollectionUtils.isNotEmpty(o1.getCourses())) {
                    for (TeacherCourseDto teacherCourseDto : o1.getCourses()) {
                        minute1 = minute1 + teacherCourseDto.getMinutes();
                    }
                }
                if (CollectionUtils.isNotEmpty(o2.getCourses())) {
                    for (TeacherCourseDto teacherCourseDto : o2.getCourses()) {
                        minute2 = minute2 + teacherCourseDto.getMinutes();
                    }
                }
                return minute2.compareTo(minute1);
            }
        });
    }

    private TeacherClassHourDto buildTeacherClassHourDto(Teacher teacher, List<ClassHour> classHours, Map<Long, List<OrgClassLesson>> lessonMap, Map<Long, String> courseNameMap, Map<Long, String> roomNameMap, Map<Long, LessonSignAudit> signAuditMap, Map<Long, Integer> lessonStudentCountMap, Map<Long, Long> lessonTeacherMap) {
        TeacherClassHourDto teacherClassHourDto = new TeacherClassHourDto();
        teacherClassHourDto.setTeacherId(teacher.getUserId());
        teacherClassHourDto.setTeacherName(teacher.getRealName());
        ArrayList courses = Lists.newArrayList();
        for (ClassHour classHour : classHours) {
            ArrayList lessons = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)lessonMap.get(classHour.getCourseId()))) {
                for (OrgClassLesson orgClassLesson : lessonMap.get(classHour.getCourseId())) {
                    if (!teacher.getUserId().equals(lessonTeacherMap.get(orgClassLesson.getId()))) continue;
                    lessons.add(orgClassLesson);
                }
            }
            courses.add(this.buildTeacherCourseDto(classHour, lessons, courseNameMap.get(classHour.getCourseId()), roomNameMap, signAuditMap, lessonStudentCountMap));
        }
        teacherClassHourDto.setCourses(courses);
        return teacherClassHourDto;
    }

    @Override
    public void export(HttpServletResponse response, Long orgId, Date date, List<TeacherClassHourDto> dtoList) {
        Preconditions.checkArgument((date != null ? 1 : 0) != 0, (Object)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        String orgName = this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(orgId.intValue()));
        String timeStr = TianXiaoConstant.MONTH_FORMAT.format(date);
        String fileName = orgName + "-\u8bfe\u65f6\u7edf\u8ba1-" + timeStr + ".xlsx";
        SXSSFWorkbook workbook = null;
        try {
            workbook = new SXSSFWorkbook(100);
            HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
            ArrayList summaryFields = Lists.newArrayList();
            summaryFields.add(new ExportField("\u8001\u5e08\u540d\u79f0", "@", 5120));
            summaryFields.add(new ExportField("\u73ed\u7ea7\u540d\u79f0", "@", 10240));
            summaryFields.add(new ExportField("\u8bfe\u8282\u6570", "0", 2560, (Object)0));
            summaryFields.add(new ExportField("\u603b\u65f6\u957f(\u5206\u949f)", "0", 5120, (Object)0));
            summaryFields.add(new ExportField("\u5e94\u5230\u4eba\u6570", "0", 5120, (Object)0));
            summaryFields.add(new ExportField("\u7b7e\u5230\u4eba\u6570", "0", 5120, (Object)0));
            summaryFields.add(new ExportField("\u8bf7\u5047\u4eba\u6570", "0", 5120, (Object)0));
            summaryFields.add(new ExportField("\u7f3a\u52e4\u4eba\u6570", "0", 5120, (Object)0));
            summaryFields.add(new ExportField("\u5355\u8bfe\u8bfe\u916c\uff08\u5143\uff0f\u8282\uff09", "0.0", 5120, (Object)0));
            summaryFields.add(new ExportField("\u8bfe\u916c\u603b\u91d1\u989d", "0.0", 5120, (Object)0));
            summaryFields.add(new ExportField("\u6bcf\u5c0f\u65f6\u8bfe\u916c\uff08\u5143\uff0f\u5c0f\u65f6\uff09", "0.0", 5120, (Object)0));
            summaryFields.add(new ExportField("\u8bfe\u916c\u603b\u91d1\u989d", "0.0", 5120, (Object)0));
            summaryFields.add(new ExportField("\u5355\u4eba\u62a5\u916c\uff08\u5143\uff0f\u4eba\u6b21\uff09", "0.0", 5120, (Object)0));
            summaryFields.add(new ExportField("\u8bfe\u916c\u603b\u91d1\u989d", "0.0", 5120, (Object)0));
            summaryFields.add(new ExportField("\u5e94\u7ed3\u603b\u989d", "0.0", 5120, (Object)0));
            ArrayList titles = Lists.newArrayList();
            HashMap title1 = Maps.newHashMap();
            title1.put("row", 0);
            title1.put("titleName", "(\u8bfe\u6d88\u6c47\u603b\u8868)");
            title1.put("startCell", 0);
            title1.put("endCell", summaryFields.size() - 1);
            titles.add(title1);
            HashMap title2 = Maps.newHashMap();
            title2.put("row", 1);
            title2.put("titleName", "(\u586b\u5199\u5355\u8bfe\u8282\u8bfe\u916c,\u81ea\u52a8\u8ba1\u7b97\u5e94\u7ed3\u603b\u8bfe\u916c)");
            title2.put("startCell", 0);
            title2.put("endCell", 7);
            titles.add(title2);
            HashMap title3 = Maps.newHashMap();
            title3.put("row", 1);
            title3.put("titleName", "(\u6309\u8bfe\u6b21\u8ba1\u7b97)");
            title3.put("startCell", 8);
            title3.put("endCell", 9);
            titles.add(title3);
            HashMap title4 = Maps.newHashMap();
            title4.put("row", 1);
            title4.put("titleName", "(\u6309\u65f6\u957f\u8ba1\u7b97)");
            title4.put("startCell", 10);
            title4.put("endCell", 11);
            titles.add(title4);
            HashMap title5 = Maps.newHashMap();
            title5.put("row", 1);
            title5.put("titleName", "(\u6309\u5b66\u5458\u8ba1\u7b97)");
            title5.put("startCell", 12);
            title5.put("endCell", 13);
            titles.add(title5);
            ArrayList detailFields = Lists.newArrayList();
            detailFields.add(new ExportField("\u8001\u5e08\u540d\u79f0", "@", 5120));
            detailFields.add(new ExportField("\u73ed\u7ea7\u540d\u79f0", "@", 12800));
            detailFields.add(new ExportField("\u8bfe\u8282", "@", 2560));
            detailFields.add(new ExportField("\u6559\u5ba4", "@", 7680));
            detailFields.add(new ExportField("\u65e5\u671f", "yyyy-MM-dd", 5120));
            detailFields.add(new ExportField("\u4e0a\u8bfe\u65f6\u95f4", "@", 12800));
            detailFields.add(new ExportField("\u65f6\u957f(\u5206\u949f)", "0", 5120));
            detailFields.add(new ExportField("\u5b89\u6392\u5b66\u5458", "0", 5120));
            detailFields.add(new ExportField("\u7b7e\u5230\u4eba\u6570", "0", 5120));
            detailFields.add(new ExportField("\u8bf7\u5047\u4eba\u6570", "0", 5120));
            detailFields.add(new ExportField("\u65f7\u8bfe\u4eba\u6570", "0", 5120));
            detailFields.add(new ExportField("\u672a\u7b7e\u5230\u4eba\u6570", "0", 5120));
            detailFields.add(new ExportField("\u7b7e\u5230\u7387", "@", 5120));
            ExcelExportService.createSheet((Workbook)workbook, "\u6c47\u603b", titles, cellStyleMap, summaryFields, dtoList, false);
            ExcelExportService.createSheet((Workbook)workbook, "\u8001\u5e08\u8be6\u60c5", null, cellStyleMap, detailFields, dtoList, true);
            ExcelExportService.exportExcel(response, (Workbook)workbook, fileName);
        }
        catch (Exception e) {
            log.error("export catch exception:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5f02\u5e38");
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                log.error("close workbook catch error:", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        ArrayList dtoList = Lists.newArrayList();
        String timeStr = TianXiaoConstant.MONTH_FORMAT.format(new Date());
        SXSSFWorkbook workbook = null;
        workbook = new SXSSFWorkbook(100);
        HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
        ArrayList summaryFields = Lists.newArrayList();
        summaryFields.add(new ExportField("\u8001\u5e08\u540d\u79f0", "@", 5120));
        summaryFields.add(new ExportField("\u73ed\u7ea7\u540d\u79f0", "@", 10240));
        summaryFields.add(new ExportField("\u8bfe\u8282\u6570", "0", 2560, (Object)0));
        summaryFields.add(new ExportField("\u603b\u65f6\u957f(\u5206\u949f)", "0", 5120, (Object)0));
        summaryFields.add(new ExportField("\u5e94\u5230\u4eba\u6570", "0", 5120, (Object)0));
        summaryFields.add(new ExportField("\u7b7e\u5230\u4eba\u6570", "0", 5120, (Object)0));
        summaryFields.add(new ExportField("\u8bf7\u5047\u4eba\u6570", "0", 5120, (Object)0));
        summaryFields.add(new ExportField("\u7f3a\u52e4\u4eba\u6570", "0", 5120, (Object)0));
        summaryFields.add(new ExportField("\u5355\u8bfe\u8bfe\u916c\uff08\u5143\uff0f\u8282\uff09", "0.0", 5120, (Object)0));
        summaryFields.add(new ExportField("\u8bfe\u916c\u603b\u91d1\u989d", "0.0", 5120, (Object)0));
        summaryFields.add(new ExportField("\u6bcf\u5c0f\u65f6\u8bfe\u916c\uff08\u5143\uff0f\u5c0f\u65f6\uff09", "0.0", 5120, (Object)0));
        summaryFields.add(new ExportField("\u8bfe\u916c\u603b\u91d1\u989d", "0.0", 5120, (Object)0));
        summaryFields.add(new ExportField("\u5355\u4eba\u62a5\u916c\uff08\u5143\uff0f\u4eba\u6b21\uff09", "0.0", 5120, (Object)0));
        summaryFields.add(new ExportField("\u8bfe\u916c\u603b\u91d1\u989d", "0.0", 5120, (Object)0));
        summaryFields.add(new ExportField("\u5e94\u7ed3\u603b\u989d", "0.0", 5120, (Object)0));
        ArrayList titles = Lists.newArrayList();
        HashMap title1 = Maps.newHashMap();
        title1.put("row", 0);
        title1.put("titleName", timeStr + "\u8bfe\u6d88\u6c47\u603b\u8868");
        title1.put("startCell", 0);
        title1.put("endCell", summaryFields.size() - 1);
        titles.add(title1);
        HashMap title2 = Maps.newHashMap();
        title2.put("row", 1);
        title2.put("titleName", "(\u586b\u5199\u5355\u8bfe\u8282\u8bfe\u916c,\u81ea\u52a8\u8ba1\u7b97\u5e94\u7ed3\u603b\u8bfe\u916c)");
        title2.put("startCell", 0);
        title2.put("endCell", 7);
        titles.add(title2);
        HashMap title3 = Maps.newHashMap();
        title3.put("row", 1);
        title3.put("titleName", "(\u6309\u8bfe\u6b21\u8ba1\u7b97)");
        title3.put("startCell", 8);
        title3.put("endCell", 9);
        titles.add(title3);
        HashMap title4 = Maps.newHashMap();
        title4.put("row", 1);
        title4.put("titleName", "(\u6309\u65f6\u957f\u8ba1\u7b97)");
        title4.put("startCell", 10);
        title4.put("endCell", 11);
        titles.add(title4);
        HashMap title5 = Maps.newHashMap();
        title5.put("row", 1);
        title5.put("titleName", "(\u6309\u5b66\u5458\u8ba1\u7b97)");
        title5.put("startCell", 12);
        title5.put("endCell", 13);
        titles.add(title5);
        ArrayList detailFields = Lists.newArrayList();
        detailFields.add(new ExportField("\u8001\u5e08\u540d\u79f0", "@", 5120));
        detailFields.add(new ExportField("\u73ed\u7ea7\u540d\u79f0", "@", 12800));
        detailFields.add(new ExportField("\u8bfe\u8282", "@", 2560));
        detailFields.add(new ExportField("\u6559\u5ba4", "@", 7680));
        detailFields.add(new ExportField("\u65e5\u671f", "yyyy-MM-dd", 5120));
        detailFields.add(new ExportField("\u4e0a\u8bfe\u65f6\u95f4", "@", 12800));
        detailFields.add(new ExportField("\u65f6\u957f(\u5206\u949f)", "0", 5120));
        detailFields.add(new ExportField("\u5b89\u6392\u5b66\u5458", "0", 5120));
        detailFields.add(new ExportField("\u7b7e\u5230\u4eba\u6570", "0", 5120));
        detailFields.add(new ExportField("\u8bf7\u5047\u4eba\u6570", "0", 5120));
        detailFields.add(new ExportField("\u65f7\u8bfe\u4eba\u6570", "0", 5120));
        detailFields.add(new ExportField("\u672a\u7b7e\u5230\u4eba\u6570", "0", 5120));
        detailFields.add(new ExportField("\u7b7e\u5230\u7387", "@", 5120));
        ExcelExportService.createSheet((Workbook)workbook, "\u6c47\u603b", titles, cellStyleMap, summaryFields, dtoList, false);
        File excelFile = new File("/Users/bjhl/Documents/testclass.xlsx");
        workbook.write((OutputStream)new FileOutputStream(excelFile));
    }
}

