/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.common.service.MsgSendService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.SigninMsgAsynModel;
import com.baijia.tianxiao.sal.course.dto.response.LessonSignReportDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentLessonSignDto;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgLessonSignServiceImpl
implements OrgLessonSignService {
    private static final Logger log = LoggerFactory.getLogger(OrgLessonSignServiceImpl.class);
    private static String smsContent = "%s\u4f60\u597d\uff0c\u4f60\u5df2\u7ecf\u5728%s\u7684%s\u5b8c\u6210\u7b7e\u5230\uff0c\u72b6\u6001\u4e3a\u201c%s\u201d\u3002\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u62e8\u62534000122166\u8f6c%s";
    private static String content = "\u4f60\u597d:\n %s\u4f60\u5df2\u7ecf\u5728%s\u7684%s\u5b8c\u6210\u7b7e\u5230\uff0c\u72b6\u6001\u4e3a\u201c%s\u201d\u3002";
    private static String remark = "\u5982\u679c\u5bf9\u6253\u5361\u60c5\u51b5\u6709\u7591\u95ee\uff0c\u8bf7\u81f4\u75354000122166\u8f6c%s";
    private static String course = "%s\u7b2c%s\u6b21\u8bfe";
    private static String defaultName = "-";
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;
    @Autowired(required=false)
    private MsgSendService msgSendService;
    @Autowired
    private StringRedisTemplate redisTemplate;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orgStudentLessonBatchSign(Long orgId, Long courseId, Long lessonId, List<Long> studentIds, Integer status) {
        if (CollectionUtils.isEmpty(studentIds) || lessonId == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u548c\u5b66\u751fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrgClassLesson lesson = this.orgClassLessonDao.getByIdForUpdate(lessonId);
        Preconditions.checkArgument((lesson != null && orgId.equals(lesson.getOrgId()) ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((status != null && status >= 0 ? 1 : 0) != 0, (Object)"\u7b7e\u5230\u72b6\u6001\u4e0d\u6b63\u786e");
        Map map = this.orgStudentDao.getStudentIdUserIdMap(studentIds);
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)lesson.getCourseId(), new String[0]);
        Preconditions.checkArgument((course != null ? 1 : 0) != 0, (Object)" \u8bfe\u8282ID\u4e0d\u6b63\u786e");
        log.info("update studentIds:{} in lesson:{} to signStatus:{}", new Object[]{map.values(), lessonId, status});
        this.orgLessonSignDao.orgLessonSignBatchEdit(lessonId, map.values(), status);
        List signStudents = this.orgLessonSignDao.getLessonStudentIds(orgId, lessonId, map.values(), status, new String[0]);
        HashSet userIds = Sets.newHashSet(map.values());
        if (CollectionUtils.isNotEmpty((Collection)signStudents)) {
            for (Object signStudent : signStudents) {
                userIds.remove(signStudent.getUserId());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)userIds) || CollectionUtils.isNotEmpty((Collection)signStudents)) {
            Preconditions.checkArgument((lesson != null && orgId.equals(lesson.getOrgId()) ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
            ArrayList newSignStudents = Lists.newArrayList();
            for (Long studentId : userIds) {
                OrgLessonSign lessonSign = new OrgLessonSign();
                lessonSign.setCourseId(lesson.getCourseId());
                lessonSign.setCreateTime(new Date());
                lessonSign.setLessonId(lessonId);
                lessonSign.setOrgId(orgId);
                lessonSign.setStatus(status);
                lessonSign.setUserId(studentId);
                lessonSign.setUpdateTime(new Date());
                lessonSign.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
                newSignStudents.add(lessonSign);
            }
            log.info("save sign students:{}", (Object)newSignStudents);
            this.orgLessonSignDao.saveAll((List)newSignStudents, false, new String[]{"courseId", "createTime", "lessonId", "orgId", "status", "userId", "updateTime", "userRole"});
            if (!this.checkOrgPermissionSignMsg(orgId.intValue())) {
                return;
            }
            if (lesson.getStartTime().after(DateUtil.getCurrentDate()) && lesson.getStartTime().before(DateUtil.getDiffDateTime((Date)DateUtil.getCurrentDate(), (int)1))) {
                ArrayList signInList = Lists.newArrayList();
                signInList.addAll(signStudents);
                signInList.addAll(newSignStudents);
                this.addToSigninMsgAsynModel(signInList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orgUnionStudentsMultiLessonBatchSign(Long orgId, Long courseId, List<Long> lessonIds, List<Long> studentIds, Integer status) {
        this.orgLessonSignDao.orgLessonSignBatchEdit(lessonIds, studentIds, status);
        Map<Long, Set<Long>> inDbSigninLessonIdStudentIdsMap = this.makeInDbSigninLessonIdStudentIdsMap(orgId, courseId, lessonIds, studentIds);
        log.info("orgUnionStudentsMultiLessonBatchSign inDB signin lessonIdStudentId map:{}", inDbSigninLessonIdStudentIdsMap);
        Map<Long, Set<Long>> inDbStudentLessonIdStudentIdsMap = this.makeInDbStudentLessonIdStudentIdsMap(lessonIds, studentIds);
        log.info("orgUnionStudentsMultiLessonBatchSign inDB students lessonIdStudentId map:{}", inDbStudentLessonIdStudentIdsMap);
        Map<Long, Set<Long>> newSigninLessonIdStudentIdsMap = this.makeDifferenceSetLessonIdStudentIdsMap(inDbSigninLessonIdStudentIdsMap, inDbStudentLessonIdStudentIdsMap);
        log.info("orgUnionStudentsMultiLessonBatchSign deference students lessonIdStudentId map:{}", newSigninLessonIdStudentIdsMap);
        ArrayList newSignStudents = Lists.newArrayList();
        for (Long lessonId : newSigninLessonIdStudentIdsMap.keySet()) {
            for (Long studentId : newSigninLessonIdStudentIdsMap.get(lessonId)) {
                OrgLessonSign lessonSign = new OrgLessonSign();
                lessonSign.setCourseId(courseId);
                lessonSign.setCreateTime(new Date());
                lessonSign.setLessonId(lessonId);
                lessonSign.setOrgId(orgId);
                lessonSign.setStatus(status);
                lessonSign.setUserId(studentId);
                lessonSign.setUpdateTime(new Date());
                lessonSign.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
                newSignStudents.add(lessonSign);
            }
        }
        log.info("save sign students length:{}", (Object)newSignStudents.size());
        if (CollectionUtils.isNotEmpty((Collection)newSignStudents)) {
            this.orgLessonSignDao.saveAll((List)newSignStudents, false, new String[]{"courseId", "createTime", "lessonId", "orgId", "status", "userId", "updateTime", "userRole"});
        }
    }

    private Map<Long, Set<Long>> makeDifferenceSetLessonIdStudentIdsMap(Map<Long, Set<Long>> inDbSigninLessonIdStudentIdsMap, Map<Long, Set<Long>> inDbStudentLessonIdStudentIdsMap) {
        HashMap result = Maps.newHashMap();
        for (Long lessonId : inDbStudentLessonIdStudentIdsMap.keySet()) {
            Set<Long> someStudents = inDbSigninLessonIdStudentIdsMap.get(lessonId);
            Set<Long> allStudents = inDbStudentLessonIdStudentIdsMap.get(lessonId);
            result.put(lessonId, Sets.newHashSet((Iterable)CollectionUtils.subtract(allStudents, (Collection)(null == someStudents ? Sets.newHashSet() : someStudents))));
        }
        return result;
    }

    private Map<Long, Set<Long>> makeInDbStudentLessonIdStudentIdsMap(List<Long> lessonIds, List<Long> studentIds) {
        HashMap result = Maps.newHashMap();
        List studentLessons = this.orgStudentLessonDao.getByLessonIdsStudentIds(lessonIds, studentIds, new String[]{"lessonId", "userId"});
        for (OrgStudentLesson studentLesson : studentLessons) {
            if (result.containsKey(studentLesson.getLessonId())) {
                ((Set)result.get(studentLesson.getLessonId())).add(studentLesson.getUserId());
                continue;
            }
            result.put(studentLesson.getLessonId(), Sets.newHashSet((Object[])new Long[]{studentLesson.getUserId()}));
        }
        return result;
    }

    private Map<Long, Set<Long>> makeInDbSigninLessonIdStudentIdsMap(Long orgId, Long courseId, List<Long> lessonIds, List<Long> studentIds) {
        HashMap result = Maps.newHashMap();
        List signList = this.orgLessonSignDao.getByOrgIdCourseIdLessonIdsStudentIds(orgId, courseId, lessonIds, studentIds, new String[]{"lessonId", "userId"});
        for (OrgLessonSign sign : signList) {
            if (result.containsKey(sign.getLessonId())) {
                ((Set)result.get(sign.getLessonId())).add(sign.getUserId());
                continue;
            }
            result.put(sign.getLessonId(), Sets.newHashSet((Object[])new Long[]{sign.getUserId()}));
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orgStudentLessonBatchFastSign(Long orgId, Long courseId, List<Long> lessonIds, Map<Long, Integer> studentIdSignInStatus) {
        Set<Long> studentIds = studentIdSignInStatus.keySet();
        if (CollectionUtils.isEmpty(studentIds) || CollectionUtils.isEmpty(lessonIds)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u548c\u5b66\u751fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("create studentsSignIns:{} in lesson:{}", studentIdSignInStatus, lessonIds);
        Map map = this.orgStudentDao.getStudentIdUserIdMap(studentIds);
        ArrayList newSignStudents = Lists.newArrayList();
        if (MapUtils.isNotEmpty((Map)map)) {
            for (Long lessonId : lessonIds) {
                OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
                Preconditions.checkArgument((lesson != null && orgId.equals(lesson.getOrgId()) ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
                for (Map.Entry studentEntry : map.entrySet()) {
                    OrgLessonSign lessonSign = new OrgLessonSign();
                    lessonSign.setCourseId(lesson.getCourseId());
                    lessonSign.setCreateTime(new Date());
                    lessonSign.setLessonId(lessonId);
                    lessonSign.setOrgId(orgId);
                    lessonSign.setStatus(studentIdSignInStatus.get(studentEntry.getKey()));
                    lessonSign.setUserId((Long)studentEntry.getValue());
                    lessonSign.setUpdateTime(new Date());
                    lessonSign.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
                    newSignStudents.add(lessonSign);
                }
            }
            log.info("save sign students:{}", (Object)newSignStudents);
            this.orgLessonSignDao.saveAll((List)newSignStudents, false, new String[]{"courseId", "createTime", "lessonId", "orgId", "status", "userId", "updateTime", "userRole"});
        }
    }

    private SendMsgRequest getSendMsg(OrgInfo orgInfo, OrgStudent student, String teacherName, OrgClassLesson lesson, OrgCourse course, Integer status) {
        SendMsgRequest request = new SendMsgRequest();
        request.setOrgId(Long.valueOf(orgInfo.getOrgId().longValue()));
        request.setMobile(student.getMobile());
        request.setCountSms(false);
        request.setReceiverId(student.getId());
        request.setWeixinOpenId(student.getWeixin());
        request.setReceiverRole(UserRoleEnum.STUDENT);
        request.setSenderId(Long.valueOf(orgInfo.getOrgId().longValue()));
        request.setSenderRole(UserRoleEnum.ORG);
        request.setWechatTemplateId(Integer.valueOf(WechateTemplateMsgType.COURSE_SIGNIN_TO_STU.getValue()));
        HashMap params = Maps.newHashMap();
        String studentName = this.getStringValue(student.getName());
        String orgName = orgInfo.getShortName();
        String courseName = course.getName();
        String signStatusStr = SignStatus.getSignStatusByCode((Integer)status).getMessage();
        String extention = this.getStringValue(orgInfo.getExtension());
        teacherName = this.getStringValue(teacherName);
        String smsContent = String.format(OrgLessonSignServiceImpl.smsContent, studentName, orgName, courseName, signStatusStr, extention);
        request.setSmsContent(smsContent);
        Date now = new Date();
        params.put("first", String.format(content, studentName, orgName, courseName, signStatusStr));
        params.put("remark", String.format(remark, extention));
        params.put("keyword1", studentName);
        params.put("keyword2", DateUtil.getStrByDateFormate((Date)now, (String)"yyyy-MM-dd HH:mm"));
        params.put("keyword3", courseName);
        params.put("keyword4", this.getStringValue(teacherName));
        request.setWechatParams((Map)params);
        log.debug("remind student comment the course! data={}", (Object)request);
        return request;
    }

    private String getStringValue(String message) {
        if (StringUtils.isBlank((String)message)) {
            return defaultName;
        }
        return message;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orgStudentLessonSign(@NonNull Long orgId, Long courseId, @NonNull Long lessonId, @NonNull Long studentId, Integer status) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        Preconditions.checkArgument((status != null && status >= 0 ? 1 : 0) != 0, (Object)"\u7b7e\u5230\u72b6\u6001\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((lessonId != null && lessonId >= 0L ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((orgId != null && orgId >= 0L ? 1 : 0) != 0, (Object)"\u673a\u6784ID\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((studentId != null && studentId >= 0L ? 1 : 0) != 0, (Object)"\u5b66\u751fID\u4e0d\u6b63\u786e");
        OrgClassLesson lesson = this.orgClassLessonDao.getByIdForUpdate(lessonId);
        Preconditions.checkArgument((lesson != null && orgId.equals(lesson.getOrgId()) ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)lesson.getCourseId(), new String[0]);
        Preconditions.checkArgument((course != null ? 1 : 0) != 0, (Object)" \u8bfe\u8282ID\u4e0d\u6b63\u786e");
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        Long userId = student == null ? null : student.getUserId();
        Preconditions.checkArgument((userId != null && userId >= 0L ? 1 : 0) != 0, (Object)("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5b66\u751fID:" + studentId));
        OrgLessonSign obj = this.orgLessonSignDao.getStudentLessonSign(orgId, courseId, lessonId, userId, Integer.valueOf(UserRole.STUDENT.getRole()));
        if (obj != null && status != null && !status.equals(obj.getStatus())) {
            obj.setStatus(status);
            this.orgLessonSignDao.update((Object)obj, new String[]{"status"});
        } else if (obj == null && status != null) {
            obj = new OrgLessonSign();
            obj.setCourseId(lesson.getCourseId());
            obj.setCreateTime(new Date());
            obj.setLessonId(lessonId);
            obj.setOrgId(orgId);
            obj.setStatus(status);
            obj.setUpdateTime(new Date());
            obj.setUserId(userId);
            obj.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
            this.orgLessonSignDao.saveOrUpdate((Object)obj, new String[0]);
        }
        if (!this.checkOrgPermissionSignMsg(orgId.intValue())) {
            return;
        }
        if (lesson.getStartTime().after(DateUtil.getCurrentDate()) && lesson.getStartTime().before(DateUtil.getDiffDateTime((Date)DateUtil.getCurrentDate(), (int)1))) {
            ArrayList signInList = Lists.newArrayList();
            signInList.add(obj);
            this.addToSigninMsgAsynModel(signInList);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public OrgStudentLessonSignDto getStudentLessonSign(@NonNull Long orgId, Long courseId, @NonNull Long lessonId, @NonNull Long studentId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        Long userId = this.orgStudentDao.getUserId(studentId);
        OrgLessonSign obj = this.orgLessonSignDao.getStudentLessonSign(orgId, courseId, lessonId, userId, Integer.valueOf(UserRole.STUDENT.getRole()));
        if (obj != null) {
            OrgStudentLessonSignDto dto = new OrgStudentLessonSignDto();
            dto.setCourseId(obj.getCourseId());
            dto.setCreateTime(obj.getCreateTime());
            dto.setId(obj.getId());
            dto.setLessonId(obj.getLessonId());
            dto.setSignStatusEnum(SignStatus.getSignStatusByCode((Integer)obj.getStatus()));
            dto.setUpdateTime(obj.getUpdateTime());
            return dto;
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Map<String, Integer>> getLessonStudentSign(Long orgId, Collection<Long> lessonIds, Map<Long, Long> userIdMap) {
        List signs = this.orgLessonSignDao.getStudentLessonSign(orgId, null, lessonIds, new String[0]);
        HashMap signUserIdMap = Maps.newHashMap();
        for (OrgLessonSign sign : signs) {
            if (!signUserIdMap.containsKey(String.valueOf(sign.getUserId()))) {
                HashMap map = Maps.newHashMap();
                signUserIdMap.put(String.valueOf(sign.getUserId()), map);
            }
            ((Map)signUserIdMap.get(String.valueOf(sign.getUserId()))).put(String.valueOf(sign.getLessonId()), sign.getStatus());
        }
        HashMap signStudentIdMap = Maps.newHashMap();
        for (String userId : signUserIdMap.keySet()) {
            signStudentIdMap.put(String.valueOf(userIdMap.get(Long.parseLong(userId))), signUserIdMap.get(userId));
        }
        return signStudentIdMap;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Map<String, Integer>> getLessonStudentSignReport(Long orgId, Collection<Long> lessonIds, Map<Long, Long> userIdMap, Long courseId) {
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)("illegal courseId = " + courseId));
        long current = System.currentTimeMillis();
        Map userIdsLessonMap = this.orgStudentLessonDao.getLessonIdsOfStudents(orgId, userIdMap.keySet(), lessonIds);
        List signList = this.orgLessonSignDao.getUserLessonSignList(orgId, userIdMap.keySet(), courseId, Integer.valueOf(UserRole.STUDENT.getRole()), null, new String[0]);
        Map<Long, List<OrgLessonSign>> userIdLessonSignMap = this.getUserIdLessonSignMap(signList);
        HashMap signStudentIdMap = Maps.newHashMap();
        for (Long userId : userIdsLessonMap.keySet()) {
            HashMap userMap = Maps.newHashMap();
            List lessons = (List)userIdsLessonMap.get(userId);
            List<OrgLessonSign> signs = userIdLessonSignMap.get(userId);
            Map<Long, Integer> lessonSignMap = this.toLessonSignMap(signs);
            for (Long lessonId : lessons) {
                Integer sign = lessonSignMap.get(lessonId);
                userMap.put(String.valueOf(lessonId), sign == null ? 0 : sign);
            }
            signStudentIdMap.put(String.valueOf(userIdMap.get(userId)), userMap);
        }
        log.debug("cost:{}ms", (Object)(System.currentTimeMillis() - current));
        return signStudentIdMap;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, Integer> getLessonStudentSignCount(Long orgId, Collection<Long> lessonIds, Map<Long, Long> userIdMap) {
        Map userIdCountMap = this.orgLessonSignDao.getOrgLessonSignCount(lessonIds, Integer.valueOf(UserRole.STUDENT.getRole()));
        log.debug("getLessonStudentSignCount result={}", (Object)userIdCountMap);
        log.debug("getLessonStudentSignCount userIdMap={}", userIdMap);
        HashMap studentIdCountMap = Maps.newHashMap();
        for (Long userId : userIdCountMap.keySet()) {
            studentIdCountMap.put(userIdMap.get(userId), userIdCountMap.get(userId));
        }
        log.debug("getLessonStudentSignCount result={}", (Object)studentIdCountMap);
        return studentIdCountMap;
    }

    @Override
    public LessonSignReportDto getLessonSignReport(@NonNull Long orgId, @NonNull Long studentId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        log.info("orgId = {}, studentId={}", (Object)orgId, (Object)studentId);
        LessonSignReportDto lessonSignReportDto = new LessonSignReportDto();
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"student not exits!");
        OrgStudent orgStudent = this.orgStudentDao.getStudent(orgId, userId, Integer.valueOf(0), new String[]{"userId", "id", "name", "nickName", "mobile", "show_mobile"});
        if (orgStudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u751f\u5df2\u5220\u9664");
        }
        lessonSignReportDto.getStudentInfo().setName(this.buildStudentName(orgStudent));
        lessonSignReportDto.getStudentInfo().setStudentId(orgStudent.getUserId());
        Integer orgNumber = ((OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[]{"number"})).getNumber();
        List orgCourseList = this.orgCourseDao.getCoursesByOrgNumber(Long.valueOf(orgNumber.longValue()), Integer.valueOf(DeleteStatus.DELETED.getValue()), new String[]{"id"});
        ArrayList deletedIds = Lists.newArrayList();
        for (OrgCourse orgCourse : orgCourseList) {
            deletedIds.add(orgCourse.getId());
        }
        List courseIds = this.orgStudentCourseDao.getStudentCourseIds(orgId, userId, null);
        courseIds.removeAll(deletedIds);
        log.debug("courseIds = {}", (Object)courseIds);
        Map courseLessonCountMap = this.orgStudentLessonDao.getStudentLessonCountOfCourses(orgId, userId, (Collection)courseIds);
        log.debug("courseLessonCountMap = {}", (Object)courseLessonCountMap);
        List courseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[]{"id", "name"});
        log.debug("courseIds = {}, courseList = {}", (Object)courseIds, (Object)courseList);
        if (CollectionUtils.isEmpty((Collection)courseList)) {
            return lessonSignReportDto;
        }
        List lessonList = this.orgClassLessonDao.queryByCourseIds(orgId, (Collection)courseIds, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        HashMap lessonMap = Maps.newHashMap();
        ArrayList allLessonIds = Lists.newArrayList();
        for (OrgClassLesson lesson : lessonList) {
            allLessonIds.add(lesson.getId());
            lessonMap.put(lesson.getId(), lesson);
        }
        HashMap studentLessonCondition = Maps.newHashMap();
        studentLessonCondition.put("orgId", orgId);
        studentLessonCondition.put("lessonId", allLessonIds);
        studentLessonCondition.put("userId", userId);
        studentLessonCondition.put("delStatus", 0);
        List studentLessons = this.orgStudentLessonDao.queryByCondition((Map)studentLessonCondition, null, new String[0]);
        HashSet effectAllLesson = Sets.newHashSet();
        HashSet effectAllStudentId = Sets.newHashSet();
        HashMap courseStudentLessonMap = Maps.newHashMap();
        for (OrgStudentLesson studentLesson : studentLessons) {
            List tempList;
            Long courseId = ((OrgClassLesson)lessonMap.get(studentLesson.getLessonId())).getCourseId();
            Long tempStudentId = studentLesson.getUserId();
            Map studentLessonMap = (Map)courseStudentLessonMap.get(courseId);
            if (studentLessonMap == null) {
                studentLessonMap = Maps.newHashMap();
                courseStudentLessonMap.put(courseId, studentLessonMap);
            }
            if ((tempList = (List)studentLessonMap.get(tempStudentId)) == null) {
                tempList = Lists.newArrayList();
                studentLessonMap.put(tempStudentId, tempList);
            }
            tempList.add(studentLesson);
            effectAllLesson.add(studentLesson.getLessonId());
            effectAllStudentId.add(tempStudentId);
        }
        List allsignList = Lists.newArrayList();
        if (effectAllLesson.size() > 0 && effectAllStudentId.size() > 0) {
            HashMap signLessonCondition = Maps.newHashMap();
            signLessonCondition.put("orgId", orgId);
            signLessonCondition.put("lessonId", effectAllLesson);
            signLessonCondition.put("studentId", effectAllStudentId);
            signLessonCondition.put("userRole", 2);
            allsignList = this.orgLessonSignDao.queryByCondition((Map)signLessonCondition, null, new String[0]);
        }
        HashMap allSignMap = Maps.newHashMap();
        for (OrgLessonSign sign : allsignList) {
            String key = sign.getUserId() + "|" + sign.getLessonId();
            allSignMap.put(key, sign.getStatus());
        }
        for (OrgCourse orgCourse : courseList) {
            LessonSignReportDto.OrgCourseInfo courseInfo = new LessonSignReportDto.OrgCourseInfo();
            courseInfo.setCourseName(orgCourse.getName());
            Integer lessonCount = (Integer)courseLessonCountMap.get(orgCourse.getId());
            courseInfo.setLessonCount(lessonCount == null ? 0 : lessonCount);
            ArrayList userIds = Lists.newArrayList((Object[])new Long[]{userId});
            courseInfo.setStudentCount(userIds.size());
            Map userIdsLessonMap = (Map)courseStudentLessonMap.get(orgCourse.getId());
            LessonSignReportDto.CourseStudentDto studentDto = new LessonSignReportDto.CourseStudentDto();
            studentDto.setStudentName(this.buildStudentName(orgStudent));
            List studentLessonList = null;
            if (userIdsLessonMap != null) {
                studentLessonList = (List)userIdsLessonMap.get(orgStudent.getUserId());
            }
            if (CollectionUtils.isNotEmpty(studentLessonList)) {
                for (OrgStudentLesson studentLesson : studentLessonList) {
                    LessonSignReportDto.StudentLessonSignInfoDto signDto = new LessonSignReportDto.StudentLessonSignInfoDto();
                    signDto.setLessonId(studentLesson.getLessonId());
                    String key = studentLesson.getUserId() + "|" + studentLesson.getLessonId();
                    Integer status = (Integer)allSignMap.get(key);
                    signDto.setSignStatus(status != null ? status.intValue() : SignStatus.UNSIGN.getCode());
                    OrgClassLesson lesson = (OrgClassLesson)lessonMap.get(studentLesson.getLessonId());
                    if (lesson == null) {
                        log.error("lessonId = {} not exits!", (Object)studentLesson.getLessonId());
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "lessonId not found!");
                    }
                    signDto.setLessonNumber(lesson.getNumber());
                    studentDto.addLessonSignInfo(signDto);
                }
            }
            if (CollectionUtils.isNotEmpty(studentDto.getLessonList())) {
                log.info("no lesson in course studentDto = {}", (Object)studentDto);
                courseInfo.getStudentList().add(studentDto);
            }
            if (userId != null) {
                log.debug("{}{}", (Object)courseInfo.getLessonCount(), courseInfo.getStudentList());
                if (courseInfo.getStudentList().size() > 0 && courseInfo.getLessonCount().intValue() != courseInfo.getStudentList().get(0).getLessonList().size()) {
                    log.warn("should be equal.{} != {}", (Object)courseInfo.getLessonCount(), (Object)courseInfo.getStudentList().size());
                }
            }
            lessonSignReportDto.getCourseList().add(courseInfo);
        }
        return lessonSignReportDto;
    }

    private Map<Long, List<OrgLessonSign>> getUserIdLessonSignMap(List<OrgLessonSign> signList) {
        return CollectorUtil.group(signList, (Function)new Function<OrgLessonSign, Long>(){

            public Long apply(OrgLessonSign arg0) {
                return arg0.getUserId();
            }
        }, (Function)new Function<OrgLessonSign, OrgLessonSign>(){

            public OrgLessonSign apply(OrgLessonSign arg0) {
                return arg0;
            }
        });
    }

    private Map<Long, Integer> toLessonSignMap(List<OrgLessonSign> signList) {
        HashMap lessonSignMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(signList)) {
            return Collections.emptyMap();
        }
        for (OrgLessonSign sign : signList) {
            lessonSignMap.put(sign.getLessonId(), sign.getStatus());
        }
        return lessonSignMap;
    }

    private String buildStudentName(OrgStudent stu) {
        if (StringUtils.isNotBlank((String)stu.getName())) {
            return stu.getName();
        }
        if (StringUtils.isNotBlank((String)stu.getNickName())) {
            return stu.getNickName();
        }
        return MaskUtil.maskMobile((String)stu.getMobile());
    }

    @Override
    public Map<Long, Double> getAttendanceRateOfCourses(Long orgId, Collection<Long> courseIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMap();
        Map shouldSignCntMap = this.orgClassLessonDao.getCourseAttendCountMap(orgId, courseIds);
        Map actualSignCntMap = this.orgLessonSignDao.getCourseSignCountMap(orgId, courseIds);
        log.debug("shouldSignCntMap={},actualSignCntMap={}", (Object)shouldSignCntMap, (Object)actualSignCntMap);
        for (Long courseId : courseIds) {
            Integer shouldSignCnt = (Integer)shouldSignCntMap.get(courseId);
            Integer actualSignCnt = (Integer)actualSignCntMap.get(courseId);
            if (actualSignCnt != null && shouldSignCnt != null && shouldSignCnt > 0) {
                Double attendanceRate = (double)actualSignCnt.intValue() / (double)shouldSignCnt.intValue();
                resultMap.put(courseId, attendanceRate);
                continue;
            }
            resultMap.put(courseId, 0.0);
        }
        log.debug("resultMap={}", (Object)resultMap);
        return resultMap;
    }

    @Override
    public Map<Long, Double> getAttendanceRateOfStudents(Long orgId, Collection<Long> studentds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(studentds)) {
            return Collections.emptyMap();
        }
        Map stuUserMap = this.orgStudentDao.getStudentIdUserIdMap(studentds);
        Collection userIds = stuUserMap.values();
        log.debug("stuUserMap={}", (Object)stuUserMap);
        log.debug("userIds={}", userIds);
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMap();
        Map shouldSignCntMap = this.orgClassLessonDao.getStudentAttendCountMap(orgId, userIds);
        Map actualSignCntMap = this.orgLessonSignDao.getStudentSignCountMap(orgId, userIds);
        log.debug("shouldSignCntMap={},actualSignCntMap={}", (Object)shouldSignCntMap, (Object)actualSignCntMap);
        for (Long studentId : studentds) {
            Long userId = (Long)stuUserMap.get(studentId);
            if (userId == null || userId <= 0L) continue;
            Integer shouldSignCnt = (Integer)shouldSignCntMap.get(userId);
            Integer actualSignCnt = (Integer)actualSignCntMap.get(userId);
            if (actualSignCnt != null && shouldSignCnt != null && shouldSignCnt > 0) {
                Double attendanceRate = (double)actualSignCnt.intValue() / (double)shouldSignCnt.intValue();
                resultMap.put(studentId, attendanceRate);
                continue;
            }
            resultMap.put(studentId, 0.0);
        }
        log.debug("resultMap={}", (Object)resultMap);
        return resultMap;
    }

    @Override
    public List<Long> getStudentBySignStatus(Long orgId, Long lessonId) {
        List dtos = this.orgLessonSignDao.getStudentLessonByStatus(orgId, lessonId, SignStatus.UNSIGN.getCode(), new String[0]);
        Collection studentIds = CollectorUtil.collect((Collection)dtos, (Function)new Function<OrgLessonSign, Long>(){

            public Long apply(OrgLessonSign input) {
                return input.getUserId();
            }
        });
        return new ArrayList<Long>(studentIds);
    }

    private boolean checkOrgPermissionSignMsg(Integer orgId) {
        TXSaleClueRule tXSaleClueRule = this.tXSaleClueRuleService.getByOrgId(orgId);
        log.info("checkOrgPermissionSignMsg orgId={orgId},txsaleClueRule={}", (Object)orgId, (Object)tXSaleClueRule);
        return tXSaleClueRule != null && tXSaleClueRule.getSigninMsg() == 0;
    }

    private Map<String, String> timerSendSignCacheKey(Collection<Long> studentIds, OrgClassLesson lesson) {
        HashMap sendMap = Maps.newHashMap();
        if (!this.checkOrgPermissionSignMsg(lesson.getOrgId().intValue())) {
            return sendMap;
        }
        for (Long studentId : studentIds) {
            final String key = lesson.getOrgId() + "" + studentIds + "" + lesson.getId();
            final String value = UUID.randomUUID().toString();
            this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.setEx(key.getBytes(), 120L, value.getBytes());
                    return null;
                }
            });
            sendMap.put(key, value);
        }
        return sendMap;
    }

    private void timerSendSignMsg(final OrgInfo orgInfo, final OrgStudent student, final Teacher teacher, final OrgClassLesson lesson, final OrgCourse course, final Integer status) {
        final String key = orgInfo.getId() + "" + student.getId() + "" + lesson.getId();
        final String value = UUID.randomUUID().toString();
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.setEx(key.getBytes(), 120L, value.getBytes());
                return null;
            }
        });
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                OrgLessonSignServiceImpl.this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                    public Object doInRedis(RedisConnection connection) throws DataAccessException {
                        String olduuid = (String)OrgLessonSignServiceImpl.this.redisTemplate.getStringSerializer().deserialize(connection.get(key.getBytes()));
                        log.debug("time send sign msg =={},{}", (Object)olduuid, (Object)value);
                        if (value.equals(olduuid)) {
                            OrgLessonSignServiceImpl.this.signSendMsg(orgInfo, student, teacher, lesson, course, status);
                        }
                        return null;
                    }
                });
            }
        }, 60000L);
    }

    @Override
    public void signSendMsg(OrgInfo orgInfo, OrgStudent student, Teacher teacher, OrgClassLesson lesson, OrgCourse course, Integer status) {
        try {
            this.msgSendService.sendMsg(this.getSendMsg(orgInfo, student, teacher == null ? null : teacher.getRealName(), lesson, course, status));
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }

    private Map<String, OrgLessonSign> conver2Map(List<OrgLessonSign> lessonSignIn) {
        return CollectorUtil.collectMap(lessonSignIn, (Function)new Function<OrgLessonSign, String>(){

            public String apply(OrgLessonSign arg0) {
                String key = arg0.getUserId() + "|" + arg0.getLessonId();
                return key;
            }
        });
    }

    private void addToSigninMsgAsynModel(List<OrgLessonSign> lessonSignIn) {
        Map<String, OrgLessonSign> newSignin = this.conver2Map(lessonSignIn);
        for (Map.Entry<String, OrgLessonSign> entry : newSignin.entrySet()) {
            final String cacheKey = "siginMsg_" + entry.getKey();
            final String value = UUID.randomUUID().toString();
            entry.getValue().setRandomUUID(value);
            this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.setEx(cacheKey.getBytes(), 120L, value.getBytes());
                    return null;
                }
            });
        }
        SigninMsgAsynModel.addNewLessonSignIn(newSignin);
    }
}

