/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.common.service.MsgSendService;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.sal.course.dto.MsgSendResult;
import com.baijia.tianxiao.sal.course.service.OrgLessonSyncService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Encoder;

@Service
public class OrgLessonSyncServiceImpl
implements OrgLessonSyncService {
    private static final Logger log = LoggerFactory.getLogger(OrgLessonSyncServiceImpl.class);
    private static String lessonStartStudent = "%s\uff0c\u4f60\u5728%s\u7684%s\u5c06\u5728%s\u5f00\u59cb\u4e0a\u8bfe\u3002\u8bf7\u505a\u597d\u4e0a\u8bfe\u51c6\u5907\u54e6\u3002\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u62e8\u62534000122166\u8f6c%s\u3002";
    private static String lessonStartStudent22480 = "%s\uff0c\u4f60\u5728%s\u7684%s\u5c06\u5728%s\u5f00\u59cb\u4e0a\u8bfe\u3002\u8bf7\u505a\u597d\u4e0a\u8bfe\u51c6\u5907\u54e6\u3002\u73ed\u8bfe\u4e0d\u63a5\u53d7\u8bf7\u5047\uff0c\u4e00\u5bf9\u4e00\u8bf7\u5047\u8bf7\u62e8\u6253(4000122166\u8f6c%s)\u4e0a\u8bfe\u5f53\u5929\u4e0d\u63a5\u53d7\u8bf7\u5047\u3002";
    private static String defaultName = "-";
    private static String remark = "\u522b\u8fdf\u5230\u54e6\uff5e\uff5e";
    @Autowired(required=false)
    private MsgSendService msgSendService;
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgClassRoomDao OrgClassRoomDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;

    private boolean checkOrgPermissionLessonMsg(Integer orgId) {
        TXSaleClueRule tXSaleClueRule = this.tXSaleClueRuleService.getByOrgId(orgId);
        return tXSaleClueRule != null && tXSaleClueRule.getAttendClassMsg() == 0;
    }

    @PostConstruct
    public void init() {
    }

    @Override
    public void syncSMSBeforeLessonBegin() {
        MsgSendResult.lessonSyncResult.set(new HashMap());
        Date now = new Date();
        Date startTime = DateUtil.getEndOfDay((Date)now);
        int i = 0;
        while (i < 24) {
            Date tempStartTime = DateUtil.getDiffDateTime((Date)startTime, (int)i, (int)11);
            Date tempEndTime = DateUtil.getDiffDateTime((Date)startTime, (int)(i + 1), (int)11);
            this.studentLessonSms(tempStartTime, tempEndTime);
            log.debug("send message startTime={},endTime={}", (Object)tempStartTime, (Object)tempEndTime);
            ++i;
        }
        Map<Integer, MsgSendResult> result = MsgSendResult.lessonSyncResult.get();
        log.info("lessonSyncResult={}", result);
        try {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Integer, MsgSendResult> orgSendResult : result.entrySet()) {
                MsgSendResult tempOrgResult = orgSendResult.getValue();
                String resultStr = JSONObject.fromObject((Object)tempOrgResult).toString();
                sb.append(String.valueOf(resultStr) + ",\n");
            }
            this.sendMail(sb.toString());
        }
        catch (Exception e) {
            log.error("syncSMSBeforeLessonBegin result mail error", (Throwable)e);
        }
        MsgSendResult.lessonSyncResult.set(null);
    }

    private void studentLessonSms(Date startTime, Date endTime) {
        Map lessonUnBeginMap = this.orgStudentLessonDao.getStudentLessonByStartTime(startTime, endTime);
        log.debug("lessonUnBeginMap={}", (Object)lessonUnBeginMap);
        List lessons = this.orgClassLessonDao.getByIds(lessonUnBeginMap.keySet(), new String[0]);
        Map teacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(null, lessonUnBeginMap.keySet());
        Map teacherNameMap = this.teacherDao.getTeacherRealNameMap(teacherIdMap.values());
        HashSet courseIds = Sets.newHashSet();
        HashSet orgIds = Sets.newHashSet();
        HashSet orgIdLs = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet userIds = Sets.newHashSet();
        for (OrgClassLesson lesson : lessons) {
            courseIds.add(lesson.getCourseId());
            orgIds.add(lesson.getOrgId().intValue());
            orgIdLs.add(lesson.getOrgId());
            roomIds.add(lesson.getRoomId());
            List value = (List)lessonUnBeginMap.get(lesson.getId());
            if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
            userIds.addAll(value);
        }
        log.debug("courseIds={},orgIds={},roomIds={}", new Object[]{courseIds, orgIds, roomIds});
        Map<Long, OrgInfo> orgInfos = this.getOrgInfoMap(orgIds);
        Map<Long, OrgCourse> courseInfos = this.getCourseInfos(courseIds);
        Map<String, OrgStudent> studentInfos = this.getStudentInfos(orgIdLs, userIds);
        Map roomNameMap = this.OrgClassRoomDao.getRoomName(null, (Collection)roomIds);
        for (OrgClassLesson lesson : lessons) {
            OrgInfo orgInfo = orgInfos.get(lesson.getOrgId());
            List lessonUserIds = (List)lessonUnBeginMap.get(lesson.getId());
            int tempStudentCount = 0;
            if (lessonUserIds != null) {
                tempStudentCount = lessonUserIds.size();
            }
            MsgSendResult.addLessonCount(orgInfo, 1, tempStudentCount);
            if (!this.checkOrgPermissionLessonMsg(lesson.getOrgId().intValue())) {
                MsgSendResult.addFailRule(orgInfo, 1, tempStudentCount);
                log.info("\u673a\u6784\u6743\u9650\u4e0d\u8db3\uff0c\u8fc7\u6ee4\u4e0a\u8bfe\u63d0\u9192\uff0c\u673a\u6784id:{},\u673a\u6784\u540d\u5b57:{}", (Object)lesson.getOrgId(), (Object)(orgInfo == null ? null : orgInfo.getName()));
                continue;
            }
            OrgCourse course = courseInfos.get(lesson.getCourseId());
            if (course == null || course.getIsDel() != 0) {
                MsgSendResult.addFailDelCourse(orgInfo, 1, tempStudentCount);
                log.info("\u8bfe\u7a0b\u72b6\u6001\u662f\u5df2\u5220\u9664\uff0c\u8fc7\u6ee4\u4e0a\u8bfe\u63d0\u9192\uff0c\u673a\u6784id:{},\u673a\u6784\u540d\u5b57:{},\u8bfe\u7a0bid:{}", new Object[]{lesson.getOrgId(), orgInfo == null ? null : orgInfo.getName(), course == null ? null : course.getName()});
                continue;
            }
            Long teacherId = (Long)teacherIdMap.get(lesson.getId());
            String teacherName = null;
            if (teacherId != null) {
                teacherName = (String)teacherNameMap.get(teacherId);
            }
            String roomName = null;
            if (lesson.getRoomId() != null) {
                roomName = (String)roomNameMap.get(lesson.getRoomId());
            }
            if (orgInfo == null || course == null || !CollectionUtils.isNotEmpty((Collection)lessonUserIds)) continue;
            int delStudentFailCount = 0;
            int sendFailCount = 0;
            for (Long lessonUserId : lessonUserIds) {
                OrgStudent student = studentInfos.get(String.valueOf(String.valueOf(orgInfo.getOrgId())) + String.valueOf('|') + String.valueOf(lessonUserId));
                if (student != null && student.getDelStatus() == 0) {
                    boolean bool = this.msgSendService.sendMsg(this.getStudentLessonStart(teacherName, roomName, lesson, course, orgInfo, student));
                    if (bool) continue;
                    ++sendFailCount;
                    continue;
                }
                ++delStudentFailCount;
                log.info("\u5b66\u5458\u72b6\u6001\u4e0d\u5408\u6cd5\uff0c\u8fc7\u6ee4\u4e0a\u8bfe\u63d0\u9192\uff0c\u673a\u6784id:{},\u673a\u6784\u540d\u5b57:{},\u8bfe\u7a0bid:{},\u5b66\u5458id:{}", new Object[]{lesson.getOrgId(), orgInfo == null ? null : orgInfo.getName(), course == null ? null : course.getName(), lessonUserId});
            }
            MsgSendResult.addFailDelStudent(orgInfo, delStudentFailCount);
            MsgSendResult.addFailSend(orgInfo, sendFailCount);
        }
    }

    private SendMsgRequest getStudentLessonStart(String teacherName, String roomName, OrgClassLesson lesson, OrgCourse course, OrgInfo orgInfo, OrgStudent student) {
        SendMsgRequest request = new SendMsgRequest();
        request.setOrgId(Long.valueOf(orgInfo.getOrgId().longValue()));
        request.setMobile(student.getMobile());
        request.setCountSms(false);
        request.setReceiverId(student.getId());
        request.setWeixinOpenId(student.getWeixin());
        request.setReceiverRole(UserRoleEnum.STUDENT);
        request.setSenderId(Long.valueOf(orgInfo.getOrgId().longValue()));
        request.setSenderRole(UserRoleEnum.ORG);
        request.setWechatTemplateId(Integer.valueOf(WechateTemplateMsgType.COURSE_START_TO_STU.getValue()));
        String smsContent = String.format(lessonStartStudent, this.getStringValue(student.getName()), this.getStringValue(orgInfo.getShortName()), this.getStringValue(course.getName()), DateUtil.getStrByDateFormate((Date)lesson.getStartTime(), (String)"yyyy-MM-dd HH:mm"), this.getStringValue(orgInfo.getExtension()));
        if (orgInfo != null && orgInfo.getOrgId() != null && orgInfo.getOrgId() == 22480) {
            smsContent = String.format(lessonStartStudent22480, this.getStringValue(student.getName()), this.getStringValue(orgInfo.getShortName()), this.getStringValue(course.getName()), DateUtil.getStrByDateFormate((Date)lesson.getStartTime(), (String)"yyyy-MM-dd HH:mm"), this.getStringValue(orgInfo.getExtension()));
        }
        HashMap params = Maps.newHashMap();
        request.setSmsContent(smsContent);
        params.put("first", smsContent);
        params.put("remark", remark);
        params.put("keyword1", DateUtil.getStrByDateFormate((Date)lesson.getStartTime(), (String)"yyyy-MM-dd HH:mm"));
        params.put("keyword2", this.getStringValue(teacherName));
        params.put("keyword3", this.getStringValue(course.getName()));
        params.put("keyword4", this.getStringValue(roomName));
        request.setWechatParams((Map)params);
        log.debug("send msg={}", (Object)request);
        return request;
    }

    private String getStringValue(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return defaultName;
        }
        return message;
    }

    private void teacherLessonSms(Date startTime, Date endTime) {
        Map lessonUnBeginMap = this.orgTeacherLessonDao.getTeacherLessonByStartTime(startTime, endTime);
        List lessons = this.orgClassLessonDao.getByIds(lessonUnBeginMap.keySet(), new String[0]);
        HashSet courseIds = Sets.newHashSet();
        HashSet orgIds = Sets.newHashSet();
        HashSet orgIdLs = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet userIds = Sets.newHashSet();
        for (OrgClassLesson lesson : lessons) {
            courseIds.add(lesson.getCourseId());
            orgIds.add(lesson.getOrgId().intValue());
            orgIdLs.add(lesson.getOrgId());
            roomIds.add(lesson.getRoomId());
            List value = (List)lessonUnBeginMap.get(lesson.getId());
            if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
            userIds.addAll(value);
        }
        Map<Long, OrgInfo> orgInfos = this.getOrgInfoMap(orgIds);
        Map<Long, OrgCourse> courseInfos = this.getCourseInfos(courseIds);
        Map<Long, Teacher> teacherInfos = this.getTeacherInfos(userIds);
    }

    private Map<Long, Teacher> getTeacherInfos(Collection<Long> userIds) {
        List teachers = this.teacherDao.getByUserIds(userIds, new String[0]);
        return CollectorUtil.collectMap((Collection)teachers, (Function)new Function<Teacher, Long>(){

            public Long apply(Teacher arg0) {
                return arg0.getUserId();
            }
        });
    }

    private Map<String, OrgStudent> getStudentInfos(Collection<Long> orgIds, Collection<Long> userIds) {
        List students = this.orgStudentDao.getStudentsByUserIdsAndOrgIds(orgIds, userIds);
        return CollectorUtil.collectMap((Collection)students, (Function)new Function<OrgStudent, String>(){

            public String apply(OrgStudent arg0) {
                return String.valueOf(String.valueOf(arg0.getOrgId())) + String.valueOf('|') + String.valueOf(arg0.getUserId());
            }
        });
    }

    private Map<Long, OrgClassRoom> getRoomsInfos(Collection<Long> roomIds) {
        List rooms = this.OrgClassRoomDao.getByIds(roomIds, new String[0]);
        return CollectorUtil.collectMap((Collection)rooms, (Function)new Function<OrgClassRoom, Long>(){

            public Long apply(OrgClassRoom arg0) {
                return arg0.getId();
            }
        });
    }

    private Map<Long, OrgCourse> getCourseInfos(Collection<Long> courseIds) {
        List courses = this.orgCourseDao.getByIds(courseIds, new String[0]);
        return CollectorUtil.collectMap((Collection)courses, (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse arg0) {
                return arg0.getId();
            }
        });
    }

    private Map<Long, OrgInfo> getOrgInfoMap(Collection<Integer> orgIds) {
        List orgInfos = this.orgInfoDao.getOrgInfos(orgIds, new String[0]);
        return CollectorUtil.collectMap((Collection)orgInfos, (Function)new Function<OrgInfo, Long>(){

            public Long apply(OrgInfo arg0) {
                return arg0.getOrgId().longValue();
            }
        });
    }

    private Map<Integer, TXSaleClueRule> getOrgSaleClueRule(Collection<Integer> orgIds) {
        return this.tXSaleClueRuleService.queryByIds(orgIds);
    }

    private void sendMail(String content) {
        Properties prop = new Properties();
        prop.setProperty("mail.host", "mail.baijiahulian.com");
        prop.setProperty("mail.smtp.auth", "true");
        Authenticator auth = new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("txm", "$lVo6%s*grcV5bqQ");
            }
        };
        Session session = Session.getInstance((Properties)prop, (Authenticator)auth);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress("MTPM@baijiahulian.com"));
            msg.addRecipients(Message.RecipientType.TO, "leiruiqi@baijiahulian.com");
            BASE64Encoder base64 = new BASE64Encoder();
            String subject = new String(base64.encode("\u76d1\u63a7\u6d4b\u8bd5".getBytes("UTF-8")));
            msg.setSubject(MimeUtility.encodeText((String)"\u76d1\u63a7\u6d4b\u8bd5", (String)"UTF-8", (String)"B"));
            MimeMultipart parts = new MimeMultipart();
            MimeBodyPart part = new MimeBodyPart();
            part.setContent((Object)content, "text/html;charset=utf-8");
            parts.addBodyPart((BodyPart)part);
            msg.setContent((Multipart)parts);
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            log.error("OrgLessonSyncService send mail error", (Throwable)e);
        }
    }
}

