/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.commons.lang.utils.BaseUtils;
import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.OrgCourseStatus;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.dao.OrgCoursePhotoDao;
import com.baijia.tianxiao.dal.course.po.OrgCoursePhoto;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.AreaDao;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseStudentOpDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonConflictDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTimeSpanDao;
import com.baijia.tianxiao.dal.org.po.Area;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgTimeSpan;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dal.util.SerialNumberUtil;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.constant.LessonWay;
import com.baijia.tianxiao.sal.course.dto.OrgClassLessonDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseDetailResponseDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseInfoDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseQueryResponseDto;
import com.baijia.tianxiao.sal.course.dto.request.OrgRecommendCourseRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgCourseGroupDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgTimeSpanDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupRelateService;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.impl.RequestSourceDesc;
import com.baijia.tianxiao.sal.organization.utils.DataAuthority;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.date.TimeStamp;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgCourseServiceImpl
implements OrgCourseService {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseServiceImpl.class);
    private static final int TOTAL_COURSE_COLOR_COUNT = 35;
    @Resource
    OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgCourseStudentOpDao orgCourseStudentStatusDao;
    @Resource
    private OrgTimeSpanDao orgTimeSpanDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private AreaDao areaDao;
    @Resource
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Resource
    private OrgCourseGroupService orgCourseGroupService;
    @Resource
    private OrgCourseGroupRelateService orgCourseGroupRelateService;
    @Resource
    private UserDao userDao;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Autowired
    private OrgCourseGroupDao orgCourseGroupDao;
    @Autowired
    private OrgCoursePhotoDao orgCoursePhotoDao;
    @Autowired
    private TxAccountPermissionService txAccountPermission;
    @Resource
    private OrgCourseConsumeRuleService orgCourseConsumeRuleService;
    @Resource
    private TXCommonRuleService tXCommonRuleService;
    @Resource
    private OrgLessonConflictDao orgLessonConflictDao;
    @Resource
    private Environment environment;

    private static boolean checkTime(String start, String end) {
        TimeStamp startTime = TimeStamp.parse((String)start);
        TimeStamp endTime = TimeStamp.parse((String)end);
        if (startTime.getHour() > endTime.getHour()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5f00\u59cb\u65f6\u95f4 \u5927\u4e8e \u7ed3\u675f\u65f6\u95f4");
        }
        if (startTime.getMinute() % 5 != 0 || endTime.getMinute() % 5 != 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5206\u949f\u4e0d\u662f5\u7684\u6574\u6570\u500d");
        }
        if (startTime.getSecond() != 0 || endTime.getSecond() != 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u79d2\u5fc5\u987b\u4e3a0");
        }
        return true;
    }

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgCourseQueryResponseDto> getOrgCourses(@NonNull Long orgId, String key, PageDto pageDto) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        Long orgNumber = this.getOrgNumber(orgId);
        if (orgNumber == null) {
            log.error("orgNumber = {}", (Object)orgNumber);
            return Lists.newArrayList();
        }
        log.info("getOrgCourses orgNumber {}", (Object)orgNumber);
        ArrayList<OrgCourseQueryResponseDto> courseQueryResponseDtos = new ArrayList<OrgCourseQueryResponseDto>();
        List orgCourses = this.orgCourseDao.getCoursesByOrgNumber(orgNumber, key, Integer.valueOf(OrgCourseStatus.IN_PROGRESS.getCode()), CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null, pageDto, new String[0]);
        HashSet<Long> courseIds = new HashSet<Long>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgCourses)) {
            for (OrgCourse orgCourse : orgCourses) {
                courseIds.add(orgCourse.getId());
                if (!StringUtils.isEmpty((String)orgCourse.getColor())) continue;
                orgCourse.setColor(this.getNextRandomColor());
                this.orgCourseDao.saveOrUpdate((Object)orgCourse, new String[0]);
            }
            Map<Long, List<String>> courseIdTeacherIdMap = this.getCourseIdTeacherNamesMap(courseIds);
            for (OrgCourse orgCourse : orgCourses) {
                OrgCourseQueryResponseDto courseQueryResponseDto = new OrgCourseQueryResponseDto();
                this.fillCourseQueryResponseDto(courseIdTeacherIdMap, orgCourse, courseQueryResponseDto);
                courseQueryResponseDtos.add(courseQueryResponseDto);
            }
        }
        return courseQueryResponseDtos;
    }

    @Override
    public void assign(Long orgId, List<Long> courserIds, Long cascadeId) {
        List orgCourses = this.orgCourseDao.getByIds(courserIds, new String[0]);
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        Preconditions.checkArgument((orgCourses != null && orgCourses.size() > 0 ? 1 : 0) != 0, (Object)("org course is null" + courserIds));
        Preconditions.checkArgument((orgAccount != null ? 1 : 0) != 0, (Object)("org account is null" + orgId));
        log.debug("course assign = orgaccount={},orgCourses={}", (Object)orgAccount, (Object)orgCourses);
        for (OrgCourse orgCourse : orgCourses) {
            if (orgCourse.getOrgNumber().longValue() != orgAccount.getNumber().longValue()) {
                throw new PermissionException();
            }
            orgCourse.setCascadeId(Integer.valueOf(cascadeId == null ? 0 : cascadeId.intValue()));
            this.orgCourseDao.update((Object)orgCourse, new String[0]);
        }
    }

    @Override
    @Transactional(readOnly=true)
    @DataAuthority(resourceTypes={RequestSourceDesc.COURSE_LIST})
    public List<OrgCourseQueryResponseDto> getEnrolledOrgCourses(@NonNull Long orgId, String key, PageDto pageDto) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        Long orgNumber = this.getOrgNumber(orgId);
        if (orgNumber == null) {
            log.error("orgNumber = {}", (Object)orgNumber);
            return Lists.newArrayList();
        }
        log.info("getOrgCourses orgNumber {}", (Object)orgNumber);
        ArrayList<Long> cascadeIds = null;
        boolean canAccess = RequestSourceDesc.COURSE_LIST.canAccess("getEnrolledOrgCourses", this.getClass(), new Class[]{Long.class, String.class, PageDto.class});
        if (!canAccess) {
            log.info("{} need dataAuthority filter ", (Object)RequestSourceDesc.COURSE_LIST.getAccountRoleType());
            cascadeIds = new ArrayList<Long>();
            cascadeIds.add(TianxiaoMContext.getTXCascadeId().longValue());
        }
        List orgCourses = this.orgCourseDao.getCoursesByCascadeIds(orgNumber, cascadeIds, key, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
        List result = new ArrayList<OrgCourse>();
        if (orgCourses == null || orgCourses.isEmpty()) {
            return Collections.emptyList();
        }
        Map courseMap = CollectionUtils.extractMap((Collection)orgCourses, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, OrgCourse>(){

            public Long extract(OrgCourse orgCourse) {
                return orgCourse.getId();
            }
        });
        List courses = this.orgStudentCourseDao.getOrgCourseByOrgId(orgId, courseMap.keySet(), null);
        for (OrgStudentCourse course : courses) {
            if (courseMap.get(course.getCourseId()) == null) continue;
            result.add((OrgCourse)courseMap.get(course.getCourseId()));
        }
        log.info("Result size=" + result.size());
        if (result.size() < 1) {
            return Collections.emptyList();
        }
        pageDto.setCount(Integer.valueOf(result.size()));
        Collections.sort(result, new Comparator<OrgCourse>(){

            @Override
            public int compare(OrgCourse o1, OrgCourse o2) {
                return (int)(o2.getId() - o1.getId());
            }
        });
        int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        int end = pageDto.getPageNum() * pageDto.getPageSize();
        result = result.subList(Math.min(start, result.size()), Math.min(end, result.size()));
        ArrayList<OrgCourseQueryResponseDto> courseQueryResponseDtos = new ArrayList<OrgCourseQueryResponseDto>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(result)) {
            for (OrgCourse orgCourse : result) {
                OrgCourseQueryResponseDto courseQueryResponseDto = OrgCourseQueryResponseDto.getInstanceByOrgCourse(orgCourse);
                courseQueryResponseDtos.add(courseQueryResponseDto);
            }
        }
        return courseQueryResponseDtos;
    }

    private void fillCourseQueryResponseDto(Map<Long, List<String>> courseIdTeacherIdMap, OrgCourse orgCourse, OrgCourseQueryResponseDto courseQueryResponseDto) {
        courseQueryResponseDto.setCourseName(orgCourse.getName());
        courseQueryResponseDto.setOrgCourseId(orgCourse.getId());
        courseQueryResponseDto.setColor(orgCourse.getColor());
        courseQueryResponseDto.setOrgCourseNumber(orgCourse.getNumber());
        courseQueryResponseDto.setOriginPrice(orgCourse.getPrice());
        courseQueryResponseDto.setCoverUrl(this.getCoverUrl(orgCourse));
        List<String> teacherNames = courseIdTeacherIdMap.get(orgCourse.getId());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(teacherNames)) {
            courseQueryResponseDto.setTeacherName(StringUtils.join((Object[])teacherNames.toArray(), (char)','));
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, List<String>> getCourseIdTeacherNamesMap(Collection<Long> courseIds) {
        List orgCourseTeachers = this.orgCourseTeacherDao.getOrgCourseTeacher(courseIds, null);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgCourseTeachers)) {
            HashMap result = Maps.newHashMap();
            HashSet teacherIds = Sets.newHashSet();
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                teacherIds.add(orgCourseTeacher.getUserId());
            }
            Map teacherNames = this.teacherDao.getTeacherRealNameMap((Collection)teacherIds);
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                Long courseId = orgCourseTeacher.getOrgCourseId();
                if (!result.containsKey(courseId)) {
                    result.put(courseId, Lists.newArrayList());
                }
                ((List)result.get(courseId)).add((String)teacherNames.get(orgCourseTeacher.getUserId()));
            }
            log.debug("courseIds:{}, teacherNames:{}", courseIds, (Object)teacherNames);
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgCourseQueryResponseDto> getLatestOrgCourses(Long orgId, PageDto pageDto) {
        log.info("getOrgLatestCourses-->orgId {}", (Object)orgId);
        ArrayList<OrgCourseQueryResponseDto> courseQueryResponseDtos = new ArrayList<OrgCourseQueryResponseDto>();
        List courseIds = this.coursePurchaseDao.getLatestdPurchaseCourseIdsList(orgId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)courseIds)) {
            log.info("get no courses id");
            return Collections.emptyList();
        }
        List orgCourses = this.orgCourseDao.getByIdsOrderByIn((Collection)courseIds, pageDto.getPageSize());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgCourses)) {
            log.info("get no courses ids={}", (Object)courseIds);
            return Collections.emptyList();
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgCourses)) {
            Map<Long, List<String>> courseIdTeacherIdMap = this.getCourseIdTeacherNamesMap(courseIds);
            for (OrgCourse orgCourse : orgCourses) {
                OrgCourseQueryResponseDto courseQueryResponseDto = new OrgCourseQueryResponseDto();
                this.fillCourseQueryResponseDto(courseIdTeacherIdMap, orgCourse, courseQueryResponseDto);
                courseQueryResponseDtos.add(courseQueryResponseDto);
            }
        }
        return courseQueryResponseDtos;
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> getCourseColors() {
        String colors = PropertiesReader.getValueNoCache((String)"erp.properties", (String)"course.colors");
        Object[] colorsArray = colors.split(",");
        if (colorsArray.length != 35) {
            log.warn("course colors count = {}", (Object)colorsArray.length);
        }
        return Lists.newArrayList((Object[])colorsArray);
    }

    private String getNextRandomColor() {
        List<String> colors = this.getCourseColors();
        Random rand = new Random();
        return colors.get(rand.nextInt(colors.size() - 1));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeCourseColor(@NonNull Long orgId, @NonNull Long courseId, @NonNull String color) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (courseId == null) {
            throw new NullPointerException("courseId");
        }
        if (color == null) {
            throw new NullPointerException("color");
        }
        if (!color.startsWith("#") || color.length() != 7) {
            log.error("color = {} \u683c\u5f0f\u4e0d\u5bf9 ", (Object)color);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "wrong color format.");
        }
        this.orgCourseDao.changeCourseColor(Integer.valueOf(this.getOrgNumber(orgId).intValue()), courseId, color);
    }

    private boolean isCourseDuplicate(OrgCourseInfoDto course, boolean updateRepeate) {
        if (updateRepeate) {
            return false;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateCourse(Long orgId, OrgCourseInfoDto course, boolean doDel, boolean updateRepeate) {
        OrgCourse orgCourse;
        boolean isUpdate;
        log.info("orgId={}, course={}", (Object)orgId, (Object)course);
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId illegal.");
        Preconditions.checkArgument((course != null ? 1 : 0) != 0, (Object)"course == null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)course.getCourseName()), (Object)"\u8bfe\u7a0b\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        Preconditions.checkArgument((course.getCoursePrice() != null && course.getCoursePrice() > 0.0 ? 1 : 0) != 0, (Object)"\u8bfe\u7a0b\u4ef7\u683c\u5fc5\u987b>0");
        if (this.isCourseDuplicate(course, updateRepeate)) {
            throw new BussinessException((UniverseErrorCode)CourseErrorCode.COURSE_EXSIST);
        }
        boolean bl = isUpdate = course.getCourseId() != null && course.getCourseId() > 0L;
        if (isUpdate && (orgCourse = this.orgCourseDao.getByCourseId(course.getCourseId(), new String[0])) != null && orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            course.setStartTime(null);
            course.setEndTime(null);
            course.setMaxStudent(null);
            course.setFreq(null);
        }
        orgCourse = new OrgCourse();
        orgCourse.setOrgNumber(this.getOrgNumber(orgId));
        orgCourse.setId(isUpdate ? course.getCourseId() : null);
        orgCourse.setBeginTime(course.getStartTime());
        orgCourse.setEndTime(course.getEndTime());
        orgCourse.setColor(this.getNextRandomColor());
        orgCourse.setCover(course.getCoverStorageId());
        orgCourse.setFreq(course.getFreq());
        orgCourse.setName(course.getCourseName());
        orgCourse.setMaxStudent(course.getMaxStudent());
        orgCourse.setNumber(Long.valueOf(System.nanoTime()));
        orgCourse.setIsDel(course.getIsDel());
        orgCourse.setSubjectId(Integer.valueOf(0));
        if (!isUpdate && course.getStatus() == null) {
            orgCourse.setStatus(Integer.valueOf(OrgCourseStatus.OFFLINE.getCode()));
        } else {
            orgCourse.setStatus(course.getStatus());
        }
        orgCourse.setVerifyStatus(Integer.valueOf(AuditStatus.PASS.getValue()));
        orgCourse.setAddress(course.getAddress());
        orgCourse.setLessonWay(LessonWay.STU_ACTIVE.getValue());
        Double lng = course.getLng();
        Double lat = course.getLat();
        if (lng != null && lat != null) {
            orgCourse.setOfflinePoi(lng + "," + lat);
        }
        if (course.getIntroduction() != null) {
            Blob intro = com.baijia.tianxiao.util.BaseUtils.strToBlob((String)course.getIntroduction(), (String)"UTF-8");
            orgCourse.setIntroduction(intro);
        }
        orgCourse.setBranchId(Long.valueOf(-1L));
        orgCourse.setClsfyId(Long.valueOf(-1L));
        orgCourse.setRoomId(Long.valueOf(-1L));
        orgCourse.setLayoutId(Long.valueOf(-1L));
        orgCourse.setPrice(course.getCoursePrice());
        orgCourse.setLessonSummary(course.getLessonSummary());
        orgCourse.setChargeType(course.getChargeType());
        if (isUpdate) {
            orgCourse.setCourseType(null);
        } else {
            Integer courseType = course.getCourseType();
            if (courseType == null) {
                courseType = CourseTypeEnum.COURSE_TYPE_CLASS.getCode();
            } else if (courseType > 2) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u7a0b\u7c7b\u578b\u53c2\u6570\u9519\u8bef");
            }
            Integer isCourse = null;
            Integer isClass = null;
            if (courseType == CourseTypeEnum.COURSE_TYPE_CLASS.getCode()) {
                isCourse = CourseTypeEnum.IS_COURSE_TRUE.getCode();
                isClass = CourseTypeEnum.IS_CLASS_TRUE.getCode();
            } else if (courseType == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                isCourse = CourseTypeEnum.IS_COURSE_TRUE.getCode();
                isClass = CourseTypeEnum.IS_CLASS_FALSE.getCode();
            } else {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u7a0b\u7c7b\u578b\u53c2\u6570\u9519\u8bef");
            }
            orgCourse.setCourseType(courseType);
            orgCourse.setIsCourse(isCourse);
            orgCourse.setIsClass(isClass);
        }
        log.debug("orgCourse={}", (Object)orgCourse);
        if (isUpdate) {
            this.orgCourseDao.update((Object)orgCourse, Boolean.valueOf(false), new String[0]);
            if (course.getIntroduction() == null) {
                this.orgCourseDao.update((Object)orgCourse, Boolean.valueOf(true), new String[]{"introduction"});
            }
        } else {
            this.orgCourseDao.save((Object)orgCourse, new String[0]);
        }
        OrgCourse newCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)orgCourse.getId(), new String[0]);
        Integer courseType = newCourse.getCourseType();
        if (isUpdate) {
            if (course.getConsumeRule() != null) {
                if (courseType == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && course.getConsumeRule() == CourseConsumeRuleEnum.TIME_0.getValue()) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "1\u5bf91\u8bfe\u4e0d\u652f\u6301\u5f53\u524d\u8bbe\u7f6e\u7684\u8bfe\u6d88\u89c4\u5219");
                }
                this.orgCourseConsumeRuleService.saveOfupdate(orgId, course.getCourseId(), course.getConsumeRule());
            }
        } else {
            Integer courseConsumeRuleValue = course.getConsumeRule();
            if (courseType == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && course.getConsumeRule() == CourseConsumeRuleEnum.TIME_0.getValue()) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "1\u5bf91\u8bfe\u4e0d\u652f\u6301\u5f53\u524d\u8bbe\u7f6e\u7684\u8bfe\u6d88\u89c4\u5219");
            }
            if (courseConsumeRuleValue == null) {
                TXCommonRule commonRule = this.tXCommonRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
                courseConsumeRuleValue = courseType == CourseTypeEnum.COURSE_TYPE_1v1.getCode() ? commonRule.getVipConsumeRule() : commonRule.getConsumeRule();
            }
            if (orgCourse.getId() != null && orgCourse.getId() > 0L) {
                this.orgCourseConsumeRuleService.create(orgId, orgCourse.getId(), courseConsumeRuleValue);
            }
        }
        if (orgCourse.getId() != null && orgCourse.getId() > 0L) {
            long number = SerialNumberUtil.generateNumber((int)orgCourse.getId().intValue(), (int)99999999, (int)4);
            orgCourse.setNumber(Long.valueOf(number));
            this.orgCourseDao.saveOrUpdate((Object)orgCourse, new String[]{"number"});
            if (StringUtils.isNotBlank((String)course.getTeacherIds())) {
                int delResult;
                List<Long> toDelTeacherIds;
                List teacherIds = null;
                try {
                    teacherIds = JacksonUtil.str2List((String)course.getTeacherIds(), Long.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "teacherIds \u53c2\u6570\u9519\u8bef\uff01");
                }
                log.debug("{},{}", (Object)teacherIds, (Object)course.getTeacherIds());
                List courseTeachers = this.orgCourseTeacherDao.getTeacherIdsByCourseId(orgCourse.getId());
                if (doDel && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)courseTeachers) && (toDelTeacherIds = this.findNeedDelTeacher(teacherIds, courseTeachers)).size() > 0 && (delResult = this.courseTeacherService.delTeacherFromCourseForLessonCheck(orgId, orgCourse.getId(), toDelTeacherIds)) == 0) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5df2\u7ecf\u6392\u8bfe\u7684\u8001\u5e08\u65e0\u6cd5\u5220\u9664");
                }
                teacherIds.removeAll(courseTeachers);
                this.courseTeacherService.addTeacherToCourse(orgId, orgCourse.getId(), teacherIds);
            }
            if (StringUtils.isNotBlank((String)course.getGroup())) {
                try {
                    List grpIds = JacksonUtil.str2List((String)course.getGroup(), Integer.class);
                    this.editGroupsOfCourse(orgId, orgCourse.getId(), grpIds);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    log.warn("{}", (Throwable)e);
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "group json format error!");
                }
            }
            if (course.getCoverStorageId() != null) {
                this.editCoursePhoto(orgCourse.getId(), course.getCoverStorageId().longValue());
            }
        } else {
            log.error("orgCourse={}", (Object)orgCourse);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "courseId illegal.");
        }
        return orgCourse.getId();
    }

    private List<Long> findNeedDelTeacher(List<Long> newTeacherList, List<Long> existingTeacherList) {
        ArrayList toDelTeacherIds = Lists.newArrayList(existingTeacherList);
        toDelTeacherIds.removeAll(newTeacherList);
        return toDelTeacherIds;
    }

    private List<Long> findNeedAddTeacher(List<Long> newTeacherList, List<Long> existingTeacherList) {
        ArrayList toAddTeacherIds = Lists.newArrayList(newTeacherList);
        toAddTeacherIds.removeAll(existingTeacherList);
        return toAddTeacherIds;
    }

    private void editCoursePhoto(Long courseId, Long storageId) {
        Preconditions.checkNotNull((Object)courseId);
        Preconditions.checkNotNull((Object)storageId);
        String coverUrl = this.getCoverUrl(storageId);
        OrgCoursePhoto photo = this.orgCoursePhotoDao.getLastAddPhoto(courseId);
        if (photo == null) {
            photo = new OrgCoursePhoto();
        }
        photo.setCreateTime(new Date());
        photo.setOrgCourseId(courseId);
        photo.setStorageId(storageId);
        photo.setUrl(coverUrl);
        photo.setCreateTime(new Date());
        this.orgCoursePhotoDao.saveOrUpdate((Object)photo, new String[0]);
    }

    private void editGroupsOfCourse(Long orgId, Long courseId, List<Integer> grpIds) {
        List orgGrpIds = this.orgCourseGroupDao.getOrgCourseGroupIdList(Integer.valueOf(orgId.intValue()));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgGrpIds) || grpIds == null || courseId == null) {
            return;
        }
        grpIds.retainAll(orgGrpIds);
        List existGrpIds = this.orgCourseGroupRelateDao.getGroupIdByCourseId(courseId, Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)existGrpIds)) {
            ArrayList toDelGrpIds = Lists.newArrayList((Iterable)existGrpIds);
            toDelGrpIds.removeAll(grpIds);
            this.orgCourseGroupRelateDao.deleteGroupOfCourse(courseId, (Collection)toDelGrpIds, Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        }
        for (Integer gid : grpIds) {
            OrgRecommendCourseRequestDto hotCourse = new OrgRecommendCourseRequestDto();
            hotCourse.setCourseId(courseId);
            hotCourse.setCourseType(CourseType.ORG_COURSE.getCode());
            this.orgCourseGroupRelateService.addCourse(gid, hotCourse, 0);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgCourseDetailResponseDto> getOrgCourseList(Long orgId, int status, PageDto pageDto) {
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        ArrayList data = Lists.newArrayList();
        if (account == null) {
            return data;
        }
        List courses = this.orgCourseDao.getAndFilterOrgCourse(account.getNumber(), null, CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null, pageDto);
        log.debug("orgId:{}, status:{}, courses:{}", new Object[]{orgId, status, courses});
        if (courses != null && !courses.isEmpty()) {
            Map<Long, Storage> storageCache = this.getAndCacheStorage(courses);
            List courseIds = com.baijia.tianxiao.util.BaseUtils.getListFilter((List)courses, (String)"id");
            Map<Long, List<String>> teacherCache = this.getCourseIdTeacherNamesMap(courseIds);
            OrgCourseDetailResponseDto dto = null;
            String host = PropertiesReader.getValue((String)"wxm", (String)"m.server");
            String imgServer = PropertiesReader.getValue((String)"wxm", (String)"img.server");
            for (OrgCourse course : courses) {
                log.info("[orgCourse] is : {} ", (Object)course);
                dto = new OrgCourseDetailResponseDto();
                dto.setName(course.getName());
                dto.setNumber(course.getNumber());
                dto.setPrice("" + course.getPrice());
                dto.setCourseId(course.getId());
                dto.setCourseType(this.getCourseType(course.getCourseType()));
                if (teacherCache.containsKey(course.getId())) {
                    dto.setTeacherName(teacherCache.get(course.getId()).get(0));
                } else {
                    dto.setTeacherName("\u5f85\u5b9a");
                }
                dto.setPreface(this.getImgUrl(course.getCover() == null ? 0L : course.getCover().longValue(), storageCache, imgServer));
                dto.setLink("{host}/course/detail/{number}".replace("{host}", host).replace("{number}", course.getNumber().toString()));
                data.add(dto);
            }
        }
        log.info("getOrgCourseList.orgId:{}, status:{}, pageDto:{}, data:{}", new Object[]{orgId, status, pageDto, data});
        return data;
    }

    private Integer getCourseType(Integer courseType) {
        switch (courseType) {
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
        }
        return 4;
    }

    private Map<Long, Storage> getAndCacheStorage(List<OrgCourse> courses) {
        List storageIds = com.baijia.tianxiao.util.BaseUtils.getListFilter(courses, (String)"cover");
        Map cache = this.storageDao.getStorageMapByIds((Collection)storageIds);
        log.debug("storageIds:{}, cache:{}", (Object)storageIds, (Object)cache);
        return cache;
    }

    private String getImgUrl(Long storageId, Map<Long, Storage> cache, String imgServer) {
        Storage storage;
        String url = "";
        if (cache.containsKey(storageId) && (storage = cache.get(storageId)) != null) {
            url = this.constructUrl(storage, imgServer);
        }
        return url;
    }

    public String constructUrl(Storage storage, String imgServer) {
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = "";
        if (StringUtils.isNotBlank((String)storage.getMimetype())) {
            surfix = storage.getMimetype().contains("/") ? storage.getMimetype().split("/")[1] : storage.getMimetype();
        }
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    @Override
    @Transactional(readOnly=true)
    public OrgCourseDetailResponseDto getOrgCourseDetail(Long orgId, Long courseId) {
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        OrgCourseDetailResponseDto dto = null;
        if (course != null) {
            String host = PropertiesReader.getValue((String)"wxm", (String)"m.server");
            String imgServer = PropertiesReader.getValue((String)"wxm", (String)"img.server");
            ArrayList ids = Lists.newArrayList((Object[])new Long[]{course.getId()});
            Map<Long, List<String>> cache = this.getCourseIdTeacherNamesMap(ids);
            dto = new OrgCourseDetailResponseDto();
            dto.setCourseType(CourseType.CLASS.getCode());
            dto.setName(course.getName());
            dto.setNumber(course.getNumber());
            dto.setPrice("" + course.getPrice());
            if (cache.containsKey(course.getId())) {
                dto.setTeacherName(cache.get(course.getId()).get(0));
            } else {
                dto.setTeacherName("\u5f85\u5b9a");
            }
            if (course.getCover() != null) {
                Storage storage = (Storage)this.storageDao.getById((Serializable)course.getCover(), new String[0]);
                if (storage != null) {
                    dto.setPreface(this.constructUrl(storage, imgServer));
                } else {
                    dto.setPreface("http://img.gsxservice.com/24205893_bptrogck.png");
                }
            } else {
                dto.setPreface("http://img.gsxservice.com/24205893_bptrogck.png");
            }
            dto.setLink("{host}/course/{number}".replace("{host}", host).replace("{number}", course.getNumber().toString()));
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrEditOrgTimeSpan(Long orgId, List<OrgTimeSpanDto> timeSpanList) {
        log.info("timeSpanList = {}", timeSpanList);
        for (OrgTimeSpanDto dto : timeSpanList) {
            if (!OrgCourseServiceImpl.checkTime(dto.getStartTime(), dto.getEndTime())) {
                return;
            }
            OrgTimeSpan orgTimeSpan = new OrgTimeSpan();
            Time endTime = Time.valueOf(dto.getEndTime());
            Time startTime = Time.valueOf(dto.getStartTime());
            orgTimeSpan.setStartTime(startTime);
            orgTimeSpan.setEndTime(endTime);
            orgTimeSpan.setOrgId(orgId);
            if (dto.getId() == null || dto.getId() == 0L) {
                orgTimeSpan.setId(null);
            } else {
                orgTimeSpan.setId(dto.getId());
            }
            this.orgTimeSpanDao.saveOrUpdate((Object)orgTimeSpan, new String[0]);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgTimeSpanDto> listOrgTimeSpan(Long orgId) {
        List list = this.orgTimeSpanDao.listOrgTimeSpan(orgId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        ArrayList dtos = Lists.newArrayList();
        for (OrgTimeSpan span : list) {
            OrgTimeSpanDto dto = new OrgTimeSpanDto();
            dto.setId(span.getId());
            dto.setStartTime(this.buildTimeStr(span.getStartTime()));
            dto.setEndTime(this.buildTimeStr(span.getEndTime()));
            dtos.add(dto);
        }
        return dtos;
    }

    private String buildTimeStr(Date time) {
        String str = DateUtil.getStrByDateFormate((Date)time, (String)"HH:mm:ss");
        if (str.equals("00:00:00")) {
            str = "24:00:00";
        }
        return str;
    }

    @Override
    public void deleteOrgTimeSpan(@NonNull Collection<Long> ids) {
        if (ids == null) {
            throw new NullPointerException("ids");
        }
        this.orgTimeSpanDao.delByIds(ids);
    }

    @Override
    @Transactional(readOnly=true)
    public CourseListReponseDto getOrgBasicCourseInfo(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is not null!");
        Preconditions.checkArgument((courseId != null ? 1 : 0) != 0, (Object)"courseId is not null!");
        OrgCourse course = this.orgCourseDao.getByCourseId(courseId, new String[0]);
        CourseListReponseDto dto = new CourseListReponseDto();
        dto.setCourseName(course.getName());
        dto.setOrgCourseId(course.getId());
        dto.setOrgCourseNumber(course.getNumber());
        dto.setCoverUrl(this.getCoverUrl(course));
        return dto;
    }

    private String getCoverUrl(OrgCourse course) {
        if (course == null || course.getCover() == null) {
            return "";
        }
        return this.getCoverUrl(course.getCover().longValue());
    }

    private String getCoverUrl(Long storageId) {
        if (storageId == null) {
            return "http://img.gsxservice.com/24489340_jifl3uig.png";
        }
        Storage storage = (Storage)this.storageDao.getById((Serializable)storageId, new String[0]);
        if (storage == null) {
            return "";
        }
        if (StringUtils.isNotBlank((String)storage.getAttach_url())) {
            return storage.getAttach_url();
        }
        return StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Object> buildLessonInfo(Long orgId, Long lessonId, Long studentId) {
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"student not exists!");
        log.debug("orgId = {}, lessonId{}, studentId ={}, userId={}", new Object[]{orgId, lessonId, studentId, userId});
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        Preconditions.checkArgument((lesson != null ? 1 : 0) != 0, (Object)"lesson not exist!");
        OrgCourse course = this.orgCourseDao.getByCourseId(lesson.getCourseId(), new String[0]);
        HashMap map = Maps.newHashMap();
        map.put("index", lesson.getNumber());
        map.put("startTime", lesson.getStartTime());
        map.put("endTime", lesson.getEndTime());
        map.put("courseName", course.getName());
        Map lessonTeacherMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{lessonId}));
        log.debug("lessonTeacherMap = {}", (Object)lessonTeacherMap);
        Long teacherId = (Long)lessonTeacherMap.get(lessonId);
        if (teacherId == null) {
            log.warn("lessonid = {}, teacherId ={}", (Object)lessonId, (Object)teacherId);
            map.put("teacherName", "");
            map.put("avatarUrl", "");
            map.put("teacherId", 0);
            return map;
        }
        Teacher teacher = this.teacherDao.getByUserId(teacherId, new String[0]);
        if (teacher != null) {
            map.put("teacherName", teacher.getRealName() != null ? teacher.getRealName() : teacher.getNickName());
            map.put("teacherId", teacher.getUserId());
            if (teacher.getAvatar() != null) {
                Storage storage = (Storage)this.storageDao.getById((Serializable)teacher.getAvatar(), new String[0]);
                if (storage != null) {
                    map.put("avatarUrl", StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
                }
            } else {
                log.warn("\u8001\u5e08\u5934\u50cf\u4e0d\u5b58\u5728!");
            }
        } else {
            log.warn("lessonid = {}, teacherId ={}", (Object)lessonId, (Object)teacherId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8001\u5e08\u4e0d\u5b58\u5728");
        }
        return map;
    }

    @Override
    public OrgCourseInfoDto getOrgCourseInfo(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"illegal courseId");
        OrgCourseInfoDto orgCourseInfoDto = new OrgCourseInfoDto();
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"areaId"});
        Area area = (Area)this.areaDao.getById((Serializable)orgInfo.getAreaId(), new String[]{"name", "bname"});
        orgCourseInfoDto.setCityName(area.getBname());
        OrgCourse course = null;
        if (courseId != null && courseId > 0L && (course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0])) != null) {
            log.debug("---------------getNumber={},getCourseType={}", (Object)course.getNumber(), (Object)course.getCourseType());
            if (course.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS.getCode()) {
                List studentIds = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
                orgCourseInfoDto.setStudentNum(studentIds.size());
            } else {
                List classIds = this.orgCourseDao.getClassIdsByParentId(courseId);
                List list = this.orgStudentCourseDao.getStudentIdsByCourseIds(orgId, (Collection)classIds);
                orgCourseInfoDto.setStudentNum(list.size());
            }
            orgCourseInfoDto.setCourseType(course.getCourseType());
            orgCourseInfoDto.setCourseNumber(course.getNumber());
            orgCourseInfoDto.setCourseId(courseId);
            orgCourseInfoDto.setCourseName(course.getName());
            orgCourseInfoDto.setCoursePrice(course.getPrice());
            orgCourseInfoDto.setCoursePriceStr(NumberUtil.get2FromDouble((double)course.getPrice()));
            orgCourseInfoDto.setLessonSummary(course.getLessonSummary());
            String courseUrl = this.environment.getProperty("org_class_course.url");
            orgCourseInfoDto.setCourseUrl(String.valueOf(courseUrl) + course.getNumber());
            orgCourseInfoDto.setMaxStudent(course.getMaxStudent());
            orgCourseInfoDto.setCoverStorageId(course.getCover());
            orgCourseInfoDto.setAddress(course.getAddress());
            orgCourseInfoDto.setStartTime(course.getBeginTime());
            orgCourseInfoDto.setEndTime(course.getEndTime());
            orgCourseInfoDto.setFreq(course.getFreq());
            String intro = com.baijia.tianxiao.util.BaseUtils.blobToString((Blob)course.getIntroduction(), (String)"UTF-8");
            orgCourseInfoDto.setIntroduction(intro);
            orgCourseInfoDto.setStatus(course.getStatus());
            orgCourseInfoDto.setIsDel(course.getIsDel());
            Integer consumeRule = this.orgCourseConsumeRuleService.getRuleValueByCourseId(orgId, course);
            orgCourseInfoDto.setConsumeRule(consumeRule);
            orgCourseInfoDto.setConsumeRuleStr(CourseConsumeRuleEnum.getRuleDescByValue(consumeRule));
            if (StringUtils.isNotBlank((String)course.getOfflinePoi())) {
                String[] lnglat = course.getOfflinePoi().split(",");
                log.debug("latlng={},len={}", (Object)lnglat, (Object)lnglat.length);
                if (lnglat != null && lnglat.length >= 2) {
                    String lng = lnglat[0];
                    String lat = lnglat[1];
                    try {
                        orgCourseInfoDto.setLat(Double.parseDouble(lat));
                        orgCourseInfoDto.setLng(Double.parseDouble(lng));
                    }
                    catch (NumberFormatException e) {
                        log.warn("lat={},lng={}", (Object)lat, (Object)lng);
                    }
                }
            }
            orgCourseInfoDto.setCoverUrl(this.getCoverUrl(course));
            orgCourseInfoDto.setTeachers(this.courseTeacherService.listCourseTeacher(orgId, courseId));
            List<OrgCourseGroupDto> groups = this.orgCourseGroupService.getByCourseId(orgId, courseId);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(groups)) {
                orgCourseInfoDto.setGroups(groups);
            }
            List teacherIds = this.orgCourseTeacherDao.getTeacherIdsByCourseId(courseId);
            log.debug("------------------teacherIds={}", (Object)teacherIds);
            List teachers = this.teacherDao.getByUserIds((Collection)teacherIds, new String[0]);
            Map teacherMap = Maps.newHashMap();
            if (teacherIds != null && teacherIds.size() > 0) {
                teacherMap = CollectorUtil.collectMap((Collection)teachers, (Function)new Function<Teacher, Long>(){

                    public Long apply(Teacher input) {
                        return input.getUserId();
                    }
                });
            }
            ArrayList userIds = Lists.newArrayList();
            for (Teacher t : teachers) {
                userIds.add(t.getUserId());
            }
            List users = this.userDao.queryByUserIds((Collection)userIds, new String[0]);
            Map teacherNumberMap = CollectorUtil.collectMap((Collection)users, (Function)new Function<User, Long>(){

                public Long apply(User u) {
                    return u.getId();
                }
            });
            Map storageIds = CollectorUtil.collectMap((Collection)teachers, (Function)new Function<Teacher, Long>(){

                public Long apply(Teacher teacher) {
                    return teacher.getAvatar();
                }
            });
            List storages = this.storageDao.getByIds(storageIds.keySet(), new String[0]);
            Map storageMap = CollectorUtil.collectMap((Collection)storages, (Function)new Function<Storage, Long>(){

                public Long apply(Storage storage) {
                    return storage.getId();
                }
            });
            ArrayList list = Lists.newArrayList();
            for (Long l : teacherIds) {
                Storage storage;
                TeacherResponseDto dto = new TeacherResponseDto();
                Teacher teacher = (Teacher)teacherMap.get(l);
                if (teacher.getOrgId() == null || teacher.getOrgId().longValue() != orgId.longValue()) continue;
                if (teacher.getAvatar() != null && (storage = (Storage)storageMap.get(teacher.getAvatar())) != null) {
                    String avatarUrl = StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
                    dto.setAvatar(avatarUrl);
                }
                dto.setBranchId(teacher.getBranchId());
                dto.setMobile(teacher.getMobile());
                dto.setSchoolAge(teacher.getSchoolAge());
                dto.setTeacherId(teacher.getUserId());
                dto.setTeacherName(teacher.getRealName());
                dto.setTeacherNumber(((User)teacherNumberMap.get(l)).getNumber());
                list.add(dto);
            }
            orgCourseInfoDto.setTeachers(list);
            HashSet set = Sets.newHashSet();
            set.add(courseId);
            Map map = this.orgClassLessonDao.getLessonCount(orgId, (Collection)set, Integer.valueOf(0));
            int hasPlan = 0;
            if (map.get(courseId) != null) {
                hasPlan = (Integer)map.get(courseId);
            }
            orgCourseInfoDto.setHasPlan(hasPlan);
            Date date = course.getBeginTime();
            if (date != null) {
                orgCourseInfoDto.setStartDay(DateUtil.getStrByDateFormate((Date)date, (String)"yyyy\u5e74MM\u6708dd\u65e5"));
                orgCourseInfoDto.setStartWeek("\u661f\u671f" + DateUtil.getChineseWeekDay((Date)date));
            } else {
                List ll = this.orgClassLessonDao.getLessons((Collection)set, null, orgId, Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[0]);
                if (ll != null && ll.size() > 0) {
                    OrgClassLesson o = (OrgClassLesson)ll.get(0);
                    orgCourseInfoDto.setStartDay(DateUtil.getStrByDateFormate((Date)o.getStartTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
                    orgCourseInfoDto.setStartWeek("\u661f\u671f" + DateUtil.getChineseWeekDay((Date)o.getStartTime()));
                } else {
                    orgCourseInfoDto.setStartDay("");
                    orgCourseInfoDto.setStartWeek("");
                }
            }
            orgCourseInfoDto.setIsCourse(course.getIsCourse());
            orgCourseInfoDto.setChargeType(course.getChargeType());
        }
        return orgCourseInfoDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOrgCourses(Long orgId, Collection<Long> courseIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId!");
        if (org.apache.commons.collections.CollectionUtils.isEmpty(courseIds)) {
            return;
        }
        Long orgNumber = this.getOrgNumber(orgId);
        Preconditions.checkArgument((orgNumber != null && orgNumber > 0L ? 1 : 0) != 0, (Object)"illegal orgNumber!");
        List studentCourseList = this.orgStudentCourseDao.getOrgCourseByOrgIdAndIds(orgId, courseIds);
        HashSet studentUserId = Sets.newHashSet();
        for (OrgStudentCourse studentCourse : studentCourseList) {
            studentUserId.add(studentCourse.getUserId());
        }
        List effectOrgStudentList = this.orgStudentDao.getStudentByUserIds(orgId, (Collection)studentUserId, new String[0]);
        if (effectOrgStudentList.size() > 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5220\u9664\u8bfe\u7a0b\u524d\u8bf7\u5148\u5c06\u73ed\u5185\u5b66\u5458\u9000\u73ed");
        }
        HashMap updateCondtion = Maps.newHashMap();
        updateCondtion.put("id", courseIds);
        updateCondtion.put("orgNumber", orgNumber);
        OrgCourse orgCourse = new OrgCourse();
        orgCourse.setIsDel(Integer.valueOf(1));
        this.orgCourseDao.update((Map)updateCondtion, (Object)orgCourse, new String[]{"isDel"});
        HashMap set = Maps.newHashMap();
        set.put("del_status", DataStatus.DELETE.getValue());
        for (Long courseId : courseIds) {
            List list = this.orgClassLessonDao.getLessonByCourseIds(Arrays.asList(courseId));
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) continue;
            try {
                HashMap map = Maps.newHashMap();
                map.put("lesson_id", com.baijia.tianxiao.util.BaseUtils.getPropertiesList((List)list, (String)"id"));
                this.orgLessonConflictDao.delByCondition((Map)map);
            }
            catch (Exception e) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, e.getMessage());
            }
        }
    }

    void cascadeDeleteCourseLessons(Long orgId, Collection<Long> courseIds) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(courseIds)) {
            this.orgClassLessonDao.deleteByCourseIds(orgId, courseIds);
        }
    }

    @Override
    public void batchUpdateStatus(Long orgId, Collection<Long> courseIds, Integer status) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId!");
        if (org.apache.commons.collections.CollectionUtils.isEmpty(courseIds)) {
            return;
        }
        Long orgNumber = this.getOrgNumber(orgId);
        Preconditions.checkArgument((orgNumber != null && orgNumber > 0L ? 1 : 0) != 0, (Object)"illegal orgNumber!");
        HashMap updateCondtion = Maps.newHashMap();
        updateCondtion.put("id", courseIds);
        updateCondtion.put("orgNumber", orgNumber);
        OrgCourse orgCourse = new OrgCourse();
        orgCourse.setStatus(status);
        this.orgCourseDao.update((Map)updateCondtion, (Object)orgCourse, new String[]{"status"});
    }

    @Override
    public void repairNumber() {
        log.info("repairNumber");
        this.orgCourseDao.repairNumber();
    }

    @Override
    public OrgCourseDetailResponseDto getOrgCourseDetailByNumber(Long orgNumber, Long courseNumber) {
        OrgCourse course = this.orgCourseDao.getByCourseNumber(courseNumber, new String[0]);
        log.debug("-----------courseNumber={},courseType={}", (Object)courseNumber, (Object)course.getCourseType());
        OrgCourseDetailResponseDto dto = null;
        if (course != null && course.getOrgNumber().equals(orgNumber)) {
            String host = PropertiesReader.getValue((String)"wxm", (String)"m.server");
            String imgServer = PropertiesReader.getValue((String)"wxm", (String)"img.server");
            ArrayList ids = Lists.newArrayList((Object[])new Long[]{course.getId()});
            Map<Long, List<String>> cache = this.getCourseIdTeacherNamesMap(ids);
            dto = new OrgCourseDetailResponseDto();
            dto.setCourseId(course.getId());
            dto.setCourseType(course.getCourseType());
            dto.setName(course.getName());
            dto.setNumber(course.getNumber());
            dto.setPrice("" + course.getPrice());
            if (cache.containsKey(course.getId())) {
                dto.setTeacherName(cache.get(course.getId()).get(0));
            } else {
                dto.setTeacherName("\u5f85\u5b9a");
            }
            if (course.getCover() != null) {
                dto.setPreface(this.getCoverUrl(course.getCover().longValue()));
            }
            dto.setLink("{host}/course/{number}".replace("{host}", host).replace("{number}", course.getNumber().toString()));
        }
        return dto;
    }

    @Override
    public List<OrgCourse> getAllOrgCourses(@NonNull Long orgId, String key) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        Long orgNumber = this.getOrgNumber(orgId);
        if (orgNumber == null) {
            log.error("orgNumber = {}", (Object)orgNumber);
            return Lists.newArrayList();
        }
        log.info("getOrgCourses orgNumber {}", (Object)orgNumber);
        List orgCourses = this.orgCourseDao.getCoursesByOrgNumberAndName(orgNumber, key, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null, null);
        return orgCourses;
    }

    @Override
    public List<OrgCourse> getAllOrgCoursesByNames(@NonNull Long orgId, List<String> courseNames) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        Long orgNumber = this.getOrgNumber(orgId);
        if (orgNumber == null) {
            log.error("orgNumber = {}", (Object)orgNumber);
            return Lists.newArrayList();
        }
        log.info("getOrgCourses orgNumber {}", (Object)orgNumber);
        List orgCourses = this.orgCourseDao.getCoursesByOrgNumberAndNames(orgNumber, courseNames, null, CourseTypeEnum.IS_COURSE_TRUE.getCode(), CourseTypeEnum.IS_CLASS_TRUE.getCode(), CourseTypeEnum.COURSE_TYPE_CLASS.getCode(), null);
        return orgCourses;
    }

    @Override
    public List<OrgCourse> getAll1V1CoursesByNames(@NonNull Long orgId, List<String> courseNames) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        Long orgNumber = this.getOrgNumber(orgId);
        if (orgNumber == null) {
            log.error("orgNumber = {}", (Object)orgNumber);
            return Lists.newArrayList();
        }
        log.info("getOrgCourses orgNumber {}", (Object)orgNumber);
        List orgCourses = this.orgCourseDao.getCoursesByOrgNumberAndNames(orgNumber, courseNames, null, CourseTypeEnum.IS_COURSE_TRUE.getCode(), CourseTypeEnum.IS_CLASS_FALSE.getCode(), CourseTypeEnum.COURSE_TYPE_1v1.getCode(), null);
        return orgCourses;
    }

    @Override
    public List<OrgClassLessonDto> getOrgClassLessonDtoList(Long orgId, Long id) {
        HashSet set = Sets.newHashSet();
        set.add(id);
        List orgClassLesson = this.orgClassLessonDao.getLessons((Collection)set, null, orgId, Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[0]);
        List<OrgClassLessonDto> classDetail = this.buildOrgClassLessonDto(orgClassLesson);
        return classDetail;
    }

    private List<OrgClassLessonDto> buildOrgClassLessonDto(List<OrgClassLesson> orgClassLesson) {
        ArrayList list = Lists.newArrayList();
        for (OrgClassLesson o : orgClassLesson) {
            OrgClassLessonDto dto = new OrgClassLessonDto();
            dto.setNumber(o.getNumber());
            Date startTime = o.getStartTime();
            Date endTime = o.getEndTime();
            dto.setDate(DateUtil.getStrByDateFormate((Date)startTime, (String)"MM\u6708dd\u65e5"));
            dto.setStartTime(DateUtil.getStrByDateFormate((Date)startTime, (String)"HH:mm"));
            dto.setEndTime(DateUtil.getStrByDateFormate((Date)endTime, (String)"HH:mm"));
            dto.setWeek("\u5468" + DateUtil.getChineseWeekDay((Date)startTime));
            list.add(dto);
        }
        return list;
    }

    @Override
    public List<Long> getCourseNumberByOrg(@NonNull Long orgNumber) {
        if (orgNumber == null) {
            throw new NullPointerException("orgNumber");
        }
        return this.orgCourseDao.getCourseNumberByOrg(orgNumber, null, null, null);
    }

    @Override
    public Map<String, OrgCourse> getAllOrgCoursesMapByNames_class(Long orgId, List<String> courseNames) {
        Long orgNumber = this.getOrgNumber(orgId);
        HashMap data = Maps.newHashMap();
        if (orgNumber == null) {
            log.error("orgNumber = {}", (Object)orgNumber);
            return data;
        }
        log.info("getOrgCourses orgNumber {}", (Object)orgNumber);
        List orgCourses = this.orgCourseDao.getCoursesByOrgNumberAndNames(orgNumber, courseNames, null, CourseTypeEnum.IS_COURSE_TRUE.getCode(), CourseTypeEnum.IS_CLASS_TRUE.getCode(), CourseTypeEnum.COURSE_TYPE_CLASS.getCode(), null);
        int i = 0;
        while (i < orgCourses.size() - 1) {
            int j = orgCourses.size() - 1;
            while (j > i) {
                String namei;
                String namej = ((OrgCourse)orgCourses.get(j)).getName();
                if (namej.equals(namei = ((OrgCourse)orgCourses.get(i)).getName())) {
                    orgCourses.remove(j);
                }
                --j;
            }
            ++i;
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgCourses)) {
            for (OrgCourse orgCourse : orgCourses) {
                data.put(orgCourse.getName(), orgCourse);
            }
        }
        return data;
    }

    @Override
    public Map<String, OrgCourse> getAllOrgCoursesMapByNames(Long orgId, List<String> courseNames) {
        Long orgNumber = this.getOrgNumber(orgId);
        HashMap data = Maps.newHashMap();
        if (orgNumber == null) {
            log.error("orgNumber = {}", (Object)orgNumber);
            return data;
        }
        log.info("getOrgCourses orgNumber {}", (Object)orgNumber);
        List orgCourses = this.orgCourseDao.getCoursesByOrgNumberAndNames(orgNumber, courseNames, null, CourseTypeEnum.IS_COURSE_TRUE.getCode(), CourseTypeEnum.IS_CLASS_FALSE.getCode(), CourseTypeEnum.COURSE_TYPE_1v1.getCode(), null);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgCourses)) {
            for (OrgCourse orgCourse : orgCourses) {
                data.put(orgCourse.getName(), orgCourse);
            }
        }
        return data;
    }

    @Override
    public void saveOrgCourse(OrgCourse orgCourse) {
        this.orgCourseDao.save((Object)orgCourse, new String[0]);
    }

    @Override
    public List<CourseDto> selectCourse(Long orgId, List<Long> teacherIds, List<Long> classRoomIds, Integer type) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u975e\u6cd5");
        List confictLessonIds = Lists.newArrayList();
        if (type == 1) {
            List confictLessons = this.orgLessonConflictDao.queryConfilctByTeacherIds(orgId, teacherIds);
            confictLessonIds = BaseUtils.getPropertyCollections((List)confictLessons, (String)"lessonIds");
        }
        List teacherLessonIds = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(teacherIds)) {
            List orgTeacherLessons = this.orgTeacherLessonDao.queryTeacherLessons(orgId, teacherIds, new String[0]);
            teacherLessonIds = BaseUtils.getPropertyCollections((List)orgTeacherLessons, (String)"lessonIds");
        }
        List orgClassLessons = this.orgClassLessonDao.queryForSelectCourse(orgId, classRoomIds, confictLessonIds, teacherLessonIds);
        List courseIds = BaseUtils.getPropertyCollections((List)orgClassLessons, (String)"courseId");
        List orgCourses = this.orgCourseDao.getByIds((Collection)courseIds, new String[0]);
        return CourseDto.converToDto(orgCourses);
    }

    @Override
    public ArrayListMultimap<Long, Long> getCourseClassIdMap(Long orgId, List<Long> parentIds) {
        Long orgNumber = this.getOrgNumber(orgId);
        List orgCourses = this.orgCourseDao.getCoursesByParentIds(orgNumber, parentIds);
        ArrayListMultimap data = ArrayListMultimap.create();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgCourses)) {
            for (OrgCourse orgCourse : orgCourses) {
                data.put((Object)orgCourse.getParentId(), (Object)orgCourse.getId());
            }
        }
        return data;
    }

    @Override
    public int getAllCourseNumberByOrg(@NonNull Long orgNumber) {
        if (orgNumber == null) {
            throw new NullPointerException("orgNumber");
        }
        return this.orgCourseDao.getAllCourseCountByOrg(orgNumber);
    }
}

