/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sal.course.dto.SigninMsgAsynModel;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.course.service.SendSigninMsgService;
import com.baijia.tianxiao.util.CollectorUtil;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service(value="SendSigninMsgService")
public class SendSigninMsgServiceImpl
implements SendSigninMsgService {
    private static final Logger log = LoggerFactory.getLogger(SendSigninMsgServiceImpl.class);
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgLessonSignService orgLessonSignService;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Autowired
    private StringRedisTemplate redisTemplate;

    @Override
    @Scheduled(cron="0 0/1 * * * ?")
    public void sendSignInMessageTask() {
        this.getOldAndResetNew();
    }

    private void getOldAndResetNew() {
        Map<String, OrgLessonSign> readySendSignInMap = SigninMsgAsynModel.getOldAndResetNew();
        int size = readySendSignInMap.size();
        log.info("sendSignInMessageTask start ,find " + size + " singIn record change");
        if (size == 0) {
            return;
        }
        HashSet lessonIds = Sets.newHashSet();
        HashSet courseIds = Sets.newHashSet();
        HashSet orgIds = Sets.newHashSet();
        HashSet longOrgIds = Sets.newHashSet();
        HashSet studentUserIds = Sets.newHashSet();
        HashMap lessonTeacherIdMap = Maps.newHashMap();
        HashMap teacherIdNameMap = Maps.newHashMap();
        HashMap lessonMap = Maps.newHashMap();
        Map orgInfoMap = Maps.newHashMap();
        HashMap lessonSignInMap = Maps.newHashMap();
        for (OrgLessonSign orgLessonSign : readySendSignInMap.values()) {
            lessonIds.add(orgLessonSign.getLessonId());
            courseIds.add(orgLessonSign.getCourseId());
            orgIds.add(orgLessonSign.getOrgId().intValue());
            longOrgIds.add(orgLessonSign.getOrgId());
            studentUserIds.add(orgLessonSign.getUserId());
            List tempLessonSignInList = (List)lessonSignInMap.get(orgLessonSign.getLessonId());
            if (tempLessonSignInList == null) {
                tempLessonSignInList = Lists.newArrayList();
                lessonSignInMap.put(orgLessonSign.getLessonId(), tempLessonSignInList);
            }
            tempLessonSignInList.add(orgLessonSign);
        }
        Map<String, OrgStudent> studentInfos = this.getStudentInfos(longOrgIds, studentUserIds);
        Map<Long, OrgCourse> courseInfos = this.getCourseInfos(courseIds);
        List lessons = this.orgClassLessonDao.getByIds((Collection)lessonIds, new String[0]);
        for (OrgClassLesson lesson : lessons) {
            lessonMap.put(lesson.getId(), lesson);
        }
        Map orgTeacherLessonMap = this.orgTeacherLessonDao.getOrgTeacherLessonMapByLessonIds((Collection)lessonIds);
        HashSet teacherIds = Sets.newHashSet();
        for (Long lessonId : lessonIds) {
            OrgTeacherLesson orgTeacherLesson = (OrgTeacherLesson)orgTeacherLessonMap.get(lessonId);
            if (orgTeacherLesson == null) continue;
            teacherIds.add(orgTeacherLesson.getTeacherId());
            lessonTeacherIdMap.put(lessonId, orgTeacherLesson.getTeacherId());
        }
        List teacherList = this.teacherDao.getByUserIds((Collection)teacherIds, new String[0]);
        for (Teacher teacher : teacherList) {
            teacherIdNameMap.put(teacher.getUserId(), teacher);
        }
        List orgInfos = this.orgInfoDao.getOrgInfos((Collection)orgIds, new String[0]);
        orgInfoMap = CollectorUtil.collectMap((Collection)orgInfos, (Function)new Function<OrgInfo, Long>(){

            public Long apply(OrgInfo arg0) {
                return arg0.getOrgId().longValue();
            }
        });
        log.info("sendSignInMessageTask start orgInfos={}", (Object)orgInfos);
        log.info("sendSignInMessageTask start teacherList={}", (Object)teacherList);
        log.info("sendSignInMessageTask start lessons={}", (Object)lessons);
        log.info("sendSignInMessageTask start courseInfos={}", courseInfos);
        log.info("sendSignInMessageTask start studentInfos={}", studentInfos);
        for (Long lessonId : lessonIds) {
            List tempLessonSignInList = (List)lessonSignInMap.get(lessonId);
            log.info("lesson signin message lesson id={},signInList={}", (Object)lessonId, (Object)tempLessonSignInList);
            OrgClassLesson lesson = (OrgClassLesson)lessonMap.get(lessonId);
            if (lesson == null) {
                log.info("lesson signin message send fail ,OrgClassLesson  null");
                continue;
            }
            OrgCourse course = courseInfos.get(lesson.getCourseId());
            if (course == null) {
                log.info("lesson signin message send fail ,course  null");
                continue;
            }
            OrgInfo orgInfo = (OrgInfo)orgInfoMap.get(lesson.getOrgId());
            if (orgInfo == null) {
                log.info("lesson signin message send fail ,orgInfo null");
                continue;
            }
            Teacher teacher = null;
            Long teacherId = (Long)lessonTeacherIdMap.get(lessonId);
            if (teacherId != null) {
                teacher = (Teacher)teacherIdNameMap.get(teacherId);
            }
            for (OrgLessonSign orgLessonSign : tempLessonSignInList) {
                OrgStudent student = studentInfos.get(String.valueOf(orgInfo.getOrgId()) + String.valueOf('|') + String.valueOf(orgLessonSign.getUserId()));
                if (student == null) {
                    log.info("lesson signin message send fail ,student  null");
                    continue;
                }
                if (!this.checkKeyValueMatch(orgLessonSign)) continue;
                this.orgLessonSignService.signSendMsg(orgInfo, student, teacher, lesson, course, orgLessonSign.getStatus());
            }
        }
    }

    private Map<String, OrgStudent> getStudentInfos(Collection<Long> orgIds, Collection<Long> userIds) {
        List students = this.orgStudentDao.getStudentsByUserIdsAndOrgIds(orgIds, userIds);
        return CollectorUtil.collectMap((Collection)students, (Function)new Function<OrgStudent, String>(){

            public String apply(OrgStudent arg0) {
                return String.valueOf(arg0.getOrgId()) + String.valueOf('|') + String.valueOf(arg0.getUserId());
            }
        });
    }

    private Map<Long, OrgCourse> getCourseInfos(Collection<Long> courseIds) {
        List courses = this.orgCourseDao.getByIds(courseIds, new String[0]);
        return CollectorUtil.collectMap((Collection)courses, (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse arg0) {
                return arg0.getId();
            }
        });
    }

    private boolean checkKeyValueMatch(OrgLessonSign orgLessonSign) {
        final String cacheKey = "siginMsg_" + orgLessonSign.getUserId() + "|" + orgLessonSign.getLessonId();
        Object result = this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                String olduuid = (String)SendSigninMsgServiceImpl.this.redisTemplate.getStringSerializer().deserialize(connection.get(cacheKey.getBytes()));
                return olduuid;
            }
        });
        if (result != null && result instanceof String) {
            String olduuid = (String)result;
            return StringUtils.equals((CharSequence)orgLessonSign.getRandomUUID(), (CharSequence)olduuid);
        }
        return false;
    }
}

