/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="orgCourseConsumeRuleService")
public class OrgCourseConsumeRuleServiceImpl
implements OrgCourseConsumeRuleService {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseConsumeRuleServiceImpl.class);
    @Resource
    private OrgCourseConsumeRuleDao orgCourseConsumeRuleDao;
    @Resource
    private TXCommonRuleService tXCommonRuleService;

    @Override
    public Map<Long, Integer> queryCourseRuleMapByCourseIds(Long orgId, Collection<Long> courseIds) {
        Map courseConsumeRuleMap = this.orgCourseConsumeRuleDao.queryCourseRuleMapByCourseIds(orgId, courseIds);
        for (Long courseId : courseIds) {
            courseConsumeRuleMap.put(courseId, 0);
        }
        return courseConsumeRuleMap;
    }

    @Override
    public Integer getRuleValueByCourseId(Long orgId, Long courseId) {
        return this.orgCourseConsumeRuleDao.getRuleValueByCourseId(orgId, courseId);
    }

    @Override
    public void create(Long orgId, Long courseId, Integer ruleValue) {
        OrgCourseConsumeRule rule = new OrgCourseConsumeRule();
        rule.setOrgId(orgId);
        rule.setCourseId(courseId);
        rule.setRuleValue(ruleValue);
        Date now = new Date();
        rule.setCreateTime(now);
        rule.setUpdateTime(now);
        this.orgCourseConsumeRuleDao.save((Object)rule, new String[0]);
        log.info("OrgCourseConsumeRuleService createRule orgId:{},courseId:{},ruleValue:{}", new Object[]{orgId, courseId, ruleValue});
    }

    @Override
    public boolean updateRuleValue(Long orgId, Long courseId, Integer ruleValue) {
        OrgCourseConsumeRule rule = new OrgCourseConsumeRule();
        rule.setOrgId(orgId);
        rule.setCourseId(courseId);
        rule.setRuleValue(ruleValue);
        HashMap updateCondtion = Maps.newHashMap();
        updateCondtion.put("orgId", orgId);
        updateCondtion.put("courseId", courseId);
        updateCondtion.put("ruleValue", ruleValue);
        updateCondtion.put("updateTime", new Date());
        int count = this.orgCourseConsumeRuleDao.update((Map)updateCondtion, new String[]{"ruleValue", "updateTime"});
        log.info("OrgCourseConsumeRuleService updateRuleValue orgId:{},courseId:{},ruleValue:{}", new Object[]{orgId, courseId, ruleValue});
        return count > 0;
    }

    @Override
    public void saveOfupdate(Long orgId, Long courseId, Integer ruleValue) {
        OrgCourseConsumeRule rule = this.orgCourseConsumeRuleDao.getRuleByCourseId(orgId, courseId);
        if (rule != null) {
            this.updateRuleValue(orgId, courseId, ruleValue);
        } else {
            this.create(orgId, courseId, ruleValue);
        }
    }

    @Override
    public OrgCourseConsumeRule getRuleByCourseId(Long orgId, Long courseId) {
        OrgCourseConsumeRule rule = this.orgCourseConsumeRuleDao.getRuleByCourseId(orgId, courseId);
        if (rule == null) {
            rule = new OrgCourseConsumeRule();
        }
        String ruleDesc = CourseConsumeRuleEnum.getRuleDescByValue(rule.getRuleValue());
        rule.setRuleDesc(ruleDesc);
        return rule;
    }

    @Override
    public OrgCourseConsumeRule getOrgDefaultRule(Long orgId) {
        OrgCourseConsumeRule defaultRule = new OrgCourseConsumeRule();
        TXCommonRule commonRule = this.tXCommonRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
        if (commonRule != null && commonRule.getConsumeRule() != null) {
            Integer defaultConsumeRuleValue = commonRule.getConsumeRule();
            defaultRule.setRuleValue(defaultConsumeRuleValue);
            String defaultRuleDesc = CourseConsumeRuleEnum.getRuleDescByValue(defaultConsumeRuleValue);
            defaultRule.setRuleDesc(defaultRuleDesc);
        }
        return defaultRule;
    }
}

