/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TtsSmsDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseSms;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TtsSms;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.SmsService;
import com.baijia.tianxiao.util.CourseSmsTokenUtil;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="SmsService1")
public class SmsServiceImpl
implements SmsService {
    private static final Logger log = LoggerFactory.getLogger(SmsServiceImpl.class);
    private static final String STUDENT_SMS_TEMPLATE = "%s\u60a8\u597d\uff0c\u60a8\u5728%s\u7684%s\u5df2\u7ecf\u5b8c\u6210\u8bfe\u7a0b\u5b89\u6392\u3002\u8bfe\u8868\u67e5\u770b\u5730\u5740\uff1a%s";
    private static final String TEACHER_SMS_TEMPLATE = "%s\u60a8\u597d\uff0c\u60a8\u5728%s\u7684%s\u5df2\u7ecf\u5b8c\u6210\u8bfe\u7a0b\u5b89\u6392\u3002\u8bfe\u8868\u67e5\u770b\u5730\u5740\uff1a%s";
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;
    @Resource
    private StudentDao studentDao;
    @Resource
    private UserDao userDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private TtsSmsDao ttsSmsDao;

    @Override
    public boolean saveAndSendSms(Long operatorId, Long smsKey, Integer userRole, Long userId, String mobile, String content) {
        if (!ParamValidateUtils.validateMobile((String)mobile) || StringUtils.isBlank((CharSequence)content)) {
            return false;
        }
        TtsSms sms = new TtsSms();
        sms.setContent(content);
        sms.setMessageType((Number)SmsMessageType.TIANXIAO_NOTIFY.getCode());
        sms.setMobile(mobile);
        sms.setOperatorId(operatorId);
        sms.setSendSmsKey(Long.valueOf(smsKey != null ? smsKey : 0L));
        sms.setUserRole((Number)userRole);
        boolean sendResult = false;
        try {
            sendResult = SmsSendUtil.sendSms((String)mobile, (String)content, (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), null, null, (boolean)true);
            sms.setSendResult((Number)(sendResult ? SmsSendResult.SUCCESS.getValue() : SmsSendResult.FAILED.getValue()));
            this.ttsSmsDao.save((Object)sms, new String[0]);
        }
        catch (Exception e) {
            log.warn("save sms record catch error:", (Throwable)e);
        }
        log.info("send sms to :{} is succ:{}", (Object)mobile, (Object)sendResult);
        return sendResult;
    }

    @Override
    public List<Long> sendCourseSms(@NonNull Long orgId, @NonNull Long courseId, @NonNull Integer userRole, @NonNull List<Long> userIds) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (courseId == null) {
            throw new NullPointerException("courseId");
        }
        if (userRole == null) {
            throw new NullPointerException("userRole");
        }
        if (userIds == null) {
            throw new NullPointerException("userIds");
        }
        log.debug("userIds = {} orgId ={} courseId = {},userRole = {}", new Object[]{userIds, orgId, courseId, userRole});
        if (UserRole.TEACHER.getRole() == userRole.intValue()) {
            return this.sendTeacherCourseSms(orgId, courseId, userRole, userIds);
        }
        if (UserRole.STUDENT.getRole() == userRole.intValue()) {
            return this.sendStudentCourseSms(orgId, courseId, userRole, userIds);
        }
        throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
    }

    private String getSmsToken(Long orgId, Long courseId, Integer userRole, Long userId, Long studentId) {
        String token = null;
        OrgCourseSms orgCourseSms = this.orgCourseSmsDao.getOrgCourseSms(orgId, courseId, userRole, userId, new String[0]);
        HashMap<String, Long> params = new HashMap<String, Long>();
        if (orgCourseSms == null) {
            orgCourseSms = new OrgCourseSms();
            orgCourseSms.setCourseId(courseId);
            orgCourseSms.setOrgId(orgId);
            orgCourseSms.setUserRole(userRole);
            orgCourseSms.setUserId(userId);
            orgCourseSms.setSend(Integer.valueOf(0));
            this.orgCourseSmsDao.save((Object)orgCourseSms, new String[0]);
        }
        params.put("id", orgCourseSms.getId());
        params.put("orgId", orgId);
        params.put("courseId", courseId);
        if (UserRole.STUDENT.getRole() == userRole.intValue()) {
            params.put("studentId", studentId);
        } else if (UserRole.TEACHER.getRole() == userRole.intValue()) {
            params.put("teacherId", userId);
        }
        orgCourseSms.setStudentId(studentId);
        try {
            log.debug("orgCourseSms = {}", (Object)orgCourseSms);
            token = CourseSmsTokenUtil.encodeToken(params);
        }
        catch (Exception e) {
            log.debug("token = {} ", token);
            return null;
        }
        return token;
    }

    private List<Long> sendStudentCourseSms(Long orgId, Long courseId, Integer userRole, List<Long> studentIds) {
        Map stuUserMap = this.orgStudentDao.getStudentIdUserIdMap(studentIds);
        ArrayList succeedStudentIds = Lists.newArrayList();
        boolean sendResult = false;
        String content = null;
        List students = this.orgStudentDao.getStudentByIds(orgId, studentIds, new String[0]);
        String orgName = this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(orgId.intValue()));
        String courseName = this.orgCourseDao.getCourseNameById(courseId);
        String longUrlFormat = PropertiesReader.getProperties((String)"url.properties").getProperty("sms.course.student.url");
        HashMap stuMap = Maps.newHashMap();
        for (OrgStudent student : students) {
            stuMap.put(student.getId(), student);
        }
        for (Long stuId : studentIds) {
            String token;
            OrgStudent student = (OrgStudent)stuMap.get(stuId);
            if (student == null || StringUtils.isEmpty((CharSequence)(token = this.getSmsToken(orgId, courseId, userRole, (Long)stuUserMap.get(stuId), stuId)))) continue;
            String longUrl = String.format(longUrlFormat, token);
            String url = ShortUrlUtil.getShortUrl((String)longUrl);
            log.debug("send sms: longUrl = {}, url = {}", (Object)longUrl, (Object)url);
            content = String.format("%s\u60a8\u597d\uff0c\u60a8\u5728%s\u7684%s\u5df2\u7ecf\u5b8c\u6210\u8bfe\u7a0b\u5b89\u6392\u3002\u8bfe\u8868\u67e5\u770b\u5730\u5740\uff1a%s", SmsServiceImpl.getStudentName(student), orgName, courseName, url);
            sendResult = this.saveAndSendSms(orgId, null, userRole, student.getUserId(), StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{student.getShowMobile()}) && student.getShowMobile().indexOf("*") < 0 ? student.getShowMobile() : student.getMobile(), content);
            if (sendResult) {
                this.orgCourseSmsDao.increaseSendTime(orgId, courseId, userRole, student.getUserId());
                succeedStudentIds.add(stuId);
                log.debug("send stu sms mobile = {}, content = {} ", (Object)student.getMobile(), (Object)content);
                continue;
            }
            log.warn("send stu sms mobile = {}, content = {}", (Object)student.getMobile(), (Object)content);
        }
        return succeedStudentIds;
    }

    private static String getStudentName(OrgStudent student) {
        if (student != null) {
            if (StringUtils.isNotEmpty((CharSequence)student.getName())) {
                return student.getName();
            }
            if (StringUtils.isNotEmpty((CharSequence)student.getNickName())) {
                return student.getNickName();
            }
            return MaskUtil.maskMobile((String)student.getMobile());
        }
        return "";
    }

    private List<Long> sendTeacherCourseSms(Long orgId, Long courseId, Integer userRole, List<Long> userIds) {
        ArrayList succeedUserIds = Lists.newArrayList();
        boolean sendResult = false;
        String content = null;
        List teachers = this.teacherDao.getByUserIds(userIds, new String[0]);
        log.debug("teachers = {}", (Object)teachers);
        Map idUserMap = this.userDao.getMapByIds(userIds, new String[0]);
        log.debug("idUserMap = {}", (Object)idUserMap);
        String orgName = this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(orgId.intValue()));
        String courseName = this.orgCourseDao.getCourseNameById(courseId);
        String longUrlFormat = PropertiesReader.getProperties((String)"url.properties").getProperty("sms.course.teacher.url");
        HashMap teacherMap = Maps.newHashMap();
        for (Teacher teacher : teachers) {
            teacherMap.put(teacher.getUserId(), teacher);
        }
        for (Long userId : userIds) {
            String token;
            Teacher teacher = (Teacher)teacherMap.get(userId);
            if (teacher == null || StringUtils.isEmpty((CharSequence)(token = this.getSmsToken(orgId, courseId, userRole, userId, null)))) continue;
            String longUrl = String.format(longUrlFormat, token);
            String url = ShortUrlUtil.getShortUrl((String)longUrl);
            log.debug("send sms: longUrl = {}, url = {}", (Object)longUrl, (Object)url);
            content = String.format("%s\u60a8\u597d\uff0c\u60a8\u5728%s\u7684%s\u5df2\u7ecf\u5b8c\u6210\u8bfe\u7a0b\u5b89\u6392\u3002\u8bfe\u8868\u67e5\u770b\u5730\u5740\uff1a%s", StringUtils.isEmpty((CharSequence)teacher.getRealName()) ? teacher.getNickName() : teacher.getRealName(), orgName, courseName, url);
            User user = (User)idUserMap.get(userId);
            if (user != null) {
                log.debug("teacher mobile = {}", (Object)user.getMobile());
                sendResult = this.saveAndSendSms(orgId, null, userRole, userId, user.getMobile(), content);
            }
            if (sendResult) {
                succeedUserIds.add(userId);
                this.orgCourseSmsDao.increaseSendTime(orgId, courseId, userRole, userId);
                log.debug("send teacher sms mobile = {}, content = {} ", (Object)(user != null ? user.getMobile() : null), (Object)content);
                continue;
            }
            log.warn("send teacher sms mobile = {}, content = {} ", (Object)(user != null ? user.getMobile() : null), (Object)content);
        }
        return succeedUserIds;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void viewSms(Long orgId, Long courseId, Long userId, Integer userRole) {
        log.debug("view sms info ,orgId={},courseId={},userId={},userRole={}", new Object[]{orgId, courseId, userId, userRole});
        OrgCourseSms sms = this.orgCourseSmsDao.getOrgCourseSms(orgId, courseId, userRole, userId, new String[0]);
        log.debug("sms={}", (Object)sms);
        if (sms != null) {
            sms.setViewStatus(Integer.valueOf(1));
            this.orgCourseSmsDao.update((Object)sms, new String[]{"viewStatus"});
        }
    }
}

