/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.common.service.MsgSendService;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.sal.course.service.OrgLessonSyncService;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.beust.jcommander.internal.Maps;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgLessonSyncServiceImpl
implements OrgLessonSyncService {
    private static final Logger log = LoggerFactory.getLogger(OrgLessonSyncServiceImpl.class);
    private static String lessonStartStudent = "%s\uff0c\u4f60\u5728%s\u7684%s\u5c06\u5728%s\u5f00\u59cb\u4e0a\u8bfe\u3002\u8bf7\u505a\u597d\u4e0a\u8bfe\u51c6\u5907\u54e6\u3002\u5982\u9700\u8bf7\u5047\uff0c\u8bf7\u62e8\u62534000122166\u8f6c%s\u3002";
    private static String defaultName = "-";
    private static String remark = "\u522b\u8fdf\u5230\u54e6\uff5e\uff5e";
    @Autowired(required=false)
    private MsgSendService msgSendService;
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgClassRoomDao OrgClassRoomDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private OrgCourseDao orgCourseDao;

    @Override
    public void syncSMSBeforeLessonBegin() {
        Date now = new Date();
        Date startTime = DateUtil.getEndOfDay((Date)now);
        for (int i = 0; i < 24; ++i) {
            Date tempStartTime = DateUtil.getDiffDateTime((Date)startTime, (int)i, (int)11);
            Date tempEndTime = DateUtil.getDiffDateTime((Date)startTime, (int)(i + 1), (int)11);
            this.studentLessonSms(tempStartTime, tempEndTime);
            log.debug("send message startTime={},endTime={}", (Object)tempStartTime, (Object)tempEndTime);
        }
    }

    private void studentLessonSms(Date startTime, Date endTime) {
        Map lessonUnBeginMap = this.orgStudentLessonDao.getStudentLessonByStartTime(startTime, endTime);
        log.debug("lessonUnBeginMap={}", (Object)lessonUnBeginMap);
        List lessons = this.orgClassLessonDao.getByIds(lessonUnBeginMap.keySet(), new String[0]);
        log.debug("lessons={}", (Object)lessons);
        Map teacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(null, lessonUnBeginMap.keySet());
        Map teacherNameMap = this.teacherDao.getTeacherRealNameMap(teacherIdMap.values());
        HashSet courseIds = Sets.newHashSet();
        HashSet orgIds = Sets.newHashSet();
        HashSet orgIdLs = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet userIds = Sets.newHashSet();
        for (OrgClassLesson lesson : lessons) {
            OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)lesson.getCourseId(), new String[0]);
            if (orgCourse.getStatus() != 0 || orgCourse.getIsDel() != 0) continue;
            courseIds.add(lesson.getCourseId());
            orgIds.add(lesson.getOrgId().intValue());
            orgIdLs.add(lesson.getOrgId());
            roomIds.add(lesson.getRoomId());
            List value = (List)lessonUnBeginMap.get(lesson.getId());
            if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
            userIds.addAll(value);
        }
        log.debug("courseIds={},orgIds={},roomIds={}", new Object[]{courseIds, orgIds, roomIds});
        Map<Long, OrgInfo> orgInfos = this.getOrgInfoMap(orgIds);
        Map<Long, OrgCourse> courseInfos = this.getCourseInfos(courseIds);
        Map<String, OrgStudent> studentInfos = this.getStudentInfos(orgIdLs, userIds);
        Map roomNameMap = this.OrgClassRoomDao.getRoomName(null, (Collection)roomIds);
        for (OrgClassLesson lesson : lessons) {
            OrgInfo orgInfo = orgInfos.get(lesson.getOrgId());
            OrgCourse course = courseInfos.get(lesson.getCourseId());
            if (course.getStatus() != 0 || course.getIsDel() != 0) continue;
            List lessonUserIds = (List)lessonUnBeginMap.get(lesson.getId());
            Long teacherId = (Long)teacherIdMap.get(lesson.getId());
            String teacherName = null;
            if (teacherId != null) {
                teacherName = (String)teacherNameMap.get(teacherId);
            }
            String roomName = null;
            if (lesson.getRoomId() != null) {
                roomName = (String)roomNameMap.get(lesson.getRoomId());
            }
            if (orgInfo == null || course == null || !CollectionUtils.isNotEmpty((Collection)lessonUserIds)) continue;
            for (Long lessonUserId : lessonUserIds) {
                OrgStudent student = studentInfos.get(String.valueOf(orgInfo.getOrgId()) + String.valueOf('|') + String.valueOf(lessonUserId));
                this.msgSendService.sendMsg(this.getStudentLessonStart(teacherName, roomName, lesson, course, orgInfo, student));
            }
        }
    }

    private SendMsgRequest getStudentLessonStart(String teacherName, String roomName, OrgClassLesson lesson, OrgCourse course, OrgInfo orgInfo, OrgStudent student) {
        SendMsgRequest request = new SendMsgRequest();
        request.setOrgId(Long.valueOf(orgInfo.getOrgId().longValue()));
        request.setMobile(student.getMobile());
        request.setCountSms(false);
        request.setReceiverId(student.getId());
        request.setWeixinOpenId(student.getWeixin());
        request.setReceiverRole(UserRoleEnum.STUDENT);
        request.setSenderId(Long.valueOf(orgInfo.getOrgId().longValue()));
        request.setSenderRole(UserRoleEnum.ORG);
        request.setWechatTemplateId(Integer.valueOf(WechateTemplateMsgType.COURSE_START_TO_STU.getValue()));
        String smsContent = String.format(lessonStartStudent, this.getStringValue(student.getName()), this.getStringValue(orgInfo.getShortName()), this.getStringValue(course.getName()), DateUtil.getStrByDateFormate((Date)lesson.getStartTime(), (String)"yyyy-MM-dd HH:mm"), this.getStringValue(orgInfo.getExtension()));
        Map params = Maps.newHashMap();
        request.setSmsContent(smsContent);
        params.put("first", smsContent);
        params.put("remark", remark);
        params.put("keyword1", DateUtil.getStrByDateFormate((Date)lesson.getStartTime(), (String)"yyyy-MM-dd HH:mm"));
        params.put("keyword2", this.getStringValue(teacherName));
        params.put("keyword3", this.getStringValue(course.getName()));
        params.put("keyword4", this.getStringValue(roomName));
        request.setWechatParams(params);
        log.debug("send msg={}", (Object)request);
        return request;
    }

    private String getStringValue(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return defaultName;
        }
        return message;
    }

    private void teacherLessonSms(Date startTime, Date endTime) {
        Map lessonUnBeginMap = this.orgTeacherLessonDao.getTeacherLessonByStartTime(startTime, endTime);
        List lessons = this.orgClassLessonDao.getByIds(lessonUnBeginMap.keySet(), new String[0]);
        HashSet courseIds = Sets.newHashSet();
        HashSet orgIds = Sets.newHashSet();
        HashSet orgIdLs = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet userIds = Sets.newHashSet();
        for (OrgClassLesson lesson : lessons) {
            courseIds.add(lesson.getCourseId());
            orgIds.add(lesson.getOrgId().intValue());
            orgIdLs.add(lesson.getOrgId());
            roomIds.add(lesson.getRoomId());
            List value = (List)lessonUnBeginMap.get(lesson.getId());
            if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
            userIds.addAll(value);
        }
        Map<Long, OrgInfo> orgInfos = this.getOrgInfoMap(orgIds);
        Map<Long, OrgCourse> courseInfos = this.getCourseInfos(courseIds);
        Map<Long, Teacher> teacherInfos = this.getTeacherInfos(userIds);
    }

    private Map<Long, Teacher> getTeacherInfos(Collection<Long> userIds) {
        List teachers = this.teacherDao.getByUserIds(userIds, new String[0]);
        return CollectorUtil.collectMap((Collection)teachers, (Function)new Function<Teacher, Long>(){

            public Long apply(Teacher arg0) {
                return arg0.getUserId();
            }
        });
    }

    private Map<String, OrgStudent> getStudentInfos(Collection<Long> orgIds, Collection<Long> userIds) {
        List students = this.orgStudentDao.getStudentsByUserIdsAndOrgIds(orgIds, userIds);
        return CollectorUtil.collectMap((Collection)students, (Function)new Function<OrgStudent, String>(){

            public String apply(OrgStudent arg0) {
                return String.valueOf(arg0.getOrgId()) + String.valueOf('|') + String.valueOf(arg0.getUserId());
            }
        });
    }

    private Map<Long, OrgClassRoom> getRoomsInfos(Collection<Long> roomIds) {
        List rooms = this.OrgClassRoomDao.getByIds(roomIds, new String[0]);
        return CollectorUtil.collectMap((Collection)rooms, (Function)new Function<OrgClassRoom, Long>(){

            public Long apply(OrgClassRoom arg0) {
                return arg0.getId();
            }
        });
    }

    private Map<Long, OrgCourse> getCourseInfos(Collection<Long> courseIds) {
        List courses = this.orgCourseDao.getByIds(courseIds, new String[0]);
        return CollectorUtil.collectMap((Collection)courses, (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse arg0) {
                return arg0.getId();
            }
        });
    }

    private Map<Long, OrgInfo> getOrgInfoMap(Collection<Integer> orgIds) {
        List orgInfos = this.orgInfoDao.getOrgInfos(orgIds, new String[0]);
        return CollectorUtil.collectMap((Collection)orgInfos, (Function)new Function<OrgInfo, Long>(){

            public Long apply(OrgInfo arg0) {
                return arg0.getOrgId().longValue();
            }
        });
    }
}

