/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.util;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.response.OrgTeacherLessonInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherClassHourDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherCourseDto;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportService {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportService.class);
    private static String HEADER_FORMAT = "@";
    public static final String EXPORT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();

    private static CellStyle createCellStyle(Workbook workBook, String format) {
        CellStyle cellStyle = workBook.createCellStyle();
        DataFormat dataFormat = workBook.createDataFormat();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setDataFormat(dataFormat.getFormat(format));
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        return cellStyle;
    }

    public static Sheet createSheet(Workbook workbook, String sheetName, List<String> titles, Map<String, CellStyle> cellStyleMap, List<ExportField> exportFields, List<TeacherClassHourDto> datas, boolean showLesson) {
        Sheet sheet = workbook.createSheet(sheetName);
        int columnSize = 0;
        for (ExportField field : exportFields) {
            columnSize += field.getExportFieldSize();
        }
        ExcelExportService.createTitleRow(sheet, cellStyleMap, titles, columnSize);
        int row = titles != null ? titles.size() : 0;
        ExcelExportService.createHeaderRow(sheet, cellStyleMap, exportFields, row++);
        for (TeacherClassHourDto tch : datas) {
            int preLessonSize = 0;
            Row dataRow = sheet.createRow(row);
            ExcelExportService.createCell(dataRow, 0, tch.getTeacherName(), cellStyleMap, exportFields.get(0).getFormat());
            int totalLessonCount = 0;
            for (int j = 0; j < tch.getCourses().size(); ++j) {
                TeacherCourseDto course = tch.getCourses().get(j);
                int index = 1;
                Row courseRow = null;
                courseRow = j == 0 ? dataRow : sheet.createRow(row + j + preLessonSize);
                ExcelExportService.createCell(courseRow, index, course.getCourseName(), cellStyleMap, exportFields.get(index).getFormat());
                if (!showLesson) {
                    ExcelExportService.createCell(courseRow, ++index, course.getLessons().size(), cellStyleMap, exportFields.get(index).getFormat());
                    ExcelExportService.createCell(courseRow, ++index, course.getMinutes(), cellStyleMap, exportFields.get(index).getFormat());
                    if (index >= exportFields.size()) continue;
                    ExcelExportService.createCell(courseRow, ++index, "", cellStyleMap, exportFields.get(index).getFormat());
                    continue;
                }
                if (course.getLessons().size() > 1) {
                    ExcelExportService.mergeCell(sheet, row + j + preLessonSize, row + j + preLessonSize + course.getLessons().size() - 1, index, index);
                }
                for (int k = 0; k < course.getLessons().size(); ++k) {
                    OrgTeacherLessonInfoDto lessonInfo = course.getLessons().get(k);
                    Row lessonRow = null;
                    lessonRow = k == 0 ? courseRow : sheet.createRow(row + k + j + preLessonSize);
                    ExcelExportService.createLessonRow(lessonRow, index, lessonInfo, exportFields, cellStyleMap);
                }
                preLessonSize = course.getLessons().size() - 1;
                totalLessonCount += course.getLessons().size();
            }
            if (!showLesson) {
                ExcelExportService.mergeCell(sheet, row, row + tch.getCourses().size() - 1, 0, 0);
                ExcelExportService.mergeCell(sheet, row, row + tch.getCourses().size() - 1, exportFields.size() - 1, exportFields.size() - 1);
                row += tch.getCourses().size();
                continue;
            }
            ExcelExportService.mergeCell(sheet, row, row + totalLessonCount - 1, 0, 0);
            row += totalLessonCount;
        }
        return sheet;
    }

    private static void mergeCell(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn) {
        CellRangeAddress rangeAddress = new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn);
        sheet.addMergedRegion(rangeAddress);
        RegionUtil.setBorderBottom((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
        RegionUtil.setBorderTop((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
        RegionUtil.setBorderLeft((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
        RegionUtil.setBorderRight((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
    }

    private static void createLessonRow(Row lessonRow, int baseColumn, OrgTeacherLessonInfoDto lessonInfo, List<ExportField> exportFields, Map<String, CellStyle> cellStyleMap) {
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getLessonNumberInfo(), cellStyleMap, exportFields.get(baseColumn).getFormat());
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getRoomName(), cellStyleMap, exportFields.get(baseColumn).getFormat());
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getStartTime(), cellStyleMap, exportFields.get(baseColumn).getFormat());
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getLessonTime(), cellStyleMap, exportFields.get(baseColumn).getFormat());
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getMinutes(), cellStyleMap, exportFields.get(baseColumn).getFormat());
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getStudentCount(), cellStyleMap, exportFields.get(baseColumn).getFormat());
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getSignCount(), cellStyleMap, exportFields.get(baseColumn).getFormat());
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getLeaveCount(), cellStyleMap, exportFields.get(baseColumn).getFormat());
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getAbsentCount(), cellStyleMap, exportFields.get(baseColumn).getFormat());
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getUnsignCount(), cellStyleMap, exportFields.get(baseColumn).getFormat());
        ExcelExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getSignRate(), cellStyleMap, exportFields.get(baseColumn).getFormat());
    }

    private static void createCell(Row row, int column, Object value, Map<String, CellStyle> cellStyleMap, String format) {
        Cell cell = row.createCell(column);
        String localFormat = null;
        if (value != null) {
            if (value instanceof Date) {
                row.getSheet().setColumnWidth(cell.getColumnIndex(), 5120);
                localFormat = EXPORT_DATE_FORMAT;
                cell.setCellValue((Date)value);
            } else if (value instanceof Number && ((Number)value).longValue() < Integer.MAX_VALUE) {
                if (value instanceof Double) {
                    localFormat = "0.00";
                    cell.setCellValue(((Number)value).doubleValue());
                } else {
                    localFormat = "0";
                    cell.setCellValue((double)((Number)value).longValue());
                }
            } else {
                cell.setCellValue(value.toString());
                localFormat = "@";
            }
        } else {
            cell.setCellValue("");
        }
        cell.setCellStyle(ExcelExportService.getCellStyle(row.getSheet().getWorkbook(), cellStyleMap, format != null ? format : localFormat));
    }

    private static CellStyle getCellStyle(Workbook workbook, Map<String, CellStyle> cellStyleMap, String format) {
        if (!cellStyleMap.containsKey(format)) {
            cellStyleMap.put(format, ExcelExportService.createCellStyle(workbook, format));
        }
        return cellStyleMap.get(format);
    }

    private static void createHeaderRow(Sheet sheet, Map<String, CellStyle> cellStyleMap, List<ExportField> exportFields, int row) {
        Row headerRow = sheet.createRow(row);
        int column = 0;
        CellStyle style = ExcelExportService.getCellStyle(sheet.getWorkbook(), cellStyleMap, HEADER_FORMAT);
        for (ExportField field : exportFields) {
            column = ExcelExportService.createHeaderCell(headerRow, style, field, column);
        }
    }

    private static int createHeaderCell(Row row, CellStyle style, ExportField field, int column) {
        if (CollectionUtils.isEmpty((Collection)field.getChildren())) {
            row.getSheet().setColumnWidth(column, field.getWidth());
            Cell cell = row.createCell(column++);
            cell.setCellStyle(style);
            cell.setCellValue(field.getName());
        } else {
            for (ExportField child : field.getChildren()) {
                column = ExcelExportService.createHeaderCell(row, style, child, column);
            }
        }
        return column;
    }

    private static void createTitleRow(Sheet sheet, Map<String, CellStyle> cellStyleMap, List<String> titles, int headerSize) {
        int row = 0;
        if (CollectionUtils.isNotEmpty(titles)) {
            for (String title : titles) {
                Row titleRow = sheet.createRow(row);
                Cell cell = titleRow.createCell(0);
                cell.setCellValue(title);
                cell.setCellStyle(ExcelExportService.getCellStyle(sheet.getWorkbook(), cellStyleMap, HEADER_FORMAT));
                ExcelExportService.mergeCell(sheet, row, row, 0, headerSize - 1);
                ++row;
            }
        }
    }

    public static void exportExcel(HttpServletResponse response, Workbook workBook, String excelFileName) {
        if (StringUtils.isBlank((CharSequence)excelFileName)) {
            excelFileName = System.currentTimeMillis() + ".xlsx";
        }
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(excelFileName, "utf-8"));
        }
        catch (UnsupportedEncodingException e1) {
            response.setHeader("Content-Disposition", "attachment; filename=" + excelFileName);
        }
        try {
            workBook.write((OutputStream)response.getOutputStream());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            log.error("export data catch error:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5931\u8d25");
        }
    }
}

