/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.OrgCourseStatus;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.dao.AreaDao;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSeatDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseStudentOpDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTimeSpanDao;
import com.baijia.tianxiao.dal.org.po.Area;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgTimeSpan;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.util.SerialNumberUtil;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.constant.LessonWay;
import com.baijia.tianxiao.sal.course.dto.OrgCourseDetailResponseDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseInfoDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseQueryResponseDto;
import com.baijia.tianxiao.sal.course.dto.request.OrgRecommendCourseRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgCourseGroupDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgTimeSpanDto;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupRelateService;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.date.TimeStamp;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgCourseServiceImpl
implements OrgCourseService {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseServiceImpl.class);
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCourseSeatDao orgCourseSeatDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgCourseStudentOpDao orgCourseStudentStatusDao;
    @Resource
    OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgTimeSpanDao orgTimeSpanDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private AreaDao areaDao;
    @Resource
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Resource
    private OrgCourseGroupService orgCourseGroupService;
    @Resource
    private OrgCourseGroupRelateService orgCourseGroupRelateService;
    @Resource
    private UserDao userDao;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Autowired
    private OrgCourseGroupDao orgCourseGroupDao;
    @Resource
    private Environment environment;
    private static final int TOTAL_COURSE_COLOR_COUNT = 35;

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgCourseQueryResponseDto> getOrgCourses(@NonNull Long orgId, String key, PageDto pageDto) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        Long orgNumber = this.getOrgNumber(orgId);
        if (orgNumber == null) {
            log.error("orgNumber = {}", (Object)orgNumber);
            return Lists.newArrayList();
        }
        log.info("getOrgCourses orgNumber {}", (Object)orgNumber);
        ArrayList<OrgCourseQueryResponseDto> courseQueryResponseDtos = new ArrayList<OrgCourseQueryResponseDto>();
        List orgCourses = this.orgCourseDao.getCoursesByOrgNumber(orgNumber, key, Integer.valueOf(OrgCourseStatus.IN_PROGRESS.getCode()), pageDto, new String[0]);
        HashSet<Long> courseIds = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty((Collection)orgCourses)) {
            for (OrgCourse orgCourse : orgCourses) {
                courseIds.add(orgCourse.getId());
                if (!StringUtils.isEmpty((String)orgCourse.getColor())) continue;
                orgCourse.setColor(this.getNextRandomColor());
                this.orgCourseDao.save((Object)orgCourse, new String[0]);
            }
            Map<Long, List<String>> courseIdTeacherIdMap = this.getCourseIdTeacherNamesMap(courseIds);
            for (OrgCourse orgCourse : orgCourses) {
                OrgCourseQueryResponseDto courseQueryResponseDto = new OrgCourseQueryResponseDto();
                this.fillCourseQueryResponseDto(courseIdTeacherIdMap, orgCourse, courseQueryResponseDto);
                courseQueryResponseDtos.add(courseQueryResponseDto);
            }
        }
        return courseQueryResponseDtos;
    }

    private void fillCourseQueryResponseDto(Map<Long, List<String>> courseIdTeacherIdMap, OrgCourse orgCourse, OrgCourseQueryResponseDto courseQueryResponseDto) {
        courseQueryResponseDto.setCourseName(orgCourse.getName());
        courseQueryResponseDto.setOrgCourseId(orgCourse.getId());
        courseQueryResponseDto.setColor(orgCourse.getColor());
        courseQueryResponseDto.setOrgCourseNumber(orgCourse.getNumber());
        courseQueryResponseDto.setOriginPrice(orgCourse.getPrice());
        List<String> teacherNames = courseIdTeacherIdMap.get(orgCourse.getId());
        if (CollectionUtils.isNotEmpty(teacherNames)) {
            courseQueryResponseDto.setTeacherName(StringUtils.join((Object[])teacherNames.toArray(), (char)','));
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, List<String>> getCourseIdTeacherNamesMap(Collection<Long> courseIds) {
        List orgCourseTeachers = this.orgCourseTeacherDao.getOrgCourseTeacher(courseIds, null);
        if (CollectionUtils.isNotEmpty((Collection)orgCourseTeachers)) {
            HashMap result = Maps.newHashMap();
            HashSet teacherIds = Sets.newHashSet();
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                teacherIds.add(orgCourseTeacher.getUserId());
            }
            Map teacherNames = this.teacherDao.getTeacherRealNameMap((Collection)teacherIds);
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                Long courseId = orgCourseTeacher.getOrgCourseId();
                if (!result.containsKey(courseId)) {
                    result.put(courseId, Lists.newArrayList());
                }
                ((List)result.get(courseId)).add(teacherNames.get(orgCourseTeacher.getUserId()));
            }
            log.debug("courseIds:{}, teacherNames:{}", courseIds, (Object)teacherNames);
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgCourseQueryResponseDto> getLatestOrgCourses(Long orgId, PageDto pageDto) {
        log.info("getOrgLatestCourses-->orgId {}", (Object)orgId);
        ArrayList<OrgCourseQueryResponseDto> courseQueryResponseDtos = new ArrayList<OrgCourseQueryResponseDto>();
        List courseIds = this.coursePurchaseDao.getLatestdPurchaseCourseIdsList(orgId);
        if (CollectionUtils.isEmpty((Collection)courseIds)) {
            log.info("get no courses id");
            return Collections.emptyList();
        }
        List orgCourses = this.orgCourseDao.getByIdsOrderByIn((Collection)courseIds, pageDto.getPageSize());
        if (CollectionUtils.isEmpty((Collection)orgCourses)) {
            log.info("get no courses ids={}", (Object)courseIds);
            return Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty((Collection)orgCourses)) {
            Map<Long, List<String>> courseIdTeacherIdMap = this.getCourseIdTeacherNamesMap(courseIds);
            for (OrgCourse orgCourse : orgCourses) {
                OrgCourseQueryResponseDto courseQueryResponseDto = new OrgCourseQueryResponseDto();
                this.fillCourseQueryResponseDto(courseIdTeacherIdMap, orgCourse, courseQueryResponseDto);
                courseQueryResponseDtos.add(courseQueryResponseDto);
            }
        }
        return courseQueryResponseDtos;
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> getCourseColors() {
        String colors = PropertiesReader.getValueNoCache((String)"erp.properties", (String)"course.colors");
        Object[] colorsArray = colors.split(",");
        if (colorsArray.length != 35) {
            log.warn("course colors count = {}", (Object)colorsArray.length);
        }
        return Lists.newArrayList((Object[])colorsArray);
    }

    private String getNextRandomColor() {
        List<String> colors = this.getCourseColors();
        Random rand = new Random();
        return colors.get(rand.nextInt(colors.size() - 1));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeCourseColor(@NonNull Long orgId, @NonNull Long courseId, @NonNull String color) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (courseId == null) {
            throw new NullPointerException("courseId");
        }
        if (color == null) {
            throw new NullPointerException("color");
        }
        if (!color.startsWith("#") || color.length() != 7) {
            log.error("color = {} \u683c\u5f0f\u4e0d\u5bf9 ", (Object)color);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "wrong color format.");
        }
        this.orgCourseDao.changeCourseColor(Integer.valueOf(this.getOrgNumber(orgId).intValue()), courseId, color);
    }

    private boolean isCourseDuplicate(OrgCourseInfoDto course, boolean updateRepeate) {
        if (updateRepeate) {
            return false;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateCourse(Long orgId, OrgCourseInfoDto course, boolean doDel, boolean updateRepeate) {
        log.info("orgId={}, course={}", (Object)orgId, (Object)course);
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId illegal.");
        Preconditions.checkArgument((course != null ? 1 : 0) != 0, (Object)"course == null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)course.getCourseName()), (Object)"\u8bfe\u7a0b\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        Preconditions.checkArgument((course.getCoursePrice() != null && course.getCoursePrice() > 0.0 ? 1 : 0) != 0, (Object)"\u8bfe\u7a0b\u4ef7\u683c\u5fc5\u987b>0");
        Preconditions.checkArgument((course.getFreq() != null && course.getFreq() >= 0 ? 1 : 0) != 0, (Object)"\u4e0a\u8bfe\u6b21\u6570\u5fc5\u987b>=0");
        Preconditions.checkArgument((course.getMaxStudent() != null && course.getMaxStudent() >= 0 ? 1 : 0) != 0, (Object)"\u73ed\u7ea7\u4eba\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if (this.isCourseDuplicate(course, updateRepeate)) {
            throw new BussinessException((UniverseErrorCode)CourseErrorCode.COURSE_EXSIST);
        }
        boolean isUpdate = course.getCourseId() != null && course.getCourseId() > 0L;
        OrgCourse orgCourse = new OrgCourse();
        orgCourse.setOrgNumber(this.getOrgNumber(orgId));
        orgCourse.setId(isUpdate ? course.getCourseId() : null);
        orgCourse.setBeginTime(course.getStartTime());
        orgCourse.setEndTime(course.getEndTime());
        orgCourse.setColor(this.getNextRandomColor());
        orgCourse.setCover(course.getCoverStorageId());
        orgCourse.setFreq(course.getFreq());
        orgCourse.setName(course.getCourseName());
        orgCourse.setMaxStudent(course.getMaxStudent());
        orgCourse.setNumber(Long.valueOf(System.nanoTime()));
        orgCourse.setIsDel(course.getIsDel());
        orgCourse.setSubjectId(Integer.valueOf(0));
        if (!isUpdate && course.getStatus() == null) {
            orgCourse.setStatus(Integer.valueOf(OrgCourseStatus.OFFLINE.getCode()));
        } else {
            orgCourse.setStatus(course.getStatus());
        }
        orgCourse.setVerifyStatus(Integer.valueOf(AuditStatus.PASS.getValue()));
        orgCourse.setAddress(course.getAddress());
        orgCourse.setLessonWay(LessonWay.STU_ACTIVE.getValue());
        Double lng = course.getLng();
        Double lat = course.getLat();
        if (lng != null && lat != null) {
            orgCourse.setOfflinePoi(lng + "," + lat);
        }
        if (course.getIntroduction() != null) {
            Blob intro = BaseUtils.strToBlob((String)course.getIntroduction(), (String)"UTF-8");
            orgCourse.setIntroduction(intro);
        }
        orgCourse.setBranchId(Long.valueOf(-1L));
        orgCourse.setClsfyId(Long.valueOf(-1L));
        orgCourse.setRoomId(Long.valueOf(-1L));
        orgCourse.setLayoutId(Long.valueOf(-1L));
        orgCourse.setPrice(course.getCoursePrice());
        orgCourse.setLessonSummary(course.getLessonSummary());
        log.debug("orgCourse={}", (Object)orgCourse);
        this.orgCourseDao.saveOrUpdate((Object)orgCourse, new String[0]);
        if (orgCourse.getId() != null && orgCourse.getId() > 0L) {
            long number = SerialNumberUtil.generateNumber((int)orgCourse.getId().intValue(), (int)99999999, (int)4);
            orgCourse.setNumber(Long.valueOf(number));
            this.orgCourseDao.saveOrUpdate((Object)orgCourse, new String[]{"number"});
            if (StringUtils.isNotBlank((String)course.getTeacherIds())) {
                List teacherIds = null;
                try {
                    teacherIds = JacksonUtil.str2List((String)course.getTeacherIds(), Long.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "teacherIds \u53c2\u6570\u9519\u8bef\uff01");
                }
                log.debug("{},{}", (Object)teacherIds, (Object)course.getTeacherIds());
                List courseTeachers = this.orgCourseTeacherDao.getTeacherIdsByCourseId(orgCourse.getId());
                if (doDel && CollectionUtils.isNotEmpty((Collection)courseTeachers)) {
                    ArrayList toDelTeacherIds = Lists.newArrayList((Iterable)courseTeachers);
                    toDelTeacherIds.removeAll(teacherIds);
                    this.courseTeacherService.delTeacherFromCourse(orgId, orgCourse.getId(), toDelTeacherIds);
                }
                this.courseTeacherService.addTeacherToCourse(orgId, orgCourse.getId(), teacherIds);
            }
            if (StringUtils.isNotBlank((String)course.getGroup())) {
                try {
                    List grpIds = JacksonUtil.str2List((String)course.getGroup(), Integer.class);
                    this.editGroupsOfCourse(orgId, orgCourse.getId(), grpIds);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    log.warn("{}", (Throwable)e);
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "group json format error!");
                }
            }
        } else {
            log.error("orgCourse={}", (Object)orgCourse);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "courseId illegal.");
        }
        return orgCourse.getId();
    }

    private void editGroupsOfCourse(Long orgId, Long courseId, List<Integer> grpIds) {
        List orgGrpIds = this.orgCourseGroupDao.getOrgCourseGroupIdList(Integer.valueOf(orgId.intValue()));
        if (CollectionUtils.isEmpty((Collection)orgGrpIds) || grpIds == null || courseId == null) {
            return;
        }
        grpIds.retainAll(orgGrpIds);
        List existGrpIds = this.orgCourseGroupRelateDao.getGroupIdByCourseId(courseId, Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        if (CollectionUtils.isNotEmpty((Collection)existGrpIds)) {
            ArrayList toDelGrpIds = Lists.newArrayList((Iterable)existGrpIds);
            toDelGrpIds.removeAll(grpIds);
            this.orgCourseGroupRelateDao.deleteGroupOfCourse(courseId, (Collection)toDelGrpIds, Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        }
        for (Integer gid : grpIds) {
            OrgRecommendCourseRequestDto hotCourse = new OrgRecommendCourseRequestDto();
            hotCourse.setCourseId(courseId);
            hotCourse.setCourseType(CourseType.ORG_COURSE.getCode());
            this.orgCourseGroupRelateService.addCourse(gid, hotCourse, 0);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgCourseDetailResponseDto> getOrgCourseList(Long orgId, int status, PageDto pageDto) {
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        ArrayList data = Lists.newArrayList();
        if (account == null) {
            return data;
        }
        List courses = this.orgCourseDao.getAndFilterOrgCourse(account.getNumber(), null, pageDto);
        log.debug("orgId:{}, status:{}, courses:{}", new Object[]{orgId, status, courses});
        if (courses != null && !courses.isEmpty()) {
            Map<Long, Storage> storageCache = this.getAndCacheStorage(courses);
            List courseIds = BaseUtils.getListFilter((List)courses, (String)"id");
            Map<Long, List<String>> teacherCache = this.getCourseIdTeacherNamesMap(courseIds);
            OrgCourseDetailResponseDto dto = null;
            String host = PropertiesReader.getValue((String)"wxm", (String)"m.server");
            String imgServer = PropertiesReader.getValue((String)"wxm", (String)"img.server");
            for (OrgCourse course : courses) {
                dto = new OrgCourseDetailResponseDto();
                dto.setCourseType(CourseType.ORG_COURSE.getCode());
                dto.setName(course.getName());
                dto.setNumber(course.getNumber());
                dto.setPrice(course.getPrice() + "");
                dto.setCourseId(course.getId());
                if (teacherCache.containsKey(course.getId())) {
                    dto.setTeacherName(teacherCache.get(course.getId()).get(0));
                } else {
                    dto.setTeacherName("\u5f85\u5b9a");
                }
                dto.setPreface(this.getImgUrl(course.getCover() == null ? 0L : course.getCover().longValue(), storageCache, imgServer));
                dto.setLink("{host}/org_class_course/detail/{number}".replace("{host}", host).replace("{number}", course.getNumber().toString()));
                data.add(dto);
            }
        }
        log.info("getOrgCourseList.orgId:{}, status:{}, pageDto:{}, data:{}", new Object[]{orgId, status, pageDto, data});
        return data;
    }

    private Map<Long, Storage> getAndCacheStorage(List<OrgCourse> courses) {
        List storageIds = BaseUtils.getListFilter(courses, (String)"cover");
        Map cache = this.storageDao.getStorageMapByIds((Collection)storageIds);
        log.debug("storageIds:{}, cache:{}", (Object)storageIds, (Object)cache);
        return cache;
    }

    private String getImgUrl(Long storageId, Map<Long, Storage> cache, String imgServer) {
        Storage storage;
        String url = "";
        if (cache.containsKey(storageId) && (storage = cache.get(storageId)) != null) {
            url = this.constructUrl(storage, imgServer);
        }
        return url;
    }

    public String constructUrl(Storage storage, String imgServer) {
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = "";
        if (storage == null) {
            return "";
        }
        if (StringUtils.isNotBlank((String)storage.getMimetype())) {
            surfix = storage.getMimetype().contains("/") ? storage.getMimetype().split("/")[1] : storage.getMimetype();
        }
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    @Override
    @Transactional(readOnly=true)
    public OrgCourseDetailResponseDto getOrgCourseDetail(Long orgId, Long courseId) {
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        OrgCourseDetailResponseDto dto = null;
        if (course != null) {
            String host = PropertiesReader.getValue((String)"wxm", (String)"m.server");
            String imgServer = PropertiesReader.getValue((String)"wxm", (String)"img.server");
            ArrayList ids = Lists.newArrayList((Object[])new Long[]{course.getId()});
            Map<Long, List<String>> cache = this.getCourseIdTeacherNamesMap(ids);
            dto = new OrgCourseDetailResponseDto();
            dto.setCourseType(CourseType.CLASS.getCode());
            dto.setName(course.getName());
            dto.setNumber(course.getNumber());
            dto.setPrice(course.getPrice() + "");
            if (cache.containsKey(course.getId())) {
                dto.setTeacherName(cache.get(course.getId()).get(0));
            } else {
                dto.setTeacherName("\u5f85\u5b9a");
            }
            Storage storage = (Storage)this.storageDao.getById((Serializable)course.getCover(), new String[0]);
            dto.setPreface(this.constructUrl(storage, imgServer));
            dto.setLink("{host}/org/course/{number}".replace("{host}", host).replace("{number}", course.getNumber().toString()));
        }
        return dto;
    }

    private static boolean checkTime(String start, String end) {
        TimeStamp startTime = TimeStamp.parse((String)start);
        TimeStamp endTime = TimeStamp.parse((String)end);
        if (startTime.getHour() > endTime.getHour()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5f00\u59cb\u65f6\u95f4 \u5927\u4e8e \u7ed3\u675f\u65f6\u95f4");
        }
        if (startTime.getMinute() % 5 != 0 || endTime.getMinute() % 5 != 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5206\u949f\u4e0d\u662f5\u7684\u6574\u6570\u500d");
        }
        if (startTime.getSecond() != 0 || endTime.getSecond() != 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u79d2\u5fc5\u987b\u4e3a0");
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrEditOrgTimeSpan(Long orgId, List<OrgTimeSpanDto> timeSpanList) {
        log.info("timeSpanList = {}", timeSpanList);
        for (OrgTimeSpanDto dto : timeSpanList) {
            if (!OrgCourseServiceImpl.checkTime(dto.getStartTime(), dto.getEndTime())) {
                return;
            }
            OrgTimeSpan orgTimeSpan = new OrgTimeSpan();
            Time endTime = Time.valueOf(dto.getEndTime());
            Time startTime = Time.valueOf(dto.getStartTime());
            orgTimeSpan.setStartTime(startTime);
            orgTimeSpan.setEndTime(endTime);
            orgTimeSpan.setOrgId(orgId);
            if (dto.getId() == null || dto.getId() == 0L) {
                orgTimeSpan.setId(null);
            } else {
                orgTimeSpan.setId(dto.getId());
            }
            this.orgTimeSpanDao.saveOrUpdate((Object)orgTimeSpan, new String[0]);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgTimeSpanDto> listOrgTimeSpan(Long orgId) {
        List list = this.orgTimeSpanDao.listOrgTimeSpan(orgId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        ArrayList dtos = Lists.newArrayList();
        for (OrgTimeSpan span : list) {
            OrgTimeSpanDto dto = new OrgTimeSpanDto();
            dto.setId(span.getId());
            dto.setStartTime(this.buildTimeStr(span.getStartTime()));
            dto.setEndTime(this.buildTimeStr(span.getEndTime()));
            dtos.add(dto);
        }
        return dtos;
    }

    private String buildTimeStr(Date time) {
        String str = DateUtil.getStrByDateFormate((Date)time, (String)"HH:mm:ss");
        if (str.equals("00:00:00")) {
            str = "24:00:00";
        }
        return str;
    }

    @Override
    public void deleteOrgTimeSpan(@NonNull Collection<Long> ids) {
        if (ids == null) {
            throw new NullPointerException("ids");
        }
        this.orgTimeSpanDao.delByIds(ids);
    }

    @Override
    @Transactional(readOnly=true)
    public CourseListReponseDto getOrgBasicCourseInfo(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is not null!");
        Preconditions.checkArgument((courseId != null ? 1 : 0) != 0, (Object)"courseId is not null!");
        OrgCourse course = this.orgCourseDao.getByCourseId(courseId, new String[0]);
        CourseListReponseDto dto = new CourseListReponseDto();
        dto.setCourseName(course.getName());
        dto.setOrgCourseId(course.getId());
        dto.setOrgCourseNumber(course.getNumber());
        dto.setCoverUrl(this.getCoverUrl(course));
        return dto;
    }

    private String getCoverUrl(OrgCourse course) {
        if (course == null) {
            return "";
        }
        if (course.getCover() == null) {
            return "";
        }
        Storage storage = (Storage)this.storageDao.getById((Serializable)course.getCover(), new String[0]);
        if (storage == null) {
            return "";
        }
        if (StringUtils.isNotBlank((String)storage.getAttach_url())) {
            return storage.getAttach_url();
        }
        return StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Object> buildLessonInfo(Long orgId, Long lessonId, Long studentId) {
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"student not exists!");
        log.debug("orgId = {}, lessonId{}, studentId ={}, userId={}", new Object[]{orgId, lessonId, studentId, userId});
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        Preconditions.checkArgument((lesson != null ? 1 : 0) != 0, (Object)"lesson not exist!");
        OrgCourse course = this.orgCourseDao.getByCourseId(lesson.getCourseId(), new String[0]);
        HashMap map = Maps.newHashMap();
        map.put("index", lesson.getNumber());
        map.put("startTime", lesson.getStartTime());
        map.put("endTime", lesson.getEndTime());
        map.put("courseName", course.getName());
        Map lessonTeacherMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{lessonId}));
        log.debug("lessonTeacherMap = {}", (Object)lessonTeacherMap);
        Long teacherId = (Long)lessonTeacherMap.get(lessonId);
        if (teacherId == null) {
            log.warn("lessonid = {}, teacherId ={}", (Object)lessonId, (Object)teacherId);
            map.put("teacherName", "");
            map.put("avatarUrl", "");
            map.put("teacherId", 0);
            return map;
        }
        Teacher teacher = this.teacherDao.getByUserId(teacherId, new String[0]);
        if (teacher != null) {
            map.put("teacherName", teacher.getRealName() != null ? teacher.getRealName() : teacher.getNickName());
            map.put("teacherId", teacher.getUserId());
            if (teacher.getAvatar() != null) {
                Storage storage = (Storage)this.storageDao.getById((Serializable)teacher.getAvatar(), new String[0]);
                if (storage != null) {
                    map.put("avatarUrl", StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
                }
            } else {
                log.warn("\u8001\u5e08\u5934\u50cf\u4e0d\u5b58\u5728!");
            }
        } else {
            log.warn("lessonid = {}, teacherId ={}", (Object)lessonId, (Object)teacherId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8001\u5e08\u4e0d\u5b58\u5728");
        }
        return map;
    }

    @Override
    public OrgCourseInfoDto getOrgCourseInfo(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId");
        OrgCourseInfoDto orgCourseInfoDto = new OrgCourseInfoDto();
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"areaId"});
        Area area = (Area)this.areaDao.getById((Serializable)orgInfo.getAreaId(), new String[]{"name", "bname"});
        orgCourseInfoDto.setCityName(area.getBname());
        OrgCourse course = null;
        if (courseId != null && courseId > 0L && (course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0])) != null) {
            orgCourseInfoDto.setCourseId(courseId);
            orgCourseInfoDto.setCourseName(course.getName());
            orgCourseInfoDto.setCoursePrice(course.getPrice());
            orgCourseInfoDto.setLessonSummary(course.getLessonSummary());
            String courseUrl = this.environment.getProperty("org_class_course.url");
            orgCourseInfoDto.setCourseUrl(courseUrl + course.getNumber());
            orgCourseInfoDto.setMaxStudent(course.getMaxStudent());
            orgCourseInfoDto.setCoverStorageId(course.getCover());
            orgCourseInfoDto.setAddress(course.getAddress());
            orgCourseInfoDto.setStartTime(course.getBeginTime());
            orgCourseInfoDto.setEndTime(course.getEndTime());
            orgCourseInfoDto.setFreq(course.getFreq());
            String intro = BaseUtils.blobToString((Blob)course.getIntroduction(), (String)"UTF-8");
            orgCourseInfoDto.setIntroduction(intro);
            orgCourseInfoDto.setStatus(course.getStatus());
            orgCourseInfoDto.setIsDel(course.getIsDel());
            if (StringUtils.isNotBlank((String)course.getOfflinePoi())) {
                String[] lnglat = course.getOfflinePoi().split(",");
                log.debug("latlng={},len={}", (Object)lnglat, (Object)lnglat.length);
                if (lnglat != null && lnglat.length >= 2) {
                    String lng = lnglat[0];
                    String lat = lnglat[1];
                    try {
                        orgCourseInfoDto.setLat(Double.parseDouble(lat));
                        orgCourseInfoDto.setLng(Double.parseDouble(lng));
                    }
                    catch (NumberFormatException e) {
                        log.warn("lat={},lng={}", (Object)lat, (Object)lng);
                    }
                }
            }
            orgCourseInfoDto.setCoverUrl(this.getCoverUrl(course));
            orgCourseInfoDto.setTeachers(this.courseTeacherService.listCourseTeacher(orgId, courseId));
            List<OrgCourseGroupDto> groups = this.orgCourseGroupService.getByCourseId(orgId, courseId);
            if (CollectionUtils.isNotEmpty(groups)) {
                orgCourseInfoDto.setGroups(groups);
            }
        }
        return orgCourseInfoDto;
    }

    @Override
    public void deleteOrgCourses(Long orgId, Collection<Long> courseIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId!");
        if (CollectionUtils.isEmpty(courseIds)) {
            return;
        }
        Long orgNumber = this.getOrgNumber(orgId);
        Preconditions.checkArgument((orgNumber != null && orgNumber > 0L ? 1 : 0) != 0, (Object)"illegal orgNumber!");
        HashMap updateCondtion = Maps.newHashMap();
        updateCondtion.put("id", courseIds);
        updateCondtion.put("orgNumber", orgNumber);
        OrgCourse orgCourse = new OrgCourse();
        orgCourse.setIsDel(Integer.valueOf(1));
        this.orgCourseDao.update((Map)updateCondtion, (Object)orgCourse, new String[]{"isDel"});
    }

    @Override
    public void batchUpdateStatus(Long orgId, Collection<Long> courseIds, Integer status) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId!");
        if (CollectionUtils.isEmpty(courseIds)) {
            return;
        }
        Long orgNumber = this.getOrgNumber(orgId);
        Preconditions.checkArgument((orgNumber != null && orgNumber > 0L ? 1 : 0) != 0, (Object)"illegal orgNumber!");
        HashMap updateCondtion = Maps.newHashMap();
        updateCondtion.put("id", courseIds);
        updateCondtion.put("orgNumber", orgNumber);
        OrgCourse orgCourse = new OrgCourse();
        orgCourse.setStatus(status);
        this.orgCourseDao.update((Map)updateCondtion, (Object)orgCourse, new String[]{"status"});
    }

    @Override
    public void repairNumber() {
        log.info("repairNumber");
        this.orgCourseDao.repairNumber();
    }
}

