/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.OrgErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupService;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgCourseGroupServiceImpl
implements OrgCourseGroupService {
    private static final Logger logger = LoggerFactory.getLogger(OrgCourseGroupServiceImpl.class);
    @Autowired
    private OrgCourseGroupDao orgCourseGroupDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modify(Integer orgId, Integer courseGroupId, String groupName) throws BussinessException {
        logger.info("modify.orgId:{}, courseGroupId:{}", (Object)orgId, (Object)courseGroupId);
        OrgCourseGroup orgCourseGroup = (OrgCourseGroup)this.orgCourseGroupDao.getById((Serializable)courseGroupId, new String[0]);
        if (orgCourseGroup == null) {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.NO_SUBJECT_FOR_REQ);
        }
        if (orgCourseGroup.getOrgId().intValue() != orgId.intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PERMISSION_DENY);
        }
        if (!groupName.equals(orgCourseGroup.getName())) {
            orgCourseGroup.setName(groupName);
            this.orgCourseGroupDao.update((Object)orgCourseGroup, new String[]{"name", "updateTime"});
        }
    }

    @Override
    public Integer add(Integer orgId, String groupName) {
        if (this.orgCourseGroupDao.countByName(orgId, groupName) > 0) {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.COURSE_GROUP_NAME_EXISTS);
        }
        OrgCourseGroup orgCourseGroup = new OrgCourseGroup();
        orgCourseGroup.setName(groupName);
        orgCourseGroup.setOrgId(orgId);
        this.orgCourseGroupDao.save((Object)orgCourseGroup, new String[]{"name", "orgId"});
        return orgCourseGroup.getId();
    }
}

